/*
 * Decompiled with CFR 0.152.
 */
package kl.cds.constant;

public enum SignMethod {
    SGD_SM3_RSA(65537L, "\u57fa\u4e8eSM3\u7b97\u6cd5\u548cRSA\u7b97\u6cd5\u7684\u7b7e\u540d", "SM3WithRSA"),
    SGD_SHA1_RSA(65538L, "\u57fa\u4e8eSHA_1\u7b97\u6cd5\u548cRSA\u7b97\u6cd5\u7684\u7b7e\u540d", "SHA1WithRSA"),
    SGD_SHA256_RSA(65540L, "\u57fa\u4e8eSHA_256\u7b97\u6cd5\u548cRSA\u7b97\u6cd5\u7684\u7b7e\u540d", "SHA256WithRSA"),
    SGD_SM3_SM2(131585L, "\u57fa\u4e8eSM3\u7b97\u6cd5\u548cSM2\u7b97\u6cd5\u7684\u7b7e\u540d", "SM3WithSM2");

    private long type;
    private String desc;
    private String signType;

    public long getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getSignType() {
        return this.signType;
    }

    private SignMethod(long type, String desc, String signType) {
        this.type = type;
        this.desc = desc;
        this.signType = signType;
    }

    public static SignMethod valueOf(long type) {
        SignMethod[] signMethods;
        for (SignMethod signMethod : signMethods = SignMethod.values()) {
            if (signMethod.getType() != type) continue;
            return signMethod;
        }
        return null;
    }

    public static SignMethod valueTypeOf(String type) {
        SignMethod[] signMethods;
        for (SignMethod signMethod : signMethods = SignMethod.values()) {
            if (!signMethod.getSignType().equalsIgnoreCase(type)) continue;
            return signMethod;
        }
        return null;
    }

    public long getValidSignType() {
        if (this.getSignType().contains("RSA")) {
            return SGD_SHA256_RSA.getType();
        }
        if (this.getSignType().contains("SM2")) {
            return SGD_SM3_SM2.getType();
        }
        return -1L;
    }
}

