/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin;

import android.os.AsyncTask;
import android.text.TextUtils;
import com.longmai.security.plugin.base.BaseCallback;
import com.longmai.security.plugin.base.BaseContainerType;
import com.longmai.security.plugin.base.ContainerInfo;
import com.longmai.security.plugin.skf.SKFLib;
import com.longmai.security.plugin.util.DigestUtil;
import com.longmai.security.plugin.util.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SOF_AppLib {
    private static final String TAG = SOF_AppLib.class.getName();
    private Map<String, Integer> Containers = new ConcurrentHashMap<String, Integer>();
    private Map<String, BaseContainerType> ContainerInfos = new ConcurrentHashMap<String, BaseContainerType>();
    private SKFLib skf;
    private String appName;
    private int appId;
    private ByteArrayOutputStream _bos = new ByteArrayOutputStream();
    private int _paddingType;
    DigestUtil digest;

    private SOF_AppLib() {
    }

    protected SOF_AppLib(SKFLib skf, String policyName, int appId) {
        LogUtil.d(TAG, "SOF_AppLib - create");
        this.skf = skf;
        this.appId = appId;
        this.appName = policyName;
    }

    public String SOF_GetAppName() {
        LogUtil.d(TAG, "SOF_GetAppName()");
        return this.appName;
    }

    public int SOF_Login(String userPin, int[] retryCount) {
        LogUtil.d(TAG, "SOF_Login()");
        if (TextUtils.isEmpty((CharSequence)userPin)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (retryCount == null || retryCount.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        byte[] random = new byte[8];
        int rtn = this.skf.SKF_GenRandom(8, random);
        if (rtn != 0) {
            return 3;
        }
        rtn = this.skf.SKF_Login(this.appId, random, userPin.getBytes(), retryCount);
        if (rtn != 0) {
            return 4;
        }
        return 0;
    }

    public int SOF_Login(int pinType, String userPin, int[] retryCount) {
        LogUtil.d(TAG, "SOF_Login()");
        if (TextUtils.isEmpty((CharSequence)userPin)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (retryCount == null || retryCount.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        byte[] random = new byte[8];
        int rtn = this.skf.SKF_GenRandom(8, random);
        if (rtn != 0) {
            return 3;
        }
        rtn = this.skf.SKF_Login(this.appId, pinType, random, userPin.getBytes(), retryCount);
        if (rtn != 0) {
            return 4;
        }
        return 0;
    }

    public int SOF_Logout() {
        LogUtil.d(TAG, "SOF_LogUtilout()");
        return this.skf.SKF_ClearSecureState(this.appId);
    }

    public int SOF_ChanegPassWd(String oldUpin, String newUpin, int[] retry) {
        LogUtil.d(TAG, "SOF_ChanegPassWd()");
        if (TextUtils.isEmpty((CharSequence)oldUpin)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (TextUtils.isEmpty((CharSequence)newUpin)) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (retry == null || retry.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        byte[] random = new byte[8];
        int rtn = this.skf.SKF_GenRandom(8, random);
        if (rtn != 0) {
            return 4;
        }
        rtn = this.skf.SKF_ChangePin(this.appId, random, oldUpin.getBytes(), newUpin.getBytes(), retry);
        if (rtn != 0) {
            return 5;
        }
        return 0;
    }

    public int SOF_EnumContainers(List<String> containers) {
        LogUtil.d(TAG, "SOF_EnumContainers()");
        if (containers == null) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        int rtn = this.skf.SKF_EnumContainers(this.appId, containers);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public int SOF_GetContainerInfo(String containerName, int[] containerType, int[] signKeyLen, int[] exchKeyLen, int[] signCertFlag, int[] exchCertFlag) {
        LogUtil.d(TAG, "SOF_GetContainerInfo() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (containerType == null || containerType.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (signKeyLen == null || signKeyLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (exchKeyLen == null || exchKeyLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        if (signCertFlag == null || signCertFlag.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 5;
        }
        if (exchCertFlag == null || exchCertFlag.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 6;
        }
        int rtn = this.skf.SKF_GetContainerType(this.appId, containerName.getBytes(), containerType, signKeyLen, exchKeyLen, signCertFlag, exchCertFlag);
        if (rtn != 0) {
            return 7;
        }
        this.ContainerInfos.put(containerName, new ContainerInfo(this.appId, containerName, containerType[0], signKeyLen[0], exchKeyLen[0], signCertFlag[0], exchCertFlag[0]));
        return 0;
    }

    public int SOF_ExportUserCert(String containerName, int signFlag, byte[] cert, int[] certLen) {
        int rtn;
        LogUtil.d(TAG, "SOF_ExportUserCert() - containerName:" + containerName + " signFlag:" + signFlag);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (cert == null || cert.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (certLen == null || certLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn2 = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn2 != 0) {
                return 4;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        if ((rtn = this.skf.SKF_ExportCertificate(this.appId, containerId, signFlag, cert, certLen)) != 0) {
            return 5;
        }
        return 0;
    }

    public int SOF_ExportPublicKeyBlob(String containerName, int signFlag, byte[] publicKeyBlob, int[] blobLen) {
        LogUtil.d(TAG, "SOF_ExportPublicKeyBlob() - containerName:" + containerName + " signFlag:" + signFlag);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (publicKeyBlob == null || publicKeyBlob.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (blobLen == null || blobLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn != 0) {
                return 4;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        int rtn = 0;
        BaseContainerType containerInfo = this.ContainerInfos.get(containerName);
        if (containerInfo == null) {
            int[] containerType = new int[1];
            int[] signKeyLen = new int[1];
            int[] exchKeyLen = new int[1];
            int[] signCertFlag = new int[1];
            int[] exchCertFlag = new int[1];
            rtn = this.skf.SKF_GetContainerType(this.appId, containerName.getBytes(), containerType, signKeyLen, exchKeyLen, signCertFlag, exchCertFlag);
            if (rtn != 0) {
                return 5;
            }
            containerInfo = new ContainerInfo(this.appId, containerName, containerType[0], signKeyLen[0], exchKeyLen[0], signCertFlag[0], exchCertFlag[0]);
            this.ContainerInfos.put(containerName, containerInfo);
        }
        switch (containerInfo.containerType) {
            case 0: {
                this.skf.SKF_SetLastError(3);
                return 6;
            }
            case 1: {
                rtn = this.skf.SKF_RSAExportPublicKey(this.appId, containerId, signFlag, publicKeyBlob, blobLen);
                if (rtn == 0) break;
                return 7;
            }
            case 2: {
                rtn = this.skf.SKF_ECCExportPublicKey(this.appId, containerId, signFlag, publicKeyBlob, blobLen);
                if (rtn == 0) break;
                return 8;
            }
            default: {
                this.skf.SKF_SetLastError(2);
                return 9;
            }
        }
        return 0;
    }

    public int SOF_SignData(String containerName, int signFlag, int hashAlgo, byte[] inData, int inDataLen, byte[] signature, int[] signLen) {
        LogUtil.d(TAG, "SOF_SignData() - containerName:" + containerName + " signFlag:" + signFlag + " hashAlgo:" + hashAlgo);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (inData == null || inData.length < inDataLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (signature == null || signature.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (signLen == null || signLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn != 0) {
                return 5;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        int rtn = 0;
        BaseContainerType containerInfo = this.ContainerInfos.get(containerName);
        if (containerInfo == null) {
            int[] containerType = new int[1];
            int[] signKeyLen = new int[1];
            int[] exchKeyLen = new int[1];
            int[] signCertFlag = new int[1];
            int[] exchCertFlag = new int[1];
            rtn = this.skf.SKF_GetContainerType(this.appId, containerName.getBytes(), containerType, signKeyLen, exchKeyLen, signCertFlag, exchCertFlag);
            if (rtn != 0) {
                return 6;
            }
            containerInfo = new ContainerInfo(this.appId, containerName, containerType[0], signKeyLen[0], exchKeyLen[0], signCertFlag[0], exchCertFlag[0]);
            this.ContainerInfos.put(containerName, containerInfo);
        }
        if (containerInfo.containerType == 0) {
            this.skf.SKF_SetLastError(3);
            return 7;
        }
        switch (signFlag) {
            case 0: {
                if (containerInfo.exchKeyLen != 0) break;
                this.skf.SKF_SetLastError(3);
                return 8;
            }
            case 1: {
                if (containerInfo.signKeyLen != 0) break;
                this.skf.SKF_SetLastError(3);
                return 9;
            }
            default: {
                this.skf.SKF_SetLastError(4);
                return 10;
            }
        }
        switch (containerInfo.containerType) {
            case 1: {
                try {
                    rtn = this.skf.SKF_RSASignData(this.appId, containerId, signFlag, hashAlgo, inData, inDataLen, signature, signLen);
                    if (rtn == 0) break;
                    return 11;
                }
                catch (NoSuchAlgorithmException e) {
                    LogUtil.e(TAG, "SKF_RSASignData()", e);
                    this.skf.SKF_SetLastError(1);
                    return 12;
                }
            }
            case 2: {
                if (hashAlgo != 1) {
                    this.skf.SKF_SetLastError(20);
                    return 15;
                }
                int inputMode = 1;
                if (inDataLen == 32) {
                    inputMode = 2;
                }
                byte[] userId = new byte[]{};
                rtn = this.skf.SKF_ECCSignData(this.appId, containerId, inputMode, signFlag, userId, inData, inDataLen, signature, signLen);
                if (rtn == 0) break;
                return 13;
            }
            default: {
                this.skf.SKF_SetLastError(1);
                return 14;
            }
        }
        return 0;
    }

    public int SOF_VerifySignedData(byte[] pubKeyBlob, int blobLen, int algoId, int hashAlgo, byte[] inData, int inDataLen, byte[] signature, int signLen) {
        LogUtil.d(TAG, "SOF_VerifySignedData()");
        if (pubKeyBlob == null || pubKeyBlob.length < blobLen) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (inData == null || inData.length < inDataLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (signature == null || signature.length < signLen) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        switch (algoId) {
            case 65536: {
                try {
                    int rtn = this.skf.SKF_ExtRSAVerify(pubKeyBlob, blobLen, hashAlgo, inData, inDataLen, signature, signLen);
                    if (rtn == 0) break;
                    return 4;
                }
                catch (NoSuchAlgorithmException e) {
                    LogUtil.e(TAG, "", e);
                    this.skf.SKF_SetLastError(1);
                    return 5;
                }
            }
            case 131328: 
            case 131584: 
            case 132096: {
                int rtn = this.skf.SKF_ECCVerify(pubKeyBlob, blobLen, inData, inDataLen, signature, signLen);
                if (rtn == 0) break;
                return 6;
            }
            default: {
                this.skf.SKF_SetLastError(4);
                return 7;
            }
        }
        return 0;
    }

    public int SOF_DigestData(int algoId, byte[] data, int dataLen, byte[] hashVal, int[] hashValLen) {
        LogUtil.d(TAG, "SOF_DigestData() - algoId:" + algoId);
        if (data == null || data.length < dataLen) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (hashVal == null || hashVal.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (hashValLen == null || hashValLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        int rtn = this.skf.SKF_DigestInit(algoId);
        if (rtn != 0) {
            return 4;
        }
        int nCount = dataLen / 1024;
        int left = dataLen % 1024;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[1024];
            System.arraycopy(data, i * 1024, tmp, 0, 1024);
            rtn = this.skf.SKF_DigestUpdate(tmp, 1024);
            if (rtn != 0) {
                return 5;
            }
            ++i;
        }
        byte[] tmp = new byte[left];
        System.arraycopy(data, nCount * 1024, tmp, 0, left);
        rtn = this.skf.SKF_DigestFinal(tmp, left, hashVal, hashValLen);
        if (rtn != 0) {
            return 6;
        }
        return 0;
    }

    public int SOF_EncryptData(int algoId, byte[] key, int keyLen, int padding, byte[] iv, int ivLen, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_EncryptData() - algoId:" + algoId);
        if (key == null || key.length < keyLen) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (output == null || output.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (outputLen == null || outputLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        int[] keyId = new int[1];
        int rtn = this.skf.SKF_SetSymtricKey(this.appId, 65535, algoId, key, keyLen, keyId);
        if (rtn != 0) {
            return 5;
        }
        rtn = this.skf.SKF_EncryptInit(this.appId, 65535, keyId[0], iv, ivLen, padding);
        if (rtn != 0) {
            return 6;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int nCount = inputLen / 1024;
        int left = inputLen % 1024;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[1024];
            System.arraycopy(input, i * 1024, tmp, 0, 1024);
            byte[] outputTmp = new byte[2048];
            int[] outputLenTmp = new int[1];
            rtn = this.skf.SKF_EncryptUpdate(this.appId, 65535, keyId[0], tmp, 1024, outputTmp, outputLenTmp);
            if (rtn != 0) {
                return 7;
            }
            bos.write(outputTmp, 0, outputLenTmp[0]);
            ++i;
        }
        byte[] tmp = new byte[left];
        System.arraycopy(input, nCount * 1024, tmp, 0, left);
        byte[] outputTmp = new byte[2048];
        int[] outputLenTmp = new int[1];
        rtn = this.skf.SKF_EncryptFinal(this.appId, 65535, keyId[0], tmp, left, outputTmp, outputLenTmp);
        if (rtn != 0) {
            return 8;
        }
        bos.write(outputTmp, 0, outputLenTmp[0]);
        if (output.length < bos.size()) {
            this.skf.SKF_SetLastError(28161);
            return 9;
        }
        outputLen[0] = padding == 0 ? inputLen : bos.size();
        System.arraycopy(bos.toByteArray(), 0, output, 0, bos.size());
        rtn = this.skf.SKF_DestroySymtricKey(this.appId, 65535, keyId[0]);
        if (rtn != 0) {
            return 10;
        }
        return 0;
    }

    public int SOF_DecryptData(int algoId, byte[] key, int keyLen, int padding, byte[] iv, int ivLen, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_DecryptData() - algoId:" + algoId);
        if (key == null || key.length < keyLen) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (output == null || output.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (outputLen == null || outputLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        int[] keyId = new int[1];
        int rtn = this.skf.SKF_SetSymtricKey(this.appId, 65535, algoId, key, keyLen, keyId);
        if (rtn != 0) {
            return 5;
        }
        rtn = this.skf.SKF_DecryptInit(this.appId, 65535, keyId[0], iv, ivLen, padding);
        if (rtn != 0) {
            return 6;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int nCount = inputLen / 1024;
        int left = inputLen % 1024;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[1024];
            System.arraycopy(input, i * 1024, tmp, 0, 1024);
            byte[] outputTmp = new byte[2048];
            int[] outputLenTmp = new int[1];
            rtn = this.skf.SKF_DecryptUpdate(this.appId, 65535, keyId[0], tmp, 1024, outputTmp, outputLenTmp);
            if (rtn != 0) {
                return 7;
            }
            bos.write(outputTmp, 0, outputLenTmp[0]);
            ++i;
        }
        byte[] tmp = new byte[left];
        System.arraycopy(input, nCount * 1024, tmp, 0, left);
        byte[] outputTmp = new byte[2048];
        int[] outputLenTmp = new int[1];
        rtn = this.skf.SKF_DecryptFinal(this.appId, 65535, keyId[0], tmp, left, outputTmp, outputLenTmp);
        if (rtn != 0) {
            return 8;
        }
        bos.write(outputTmp, 0, outputLenTmp[0]);
        if (output.length < bos.size()) {
            this.skf.SKF_SetLastError(28161);
            return 11;
        }
        outputLen[0] = bos.size();
        System.arraycopy(bos.toByteArray(), 0, output, 0, bos.size());
        rtn = this.skf.SKF_DestroySymtricKey(this.appId, 65535, keyId[0]);
        if (rtn != 0) {
            return 12;
        }
        return 0;
    }

    public int SOF_EnumFiles(List<String> files) {
        LogUtil.d(TAG, "SOF_EnumFiles()");
        if (files == null) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        int rtn = this.skf.SKF_EnumFiles(this.appId, files);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public int SOF_GetFileInfo(String fileName, int[] fileSize, int[] readRights, int[] writeRights) {
        LogUtil.d(TAG, "SOF_GetFileInfo() - fileName:" + fileName);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (fileSize == null || fileSize.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (readRights == null || readRights.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (writeRights == null || writeRights.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        int rtn = this.skf.SKF_GetFileInfo(this.appId, fileName.getBytes(), fileSize, readRights, writeRights);
        if (rtn != 0) {
            return 5;
        }
        return 0;
    }

    public int SOF_ReadFile(String fileName, int offset, int readLen, byte[] output) {
        int rtn;
        LogUtil.d(TAG, "SOF_ReadFile() - fileName:" + fileName);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (output == null || output.length < readLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        int count = readLen / 1024;
        int left = readLen % 1024;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int i = 0;
        while (i < count) {
            byte[] outputTmp = new byte[2048];
            int[] outputLenTmp = new int[1];
            rtn = this.skf.SKF_ReadFile(this.appId, fileName.getBytes(), i * 1024 + offset, 1024, outputTmp, outputLenTmp);
            if (rtn != 0) {
                return 3;
            }
            bos.write(outputTmp, 0, outputLenTmp[0]);
            ++i;
        }
        if (left > 0) {
            byte[] outputTmp = new byte[2048];
            int[] outputLenTmp = new int[1];
            rtn = this.skf.SKF_ReadFile(this.appId, fileName.getBytes(), count * 1024 + offset, left, outputTmp, outputLenTmp);
            if (rtn != 0) {
                return 4;
            }
            bos.write(outputTmp, 0, outputLenTmp[0]);
        }
        System.arraycopy(bos.toByteArray(), 0, output, 0, bos.size());
        return 0;
    }

    public int SOF_WriteFile(String fileName, int offset, byte[] input, int length) {
        int rtn;
        LogUtil.d(TAG, "SOF_WriteFile() - fileName:" + fileName + " length:" + length);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length < length) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        int count = length / 1024;
        int left = length % 1024;
        int i = 0;
        while (i < count) {
            byte[] buff = new byte[1024];
            System.arraycopy(input, i * 1024, buff, 0, 1024);
            rtn = this.skf.SKF_WriteFile(this.appId, fileName.getBytes(), i * 1024 + offset, buff, 1024);
            if (rtn != 0) {
                return 3;
            }
            ++i;
        }
        if (left > 0) {
            byte[] buff = new byte[left];
            System.arraycopy(input, count * 1024, buff, 0, left);
            rtn = this.skf.SKF_WriteFile(this.appId, fileName.getBytes(), count * 1024 + offset, buff, left);
            if (rtn != 0) {
                return 4;
            }
        }
        return 0;
    }

    public int SOF_ExtPublicEncrypt(byte[] pubKeyBlob, int blobLen, int algoId, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_ExtPublicEncrypt()");
        if (pubKeyBlob == null || pubKeyBlob.length < blobLen) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (output == null || output.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (outputLen == null || outputLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        int rtn = 0;
        switch (algoId) {
            case 65536: {
                rtn = this.skf.SKF_ExtRSAEncrypt(pubKeyBlob, blobLen, input, inputLen, output, outputLen);
                if (rtn == 0) break;
                return 5;
            }
            case 131328: 
            case 131584: 
            case 132096: {
                if (inputLen > 128) {
                    this.skf.SKF_SetLastError(2);
                    return 6;
                }
                rtn = this.skf.SKF_ExtECCEncrypt(pubKeyBlob, blobLen, input, inputLen, output, outputLen);
                if (rtn == 0) break;
                return 7;
            }
            default: {
                this.skf.SKF_SetLastError(4);
                return 8;
            }
        }
        return 0;
    }

    public int SOF_PublicEncrypt(String containerName, int signFlag, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_PrivateDecrypt() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (output == null || output.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (outputLen == null || outputLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn != 0) {
                return 5;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        int rtn = 0;
        BaseContainerType containerInfo = this.ContainerInfos.get(containerName);
        if (containerInfo == null) {
            int[] containerType = new int[1];
            int[] signKeyLen = new int[1];
            int[] exchKeyLen = new int[1];
            int[] signCertFlag = new int[1];
            int[] exchCertFlag = new int[1];
            rtn = this.skf.SKF_GetContainerType(this.appId, containerName.getBytes(), containerType, signKeyLen, exchKeyLen, signCertFlag, exchCertFlag);
            if (rtn != 0) {
                return 6;
            }
            containerInfo = new ContainerInfo(this.appId, containerName, containerType[0], signKeyLen[0], exchKeyLen[0], signCertFlag[0], exchCertFlag[0]);
            this.ContainerInfos.put(containerName, containerInfo);
        }
        if (containerInfo.containerType == 0) {
            this.skf.SKF_SetLastError(3);
            return 7;
        }
        switch (signFlag) {
            case 0: {
                if (containerInfo.exchKeyLen != 0) break;
                this.skf.SKF_SetLastError(3);
                return 8;
            }
            case 1: {
                if (containerInfo.signKeyLen != 0) break;
                this.skf.SKF_SetLastError(3);
                return 9;
            }
            default: {
                this.skf.SKF_SetLastError(1);
                return 10;
            }
        }
        switch (containerInfo.containerType) {
            case 1: {
                rtn = this.skf.SKF_RSAEncrypt(this.appId, containerId, signFlag, input, inputLen, output, outputLen);
                if (rtn == 0) break;
                return 11;
            }
            case 2: {
                if (inputLen > 128) {
                    this.skf.SKF_SetLastError(2);
                    return 12;
                }
                byte[] publicKeyBlob = new byte[1024];
                int[] blobLen = new int[1];
                rtn = this.skf.SKF_ECCExportPublicKey(this.appId, containerId, signFlag, publicKeyBlob, blobLen);
                if (rtn != 0) {
                    return 13;
                }
                rtn = this.skf.SKF_ExtECCEncrypt(publicKeyBlob, blobLen[0], input, inputLen, output, outputLen);
                if (rtn == 0) break;
                return 14;
            }
            default: {
                this.skf.SKF_SetLastError(1);
                return 15;
            }
        }
        return 0;
    }

    public int SOF_PrivateDecrypt(String containerName, int signFlag, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_PrivateDecrypt() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (output == null || output.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (outputLen == null || outputLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn != 0) {
                return 5;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        int rtn = 0;
        BaseContainerType containerInfo = this.ContainerInfos.get(containerName);
        if (containerInfo == null) {
            int[] containerType = new int[1];
            int[] signKeyLen = new int[1];
            int[] exchKeyLen = new int[1];
            int[] signCertFlag = new int[1];
            int[] exchCertFlag = new int[1];
            rtn = this.skf.SKF_GetContainerType(this.appId, containerName.getBytes(), containerType, signKeyLen, exchKeyLen, signCertFlag, exchCertFlag);
            if (rtn != 0) {
                return 6;
            }
            containerInfo = new ContainerInfo(this.appId, containerName, containerType[0], signKeyLen[0], exchKeyLen[0], signCertFlag[0], exchCertFlag[0]);
            this.ContainerInfos.put(containerName, containerInfo);
        }
        if (containerInfo.containerType == 0) {
            this.skf.SKF_SetLastError(3);
            return 7;
        }
        switch (signFlag) {
            case 0: {
                if (containerInfo.exchKeyLen != 0) break;
                this.skf.SKF_SetLastError(3);
                return 8;
            }
            case 1: {
                if (containerInfo.signKeyLen != 0) break;
                this.skf.SKF_SetLastError(3);
                return 9;
            }
            default: {
                this.skf.SKF_SetLastError(1);
                return 10;
            }
        }
        switch (containerInfo.containerType) {
            case 1: {
                rtn = this.skf.SKF_RSADecrypt(this.appId, containerId, signFlag, input, inputLen, output, outputLen);
                if (rtn == 0) break;
                return 11;
            }
            case 2: {
                rtn = this.skf.SKF_ECCPrivateDecrypt(this.appId, containerId, signFlag, input, inputLen, output, outputLen);
                if (rtn == 0) break;
                return 12;
            }
            default: {
                this.skf.SKF_SetLastError(1);
                return 13;
            }
        }
        return 0;
    }

    public int SOF_CreaterFile(String fileName, int fileSize, int readRights, int writeRights) {
        LogUtil.d(TAG, "SOF_CreaterFile() - fileName:" + fileName);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        int rtn = this.skf.SKF_CreaterFile(this.appId, fileName.getBytes(), fileSize, readRights, writeRights);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public int SOF_DeleteFile(String fileName) {
        LogUtil.d(TAG, "SOF_DeleteFile() - fileName:" + fileName);
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        int rtn = this.skf.SKF_DeleteFile(this.appId, fileName.getBytes());
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public int SOF_GetPINInfo(int pinType, int[] maxRetryCount, int[] retryCount, int[] defaultPin) {
        LogUtil.d(TAG, "SOF_GetPINInfo()");
        return this.skf.SKF_GetPINInfo(this.appId, pinType, maxRetryCount, retryCount, defaultPin);
    }

    public int SOF_UnblockPIN(String soPin, String userPin, int[] retryCount) {
        LogUtil.d(TAG, "SOF_UnblockPIN()");
        if (TextUtils.isEmpty((CharSequence)soPin)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (TextUtils.isEmpty((CharSequence)userPin)) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (retryCount == null || retryCount.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        byte[] random = new byte[8];
        int rtn = this.skf.SKF_GenRandom(8, random);
        if (rtn != 0) {
            return 4;
        }
        rtn = this.skf.SKF_UnblockPIN(this.appId, random, soPin.getBytes(), userPin.getBytes(), retryCount);
        if (rtn != 0) {
            return 5;
        }
        return 0;
    }

    public int SOF_CreateContainer(String containerName) {
        LogUtil.d(TAG, "SOF_CreateContainer() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        int[] containerId = new int[1];
        int rtn = this.skf.SKF_CreateContainer(this.appId, containerName.getBytes(), containerId);
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public int SOF_DeleteContainer(String containerName) {
        LogUtil.d(TAG, "SOF_DeleteContainer() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        int rtn = this.skf.SKF_DeleteContainer(this.appId, containerName.getBytes());
        if (rtn != 0) {
            return 2;
        }
        return 0;
    }

    public int SOF_ImportCertificate(String containerName, int signFlag, byte[] cert, int certLen) {
        int rtn;
        LogUtil.d(TAG, "SOF_ImportCertificate() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (cert == null || cert.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (cert.length < certLen) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn2 = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn2 != 0) {
                return 4;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        if ((rtn = this.skf.SKF_ImportCertificate(this.appId, containerId, signFlag, 0, cert, certLen)) != 0) {
            return 5;
        }
        int nCount = certLen / 1024;
        int left = certLen % 1024;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[1024];
            System.arraycopy(cert, i * 1024, tmp, 0, 1024);
            rtn = this.skf.SKF_ImportCertificate(this.appId, containerId, signFlag, 1, tmp, 1024);
            if (rtn != 0) {
                return 6;
            }
            ++i;
        }
        if (left > 0) {
            byte[] tmp = new byte[left];
            System.arraycopy(cert, nCount * 1024, tmp, 0, left);
            rtn = this.skf.SKF_ImportCertificate(this.appId, containerId, signFlag, 2, tmp, left);
            if (rtn != 0) {
                return 7;
            }
        }
        return 0;
    }

    public int SOF_GenKeyPair(String containerName, int signFlag, int algoId, int bitLen, byte[] pubKey, int[] keyLen) {
        LogUtil.d(TAG, "SOF_GenRSAKeyPair() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn != 0) {
                return 2;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        switch (algoId) {
            case 65536: {
                int rtn = this.skf.SKF_GenRSAKeyPair(this.appId, containerId, signFlag, bitLen, pubKey, keyLen);
                if (rtn == 0) break;
                return 3;
            }
            case 131328: 
            case 131584: 
            case 132096: {
                int rtn = this.skf.SKF_GenECCKeyPair(this.appId, containerId, signFlag, bitLen, pubKey, keyLen);
                if (rtn == 0) break;
                return 4;
            }
            default: {
                this.skf.SKF_SetLastError(4);
                return 5;
            }
        }
        this.ContainerInfos.remove(containerName);
        return 0;
    }

    public int SOF_ImportRSAKeyPair(String containerName, int algId, int bitLen, byte[] wrappedKey, int wrappedKeyLen, byte[] encryptedData, int encryptedDataLen) {
        int rtn;
        LogUtil.d(TAG, "SOF_ImportRSAKeyPair() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn2 = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn2 != 0) {
                return 2;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        if ((rtn = this.skf.SKF_ImportRSAKeyPair(this.appId, containerId, algId, 0, bitLen, wrappedKey, wrappedKeyLen, encryptedData, encryptedDataLen)) != 0) {
            return 3;
        }
        rtn = this.skf.SKF_ImportRSAKeyPair(this.appId, containerId, algId, 1, bitLen, wrappedKey, wrappedKeyLen, encryptedData, 1024);
        if (rtn != 0) {
            return 4;
        }
        rtn = this.skf.SKF_ImportRSAKeyPair(this.appId, containerId, algId, 2, bitLen, wrappedKey, wrappedKeyLen, Arrays.copyOfRange(encryptedData, 1024, encryptedData.length), encryptedDataLen - 1024);
        if (rtn != 0) {
            return 5;
        }
        this.ContainerInfos.remove(containerName);
        return 0;
    }

    public int SOF_ImportECCKeyPair(String containerName, byte[] envelopedKeyBlob, int envelopedKeyBlobLen) {
        int rtn;
        LogUtil.d(TAG, "SOF_ImportECCKeyPair() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn2 = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn2 != 0) {
                return 2;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        if ((rtn = this.skf.SKF_ImportECCKeyPair(this.appId, containerId, envelopedKeyBlob, envelopedKeyBlobLen)) != 0) {
            return 3;
        }
        this.ContainerInfos.remove(containerName);
        return 0;
    }

    public int SOF_ImportExtRSAKeyPair(String containerName, int signFlag, byte[] blob, int blobLen) {
        int rtn;
        LogUtil.d(TAG, "SOF_ImportExtRSAKeyPair() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (blob == null || blob.length < blobLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn2 = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn2 != 0) {
                return 3;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        if ((rtn = this.skf.SKF_ImportExtRSAKeyPair(this.appId, containerId, signFlag, 0, blob, blobLen)) != 0) {
            return 4;
        }
        int nCount = blobLen / 1024;
        int left = blobLen % 1024;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[1024];
            System.arraycopy(blob, i * 1024, tmp, 0, 1024);
            rtn = this.skf.SKF_ImportExtRSAKeyPair(this.appId, containerId, signFlag, 1, tmp, 1024);
            if (rtn != 0) {
                return 5;
            }
            ++i;
        }
        byte[] tmp = new byte[left];
        System.arraycopy(blob, nCount * 1024, tmp, 0, left);
        rtn = this.skf.SKF_ImportExtRSAKeyPair(this.appId, containerId, signFlag, 2, tmp, left);
        if (rtn != 0) {
            return 6;
        }
        this.ContainerInfos.remove(containerName);
        return 0;
    }

    public int SOF_SM3Digest(byte[] data, int length, byte[] digest, int[] digestLen) {
        LogUtil.d(TAG, "SOF_SM3Digest()");
        return this.skf.SKF_SM3Digest(data, length, digest, digestLen);
    }

    public int SOF_GetLastError() {
        LogUtil.d(TAG, "SOF_GetLastError()");
        return this.skf.SKF_GetLastError();
    }

    public int SOF_Public(String containerName, int signFlag, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_Public() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn != 0) {
                return 4;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        return this.skf.SKF_RSAPublic(this.appId, containerId, signFlag, input, inputLen, output, outputLen);
    }

    public int SOF_Private(String containerName, int signFlag, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_Private() - containerName:" + containerName);
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn != 0) {
                return 4;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        return this.skf.SKF_RSAPrivate(this.appId, containerId, signFlag, input, inputLen, output, outputLen);
    }

    public int SOF_SetSymtricKey(int algoId, byte[] key, int keyLen, int[] keyId) {
        LogUtil.d(TAG, "SOF_SetSymtricKey() - algoId:" + algoId);
        if (key == null || key.length < keyLen) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        return this.skf.SKF_SetSymtricKey(this.appId, 65535, algoId, key, keyLen, keyId);
    }

    public int SOF_DestroySymtricKey(int keyId) {
        LogUtil.d(TAG, "SOF_DestroySymtricKey() - keyId:" + keyId);
        return this.skf.SKF_DestroySymtricKey(this.appId, 65535, keyId);
    }

    public int SOF_EncryptInit(int keyId, byte[] iv, int ivLen, int paddingType) {
        LogUtil.d(TAG, "SOF_EncryptInit() - keyId:" + keyId);
        this._bos = new ByteArrayOutputStream();
        this._bos.reset();
        this._paddingType = paddingType;
        return this.skf.SKF_EncryptInit(this.appId, 65535, keyId, iv, ivLen, paddingType);
    }

    public int SOF_EncryptUpdate(int keyId, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        int len;
        LogUtil.d(TAG, "SOF_EncryptUpdate() - keyId:" + keyId);
        this._bos.write(input, 0, inputLen);
        ByteArrayInputStream bis = new ByteArrayInputStream(this._bos.toByteArray());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.reset();
        this._bos.reset();
        byte[] tmp = new byte[1024];
        while ((len = bis.read(tmp, 0, 1024)) != -1) {
            if (len == 1024) {
                byte[] outputTmp = new byte[2048];
                int[] outputLenTmp = new int[1];
                int rtn = this.skf.SKF_EncryptUpdate(this.appId, 65535, keyId, tmp, 1024, outputTmp, outputLenTmp);
                if (rtn != 0) {
                    return 1;
                }
                bos.write(outputTmp, 0, outputLenTmp[0]);
                continue;
            }
            this._bos.write(tmp, 0, len);
        }
        if (output.length < bos.size()) {
            this.skf.SKF_SetLastError(28161);
            return 2;
        }
        outputLen[0] = bos.size();
        System.arraycopy(bos.toByteArray(), 0, output, 0, bos.size());
        return 0;
    }

    public int SOF_EncryptFinal(int keyId, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_EncryptFinal() - keyId:" + keyId);
        this._bos.write(input, 0, inputLen);
        byte[] buff = this._bos.toByteArray();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.reset();
        int nCount = buff.length / 1024;
        int left = buff.length % 1024;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[1024];
            System.arraycopy(buff, i * 1024, tmp, 0, 1024);
            byte[] outputTmp = new byte[2048];
            int[] outputLenTmp = new int[1];
            int rtn = this.skf.SKF_EncryptUpdate(this.appId, 65535, keyId, tmp, 1024, outputTmp, outputLenTmp);
            if (rtn != 0) {
                return 7;
            }
            bos.write(outputTmp, 0, outputLenTmp[0]);
            ++i;
        }
        byte[] tmp = new byte[left];
        System.arraycopy(buff, nCount * 1024, tmp, 0, left);
        byte[] outputTmp = new byte[2048];
        int[] outputLenTmp = new int[1];
        int rtn = this.skf.SKF_EncryptFinal(this.appId, 65535, keyId, tmp, left, outputTmp, outputLenTmp);
        if (rtn != 0) {
            return 8;
        }
        bos.write(outputTmp, 0, outputLenTmp[0]);
        if (output.length < bos.size()) {
            this.skf.SKF_SetLastError(28161);
            return 9;
        }
        outputLen[0] = this._paddingType == 0 && left != 0 ? left : (this._paddingType == 0 && nCount != 0 && left == 0 ? 1024 : bos.size());
        System.arraycopy(bos.toByteArray(), 0, output, 0, bos.size());
        return 0;
    }

    public int SOF_DecryptInit(int keyId, byte[] iv, int ivLen, int paddingType) {
        LogUtil.d(TAG, "SOF_DecryptInit() - keyId:" + keyId);
        this._bos = new ByteArrayOutputStream();
        this._bos.reset();
        return this.skf.SKF_DecryptInit(this.appId, 65535, keyId, iv, ivLen, paddingType);
    }

    public int SOF_DecryptUpdate(int keyId, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        int len;
        LogUtil.d(TAG, "SOF_DecryptUpdate() - keyId:" + keyId);
        this._bos.write(input, 0, inputLen);
        ByteArrayInputStream bis = new ByteArrayInputStream(this._bos.toByteArray());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.reset();
        this._bos.reset();
        byte[] tmp = new byte[1024];
        while ((len = bis.read(tmp, 0, 1024)) != -1) {
            if (len == 1024) {
                byte[] outputTmp = new byte[2048];
                int[] outputLenTmp = new int[1];
                int rtn = this.skf.SKF_DecryptUpdate(this.appId, 65535, keyId, tmp, 1024, outputTmp, outputLenTmp);
                if (rtn != 0) {
                    return 1;
                }
                bos.write(outputTmp, 0, outputLenTmp[0]);
                continue;
            }
            this._bos.write(tmp, 0, len);
        }
        if (output.length < bos.size()) {
            this.skf.SKF_SetLastError(28161);
            return 2;
        }
        outputLen[0] = bos.size();
        System.arraycopy(bos.toByteArray(), 0, output, 0, bos.size());
        return 0;
    }

    public int SOF_DecryptFinal(int keyId, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_DecryptFinal() - keyId:" + keyId);
        this._bos.write(input, 0, inputLen);
        byte[] buff = this._bos.toByteArray();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.reset();
        int nCount = buff.length / 1024;
        int left = buff.length % 1024;
        int i = 0;
        while (i < nCount) {
            byte[] tmp = new byte[1024];
            System.arraycopy(buff, i * 1024, tmp, 0, 1024);
            byte[] outputTmp = new byte[2048];
            int[] outputLenTmp = new int[1];
            int rtn = this.skf.SKF_DecryptUpdate(this.appId, 65535, keyId, tmp, 1024, outputTmp, outputLenTmp);
            if (rtn != 0) {
                return 7;
            }
            bos.write(outputTmp, 0, outputLenTmp[0]);
            ++i;
        }
        byte[] tmp = new byte[left];
        System.arraycopy(buff, nCount * 1024, tmp, 0, left);
        byte[] outputTmp = new byte[2048];
        int[] outputLenTmp = new int[1];
        int rtn = this.skf.SKF_DecryptFinal(this.appId, 65535, keyId, tmp, left, outputTmp, outputLenTmp);
        if (rtn != 0) {
            return 8;
        }
        bos.write(outputTmp, 0, outputLenTmp[0]);
        if (output.length < bos.size()) {
            this.skf.SKF_SetLastError(28161);
            return 11;
        }
        outputLen[0] = bos.size();
        System.arraycopy(bos.toByteArray(), 0, output, 0, bos.size());
        return 0;
    }

    public int SOF_SoftDigestInit(int algoId, byte[] eccPubKey) {
        LogUtil.d(TAG, "SOF_DecryptFinal() - algoId:" + algoId);
        this.digest = new DigestUtil();
        try {
            return this.digest.SoftDigestInit(algoId, eccPubKey);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return 1;
        }
    }

    public int SOF_SoftDigestUpdate(byte[] input, int inputLen) {
        LogUtil.d(TAG, "SOF_DigestUpdate()");
        return this.digest.SoftDigestUpdate(input, inputLen);
    }

    public int SOF_SoftDigestFinal(byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_DigestFinal()");
        return this.digest.SoftDigestFinal(input, inputLen, output, outputLen);
    }

    public int SOF_SoftDigestFinal(byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_DigestFinal()");
        return this.digest.SoftDigestFinal(output, outputLen);
    }

    public int SOF_ExtRSAPubKeyOperation(byte[] pubKeyBlob, byte[] input, int inputLen, byte[] output, int[] outputLen) {
        LogUtil.d(TAG, "SOF_ExtRSAPubKeyOperation()");
        if (pubKeyBlob == null) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (input == null || input.length < inputLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        if (output == null || output.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 3;
        }
        if (outputLen == null || outputLen.length <= 0) {
            this.skf.SKF_SetLastError(2);
            return 4;
        }
        int rtn = this.skf.SKF_ExtRSAPubKeyOperation(pubKeyBlob, input, inputLen, output, outputLen);
        if (rtn != 0) {
            return 5;
        }
        return 0;
    }

    public int SOF_DeleteCertificate(String containerName, int signFlag) {
        int rtn;
        LogUtil.d(TAG, "SOF_DeleteCertificate()");
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn2 = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn2 != 0) {
                return 2;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        if ((rtn = this.skf.SKF_DeleteCertificate(this.appId, containerId, signFlag)) != 0) {
            return 3;
        }
        return 0;
    }

    public int SOF_DeleteKeyPair(String containerName, int signFlag) {
        int rtn;
        LogUtil.d(TAG, "SOF_DeleteKeyPair()");
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        Integer containerId = this.Containers.get(containerName);
        if (containerId == null) {
            int[] id = new int[1];
            int rtn2 = this.skf.SKF_OpenContainer(this.appId, containerName.getBytes(), id);
            if (rtn2 != 0) {
                return 2;
            }
            containerId = id[0];
            this.Containers.put(containerName, containerId);
        }
        if ((rtn = this.skf.SKF_DeleteKeyPair(this.appId, containerId, signFlag)) != 0) {
            return 3;
        }
        return 0;
    }

    public int SOF_SignData(String containerName, int signFlag, int hashAlgo, byte[] hash, int hashLen, int timeOut, BaseCallback<byte[]> callback) {
        LogUtil.d(TAG, "SOF_SignData()");
        if (TextUtils.isEmpty((CharSequence)containerName)) {
            this.skf.SKF_SetLastError(2);
            return 1;
        }
        if (hash == null || hash.length < hashLen) {
            this.skf.SKF_SetLastError(2);
            return 2;
        }
        SignAsyncTask task = new SignAsyncTask(containerName, signFlag, hashAlgo, hash, hashLen, timeOut, callback);
        task.execute(new Void[0]);
        return 0;
    }

    class SignAsyncTask
    extends AsyncTask<Void, Void, Integer> {
        String containerName;
        int signFlag;
        int hashAlgo;
        byte[] hash;
        int hashLen;
        int timeOut;
        BaseCallback<byte[]> callback;
        byte[] signature = new byte[1024];
        int[] signLen = new int[1];

        public SignAsyncTask(String containerName, int signFlag, int hashAlgo, byte[] hash, int hashLen, int timeOut, BaseCallback<byte[]> callback) {
            this.containerName = containerName;
            this.signFlag = signFlag;
            this.hashAlgo = hashAlgo;
            this.hash = hash;
            this.hashLen = hashLen;
            this.timeOut = timeOut;
            this.callback = callback;
        }

        protected Integer doInBackground(Void ... arg0) {
            Integer containerId = (Integer)SOF_AppLib.this.Containers.get(this.containerName);
            if (containerId == null) {
                int[] id = new int[1];
                int rtn = SOF_AppLib.this.skf.SKF_OpenContainer(SOF_AppLib.this.appId, this.containerName.getBytes(), id);
                if (rtn != 0) {
                    return 1;
                }
                containerId = id[0];
                SOF_AppLib.this.Containers.put(this.containerName, containerId);
            }
            int rtn = 0;
            BaseContainerType containerInfo = (BaseContainerType)SOF_AppLib.this.ContainerInfos.get(this.containerName);
            if (containerInfo == null) {
                int[] containerType = new int[1];
                int[] signKeyLen = new int[1];
                int[] exchKeyLen = new int[1];
                int[] signCertFlag = new int[1];
                int[] exchCertFlag = new int[1];
                rtn = SOF_AppLib.this.skf.SKF_GetContainerType(SOF_AppLib.this.appId, this.containerName.getBytes(), containerType, signKeyLen, exchKeyLen, signCertFlag, exchCertFlag);
                if (rtn != 0) {
                    return 2;
                }
                containerInfo = new ContainerInfo(SOF_AppLib.this.appId, this.containerName, containerType[0], signKeyLen[0], exchKeyLen[0], signCertFlag[0], exchCertFlag[0]);
                SOF_AppLib.this.ContainerInfos.put(this.containerName, containerInfo);
            }
            if (containerInfo.containerType == 0) {
                SOF_AppLib.this.skf.SKF_SetLastError(3);
                return 3;
            }
            switch (this.signFlag) {
                case 0: {
                    if (containerInfo.exchKeyLen != 0) break;
                    SOF_AppLib.this.skf.SKF_SetLastError(3);
                    return 4;
                }
                case 1: {
                    if (containerInfo.signKeyLen != 0) break;
                    SOF_AppLib.this.skf.SKF_SetLastError(3);
                    return 5;
                }
                default: {
                    SOF_AppLib.this.skf.SKF_SetLastError(4);
                    return 6;
                }
            }
            int _timeOut = this.timeOut + 2;
            switch (containerInfo.containerType) {
                case 1: {
                    rtn = SOF_AppLib.this.skf.SKF_RSASignDataInteractiveCancel(SOF_AppLib.this.appId, containerId, this.signFlag, this.hashAlgo);
                    if (rtn != 0) {
                        return 7;
                    }
                    do {
                        if ((rtn = SOF_AppLib.this.skf.SKF_RSASignDataInteractive(SOF_AppLib.this.appId, containerId, this.signFlag, this.hashAlgo, this.timeOut, this.hash, this.hashLen, this.signature, this.signLen)) == 0) {
                            return 0;
                        }
                        int errorCode = SOF_AppLib.this.skf.SKF_GetLastError();
                        if (errorCode == 28417) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                return 8;
                            }
                        } else {
                            return 9;
                        }
                    } while (--_timeOut > 0);
                    break;
                }
                case 2: {
                    int inputMode = 2;
                    byte[] userId = new byte[]{};
                    rtn = SOF_AppLib.this.skf.SKF_ECCSignDataInteractiveCancel(SOF_AppLib.this.appId, containerId, inputMode, this.signFlag);
                    if (rtn != 0) {
                        return 10;
                    }
                    do {
                        if ((rtn = SOF_AppLib.this.skf.SKF_ECCSignDataInteractive(SOF_AppLib.this.appId, containerId, inputMode, this.signFlag, this.timeOut, userId, 0, this.hash, this.hashLen, this.signature, this.signLen)) == 0) {
                            return 0;
                        }
                        int errorCode = SOF_AppLib.this.skf.SKF_GetLastError();
                        if (errorCode == 28417) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                return 11;
                            }
                        } else {
                            return 12;
                        }
                    } while (--_timeOut > 0);
                    break;
                }
                default: {
                    SOF_AppLib.this.skf.SKF_SetLastError(1);
                    return 13;
                }
            }
            SOF_AppLib.this.skf.SKF_SetLastError(21);
            return 14;
        }

        protected void onPostExecute(Integer result) {
            if (result == 0) {
                this.callback.onResult(0, Arrays.copyOf(this.signature, this.signLen[0]));
            } else {
                int errorCode = SOF_AppLib.this.skf.SKF_GetLastError();
                this.callback.onResult(errorCode, null);
            }
        }
    }
}

