/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.tf;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.device.Device;
import com.longmai.security.plugin.device.DeviceManager;
import com.longmai.security.plugin.driver.conn.Connection;
import com.longmai.security.plugin.driver.tf.ConnectionImpl;
import com.longmai.security.plugin.driver.tf.base.TF;
import com.longmai.security.plugin.driver.tf.ndk.mTokenTF;
import com.longmai.security.plugin.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DeviceManagerImple
implements DeviceManager {
    private static final String TAG = DeviceManagerImple.class.getName();
    private static final int currentapiVersion = Build.VERSION.SDK_INT;
    private List<Device> devices = new ArrayList<Device>();
    private Context ctx;
    private String packageName;
    private TF tf;
    private boolean mkdir = false;

    public DeviceManagerImple() throws PluginException {
        this.tf = new mTokenTF();
    }

    @TargetApi(value=19)
    public DeviceManagerImple(Context ctx) throws PluginException {
        LogUtil.d((String)TAG, (String)"DeviceManagerImple Create");
        this.ctx = ctx;
        this.tf = new mTokenTF();
    }

    public List<Device> find(int timeOut, String ... parameter) throws PluginException {
        return this.find(parameter);
    }

    @SuppressLint(value={"NewApi"})
    public List<Device> find(String ... parameter) throws PluginException {
        int[] token_number;
        int rtn;
        LogUtil.d((String)TAG, (String)"find()");
        this.devices.clear();
        if (!this.mkdir) {
            byte[] path = new byte[1024];
            int[] length = new int[1];
            int rtn2 = this.tf.get_tf_path(path, length);
            if (rtn2 != 0) {
                throw new PluginException(12, "Gets a TF card path failure");
            }
            ByteArrayOutputStream ioFilePath = new ByteArrayOutputStream();
            ioFilePath.write(path, 0, length[0] - 1);
            if (currentapiVersion > 18) {
                File[] dirs;
                if (this.ctx == null) {
                    throw new PluginException("Context is null");
                }
                this.packageName = "/Android/data/" + this.ctx.getPackageName() + "\u0000";
                try {
                    ioFilePath.write(this.packageName.getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                File dir = new File(ioFilePath.toString().trim());
                if (!dir.exists() && (currentapiVersion > 18 ? ((dirs = this.ctx.getExternalFilesDirs(null)) == null || !dirs[0].exists() || !dir.exists()) && !dir.mkdirs() : !dir.mkdirs())) {
                    throw new PluginException("Create \"" + dir + "\" directory failed");
                }
            } else {
                try {
                    ioFilePath.write("/IO.SYS\u0000".getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if ((rtn2 = this.tf.init(ioFilePath.toByteArray())) != 0) {
                throw new PluginException(5);
            }
            this.mkdir = true;
        }
        if ((rtn = this.tf.find(token_number = new int[1])) != 0) {
            throw new PluginException("Find device failure");
        }
        int i = 0;
        while (i < token_number[0]) {
            this.devices.add(new Device(i, "TF" + i, 0));
            ++i;
        }
        return this.devices;
    }

    public Connection getConnection(Device device) throws PluginException {
        ConnectionImpl conn = new ConnectionImpl(device, this.tf);
        return conn;
    }

    public Connection getConnection(Device device, int timeout) throws PluginException {
        return this.getConnection(device);
    }
}

