/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.activity.LogQueryActivity;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.StringUtil;
import java.io.File;

public class LogSetupActivity
extends BaseActivity {
    private CheckBox mLogSwitchCheckBox = null;
    private Spinner mLogLevelSpinner = null;
    private Spinner mLogFileSizeSpinner = null;
    private Button mLogQueryButton = null;
    private Button mLogExportButton = null;
    private final String[] logLevelStr = new String[]{"DEBUG", "WARNING"};
    private final String[] logFileSizeStr = new String[]{"1MB", "2MB", "3MB", "4MB"};
    private final int EXPORT_LOG_OK = 1;
    private final int EXPORT_LOG_FAILED = 2;
    private String mPrivatePath;
    private final String mLogFileName = "safeclient.log";
    private String mLogFilePath;
    private String mSDCardPath;
    private MyApplication myApplication = null;
    private SslClientConfig sslClientConfig = null;
    private int mLogSwicth = 0;
    private int mLogLevel = 0;
    private int mLogFileSize = 0;
    Handler mExportLogHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                case 1: {
                    String path = LogSetupActivity.this.mSDCardPath + "/" + "safeclient.log";
                    Toast.makeText((Context)LogSetupActivity.this, (CharSequence)(StringUtil.getStringRes((Context)LogSetupActivity.this, R.string.export_to) + path), (int)0).show();
                    break;
                }
                case 2: {
                    Toast.makeText((Context)LogSetupActivity.this, (CharSequence)StringUtil.getStringRes((Context)LogSetupActivity.this, R.string.export_log_failed), (int)0).show();
                    break;
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_log_setup);
        this.mPrivatePath = this.getFilesDir().getAbsolutePath() + "/";
        File page = this.getExternalFilesDir(null);
        this.mSDCardPath = page != null ? page.getPath() : "";
        this.mLogFilePath = this.mPrivatePath + "safeclient.log";
        Log.d("onCreate", "pathStr = " + this.mPrivatePath);
        Log.d("LogSetupActivity", "mSDCardPath = " + this.mSDCardPath);
        this.myApplication = (MyApplication)this.getApplication();
        this.sslClientConfig = this.myApplication.sslClientConfig;
        this.initLogSetupCheckBox(this.mLogSwitchCheckBox, R.id.log_switch_checkbox);
        this.initLogSetupSpiner(this.mLogLevelSpinner, R.id.log_level_spinner, this.logLevelStr);
        this.initLogSetupSpiner(this.mLogFileSizeSpinner, R.id.log_file_size_spinner, this.logFileSizeStr);
        this.initLogSetupButton(this.mLogQueryButton, R.id.log_query_button);
        this.initLogSetupButton(this.mLogExportButton, R.id.log_export_button);
        this.mLeftBtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.mRightBtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.mTitleText = (TextView)this.findViewById(R.id.titlebar_text);
        this.initLeftBtn();
        this.initTitleText();
        this.initRightBtn();
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("LogSetupActivity", "onDestroy");
        if (this.myApplication.activityList != null) {
            this.myApplication.activityList.remove((Object)this);
        }
    }

    @Override
    protected void initRightBtn() {
        super.initRightBtn();
        this.mRightBtn.setVisibility(0);
        this.mRightBtn.setBackgroundResource(R.drawable.save);
        this.mRightBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.d("LogSetupActivity", "LogSetupSaveButton clicked ");
                LogSetupActivity.this.sslClientConfig.setLogSwitch(LogSetupActivity.this.mLogSwicth);
                LogSetupActivity.this.sslClientConfig.setLogLevel(LogSetupActivity.this.mLogLevel);
                LogSetupActivity.this.sslClientConfig.setLogFileSize(LogSetupActivity.this.mLogFileSize);
                LogSetupActivity.this.myApplication.writeSslclientConfigFile();
                Toast.makeText((Context)v.getContext(), (CharSequence)StringUtil.getStringRes((Context)LogSetupActivity.this, R.string.save_config_success), (int)0).show();
            }
        });
    }

    @Override
    protected void initTitleText() {
        super.initTitleText();
        this.mTitleText.setText(R.string.label_log_setup);
    }

    private CheckBox initLogSetupCheckBox(CheckBox checkBox, int id2) {
        checkBox = (CheckBox)this.findViewById(id2);
        if (id2 == R.id.log_switch_checkbox) {
            if (this.sslClientConfig.getLogSwitch() == 0) {
                checkBox.setChecked(false);
                this.mLogSwicth = 0;
            } else {
                checkBox.setChecked(true);
                this.mLogSwicth = 1;
            }
        }
        checkBox.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (R.id.log_switch_checkbox == ((CheckBox)v).getId()) {
                    if (((CheckBox)v).isChecked()) {
                        Log.d("LogSetupActivity", "LogSwitchCheckBox checked " + ((CheckBox)v).getId());
                        LogSetupActivity.this.mLogSwicth = 1;
                    } else {
                        Log.d("LogSetupActivity", "LogSwitchCheckBox unchecked");
                        LogSetupActivity.this.mLogSwicth = 0;
                    }
                }
            }
        });
        return checkBox;
    }

    private Spinner initLogSetupSpiner(Spinner spinner, int id2, String[] strArray) {
        ArrayAdapter adapter = null;
        spinner = (Spinner)this.findViewById(id2);
        adapter = new ArrayAdapter((Context)this, R.layout.spinner_item_select, (Object[])strArray);
        adapter.setDropDownViewResource(R.layout.spinner_item_dropdown);
        spinner.setAdapter((SpinnerAdapter)adapter);
        if (R.id.log_level_spinner == id2) {
            Log.d("LogSetupActivity", "init log_level_spinner " + strArray[this.sslClientConfig.getLogLevel()]);
            spinner.setSelection(this.sslClientConfig.getLogLevel());
            this.mLogLevel = this.sslClientConfig.getLogLevel();
        } else if (R.id.log_file_size_spinner == id2) {
            if (this.sslClientConfig.getLogFileSize() < 1) {
                Log.e("LogSetupActivity", "init log_file_size_spinner, log file size < 1");
                spinner.setSelection(0);
                this.mLogFileSize = 1;
            } else {
                Log.d("LogSetupActivity", "init log_file_size_spinner " + strArray[this.sslClientConfig.getLogFileSize() - 1]);
                spinner.setSelection(this.sslClientConfig.getLogFileSize() - 1);
                this.mLogFileSize = this.sslClientConfig.getLogFileSize();
            }
        }
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> arg0, View v, int position, long arg3) {
                if (R.id.log_level_spinner == arg0.getId()) {
                    Log.d("LogSetupActivity", "log_level_spinner checked " + arg0.getItemAtPosition(position).toString());
                    LogSetupActivity.this.mLogLevel = position;
                } else if (R.id.log_file_size_spinner == arg0.getId()) {
                    Log.d("LogSetupActivity", "log_file_size_spinner checked " + arg0.getItemAtPosition(position).toString());
                    LogSetupActivity.this.mLogFileSize = position + 1;
                }
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
        return spinner;
    }

    private void exportLogToSDCard() {
        if (this.mSDCardPath == null) {
            return;
        }
        final File sourceFile = new File(this.mLogFilePath);
        final File targetFile = new File(this.mSDCardPath + "/" + "safeclient.log");
        new Thread(){

            @Override
            public void run() {
                Message msg = new Message();
                msg.what = FileUtil.copeFile(sourceFile, targetFile) ? 1 : 2;
                LogSetupActivity.this.mExportLogHandler.sendMessage(msg);
            }
        }.start();
    }

    private Button initLogSetupButton(Button button, int id2) {
        button = (Button)this.findViewById(id2);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int viewId = ((Button)v).getId();
                if (viewId == R.id.log_query_button) {
                    Log.d("LogSetupActivity", "log_query_button clicked " + viewId);
                    Intent intent = new Intent((Context)LogSetupActivity.this, LogQueryActivity.class);
                    LogSetupActivity.this.startActivity(intent);
                }
                if (viewId == R.id.log_export_button) {
                    Log.d("LogSetupActivity", "log_export_button checked " + viewId);
                    LogSetupActivity.this.exportLogToSDCard();
                }
            }
        });
        return button;
    }
}

