/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.safeclient.R;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.adapter.SwitchLanguageAdapter;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.bean.LanguageBean;
import com.xdja.safeclient.utils.LocaleUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.sslvpn.SSLVPN;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class SwitchLanguageActivity
extends BaseActivity
implements View.OnClickListener {
    SwitchLanguageAdapter adapter;
    TextView titlebarText;
    ImageView titlebarLeftbtn;
    ImageView titlebarRightbtn;
    RecyclerView rvLanguageList;
    List<LanguageBean> list = new ArrayList<LanguageBean>();
    LocaleUtil.ChangeListener listener = new LocaleUtil.ChangeListener(){

        @Override
        public void onChange(LanguageBean language) {
            SSLVPN.setLocale(language.isAuto() ? LocaleUtil.getSystemLocale() : language.getLocale());
            SwitchLanguageActivity.this.finish();
            Intent intent = new Intent((Context)SwitchLanguageActivity.this, SafeVerifyActivity.class);
            intent.setFlags(0x10008000);
            SwitchLanguageActivity.this.startActivity(intent);
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_switch_language);
        this.initView();
        this.titlebarRightbtn.setBackgroundResource(R.drawable.save);
        this.titlebarRightbtn.setVisibility(0);
        this.titlebarText.setText(R.string.switch_language);
        this.initLanguage();
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        this.rvLanguageList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.adapter = new SwitchLanguageAdapter((Context)this, this.list, this.getDefaultPosition());
        this.rvLanguageList.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    private void initView() {
        this.titlebarText = (TextView)this.findViewById(R.id.titlebar_text);
        this.titlebarLeftbtn = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.titlebarRightbtn = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.rvLanguageList = (RecyclerView)this.findViewById(R.id.rv_language_list);
        this.titlebarLeftbtn.setOnClickListener((View.OnClickListener)this);
        this.titlebarRightbtn.setOnClickListener((View.OnClickListener)this);
    }

    private int getDefaultPosition() {
        if (LocaleUtil.autoChoose((Context)this)) {
            return 0;
        }
        String name = LocaleUtil.getCurrentLocaleName((Context)this);
        LanguageBean language = new LanguageBean(name);
        return this.list.indexOf(language);
    }

    private void initLanguage() {
        this.list.add(new LanguageBean(StringUtil.getStringRes((Context)this, R.string.auto), Locale.getDefault(), true));
        this.list.add(new LanguageBean("\u7b80\u4f53\u4e2d\u6587", Locale.SIMPLIFIED_CHINESE));
        this.list.add(new LanguageBean("English", Locale.ENGLISH));
    }

    public void onClick(View view) {
        if (view.getId() == R.id.titlebar_leftbtn) {
            this.finish();
        }
        if (view.getId() == R.id.titlebar_rightbtn) {
            LanguageBean selectLanguage = this.list.get(this.adapter.getSelectedPosition());
            LocaleUtil.changeLanguage((Context)this, selectLanguage, this.listener);
            SharedPreferencesUtil.put((Context)this, "auto", selectLanguage.isAuto());
            SharedPreferencesUtil.put((Context)this, "current_language", selectLanguage.getName());
        }
    }
}

