/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.xdja.bean.SettingBean;
import com.xdja.safeclient.R;
import java.util.List;

public class SettingAdapter
extends RecyclerView.Adapter<ViewHolder> {
    Context context;
    List<SettingBean> list;
    OnItemClickListener listener;

    public SettingAdapter(Context context, List<SettingBean> list, OnItemClickListener listener) {
        this.context = context;
        this.list = list;
        this.listener = listener;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from((Context)this.context).inflate(R.layout.list_item_setting, null));
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        final SettingBean bean = this.list.get(position);
        holder.icon.setImageResource(bean.getIconResId());
        holder.name.setText(bean.getNameResId());
        holder.ll_whole.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SettingAdapter.this.listener.onClick(bean);
            }
        });
        if (position == 0) {
            holder.ll_whole.setBackgroundResource(R.drawable.list_top_selector);
        } else if (position == this.list.size() - 1) {
            holder.ll_whole.setBackgroundResource(R.drawable.list_bottom_selector);
        } else {
            holder.ll_whole.setBackgroundResource(R.drawable.list_middle_selector);
        }
    }

    public int getItemCount() {
        return this.list != null ? this.list.size() : 0;
    }

    public static interface OnItemClickListener {
        public void onClick(SettingBean var1);
    }

    class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView icon;
        TextView name;
        View ll_whole;

        public ViewHolder(View itemView) {
            super(itemView);
            this.icon = (ImageView)itemView.findViewById(R.id.icon);
            this.name = (TextView)itemView.findViewById(R.id.name);
            this.ll_whole = itemView.findViewById(R.id.ll_whole);
        }
    }
}

