/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.device.Device;
import com.longmai.security.plugin.device.DeviceManager;
import com.longmai.security.plugin.driver.ble.ConnectionImpl;
import com.longmai.security.plugin.driver.conn.Connection;
import com.longmai.security.plugin.util.LogUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DeviceManagerImple
implements DeviceManager,
BluetoothAdapter.LeScanCallback {
    private static final String TAG = DeviceManagerImple.class.getName();
    private static final int currentapiVersion = Build.VERSION.SDK_INT;
    private Map<String, BluetoothDevice> devices = new ConcurrentHashMap<String, BluetoothDevice>();
    private BluetoothAdapter mBluetoothAdapter;
    private String findByName;
    private Connection conn;

    public DeviceManagerImple(Context context) throws PluginException {
        if (currentapiVersion < 18) {
            throw new PluginException(5);
        }
        if (context == null) {
            throw new PluginException("Context is null");
        }
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.mBluetoothAdapter = bluetoothManager.getAdapter();
        if (this.mBluetoothAdapter == null) {
            throw new PluginException(5);
        }
    }

    public List<Device> find(String ... parameter) throws PluginException {
        return this.find(3000, parameter);
    }

    public synchronized List<Device> find(int timeOut, String ... parameter) throws PluginException {
        LogUtil.d((String)TAG, (String)("find() - timeOut:" + timeOut + " Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
        this.devices.clear();
        this.findByName = parameter.length > 0 ? parameter[0] : null;
        if (this.conn != null && this.conn.isValid()) {
            BluetoothDevice device = (BluetoothDevice)this.conn.getValue(0);
            this.devices.put(device.getName(), device);
            if (device.getName().equals(this.findByName)) {
                ArrayList<Device> list = new ArrayList<Device>();
                list.add(new Device(0, device.getName(), 128));
                return list;
            }
        }
        try {
            if (!this.mBluetoothAdapter.isEnabled()) {
                throw new PluginException(17);
            }
        }
        catch (SecurityException e) {
            throw new PluginException(17);
        }
        this.mBluetoothAdapter.startLeScan((BluetoothAdapter.LeScanCallback)this);
        try {
            LogUtil.w((String)TAG, (String)"DeviceManagerImple.find.waiting()");
            this.wait(timeOut);
            LogUtil.w((String)TAG, (String)"DeviceManagerImple.find.waited()");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.mBluetoothAdapter.stopLeScan((BluetoothAdapter.LeScanCallback)this);
        LogUtil.d((String)TAG, (String)("find() - devices.size():" + this.devices.size()));
        if (this.findByName != null && this.devices.size() <= 0) {
            throw new PluginException(12);
        }
        ArrayList<Device> list = new ArrayList<Device>();
        for (Map.Entry<String, BluetoothDevice> entry : this.devices.entrySet()) {
            String key = entry.getKey();
            list.add(new Device(0, key, 128));
            LogUtil.d((String)TAG, (String)("find() - list.add() - " + key));
        }
        LogUtil.d((String)TAG, (String)("find() - list.size():" + list.size()));
        return list;
    }

    public synchronized Connection getConnection(Device device) throws PluginException {
        LogUtil.d((String)TAG, (String)"getConnection()");
        BluetoothDevice dev = this.devices.get(device.getName());
        if (dev == null) {
            throw new PluginException(12);
        }
        if (this.conn != null && this.conn.isValid()) {
            this.conn.close();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.conn = new ConnectionImpl(dev);
        return this.conn;
    }

    public Connection getConnection(Device device, int timeOut) throws PluginException {
        return this.getConnection(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
        LogUtil.d((String)TAG, (String)("onLeScan() - name: " + device.getName() + " mac: " + device.getAddress() + " Thread: " + Thread.currentThread().getName() + " Id: " + Thread.currentThread().getId()));
        String devName = device.getName();
        if (TextUtils.isEmpty((CharSequence)devName)) {
            devName = device.getAddress();
        }
        this.devices.put(devName, device);
        LogUtil.d((String)TAG, (String)("onLeScan() - devices: " + this.devices.size()));
        if (this.findByName != null && this.findByName.equals(devName)) {
            DeviceManagerImple deviceManagerImple = this;
            synchronized (deviceManagerImple) {
                this.notify();
            }
        }
    }
}

