package com.safetf;

import android.content.Context;

import com.xdja.safeclient.R;

import static com.xdja.safeclient.utils.StringUtil.*;

public class SafeTFError {
    public final static int XKR_BASE = 0;//0x0003A000
    /**
     * 成功
     */
    public final static int XKR_OK = XKR_BASE + 0;
    //public final static int XKR_PWD_N                      = XKR_BASE+N;
    /**
     * 卡口令还有1次重试机会
     */
    public final static int XKR_PWD_1 = XKR_BASE + 1;
    /**
     * 卡口令还有2次重试机会
     */
    public final static int XKR_PWD_2 = XKR_BASE + 2;
    /**
     * 卡口令还有3次重试机会
     */
    public final static int XKR_PWD_3 = XKR_BASE + 3;
    /**
     * 卡口令还有4次重试机会
     */
    public final static int XKR_PWD_4 = XKR_BASE + 4;
    /**
     * 卡口令还有5次重试机会
     */
    public final static int XKR_PWD_5 = XKR_BASE + 5;
    /**
     * 卡口令还有6次重试机会
     */
    public final static int XKR_PWD_6 = XKR_BASE + 6;
    /**
     * 卡口令还有7次重试机会
     */
    public final static int XKR_PWD_7 = XKR_BASE + 7;
    /**
     * 卡口令还有8次重试机会
     */
    public final static int XKR_PWD_8 = XKR_BASE + 8;
    /**
     * 卡口令还有9次重试机会
     */
    public final static int XKR_PWD_9 = XKR_BASE + 9;
    /**
     * 指定的句柄不存在
     */
    public final static int XKR_NO_HANDLE = XKR_BASE - 1;
    /**
     * 通过卡接口收发数据失败
     */
    public final static int XKR_IO_FAILED = XKR_BASE - 2;
    /**
     * 返回数据之长度错误
     */
    public final static int XKR_BACK_LENGTH = XKR_BASE - 3;
    /**
     * 返回错误的数据
     */
    public final static int XKR_BACK_DATA = XKR_BASE - 4;
    /**
     * 卡重置失败
     */
    public final static int XKR_RESET_FAILED = XKR_BASE - 5;
    /**
     * 指定的角色不存在
     */
    public final static int XKR_NO_ROLE = XKR_BASE - 6;
    /**
     * 输入数据的长度不合适
     */
    public final static int XKR_DATAIN_SIZE = XKR_BASE - 7;
    /**
     * 指定的数据接收缓冲区大小不合适
     */
    public final static int XKR_OUTBUF_SIZE = XKR_BASE - 8;
    /**
     * 接口参数错误
     */
    public final static int XKR_INVALID_PARA = XKR_BASE - 9;
    /**
     * 口令错误
     */
    public final static int XKR_PASSWORD = XKR_BASE - 10;
    /**
     * EEPROM写入错误
     */
    public final static int XKR_EEPROM_WRITE = XKR_BASE - 11;
    /**
     * COS指令参数错误
     */
    public final static int XKR_PARAMETER = XKR_BASE - 12;
    /**
     * 命令与线路保护不适应
     */
    public final static int XKR_CMD_NOTMATCH_LINE = XKR_BASE - 13;
    /**
     * 命令与文件结构不相容
     */
    public final static int XKR_CMD_NOTMATCH_FAT = XKR_BASE - 14;
    /**
     * 权限不够
     */
    public final static int XKR_NO_POWER = XKR_BASE - 15;
    /**
     * 密钥被锁死
     */
    public final static int XKR_KEY_LOCKED = XKR_BASE - 16;
    /**
     * 数据域参数错误
     */
    public final static int XKR_DATA_PARAMETER = XKR_BASE - 18;
    /**
     * 应用锁定
     */
    public final static int XKR_APP_LOCKED = XKR_BASE - 19;
    /**
     * 文件不存在
     */
    public final static int XKR_FILE_NOT_EXIST = XKR_BASE - 20;
    /**
     * 文件无足够空间
     */
    public final static int XKR_NO_FILE_SPACE = XKR_BASE - 21;
    /**
     * 未取随机数
     */
    public final static int XKR_NOT_GET_RANDOM = XKR_BASE - 22;
    /**
     * 文件已存在
     */
    public final static int XKR_FILE_EXIST = XKR_BASE - 23;
    /**
     * 文件内容错误
     */
    public final static int XKR_FILE_CONTENT = XKR_BASE - 24;
    /**
     * 错误的状态
     */
    public final static int XKR_WRONG_STATE = XKR_BASE - 25;
    /**
     * 卡锁定
     */
    public final static int XKR_CARD_LOCKED = XKR_BASE - 26;
    /**
     * Le错误
     */
    public final static int XKR_WRONG_LE = XKR_BASE - 27;
    /**
     * 命令不存在
     */
    public final static int XKR_NO_THIS_CMD = XKR_BASE - 28;
    /**
     * 数据无效
     */
    public final static int XKR_INVALID_DATA = XKR_BASE - 29;
    /**
     * MAC错误
     */
    public final static int XKR_WRONG_MAC = XKR_BASE - 30;
    /**
     * 密钥文件不存在
     */
    public final static int XKR_KEYFILE_NOT_EXIST = XKR_BASE - 31;
    /**
     * 密钥不存在
     */
    public final static int XKR_KEY_NOT_EXIST = XKR_BASE - 32;
    /**
     * 密钥类型不对
     */
    public final static int XKR_WRONG_KEY_TYPE = XKR_BASE - 33;
    /**
     * 返回公钥内容格式不对
     */
    public final static int XKR_BAD_PUBKEY = XKR_BASE - 34;
    /**
     * HASH运算失败
     */
    public final static int XKR_HASH_FAILED = XKR_BASE - 35;
    /**
     * RSA 公钥运算失败
     */
    public final static int XKR_RSAPUBLIC_FAILED = XKR_BASE - 36;
    /**
     * 返回私钥内容格式不对
     */
    public final static int XKR_BAD_PRIKEY = XKR_BASE - 37;
    /**
     * 等待用户签名确认
     */
    public final static int XKR_SIGN_CONFIRM = XKR_BASE - 38;
    /**
     * 用户签名确认取消
     */
    public final static int XKR_SIGN_CANCEL = XKR_BASE - 39;
    /**
     * 使用条件不满足
     */
    public final static int XKR_CONDITION = XKR_BASE - 40;
    /**
     * 解密失败
     */
    public final static int XKR_DECRYPT_FAIL = XKR_BASE - 41;
    /**
     * 文件偏移地址超出，即未找到数据
     */
    public final static int XKR_NOT_FIND_DATA = XKR_BASE - 42;
    /**
     * DGI不支持
     */
    public final static int XKR_DGI_NOT_SUPPORT = XKR_BASE - 43;
    /**
     * 安全报文数据对象不正确
     */
    public final static int XKR_DATA_NOCORRENT = XKR_BASE - 44;
    /**
     * 外部认证失败
     */
    public final static int XKR_EXAUTH_FAIL = XKR_BASE - 45;
    /**
     * RSA密钥未找到
     */
    public final static int XKR_RSA_NOT_FIND = XKR_BASE - 46;
    /**
     * 创建事务锁失败
     */
    public final static int XKR_TLOCK_FAILD = XKR_BASE - 47;
    /**
     * 事务锁超时
     */
    public final static int XKR_TLOCK_TIMEOUT = XKR_BASE - 48;

    /**
     * 证书内容错误
     */
    public final static int XKR_BAD_CERT = XKR_BASE - 49;

    /**
     * 签名验证失败
     */
    public final static int XKR_SIGN_VERIFY = XKR_BASE - 50;                    //签名验证失败

    /**
     * 获取盘符/挂载路径失败
     */
    public final static int XKR_GETMOUNTPATH_FAILD = XKR_BASE - 51;

    /**
     * 内存申请失败
     */
    public final static int XKR_MALLOC_FALID = XKR_BASE - 95;
    /**
     * 未插入U盾卡
     */
    public final static int XKR_NO_KEY = XKR_BASE - 97;
    /**
     * 暂不支持
     */
    public final static int XKR_NOT_SUPPORT = XKR_BASE - 98;

    /**
     * 未知错误
     */
    public final static int XKR_UNKNOWN = XKR_BASE - 100;


    public final static String getErrorInfo(Context context, int errorCode) {
        String errorInfo = "";
        switch (errorCode) {
            case XKR_OK:
                errorInfo = getStringRes(context, R.string.success);
                break;
            case XKR_PWD_1:
                errorInfo = context.getString(R.string.xkr_pwd1);
                break;
            case XKR_PWD_2:
                errorInfo = context.getString(R.string.xkr_pwd2);
                break;
            case XKR_PWD_3:
                errorInfo = context.getString(R.string.xkr_pwd3);
                break;
            case XKR_PWD_4:
                errorInfo = context.getString(R.string.xkr_pwd4);
                break;
            case XKR_PWD_5:
                errorInfo = context.getString(R.string.xkr_pwd5);
                break;
            case XKR_PWD_6:
                errorInfo = context.getString(R.string.xkr_pwd6);
                break;
            case XKR_PWD_7:
                errorInfo = context.getString(R.string.xkr_pwd7);
                break;
            case XKR_PWD_8:
                errorInfo = context.getString(R.string.xkr_pwd8);
                break;
            case XKR_PWD_9:
                errorInfo = context.getString(R.string.xkr_pwd9);
                break;

            case XKR_NO_HANDLE:
                errorInfo = context.getString(R.string.xkr_no_handle);
                break;
            case XKR_IO_FAILED:
                errorInfo = context.getString(R.string.xkr_io_failed);
                break;
            case XKR_BACK_LENGTH:
                errorInfo = context.getString(R.string.xkr_back_length);
                break;
            case XKR_BACK_DATA:
                errorInfo = context.getString(R.string.xkr_back_data);
                break;
            case XKR_RESET_FAILED:
                errorInfo = context.getString(R.string.xkr_reset_failed);
                break;
            case XKR_NO_ROLE:
                errorInfo = context.getString(R.string.xkr_no_role);
                break;
            case XKR_DATAIN_SIZE:
                errorInfo = context.getString(R.string.xkr_datain_size);
                break;
            case XKR_OUTBUF_SIZE:
                errorInfo = context.getString(R.string.xkr_outbuf_size);
                break;
            case XKR_INVALID_PARA:
                errorInfo = context.getString(R.string.xkr_invaild_para);
                break;
            case XKR_PASSWORD:
                //errorInfo = "口令错误";
                // fix by zhaoxiaolong 2016-05-13 bugid 12842
                errorInfo = context.getString(R.string.xkr_password);
                break;
            case XKR_EEPROM_WRITE:
                errorInfo = context.getString(R.string.xkr_eeprom_write);
                break;
            case XKR_PARAMETER:
                errorInfo = context.getString(R.string.xkr_parameter);
                break;
            case XKR_CMD_NOTMATCH_LINE:
                errorInfo = context.getString(R.string.xkr_cmd_notmatch_line);
                break;
            case XKR_CMD_NOTMATCH_FAT:
                errorInfo = context.getString(R.string.xkr_cmd_notmatch_fat);
                break;
            case XKR_NO_POWER:
                errorInfo = context.getString(R.string.xkr_no_power);
                break;
            case XKR_KEY_LOCKED:
                errorInfo = context.getString(R.string.xkr_key_locked);
                break;
            case XKR_DATA_PARAMETER:
                errorInfo = context.getString(R.string.xkr_data_parameter);
                break;
            case XKR_APP_LOCKED:
                errorInfo = context.getString(R.string.xkr_app_locked);
                break;
            case XKR_FILE_NOT_EXIST:
                errorInfo = context.getString(R.string.xkr_file_not_exist);
                break;
            case XKR_NO_FILE_SPACE:
                errorInfo = context.getString(R.string.xkr_no_file_space);
                break;
            case XKR_NOT_GET_RANDOM:
                errorInfo = context.getString(R.string.xkr_not_get_random);
                break;
            case XKR_FILE_EXIST:
                errorInfo = context.getString(R.string.xkr_file_exist);
                break;
            case XKR_FILE_CONTENT:
                errorInfo = context.getString(R.string.xkr_file_content);
                break;
            case XKR_WRONG_STATE:
                errorInfo = context.getString(R.string.xkr_wrong_state);
                break;
            case XKR_CARD_LOCKED:
                errorInfo = context.getString(R.string.xkr_card_locked);
                break;
            case XKR_WRONG_LE:
                errorInfo = context.getString(R.string.xkr_wrong_le);
                break;
            case XKR_NO_THIS_CMD:
                errorInfo = context.getString(R.string.xkr_no_this_cmd);
                break;
            case XKR_INVALID_DATA:
                errorInfo = context.getString(R.string.xkr_incalid_data);
                break;
            case XKR_WRONG_MAC:
                errorInfo = context.getString(R.string.xkr_wrong_mac);
                break;
            case XKR_KEYFILE_NOT_EXIST:
                errorInfo = context.getString(R.string.xkr_keyfile_not_exist);
                break;
            case XKR_KEY_NOT_EXIST:
                errorInfo = context.getString(R.string.xkr_key_not_exist);
                break;
            case XKR_WRONG_KEY_TYPE:
                errorInfo = context.getString(R.string.xkr_wrong_key_type);
            case XKR_BAD_PUBKEY:
                errorInfo = context.getString(R.string.xkr_bad_pubkey);
                break;
            case XKR_HASH_FAILED:
                errorInfo = context.getString(R.string.xkr_hash_failed);
                break;
            case XKR_RSAPUBLIC_FAILED:
                errorInfo = context.getString(R.string.xkr_rsapublic_failed);
                break;
            case XKR_BAD_PRIKEY:
                errorInfo = context.getString(R.string.xkr_bad_prikey);
                break;
            case XKR_SIGN_CONFIRM:
                errorInfo = context.getString(R.string.xkr_sign_confirm);
                break;
            case XKR_SIGN_CANCEL:
                errorInfo = context.getString(R.string.xkr_sign_cancel);
                break;
            case XKR_CONDITION:
                errorInfo = context.getString(R.string.xkr_condition);
                break;
            case XKR_DECRYPT_FAIL:
                errorInfo = context.getString(R.string.xkr_decrypt_fail);
                break;
            case XKR_NOT_FIND_DATA:
                errorInfo = context.getString(R.string.xkr_not_find_data);
                break;
            case XKR_DGI_NOT_SUPPORT:
                errorInfo = context.getString(R.string.xkr_dgi_not_support);
                break;
            case XKR_DATA_NOCORRENT:
                errorInfo = context.getString(R.string.xkr_data_nocorrnt);
                break;
            case XKR_EXAUTH_FAIL:
                errorInfo = context.getString(R.string.xkr_exauth_fail);
                break;
            case XKR_RSA_NOT_FIND:
                errorInfo = context.getString(R.string.xkr_rsa_not_find);
                break;
            case XKR_TLOCK_FAILD:
                errorInfo = context.getString(R.string.xkr_tlock_failed);
                break;
            case XKR_TLOCK_TIMEOUT:
                errorInfo = context.getString(R.string.xkr_tlock_timeout);
                break;
            case XKR_BAD_CERT:
                errorInfo = context.getString(R.string.xkr_bad_cert);
                break;
            case XKR_SIGN_VERIFY:
                errorInfo = context.getString(R.string.xkr_sign_verify);
                break;
            case XKR_GETMOUNTPATH_FAILD:
                errorInfo = context.getString(R.string.xkr_germountpath_faild);
                break;
            case XKR_MALLOC_FALID:
                errorInfo = context.getString(R.string.xkr_malloc_failed);
            case XKR_NO_KEY:
                errorInfo = context.getString(R.string.xkr_no_key);
                break;
            case XKR_NOT_SUPPORT:
                errorInfo = context.getString(R.string.xkr_not_support);
                break;

            default:

                errorInfo = context.getString(R.string.xkr_default_error) + String.format("%08x", errorCode) + "]";
                break;
        }

        return errorInfo;
    }

}
