package com.xdja.emm.framework.binder.param;


import android.os.Parcel;
import android.os.Parcelable;

public class EventInfo implements Parcelable {
	
	private String pkgName = null;

	private long occuredTime = 0L;
	
	private long occuredLong = 0L;
	

	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeString(pkgName);
		dest.writeLong(occuredTime);
		dest.writeLong(occuredLong);
	}
	
	public static final Creator<EventInfo> CREATOR = new Creator<EventInfo>() {
		@Override
		public EventInfo createFromParcel(Parcel in) {
			return new EventInfo(in);
		}

		@Override
		public EventInfo[] newArray(int size) {
			return new EventInfo[size];
		}
	};
	
	public EventInfo(){
		
	}
	
	public EventInfo(Parcel parcel) {
		pkgName = parcel.readString();
		occuredTime = parcel.readLong();
		occuredLong = parcel.readLong();
	}
	
	public String getPkgName() {
		return pkgName;
	}
	
	public void setPkgName(String pkgName) {
		this.pkgName = pkgName;
	}

	public long getOccuredTime() {
		return occuredTime;
	}

	public void setOccuredTime(long occuredTime) {
		this.occuredTime = occuredTime;
	}

	public long getOccuredLong() {
		return occuredLong;
	}

	public void setOccuredLong(long occuredLong) {
		this.occuredLong = occuredLong;
	}

}
