package com.xdja.key.covercard;


import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.telephony.TelephonyManager;

import com.xdja.SafeKey.JNIAPI;
import com.xdja.SafeKey.XDJA_DEVINFO;
import com.xdja.SafeKey.XDJA_FILE;
import com.xdja.SafeKey.XDJA_RSA_PUBKEY;
import com.xdja.SafeKey.XDJA_SM2_PARAM;
import com.xdja.SafeKey.XDJA_SM2_PUBKEY;
import com.xdja.cc.CoverCard;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.event.EventManager;
import com.xdja.safeclient.event.SimStateChangedListener;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.tmc.TMCAPI;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import opencard.core.util.HexString;

/**
 * Created by xingjianqiang on 2017/8/5.
 * Project : safeclient.android.origin
 * Email : xingjianqiang@xdja.com
 */

public class CoverCardWrapper implements SimStateChangedListener, TMCAPI.TMCAPICallBack{
    private static TMCAPI coverCard = null;
    private static final String THIS_FILE = "CoverCardWrapper";
    private int state = CardState.NULL;
    private static CoverCardWrapper coverCardWrapper;
    private static int simState = -1;
    private int connnectTimeout = 10;
    private int lastErrCode = 0;

    // 是否有需要延后执行的init动作
    private boolean hasPendingInit = false;

    private List<CoverCardStateChangedListener> listenerList = new ArrayList<>();

    private CoverCardWrapper(){}

    private static TelephonyManager telephonyManager;
    public static CoverCardWrapper getInstance() {
        if (coverCardWrapper == null) {
            coverCardWrapper = new CoverCardWrapper();
            EventManager.getInstance().addSimStateChangedListener(coverCardWrapper);
//            SubscriptionManager mSubscriptionManager = (SubscriptionManager)MyApplication.myApplication.getSystemService(Context.TELEPHONY_SUBSCRIPTION_SERVICE);
//            mSubscriptionManager.addOnSubscriptionsChangedListener(coverCardWrapper);
            telephonyManager = (TelephonyManager)MyApplication.myApplication.getSystemService(Context.TELEPHONY_SERVICE);
            simState = telephonyManager.getSimState();
        }
        return coverCardWrapper;
    }


//    @Override
//    public void onSubscriptionsChanged() {
//
//        if (state != CardState.READY) {
//            return;
//        }
//
//        KeyDevInfo keyDevInfo = new KeyDevInfo();
//        int ret = KeyWrapper.getInstance().getDevInfo(KeyWrapper.currentIndex, keyDevInfo);
//
//        if (ret == 0 && keyDevInfo.getDriver().equals(KeyWrapper.COVER_KEY_DRIVER_NAME)) {
//            destroy();
//
//            /*
//             * 此处需要停止隧道客户端（通过转发版调卡），因为如果不停止，隧道版会持续调用转发版贴膜卡接口，导致转发版
//             * 过早启动，检测不到贴膜卡
//             */
//
//            /*
//             * 停止隧道客户端防止反复调用贴膜卡接口
//             */
//            if (Function.isPackageExist_v2(MyApplication.myApplication, CONSTANT.VIDEO_CLIENT_PACKAGE_NAME)) {
//                Intent intent = new Intent();
//                intent.setAction(CONSTANT.ACTION_EXIT_TUN_CLIENT);
//                intent.putExtra("reason", "sim switched!");
//                MyApplication.myApplication.sendBroadcast(intent);
//            }
//
//
//            MyApplication.myApplication.getHandler().post(new Runnable() {
//                @Override
//                public void run() {
//                    AlertUtil.popSystemAlert(MyApplication.myApplication, "提示", "检测到SIM卡发生切换，请稍后尝试重新启动安全客户端！", null);
//                }
//            });
//
//            Function.stopVPN(MyApplication.myApplication);
//            new Timer().schedule(new TimerTask() {
//                @Override
//                public void run() {
//                    Function.exitApp(MyApplication.myApplication);
//                }
//            }, 2000);
//        }
//    }

    private void setCardState(int curState) {
        int prevState = this.state;

        if (curState == CardState.INVALID) {
            if (prevState == CardState.INITIALIZING || prevState == CardState.READY) {
                destroy();
            }
        }

        // update state
        if (prevState != curState) {
            this.state = curState;
            notifyListeners(curState);
        }

    }

    private void notifyListeners(int state) {
        for(CoverCardStateChangedListener listener: listenerList) {
            listener.onCoverCardStateChanged(state);
        }
    }

    public boolean addStateListener(CoverCardStateChangedListener listener) {
        return listenerList.add(listener);
    }

    public boolean removeStateListener(CoverCardStateChangedListener listener) {
        return listenerList.remove(listener);
    }

    @Override
    public void isSupported(boolean b) {

        if (openServiceTimer != null) {
            openServiceTimer.purge();
            openServiceTimer.cancel();
            openServiceTimer = null;
        }

        if (coverCard == null) {
            // already destroyed
            Log.d(THIS_FILE, "Covercard is destroyed already");
            return;
        }

        Log.d(THIS_FILE, "Is supported ? " + b);
        String strOtiType = coverCard.GetOtiType();
        if (strOtiType.equals("Not Support")) {
            Log.e(THIS_FILE, "Cover card init failed.");
            lastErrCode = StatusCode.INIT_FAILED;
            setCardState(CardState.INVALID);
        } else {
            Log.e(THIS_FILE, "Cover card init success. Ready to use");
            lastErrCode = StatusCode.SUCCESS;
            setCardState(CardState.READY);
            Log.d(THIS_FILE, "Covercard open success, OTI type:" + strOtiType);
        }
    }

    private abstract class CoverCardRunnable{
        protected abstract int doRun(Object... args);

        public int run(Object... args) {
            long startTime;
            int retryCnt = 4;
            int ret;

            if (state == CardState.NULL) {
                lastErrCode = StatusCode.NOT_STARTED;
                return lastErrCode;
            }

            if (state == CardState.INVALID) {
                return lastErrCode;
            }

            if (state == CardState.READY) {

                ret = doRun(args);
                if (ret == 0) { //调用成功
                    return ret;
                }
                if (ret == -100 || ret == -2 || ret == -18) {
                    // 调用出错，打开日志开关
                    coverCard.SetLogFlag(true);

                    do {
                        try {
                            Thread.sleep(1000);
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        ret = doRun(args);
                        if (ret == 0) {
                            return ret;
                        }
                        retryCnt--;

                    } while ((ret == -100 || ret == -2 || ret == -18) && retryCnt > 0);

                    coverCard.SetLogFlag(false);
                    // 尝试重新初始化贴膜卡
                    if (retryCnt == 0) {
                        // 尝试重新初始化贴膜卡
                        destroy();
                        init();
                    }
                }
                return ret;
            }


            if (Function.isMainThread()) {
                if (state == CardState.INITIALIZING) {
                    Log.d(THIS_FILE, "Main thread can't sleep here.");
                    return lastErrCode;
                }
            }

            startTime = System.currentTimeMillis();
            while (state == CardState.INITIALIZING) {
                Log.d(THIS_FILE, "Cover card is not ready. Wait!");
                try {
                    Thread.sleep(200);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

                if (state == CardState.READY) {
                    ret = doRun(args);
                    if (ret == 0) { //调用成功
                        return ret;
                    }
                    if (ret == -100 || ret == -2 || ret == -18) {
                        // 调用出错，打开日志开关
                        coverCard.SetLogFlag(true);

                        do {
                            try {
                                Thread.sleep(1000);
                            } catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            ret = doRun(args);
                            if (ret == 0) {
                                return ret;
                            }
                            retryCnt--;

                        } while ((ret == -100 || ret == -2 || ret == -18) && retryCnt > 0);

                        coverCard.SetLogFlag(false);
                        // 尝试重新初始化贴膜卡
                        if (retryCnt == 0) {
                            // 尝试重新初始化贴膜卡
                            destroy();
                            init();
                        }
                    }
                    return ret;
                }

                if (state == CardState.NULL) {
                    return lastErrCode;
                }

                if (state == CardState.INVALID) {
                    return lastErrCode;
                }

//                else {
//                    if ((currentTime - startTime) > delta) {
//
//                        MyApplication.myApplication.getHandler().post(new Runnable() {
//                            @Override
//                            public void run() {
//                                if (coverCard != null) {
//                                    Log.e(THIS_FILE, "Start to reconnect 5 seconds");
//
//                                    MyApplication.myApplication.getHandler().post(new Runnable() {
//                                        @Override
//                                        public void run() {
//                                            coverCard.CloseSEService();
//                                            coverCard = new CoverCard();
//                                            coverCard.OpenSEService(MyApplication.myApplication, CoverCardWrapper.getInstance());
//                                        }
//                                    });
//
//                                }
//                            }
//                        });
//
//                        delta += 5*1000;
//                    }
//                }

            }



            // should never go here
            return lastErrCode;
        }
    }

    private class GetCardIDRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object ...args) {
            byte[] cardId = (byte[])args[0];
            int[] cardIdLen = (int[])args[1];
            XDJA_DEVINFO deviceInfo = new XDJA_DEVINFO();
            int ret = coverCard.GetDevInfo(deviceInfo);
            if (ret == 0) {
                cardIdLen[0] = 32;
                Log.d(THIS_FILE, "Get dev info success.");
                System.arraycopy(deviceInfo.cardid, 0, cardId, 0, 32);
                return ret;
            }

            Log.e(THIS_FILE, "Get dev info failed. ret = " + ret);
            return ret;
        }
    }

    private class GetDevInfoRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            XDJA_DEVINFO xdja_devinfo = (XDJA_DEVINFO)args[0];
            return coverCard.GetDevInfo(xdja_devinfo);
        }
    }

    public int getDevInfo(XDJA_DEVINFO devinfo) {
        return new GetDevInfoRunnable().run(devinfo);
    }

    // xdja api
    public int genRandom(int len, byte[] random) {
        return new GenerateRandomRunnable().run(len, random);
    }
    private class GenerateRandomRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.GenRandom((int)args[0], (byte[])args[1]);
        }
    }

    public int changePIN(int role, byte[] oldpin, int oldlen, byte[] newpin, int newlen) {
        return new ChangePINRunnable().run(role, oldpin, oldlen, newpin, newlen);
    }

    private class ChangePINRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.ChangePIN((int)args[0], (byte[])args[1], (int)args[2], (byte[])args[3], (int)args[4]);
        }
    }

    // create file
    public int createFile(XDJA_FILE file) {
        return new CreateFileRunnable().run(file);
    }
    private class CreateFileRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.CreateFile((XDJA_FILE) args[0]);
        }
    }

    // write file
    public int writeFile(byte[] fid, int pos, int len, byte[] data) {
        return new WriteFileRunnable().run(fid, pos, len, data);
    }
    private class WriteFileRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.WriteFile((byte[])args[0], (int)args[1], (int)args[2], (byte[])args[3]);
        }
    }

    // read rsa pubkey
    public int readRsaPubkey(byte[] fid, XDJA_RSA_PUBKEY pubkey) {
        return new ReadRSAPubkeyRunnable().run(fid, pubkey);
    }
    private class ReadRSAPubkeyRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.ReadRsaPubKey((byte[])args[0], (XDJA_RSA_PUBKEY)args[1]);
        }
    }

    // write rsa pubkey
    private class WriteRSAPubkeyRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.WriteRsaPubKey((byte[])args[0], (XDJA_RSA_PUBKEY)args[1]);
        }
    }
    public int writeRsaPubkey(byte[] fid, XDJA_RSA_PUBKEY pubkey) {
        return new WriteRSAPubkeyRunnable().run(fid, pubkey);
    }


    // write cert
    private class WriteCertRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.WriteCert((byte[])args[0], (byte[])args[1], (int)args[2]);
        }
    }
    public int writeCert(byte[] fid, byte[] cert, int len) {
        return new WriteCertRunnable().run(fid, cert, len);
    }

    // generate rsa pair
    private class GenerateRSAPairRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.GenRSAKeyPair((int)args[0], (byte[])args[1], (byte[])args[2]);
        }
    }
    public int genRsaKeyPair(int bits, byte[] pubfid, byte[] prifid) {
        return new GenerateRSAPairRunnable().run(bits, pubfid, prifid);
    }

    // rsa pubkey calc
    private class RsaPubkeyCalcRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.RSAPubKeyCalc((byte[])args[0], (int)args[1], (byte[])args[2], (int)args[3], (byte[])args[4], (int[])args[5]);
        }
    }
    public int rsaPubkeyCalc(byte[] fid, int bits, byte[] datain, int inlen, byte[] out, int[] outlen) {
        return new RsaPubkeyCalcRunnable().run(fid, bits, datain, inlen, out, outlen);
    }

    // rsa sign
    private class RsaSignRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.RSASign((byte[])args[0], (int)args[1], (int)args[2],
                    (byte[])args[3], (int)args[4], (byte[])args[5], (int[])args[6]);
        }
    }
    public int rsaSign(byte[] fid, int bits, int datatype,
                       byte[] datain, int inlen, byte[] sign, int[] signlen) {
        return new RsaSignRunnable().run(fid, bits, datatype, datain, inlen, sign, signlen);
    }

    // rsa sign verify
    private class RsaSignVerifyRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.RSASignVerify((byte[])args[0], (int)args[1], (int)args[2],
                    (byte[])args[3], (int)args[4], (byte[])args[5], (int)args[6]);
        }
    }
    public int rsaSignVerify(byte[] id, int bits, int datatype,
                             byte[] datain, int inlen, byte[] sign, int signlen) {
        return new RsaSignVerifyRunnable().run(id, bits, datatype, datain, inlen, sign, signlen);
    }

    // set sm2 param
    private class SetSM2ParamRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.SetSM2Param((XDJA_SM2_PARAM)args[0]);
        }
    }
    public int setSM2Param(XDJA_SM2_PARAM sm2_param) {
        return new SetSM2ParamRunnable().run(sm2_param);
    }

    // set sm2 id
    private class SetSM2IdRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.SetSM2Id((byte[])args[0], (int)args[1]);
        }
    }
    public int setSM2Id(byte[] id, int len) {
        return new SetSM2ParamRunnable().run(id, len);
    }

    // gen sm2 keypair
    private class GenSM2KeypairRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.GenSM2KeyPair((byte[])args[0], (byte[])args[1]);
        }
    }
    public int genSM2Keypair(byte[] pubfid, byte[] prifid) {
        return new GenSM2KeypairRunnable().run(pubfid, prifid);
    }

    // read sm2 pubkey
    private class ReadSM2PubkeyRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.ReadSm2PubKey((byte[])args[0], (XDJA_SM2_PUBKEY)args[1]);
        }
    }
    public int readSM2Pubkey(byte[] fid, XDJA_SM2_PUBKEY pubkey) {
        return new ReadSM2PubkeyRunnable().run(fid, pubkey);
    }

    // sm2 encrypt
    private class SM2EncryptRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.SM2Encrypt((byte[])args[0], (byte[])args[1], (int)args[2], (byte[])args[3], (int[])args[4]);
        }
    }
    public int sm2Encrypt(byte[] id, byte[] data, int len, byte[] out, int[] outlen) {
        return new SM2EncryptRunnable().run(id, data, len, out, outlen);
    }

    // sm2 decrypt
    private class SM2DecryptRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.SM2Decrypt((byte[])args[0], (byte[])args[1], (int)args[2], (byte[])args[3], (int[])args[4]);
        }
    }
    public int sm2Decrypt(byte[] id, byte[] datain, int inlen, byte[] dataout, int[] outlen) {
        return new SM2DecryptRunnable().run(id, datain, inlen, dataout, outlen);
    }


    // unlock pin
    private class UnlockPinRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
//            return coverCard.UnlockPIN((int)args[0], (byte[])args[1], (int)args[2], (byte[])args[3], (int)args[4]);
            return 0;
        }
    }
    public int unlockPIN(int pukid, byte[] puk, int puklen, byte[] pin, int pinlen) {
        return new UnlockPinRunnable().run(pukid, puk, puklen, pin, pinlen);
    }

    // write sm2 pubkey
    private class WriteSM2PubkeyRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.WriteSm2PubKey((byte[])args[0], (XDJA_SM2_PUBKEY)args[1]);
        }
    }
    public int writeSM2Pubkey(byte[] fid, XDJA_SM2_PUBKEY pubkey) {
        return new WriteSM2PubkeyRunnable().run(fid, pubkey);
    }

    // sm2 sign verify
    private class SM2SignVerifyRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            return coverCard.SM2SignVerify((byte[])args[0], (int)args[1], (byte[])args[2], (int)args[3], (byte[])args[4], (int)args[5]);
        }
    }
    public int sm2SignVerify(byte[] pubfid, int datatype, byte[] datain, int inlen, byte[] sign, int signlen) {
        return new SM2SignVerifyRunnable().run(pubfid, datatype, datain, inlen, sign, signlen);
    }

    private class ReadCertRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            byte[] fid = (byte[]) args[0];
            byte[] cert = (byte[])args[1];
            int[] len = (int[])args[2];
            return coverCard.ReadCert(fid, cert, len);
        }
    }

    private class VerifyPINRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            int role = (int) args[0];
            byte[] pin = (byte[]) args[1];
            int len = (int) args[2];
            int ret = coverCard.VerifyPIN(role, pin, len);
            return ret;
        }
    }

    private class RSAPrikeyCalcRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            byte[] fid = (byte[]) args[0];
            int bits = (int) args[1];
            byte[] inputData = (byte[]) args[2];
            int inputDataSize = (int) args[3];
            byte[] outputData = (byte[]) args[4];
            int[] outputDataSize = (int[]) args[5];
            return coverCard.RSAPriKeyCalc(fid, bits, inputData, inputDataSize, outputData, outputDataSize);
        }
    }

    private class SM2SignRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {

            byte[] pubFid = (byte[]) args[0];
            byte[] priFid = (byte[]) args[1];
            int isHashed = (int) args[2];
            byte[] dataIn = (byte[]) args[3];
            int inLen = (int) args[4];
            byte[] signData = (byte[]) args[5];
            int[] signDataLen = (int[]) args[6];

            return coverCard.SM2Sign(pubFid, priFid, isHashed==0?1:0, dataIn, inLen, signData, signDataLen);
        }
    }

    private class ReadFileRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            byte[] fid = (byte[]) args[0];
            int pos = (int) args[1];
            int len = (int) args[2];
            byte[] outData = (byte[]) args[3];

            return coverCard.ReadFile(fid, pos, len, outData);
        }
    }

    private class GetSM2ParamRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            XDJA_SM2_PARAM sm2Param = (XDJA_SM2_PARAM) args[0];
            return coverCard.GetSM2Param(sm2Param);
        }
    }

    private class GetSM2IDRunnable extends CoverCardRunnable {

        @Override
        protected int doRun(Object... args) {
            byte[] sm2id = (byte[]) args[0];
            int[] len = (int[]) args[1];
            return coverCard.GetSM2Id(sm2id, len);
        }
    }

    int rcvSimReadyEventCount = 0;
    @Override
    public void onSimStateChanged(int preState, int curState) {
        Log.e(THIS_FILE, "Current sim state " + curState);
        switch (curState) {
            case 6: // SIM卡未就绪，在切换流量卡时走到这个状态
            case TelephonyManager.SIM_STATE_ABSENT:
            case TelephonyManager.SIM_STATE_UNKNOWN:
                simState = curState;

                if (state != CardState.READY) {
                    return;
                }

                KeyDevInfo keyDevInfo = new KeyDevInfo();
                int ret = KeyWrapper.getInstance().getDevInfo(KeyWrapper.currentIndex, keyDevInfo);

                if (ret == 0 && keyDevInfo.getDriver().equals(KeyWrapper.COVER_KEY_DRIVER_NAME)) {
                    if (state == CardState.READY) {
                        destroy();

                        /**
                         * 此处需要停止隧道客户端（通过转发版调卡），因为如果不停止，隧道版会持续调用转发版贴膜卡接口，导致转发版
                         * 过早启动，检测不到贴膜卡
                         */
                        if (Function.isPackageExist_v2(MyApplication.myApplication, CONSTANT.VIDEO_CLIENT_PACKAGE_NAME)) {
                            Intent intent = new Intent();
                            intent.setAction(CONSTANT.ACTION_EXIT_TUN_CLIENT);
                            intent.putExtra("reason", "sim out");
                            MyApplication.myApplication.sendBroadcast(intent);
                        }

                        MyApplication.myApplication.getHandler().post(new Runnable() {
                            @Override
                            public void run() {
                                AlertUtil.popSystemAlert(MyApplication.myApplication,
                                        MyApplication.myApplication.getString(R.string.safe_client),
                                        MyApplication.myApplication.getString(R.string.detect_sim_change), null,false);

                                Function.stopVPN(MyApplication.myApplication);
                                new Timer().schedule(new TimerTask() {
                                    @Override
                                    public void run() {
                                        Function.exitApp(MyApplication.myApplication);
                                    }
                                }, 2000);


                            }

                        });

                    }
                }
                break;

            case TelephonyManager.SIM_STATE_READY:
                Log.d(THIS_FILE, "Current sim state " + curState);
                simState = curState;

                if (noSimTimer != null) {
                    noSimTimer.purge();
                    noSimTimer.cancel();
                    noSimTimer = null;
                }
                if (hasPendingInit) {
                    hasPendingInit = false;
                    MyApplication.myApplication.getHandler().post(
                            new Runnable() {
                                @Override
                                public void run() {
                                    if (state == CardState.INITIALIZING) {
                                        Log.e(THIS_FILE, "Sim ready now. Start to call cover card init");
                                        coverCard = new TMCAPI();
                                        coverCard.OpenSEService(MyApplication.myApplication, CoverCardWrapper.getInstance());
                                    }
                                }
                            });
                    return;

                }

                if (KeyWrapper.getInstance().isKeyError()) {
                    Function.runOnMainThread(new Runnable() {
                        @Override
                        public void run() {
                            KeyWrapper.getInstance().sysDestroy();
                            Function.initKeyModule(true);
                        }
                    });

                }
                break;

        }
    }

    public static class StatusCode {
        public static final int SUCCESS = 0;
        public static final int APP_NOT_INITIALIZED = -200; // 应用程序未初始化
        public static final int INIT_FAILED = -201; // 贴膜卡初始化失败
        public static final int SIM_NOT_VALID = -202; // 无可用的sim卡
        public static final int NOT_STARTED = -203; // 贴膜卡没有调用初始化
        public static final int INIT_IN_PROGRESS = -204; // 贴膜卡正在初始化中
    }

    public int getState() {
        return state;
    }
    /**
     * 贴膜卡状态
     */
    public static class CardState {
        public static final int INVALID = -1; // 当前无可用的设备
        public static final int NULL = 0; //当前未启用
        public static final int INITIALIZING = 1; // 初始化中
        public static final int READY = 2; // 当前可用

        public static String getComment(int state) {
            switch (state) {
                case INVALID:
                    return "INVALID";
                case NULL:
                    return "NULL";
                case INITIALIZING:
                    return "INITIALIZING";
                case READY:
                    return "READY";
                default:
                    return "UNKONW STATE";
            }
        }
    }

    private void openService() {
        Log.e(THIS_FILE, "Start to call cover card init");
        coverCard = new TMCAPI();
        coverCard.SetLogFlag(false);
        coverCard.OpenSEService(MyApplication.myApplication, CoverCardWrapper.getInstance());
    }

    private Timer noSimTimer = null;
    private Timer openServiceTimer = null;
    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public int init() {

        MyApplication application = MyApplication.myApplication;
        final int simState;
        int dataState;
        long startTime;
        boolean simReady = true;

        Log.e(THIS_FILE, "Get into cover card init");
        if (application == null) {
            Log.e(THIS_FILE, "Application NOT initialized!");
            return StatusCode.APP_NOT_INITIALIZED;
        }

        if (state == CardState.INITIALIZING || state == CardState.READY) {
            Log.d(THIS_FILE, "Cover card is init in porgess.");
            return StatusCode.SUCCESS;
        }

        TelephonyManager tm = (TelephonyManager) application.getSystemService(Service.TELEPHONY_SERVICE);
        simState = tm.getSimState();

        if (simState != TelephonyManager.SIM_STATE_READY) {
            Log.d(THIS_FILE, "SIM init state = " + simState);
            simReady = false;
        }

        if (simReady) {
            if (hasPendingInit) {
                if (noSimTimer != null) {
                    noSimTimer.purge();
                    noSimTimer.cancel();
                }
            }

            application.getHandler().post(new Runnable() {
                @Override
                public void run() {
                    openService();
                }
            });

            if (openServiceTimer != null) {
                openServiceTimer.purge();
                openServiceTimer.cancel();
            }
            openServiceTimer = new Timer();
            openServiceTimer.schedule(new TimerTask() {
                @Override
                public void run() {
                    lastErrCode = StatusCode.INIT_FAILED;
                    setCardState(CardState.INVALID);
                }
            }, 20000);

//            // caculate boot time
//            long bootTime = SystemClock.elapsedRealtime()/1000;
//            if (bootTime > 60) {
//                Log.d(THIS_FILE, "Post open covercard service task now.");
//                application.getHandler().post(new Runnable() {
//                    @Override
//                    public void run() {
//                        openService();
//                    }
//                });
//            } else {
//                Log.d(THIS_FILE, "Post open covercard service task delayed.");
//                application.getHandler().postDelayed(new Runnable() {
//                    @Override
//                    public void run() {
//                        openService();
//                    }
//                }, 10000);
//            }
        } else {
            hasPendingInit = true;
            if (noSimTimer != null) {
                noSimTimer.purge();
                noSimTimer.cancel();
            }

            noSimTimer = new Timer();
            noSimTimer.schedule(new TimerTask() {
                @Override
                public void run() {
                    hasPendingInit = false;
                    lastErrCode = StatusCode.SIM_NOT_VALID;
                    setCardState(CardState.INVALID);
                }
            }, 10000);
        }

        lastErrCode = StatusCode.INIT_IN_PROGRESS;
        setCardState(CardState.INITIALIZING);
        return StatusCode.SUCCESS;

    }

    public void destroy() {

        Log.d(THIS_FILE, "Destroy cover card factory");
        if (state == CardState.READY) {
            if (coverCard != null) {
                coverCard.CloseSEService();
            }
        }
        hasPendingInit = false;
        setCardState(CardState.NULL);
        coverCard = null;

    }


    public int getCardID(byte[] cardId, int[] len) {
        return new GetCardIDRunnable().run(cardId, len);
    }

    public int readCert(byte[] fid, byte[] cert, int[] len) {
        Log.d(THIS_FILE, "Read cert fid = " + fid[0] + "," + fid[1]);
        int ret;
        ret = new ReadCertRunnable().run(fid, cert, len);
        Log.e(THIS_FILE, "Cover card read cert return " + ret + "cert len " + len[0]);
        if (len[0] < 0) {
            len[0] = 0;
            ret = JNIAPI.XKR_FILE_NOT_EXIST;
        }
        return ret;
    }

    public int verifyPIN(int role, byte[] pin, int len) {
        // Current cover key only support role 1
        return new VerifyPINRunnable().run(0x01, pin, len);
    }

    public int RSAPrikeyCalc(byte[] fid, int bits, byte[] data, int size, byte[] out, int[] outSize) {
        return new RSAPrikeyCalcRunnable().run(fid, bits, data, size, out, outSize);
    }

    public int SM2Sign(byte[] pubFid, byte[] priFid, int isHashed, byte[] dataIn, int inLen, byte[] signData, int[] signLen) {
        return new SM2SignRunnable().run(pubFid, priFid, isHashed, dataIn, inLen, signData, signLen);
    }

    public int readFile(byte[] fid, int pos, int len, byte[] dataout) {
        return new ReadFileRunnable().run(fid, pos, len, dataout);
    }

    public int getSM2Param(XDJA_SM2_PARAM sm2Param) {
        int ret = new GetSM2ParamRunnable().run(sm2Param);
        Log.d(THIS_FILE, "SM2 Parma p " + HexString.dump(sm2Param.p));
        Log.d(THIS_FILE, "SM2 Parma a " + HexString.dump(sm2Param.a));
        Log.d(THIS_FILE, "SM2 Parma b " + HexString.dump(sm2Param.b));
        Log.d(THIS_FILE, "SM2 Parma n " + HexString.dump(sm2Param.n));
        Log.d(THIS_FILE, "SM2 Parma x " + HexString.dump(sm2Param.x));
        Log.d(THIS_FILE, "SM2 Parma y " + HexString.dump(sm2Param.y));
        return ret;
    }

    public int getSM2ID(byte[] id, int[] len) {
        return new GetSM2IDRunnable().run(id, len);
    }

    public boolean checkDevice () {
        XDJA_DEVINFO xdja_devinfo = new XDJA_DEVINFO();

        int ret = new GetDevInfoRunnable().run(xdja_devinfo);

        if (ret == StatusCode.SUCCESS) {
            return true;
        }
        return false;
    }

}
