package com.xdja.key.zhongfu;

import com.xdja.safeclient.utils.Log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by xingjianqiang on 2017/8/11.
 * Project : safeclient.android.origin
 * Email : xingjianqiang@xdja.com
 */

public class ZhongfuDevState {

    private String THIS_FILE = "ZhongfuDevState";

    public static final int DEVICE_NOT_OPENED= 1000;
    public static final int APP_NOT_OPENED = 1001;
    public static final int CONTAINER_NOT_OPENED = 1002;

    private class AppState {
        String appName;
        long[] appHandle = new long[]{0};
        HashMap<String, long[]> containers = new HashMap<>();

        public void init() {
            appName = null;
            appHandle[0] = 0;
            containers.clear();
        }

    }

    private String devAdress;
    private long[] devHandle = new long[]{0};
    private ArrayList<AppState> appStateArrayList = new ArrayList<>();

    public void init() {
        devAdress = null;
        for (AppState appState:appStateArrayList) {
            appState.init();
        }
        appStateArrayList.clear();
    }


    public int getDev(String device, long[] handle) {
        if (device.equalsIgnoreCase(devAdress)) {
            Log.d(THIS_FILE, "Device " + devAdress + " already opened.");
            handle[0] = devHandle[0];
            return 0;
        }
        return DEVICE_NOT_OPENED;
    }

    public int getApp(String device, String appName, long[] appHandle) {
        if (!device.equalsIgnoreCase(devAdress)) {
            return DEVICE_NOT_OPENED;
        }

        for (AppState appState:appStateArrayList) {
            if (appName.equals(appState.appName)) {
                appHandle[0] = appState.appHandle[0];
                return 0;
            }
        }

        return APP_NOT_OPENED;

    }

    public int getContainer(String device, String app, String container, long[] containerHandle) {
        if (!device.equalsIgnoreCase(devAdress)) {
            return DEVICE_NOT_OPENED;
        }

        for (AppState appState:appStateArrayList) {
            if (app.equals(appState.appName)) {
                Iterator iter = appState.containers.entrySet().iterator();
                while(iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    if (container.equals(entry.getKey())) {
                        long[] handle = (long[]) entry.getValue();
                        containerHandle[0] = handle[0];
                        return 0;
                    }
                }

                return CONTAINER_NOT_OPENED;
            }
        }

        return APP_NOT_OPENED;

    }

    public int updateDev(String device, long[] handle) {
        init();
        devAdress = device;
        devHandle[0] = handle[0];
        return 0;
    }

    public int updateApp(String device, String app, long[] handle) {
        if (!device.equalsIgnoreCase(devAdress)) {
            return DEVICE_NOT_OPENED;
        }
        for (AppState appState:appStateArrayList) {
            if (app.equals(appState.appName)) {
                if (appState.appHandle[0] == handle[0]) {
                    Log.d(THIS_FILE, "Handle already update.");
                    return 0;
                }
                appState.appHandle[0] = handle[0];
                appState.containers.clear();
                return 0;
            }
        }

        AppState appState = new AppState();
        appState.appHandle[0] = handle[0];
        appState.appName = app;
        appStateArrayList.add(appState);
        return 0;
    }

    public int updateContainer(String device, String app, String container, long[] conHandle) {
        if (!device.equalsIgnoreCase(devAdress)) {
            return DEVICE_NOT_OPENED;
        }

        for (AppState appState:appStateArrayList) {
            if (app.equals(appState.appName)) {
                Iterator iter = appState.containers.entrySet().iterator();
                while(iter.hasNext()) {
                    Map.Entry entry = (Map.Entry)iter.next();
                    if (container.equals(entry.getKey())) {
                        long[] handle = (long[]) entry.getValue();
                        handle[0] = conHandle[0];
                        return 0;
                    }
                }

                appState.containers.put(container, conHandle);
                return 0;
            }
        }

        return APP_NOT_OPENED;
    }


}
