package com.xdja.key.zhongfu;

import com.xdja.safeclient.utils.Log;
import com.zf.msmart.SmartCTCAPI;

/**
 * Created by xingjianqiang on 2017/7/28.
 * Project : safeclient.android.origin
 * Email : xingjianqiang@xdja.com
 */

public class ZhongfuWrapper {

    private static final String TAG = "ZhongfuWrapper";

    private static SmartCTCAPI smartapi = new SmartCTCAPI();
    private static ZhongfuWrapper key = null;
    public static ZhongfuWrapper getInstance() {
        if (key == null)
            key = new ZhongfuWrapper();

        return key;
    }

    // 当前设备状态
    ZhongfuDevState zhongfuDevState = new ZhongfuDevState();

    private ZhongfuWrapper() {}


    public long disconnect(String address) {

        Log.d(TAG, "Disconnect device");
        long ret;
        long[] devHandle = new long[1];

        ret = zhongfuDevState.getDev(address, devHandle);
        if (ret == 0) {
            ret = smartapi.SKF_DisConnectDev(devHandle[0]);

            if (ret == 0) {
                Log.d(TAG, "Disconnect device success.");
                zhongfuDevState.init();
                return 0;
            }
            Log.e(TAG, "Disconnect error. Ret " + ret);
        }

        Log.d(TAG, "Device " + address + " not opened.");
        return ret;

    }


    public long connect(String address, long[] devHandle) {
        long ret;

        ret = zhongfuDevState.getDev(address, devHandle);
        if (ret == 0) {
            Log.d(TAG, "Device " + address + " already opened.");
            return 0;
        }

        ret = smartapi.SKF_ConnectDev(address.getBytes(), devHandle);
        if (ret == 0) {
            zhongfuDevState.updateDev(address, devHandle);
        } else {
            Log.e(TAG, "Connect device " + address + " failed. ret " + ret);
        }
        return ret;
    }


    public long openApp(String device, String appName, long[] appHandle) {
        long ret;
        long[] devHandle = new long[1];

        ret = zhongfuDevState.getApp(device, appName, appHandle);

        if (ret == 0) {
            Log.d(TAG, "App " + appName + " already opened.");
            return 0;
        }
        ret = connect(device, devHandle);
        if (ret != 0) {
            Log.e(TAG, "Open device " + device + "failed.");
            return ret;
        }
        zhongfuDevState.getDev(device, devHandle);
        ret = smartapi.SKF_OpenApplication(devHandle[0], appName.getBytes(), appHandle);
        if (ret == 0) {
            Log.d(TAG, "Open application success.");
            zhongfuDevState.updateApp(device, appName, appHandle);
        }
        return ret;

    }

    public long openContainer(String device, String appName, String container, long[] conHandle) {
        long ret;
        long[] devHandle = new long[1];
        long[] appHandle = new long[1];

        ret = zhongfuDevState.getContainer(device, appName, container, conHandle);
        if (ret == 0) {
            Log.d(TAG, "Container " + container + " already opened.");
            return ret;
        }


        ret = connect(device, devHandle);
        if (ret != 0) {
            Log.e(TAG, "Open device " + device + "failed.");
            return ret;
        }

        ret = openApp(device, appName, appHandle);
        if (ret != 0) {
            Log.e(TAG, "Open container " + container + "failed.");
            return ret;
        }

        ret = smartapi.SKF_OpenContainer(appHandle[0], container.getBytes(), conHandle);
        if (ret == 0) {
            Log.d(TAG, "Open container "+container+ " success.");
            zhongfuDevState.updateContainer(device, appName, container, conHandle);
        }

        return ret;

    }


    public long verifyPIN(long appHandle, String pin) {
        long[] pulRetryCount = new long[2];
        long ret;

        ret = smartapi.SKF_VerifyPIN(appHandle, SmartCTCAPI.USER_TYPE, pin.getBytes(), pulRetryCount);
        if  (ret != 0) {
            Log.e(TAG, "Pin error. Have " + pulRetryCount[0] + " times retry");
        }

        return ret;
    }

    public long readCert(long conHandle, boolean isSign, byte[] cert, long[] len) {
        long ret;

        ret = smartapi.SKF_ExportCertificate(conHandle, isSign, cert, len);

        if (ret != 0) {
            Log.e(TAG, "Read cert error. ret " + ret);
            return ret;
        }
        return 0;
    }

    public String getCardId(long devHandle) {
        SmartCTCAPI.DEVICEINFO devInfo = new SmartCTCAPI.DEVICEINFO();
        long ret;

        ret = smartapi.SKF_GetDevInfo(devHandle, devInfo);
        if (ret != 0) {
            Log.e(TAG, "Get dev info failed. ");
            return null;
        }

        return new String(devInfo.SerialNumber);

    }

    public long rsaSign(long containerHandle, byte[] inputData, long inputLen, byte[] outputData, long[] outputLen) {
        long ret;

        ret = smartapi.SKF_RSASignData(containerHandle, inputData, inputLen, outputData, outputLen);

        if (ret != 0) {
            Log.e(TAG, "RSA sign data error. ret " + ret);
        }

        return ret;
    }

    public long sm2Sign(long containerHandle, byte[] inputData, long inputLen, byte[] outputData, long[] outputLen) {
        long ret;
        SmartCTCAPI.ECCSIGNATUREBLOB sign = new SmartCTCAPI.ECCSIGNATUREBLOB();
        ret = smartapi.SKF_ECCSignData(containerHandle, inputData, inputLen, sign);

        if (ret != 0) {
            Log.e(TAG, "SM2 sign data error. ret " + ret);
        }

        System.arraycopy(sign.r, 0, outputData, 0, 32);
        System.arraycopy(sign.s, 0, outputData, 32, 32);

        outputLen[0] = 64;
        return ret;
    }

//    public int importTestExchangeCert() {
//        byte[] certBuf = new byte[2048];
//        int[] certLen = new int[1];
//        byte[] prikeyBuf = new byte[2048];
//        int[] prikeyLen = new int[1];
//
//        byte[] enPrikeyBuf = new byte[2048];
//        long[] enPrikeyLen = new long[1];
//
//        byte[] sessionKey = new byte[16];
//        long[] keyHandle = {0,0};
//        long ret;
//        int status;
//        int rsalen = 128;
//
//
//        // 打开应用
//        ret = openApp(CONSTANT.ZHONGFU_APP_NAME);
//
//        if (ret != 0) {
//            Log.e(TAG, "Open application failed.");
//            return -1;
//        }
//
//        ret = verifyPIN("111111");
//        if (ret != 0) {
//            Log.e(TAG, "Verify pin failed. ret " + ret);
//            return -1;
//        }
//
//        Log.d(TAG, "Verify pin success.");
//
//        // create container
//        ret = openContainer("xdja");
//
//
//        if (ret != 0) {
//            Log.e(TAG, "Open container xdja failed. Create container");
//            ret = createContainer("xdja");
//            if (ret != 0) {
//                Log.e(TAG, "Create container xdja failed.");
//                return -1;
//            } else {
//                Log.d(TAG, "Create container xdja success.");
//            }
//        }
//
//        SmartCTCAPI.RSAPUBLICKEYBLOB rsapublickeyblob = new SmartCTCAPI.RSAPUBLICKEYBLOB();
//        ret = smartapi.SKF_GenRSAKeyPair(hContainer[0], 1024, rsapublickeyblob);
//
//        if (ret != 0) {
//            Log.e(TAG, "Gen rsa key pair faild. ret " + ret);
//            return -1;
//        } else {
//            Log.e(TAG, "Gen rsa key pair success.");
//
//            Log.d(TAG, "Gen Pubkey " + Function.byte2hex(rsapublickeyblob.Modulus, 128, 128));
//        }
//
//        Arrays.fill(sessionKey, (byte) 0x02);
//        ret = smartapi.SKF_SetSymmKey(hHandle[0], sessionKey, SmartCTCAPI.SGD_SMS4_ECB, keyHandle);
//
//        if (ret != 0) {
//            Log.e(TAG, "Set symmkey faild. ret " + ret);
//            return -1;
//        } else {
//            Log.e(TAG, "Set symmkey success.");
//        }
//
//        SmartCTCAPI.BLOCKCIPHERPARAM blockcipherparam = new SmartCTCAPI.BLOCKCIPHERPARAM();
//        blockcipherparam.PaddingType = 0;
//        ret = smartapi.SKF_EncryptInit(keyHandle[0], blockcipherparam);
//        if (ret != 0) {
//            Log.e(TAG, "Encrypt init faild. ret " + ret);
//            return -1;
//        } else {
//            Log.e(TAG, "Encrypt init success.");
//        }
//
//        status = SSLVPN.parsePKCS12("/sdcard/4800eb4d.pfx", "4800eb4d", certBuf, certLen, prikeyBuf, prikeyLen);
//        Log.d(TAG, "Parse pkcs12 status " + status + " cert len "+ certLen[0] + " prikey len " + prikeyLen[0]);
//
//        enPrikeyLen[0] = 2048;
//        ret = smartapi.SKF_Encrypt(keyHandle[0], prikeyBuf, prikeyLen[0], enPrikeyBuf, enPrikeyLen);
//        if (ret != 0) {
//            Log.e(TAG, "Encrypt prikey faild. ret " + ret);
//            return -1;
//        } else {
//            Log.d(TAG, "Input prikey " + Function.byte2hex(prikeyBuf, prikeyLen[0]));
//            Log.d(TAG, "Output prikey " + Function.byte2hex(enPrikeyBuf, (int)enPrikeyLen[0]));
//            Log.e(TAG, "Encrypt prikey success. out len " + enPrikeyLen[0]);
//        }
//
//        // padding data
//        byte[] inputBuf = new byte[rsalen];
//        Arrays.fill(inputBuf, (byte) 0xff);
//        inputBuf[0] = 0x00;
//        inputBuf[1] = 0x02;
//        inputBuf[rsalen-16-1] = 0x00;
//        System.arraycopy(sessionKey, 0, inputBuf, rsalen-16, 16);
//
//        Log.d(TAG, "Input buf  " + Function.byte2hex(inputBuf, rsalen));
//
//        // use pubkey encyrpt symkey
//        byte[] outputData = new byte[2048];
//        long[] outputDataLen = new long[1];
//        outputDataLen[0] = 2048;
//        ret = smartapi.SKF_ExtRSAPubKeyOperation(hHandle[0], rsapublickeyblob, inputBuf, rsalen, outputData, outputDataLen);
//
//        Log.d(TAG, "Output buf  " + Function.byte2hex(outputData, (int) outputDataLen[0]));
//        if (ret != 0) {
//            Log.e(TAG, "Pubkey encrypt symkey faild. ret " + ret);
//            return -1;
//        } else {
//            Log.e(TAG, "Pubkey encrypt symkey success. out len " + outputDataLen[0]);
//        }
//
//        // import rsa key pair
//        ret = smartapi.SKF_ImportRSAKeyPair(hContainer[0], SmartCTCAPI.SGD_SMS4_ECB, outputData, outputDataLen[0], enPrikeyBuf, enPrikeyLen[0]);
//        if (ret != 0) {
//            Log.e(TAG, "Import rsa pair faild. ret " + ret);
////            return -1;
//        } else {
//            Log.e(TAG, "Import rsa pair success.");
//        }
//
//        ret = smartapi.SKF_ImportCertificate(hContainer[0], true, certBuf, certLen[0]);
//        if (ret != 0) {
//            Log.e(TAG, "Import cert faild. ret " + ret);
////            return -1;
//        } else {
//            Log.e(TAG, "Import cert success.");
//        }
//
//        return 0;
//    }

    public long importCert(long conHandle, boolean isSign, byte[] certBuf, long certLen) {
        long ret;
        ret = smartapi.SKF_ImportCertificate(conHandle, isSign, certBuf, certLen);
        if (ret != 0) {
            Log.e(TAG, "Import cert faild. ret " + ret);
//            return -1;
        } else {
            Log.d(TAG, "Import cert success.");
        }
        return ret;
    }



}
