package com.xdja.safeclient;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.SystemClock;
import android.telephony.TelephonyManager;

import com.xdja.safeclient.receiver.bootBroadcastReceiver;
import com.xdja.safeclient.utils.Log;

public class GuardianHelper {

	private static String TAG = "guardian-Helper";
	public final static String ALARM_ACTION = "com.xdja.safeclient.guardian_advise";
	
	public enum guardian_network {
	    G_NETWORK_NONE,
	    G_NETWORK_2G,
	    G_NETWORK_3G,
	    G_NETWORK_4G,
	    G_NETWORK_5G,
	    G_NETWORK_WIFI,
	};
	
	public enum guardian_option {
	    G_OPT_CONNECTING,
	    G_OPT_CONNECT_FAIL,
	    G_OPT_CONNECTED,
	    G_OPT_HANDSHAKE_BEGIN,
	    G_OPT_HANDSHAKE_SUCCESS,
	    G_OPT_HANDSHAKE_FAIL,
	    G_OPT_DATA_SENT,
	    G_OPT_DATA_RECVED,
	    G_OPT_HEARTBEAT_SENT,
	    G_OPT_HEARTBEAT_RECVED,
	    G_OPT_CONNECTION_CLOSE,
	    G_OPT_TIME_UPDATED,
	    G_OPT_NETWORK_SWITCHED,
	    G_OPT_SCREEN_ON,
	    G_OPT_SCREEN_OFF,
	    G_START_VPN,
	    G_OPTIONS_NUM
	};
	
	public static void invokeOnceAlarm(Context context, int second) {

		Log.d(TAG, "invokeAlarm,  second = " + second);
		
		Intent intent = new Intent(context, bootBroadcastReceiver.class);

		intent.putExtra("Later", second);
		
		intent.setAction(ALARM_ACTION);

		PendingIntent sender = PendingIntent.getBroadcast(context, 0, intent, 0);

		// 开始时间
		long firstime = SystemClock.elapsedRealtime();
		
		AlarmManager am = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);

		//am.setRepeating(AlarmManager.RTC_WAKEUP, firstime, 1000*second, sender);	
		am.set(AlarmManager.ELAPSED_REALTIME_WAKEUP, firstime + 1000*second, sender);
	}

	public static void cancleOnceAlarm(Context context) {
		Log.d(TAG, "cancleAlarm");
		
		Intent intent = new Intent(context, bootBroadcastReceiver.class);
		intent.setAction(ALARM_ACTION);
		PendingIntent sender = PendingIntent.getBroadcast(context, 0, intent, 0);
		
		AlarmManager alarm = (AlarmManager) context.getSystemService(Context.ALARM_SERVICE);
		alarm.cancel(sender);
	}

	// 检查网络类型
	public static guardian_network getNetWorkType(Context context) {
		String name = "";
		guardian_network type = guardian_network.G_NETWORK_NONE;

		try {
			ConnectivityManager cm = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo info = cm.getActiveNetworkInfo();

			if (info == null) {
				name = "null";
				type = guardian_network.G_NETWORK_NONE;

				Log.i(TAG, "checkNetWork, info == null");

				return type;
			}

			if (!info.isConnected()) {
				name = "null";
				type = guardian_network.G_NETWORK_NONE;

				Log.i(TAG, "checkNetWork, ! isConnected");

				return type;
			}

			if (info.getState() != NetworkInfo.State.CONNECTED) {
				name = "null";
				type = guardian_network.G_NETWORK_NONE;

				Log.i(TAG, "checkNetWork, not CONNECTED");

				return type;
			}

			Log.d(TAG, "Current network type = " + info.getType());

			if (info.getType() == ConnectivityManager.TYPE_WIFI) {
				name = "wifi";
				type = guardian_network.G_NETWORK_WIFI;

				Log.i(TAG, "checkNetWork, wifi");
			} else if (info.getType() == ConnectivityManager.TYPE_MOBILE ||
					info.getType() == 12)  // TYPE_MOBILE_CBS 中兴双在线系统专用 Add by xjq, 2017-7-3 14:55:53
			{

				int subType = info.getSubtype();

				Log.i(TAG, "checkNetWork, TYPE_MOBILE, subType = " + subType);

				if (subType == TelephonyManager.NETWORK_TYPE_GPRS) {
					type = guardian_network.G_NETWORK_2G;
					Log.i(TAG, "checkNetWork, NETWORK_TYPE_2G");
				} else if (subType == TelephonyManager.NETWORK_TYPE_CDMA
						|| subType == TelephonyManager.NETWORK_TYPE_EDGE) {
					name = "2g";
					type = guardian_network.G_NETWORK_2G;
					Log.i(TAG, "checkNetWork, G_NETWORK_2G");
				}
				/*
				 * TelephonyManager.NETWORK_TYPE_UMTS 通用移动通信系统
				 * TelephonyManager.NETWORK_TYPE_EHRPD 电信
				 * TelephonyManager.NETWORK_TYPE_HSDPA 联通
				 * TelephonyManager.NETWORK_TYPE_HSPA 联通
				 * TelephonyManager.NETWORK_TYPE_HSPAP 联通
				 * TelephonyManager.NETWORK_TYPE_HSUPA 联通
				 * TelephonyManager.NETWORK_TYPE_EVDO_A 电信
				 * TelephonyManager.NETWORK_TYPE_EVDO_0 电信
				 * TelephonyManager.NETWORK_TYPE_EVDO_B 电信
				 * 
				 */
				else if (subType == TelephonyManager.NETWORK_TYPE_UMTS || subType == TelephonyManager.NETWORK_TYPE_EHRPD
						|| subType == TelephonyManager.NETWORK_TYPE_HSDPA
						|| subType == TelephonyManager.NETWORK_TYPE_HSPA
						|| subType == TelephonyManager.NETWORK_TYPE_HSPAP
						|| subType == TelephonyManager.NETWORK_TYPE_HSUPA
						|| subType == TelephonyManager.NETWORK_TYPE_EVDO_A
						|| subType == TelephonyManager.NETWORK_TYPE_EVDO_0
						|| subType == TelephonyManager.NETWORK_TYPE_EVDO_B) {
					name = "3g";
					type = guardian_network.G_NETWORK_3G;
					Log.i(TAG, "checkNetWork, G_NETWORK_3G");
				}
				// LTE是3g到4g的过渡，是3.9G的全球标准
				else if (subType == TelephonyManager.NETWORK_TYPE_LTE) {
					name = "4g";
					type = guardian_network.G_NETWORK_4G;
					Log.i(TAG, "checkNetWork, G_NETWORK_4G");
				} else {
					type = guardian_network.G_NETWORK_3G;
					Log.i(TAG, "checkNetWork, unknow type, G_NETWORK_3G");
				}
			} else {
				name = "4g";
				type = guardian_network.G_NETWORK_4G;
				Log.i(TAG, "checkNetWork, other equals G_NETWORK_4G");
			}
		} catch (Exception e) {
			e.printStackTrace();
			name = "null";
			type = guardian_network.G_NETWORK_NONE;
			Log.i(TAG, "checkNetWork, Exception");
		}

		Log.i(TAG, "checkNetWork, type : " + type + " name : " + name);

		return type;
	}
	    
}
