package com.xdja.safeclient;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Intent;
import android.database.Cursor;
import android.database.CursorWrapper;
import android.database.MatrixCursor;
import android.net.Uri;

import com.xdja.safeclient.StartVpnActivity;
import com.xdja.safeclient.utils.Log;

/**
 * 嘉赛MDM对APK应用保活方案规范
 * 1、	ContentProvider规范
 * 1.1  规范说明
 * 第三方应用需要开发一个ContentProvider服务，URI定义为：content://{第三方应用包名}.KeepProvider/。其中{第三方应用包名}需要替换为应用自身包名。
 * 在该Provider中query方法中实现第三方应用自身保活逻辑。
 */
public class KeepProvider extends ContentProvider {

    public static final String TAG = "KeepProvider";

    public KeepProvider() {
    }

    @Override
    public int delete(Uri uri, String selection, String[] selectionArgs) {
        // Implement this to handle requests to delete one or more rows.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public String getType(Uri uri) {
        // TODO: Implement this to handle requests for the MIME type of the data
        // at the given URI.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public Uri insert(Uri uri, ContentValues values) {
        // TODO: Implement this to handle requests to insert a new row.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public boolean onCreate() {
        // TODO: Implement this to initialize your content provider on startup.
        return false;
    }

    @Override
    public Cursor query(Uri uri, String[] projection, String selection,
                        String[] selectionArgs, String sortOrder) {

        MatrixCursor cursor = new MatrixCursor(new String[]{"result"});

        int result = startTunVpn();

        //启动失败
        if (result == -1) {
            cursor.addRow(new String[]{"fail"});
        } else {
            //启动成功
            cursor.addRow(new String[]{"success"});
        }

        return cursor;

    }

    @Override
    public int update(Uri uri, ContentValues values, String selection,
                      String[] selectionArgs) {
        // TODO: Implement this to handle requests to update one or more rows.
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private int startTunVpn() {
        //ComponentName componetName = new ComponentName(CONSTANT.PackageName,"com.xdja.safeclient.activity.StartVpnActivity");
        try {
            Intent intent = new Intent(getContext(), StartVpnActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT
                    | Intent.FLAG_ACTIVITY_NEW_TASK);
            //intent.setComponent(componetName);
            getContext().startActivity(intent);
        } catch (Exception e) {
            e.printStackTrace();
            Log.e(TAG, "startActivity StartVpnActivity failed");
            return -1;
        }

        return 0;
    }


}
