package com.xdja.safeclient;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.xdja.safeclient.utils.Log;

import com.xdja.safeclient.bean.TrafficTable;
import com.xdja.safeclient.utils.FileUtil;

public class TrafficStatistics {
    public SQLiteDatabase getmDB() {
        return mDB;
    }

    public void setmDB(SQLiteDatabase mDB) {
        this.mDB = mDB;
    }

    public static String getMdbname() {
        return mDBName;
    }

    public static String getMtraffictable() {
        return mTrafficTable;
    }

    private static final String mDBName = "flow.db";
    //	private static final String pathStr = "data/data/com.xdja.safeclient/files/";
    private String pathStr;
    private String mDBPath;
    private static final String mTrafficTable = "traffic";

    private SQLiteDatabase mDB = null;

    /**
     * 打开数据库
     *
     * @param context
     * @return
     */
    public SQLiteDatabase openDB(Context context) {

        pathStr = context.getFilesDir().getAbsolutePath() + "/";

        mDBPath = pathStr + mDBName;
        Log.i(TrafficStatistics.class.getName(), "mDBPath = " + mDBPath);

        File jhPath = new File(mDBPath);

        if (jhPath.exists()) {
            try {
                mDB = SQLiteDatabase.openOrCreateDatabase(mDBPath, null);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                Log.e("db", e.getMessage());
                e.printStackTrace();
            }
            Log.i(TrafficStatistics.class.getName(), "openOrCreateDatabase");
            return mDB;
        } else {
            File path = new File(pathStr);
            if (path.exists() == false) {
                if (path.mkdir()) {
                    Log.i(TrafficStatistics.class.getName(), "mkdir " + pathStr + " success");
                } else {
                    Log.e(TrafficStatistics.class.getName(), "mkdir " + pathStr + " failed");
                }
            }

            if (false == FileUtil.copyAssetsToPrivatePath(context, mDBName, jhPath)) {
                return null;
            }
            Log.i(TrafficStatistics.class.getName(), "openDB");
            return openDB(context);
        }

    }

    public void closeDB() {
        if (mDB != null) {
            Log.i(TrafficStatistics.class.getName(), "close DB");
            mDB.close();
            mDB = null;
        }
    }

    /**
     * 计算总流量
     *
     * @param db
     * @param traffic
     */
    public void queryTrafficAmount(SQLiteDatabase db, TrafficTable traffic) {
        Cursor cur = null;

        if (db == null) {
            return;
        }

        String sql = "select sum(traffic_up),sum(traffic_down) from "
                + mTrafficTable;

        Log.d(TrafficStatistics.class.getName(), sql);

        try {
            cur = db.rawQuery(sql, null);
        } catch (Exception e) {
            cur = null;
            return;
        }

        if (cur != null) {
            int indexTrafficUp = cur.getColumnIndex("sum(traffic_up)");
            int indexTrafficDown = cur.getColumnIndex("sum(traffic_down)");

            if (indexTrafficUp < 0 || indexTrafficDown < 0) {
                return;
            }

            if (cur.moveToFirst()) {
                do {
                    traffic.setmTrafficUp(cur.getInt(indexTrafficUp));
                    traffic.setmTrafficDown(cur.getInt(indexTrafficDown));
                } while (cur.moveToNext());
            }
        }
    }

    /**
     * 计算开始日期和结束日期之间的流量
     *
     * @param db
     * @param traffic
     * @return
     */
    public void queryTraffic(SQLiteDatabase db, TrafficTable traffic) {
        Cursor cur = null;

        if (db == null) {
            return;
        }

        String sql = "select sum(traffic_up),sum(traffic_down) from "
                + mTrafficTable
                + " where date >= " + "'" + traffic.getmStartDate() + "'"
                + " and date <= " + "'" + traffic.getmEndDate() + "'";

        Log.d(TrafficStatistics.class.getName(), sql);

        try {
            cur = db.rawQuery(sql, null);
        } catch (Exception e) {
            cur = null;
            return;
        }

        if (cur != null) {
            int indexTrafficUp = cur.getColumnIndex("sum(traffic_up)");
            int indexTrafficDown = cur.getColumnIndex("sum(traffic_down)");

            if (indexTrafficUp < 0 || indexTrafficDown < 0) {
                return;
            }

            if (cur.moveToFirst()) {
                do {
                    traffic.setmTrafficUp(cur.getInt(indexTrafficUp));
                    traffic.setmTrafficDown(cur.getInt(indexTrafficDown));
                } while (cur.moveToNext());
            }
        }
    }

    /**
     * 计算天数
     *
     * @param dt1
     * @param dt2
     * @return
     */
    public static long dateDiff(Date dt1, Date dt2) {
        long diff = 0;
        try {
            long n1 = dt1.getTime();
            long n2 = dt2.getTime();
            diff = Math.abs(n1 - n2);

            diff /= 3600 * 1000 * 24;
        } catch (Exception e) {
            return -1;
        }
        return diff + 1;
    }

    /**
     * 计算日均流量
     *
     * @param db
     * @param traffic
     * @throws ParseException
     */
    public void queryTrafficAverage(SQLiteDatabase db, TrafficTable traffic) throws ParseException {
        Cursor cur = null;
        long daySum = 1;

        if (db == null) {
            return;
        }

        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);

        Date start = formatDate.parse(traffic.getmStartDate());

        Date end = formatDate.parse(traffic.getmEndDate());

        daySum = dateDiff(start, end);

        Log.d(TrafficStatistics.class.getName(), "daySum = " + daySum);

        String sql = "select sum(traffic_up),sum(traffic_down) from "
                + mTrafficTable
                + " where date >= " + "'" + traffic.getmStartDate() + "'"
                + " and date <= " + "'" + traffic.getmEndDate() + "'";

        Log.d(TrafficStatistics.class.getName(), sql);

        if (daySum == 0) {
            Log.e(TrafficStatistics.class.getName(), "error,daySum = " + daySum);
            return;
        }

        try {
            cur = db.rawQuery(sql, null);
        } catch (Exception e) {
            cur = null;
            return;
        }

        if (cur != null) {
            int indexTrafficUp = cur.getColumnIndex("sum(traffic_up)");
            int indexTrafficDown = cur.getColumnIndex("sum(traffic_down)");

            if (indexTrafficUp < 0 || indexTrafficDown < 0) {
                return;
            }

            if (cur.moveToFirst()) {
                do {
                    traffic.setmTrafficUp(Integer.parseInt(cur.getInt(indexTrafficUp) / daySum + ""));
                    traffic.setmTrafficDown(Integer.parseInt((cur.getInt(indexTrafficDown) / daySum) + ""));
                } while (cur.moveToNext());
            }
        }

    }

}

