package com.xdja.safeclient.activity;

import android.os.Bundle;

import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.utils.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RadioButton;
import android.widget.TextView;

import com.safetf.CertDetailInfo;
import com.safetf.SafeTF;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.utils.ByteUtil;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.safeclient.utils.ToastUtil;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static com.xdja.safeclient.utils.StringUtil.*;

public class CertSetActivity extends BaseActivity implements OnClickListener, OnItemClickListener {

    ImageView btn_titleLeft = null;
    TextView tv_title = null;
    ImageView btn_titleRight = null;

    public ListView lv_listView = null;

    MyAdapter myAdapter = null;
    List<CertDetailInfo> certList = null;

    MyApplication myApplication = null;

    private byte mCertType = 0; /* 默认交换证书 */

    private final static String TAG = "CertSetActivity";

    /**
     * 只展示证书，不允许选择和保存
     */
    public static boolean justShow = false;

    public static final String FLAG_JUST_SHOW = "just_show";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_certset);

        justShow = getIntent().getBooleanExtra(FLAG_JUST_SHOW, false);

        myApplication = (MyApplication) getApplication();

		/* 取配置文件中证书类型  0：交换证书 1：签名证书 */
        mCertType = (byte) myApplication.propertiesConfig.getmCertType();
        Log.d("CertSetActivity", "loadProperties, mCertType = " + mCertType);

        btn_titleLeft = (ImageView) findViewById(R.id.titlebar_leftbtn);
        tv_title = (TextView) findViewById(R.id.titlebar_text);
        btn_titleRight = (ImageView) findViewById(R.id.titlebar_rightbtn);
        lv_listView = (ListView) findViewById(R.id.listview);

        tv_title.setText(getString(R.string.certset));
        if (justShow) {
            btn_titleRight.setVisibility(View.GONE);
        } else {
            btn_titleRight.setVisibility(View.VISIBLE);
        }
        btn_titleRight.setBackgroundResource(R.drawable.save);

        btn_titleLeft.setOnClickListener(this);
        btn_titleRight.setOnClickListener(this);
        lv_listView.setOnItemClickListener(this);

        lv_listView = (ListView) findViewById(R.id.listview);
        certList = getData();
        if (certList != null) {
            myAdapter = new MyAdapter(certList);
            //设置上次默认选中证书的位置
            int defaultPosition = getDefaultSelectCertPosition();
            myAdapter.setcurSelectPosition(defaultPosition);
            myAdapter.setDefaultPosition(defaultPosition);
            Log.d(TAG, "默认证书位置" + defaultPosition);
            lv_listView.setAdapter(myAdapter);
        }

        myApplication.activityList.add(this);
        myApplication.topActivity = this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy");
        if (myApplication.activityList != null) {
            myApplication.activityList.remove(this);
        }
    }

    /**
     * 获取上次选择默认证书位置
     *
     * @return 位置
     */
    public int getDefaultSelectCertPosition() {

        SslClientConfig sslClientConfig = myApplication.sslClientConfig;
        int size = certList.size();
        for (int i = 0; i < size; i++) {
            if (Arrays.equals(sslClientConfig.getCertId(), certList.get(i).certId)) {
                return i;
            }
        }

        return -1;
    }

    @Override
    public void onClick(View arg0) {
        // TODO Auto-generated method stub
        int viewId = arg0.getId();
        if (R.id.titlebar_rightbtn == viewId) {//保存
            save();
        } else if (R.id.titlebar_leftbtn == viewId) {//返回
            finish();
        }
    }

    private List<CertDetailInfo> getData() {
        int nres = -1;
        List<CertDetailInfo> list = new ArrayList<CertDetailInfo>();
        CertDetailInfo certDetailInfo = null;
        MyApplication application = MyApplication.myApplication;
        byte[] fid = new byte[]{0x00, 0x29};
        byte[] certBuf = new byte[2048];
        int[] certLen = new int[1];
        if (application != null) {
            if (application.sslClientConfig != null) {
                fid = application.sslClientConfig.getCertId();
                Log.d(TAG, "CertId :" + fid[0] + fid[1]);
            }
        }


        nres = KeyWrapper.getInstance().readSignCert(certBuf, certLen);
        if (nres != 0) {
            Log.d(TAG, "Read cert failed. " + KeyWrapper.StatusCode.getComment(nres));
            return null;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            ByteArrayInputStream bin = new ByteArrayInputStream(certBuf);
            CertificateFactory cf = null;
            cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate) cf.generateCertificate(bin);
            certDetailInfo = new CertDetailInfo();

            certDetailInfo.issuerOrg = cert.getIssuerX500Principal().getName();
            certDetailInfo.issuerCn = cert.getIssuerDN().getName();
            certDetailInfo.subjectOrg = cert.getSubjectX500Principal().getName();
            certDetailInfo.subjectCn = cert.getSubjectDN().getName();

            System.arraycopy(fid, 0, certDetailInfo.certId, 0, 2);
            certDetailInfo.indate = formatter.format(cert.getNotBefore()) + "/" + formatter.format(cert.getNotAfter());
            certDetailInfo.sn = cert.getSerialNumber().toString(16);
            list.add(certDetailInfo);
            bin.close();

        } catch (CertificateException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        } catch (NoSuchProviderException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }




        if (list.size() == 0) {
            AlertUtil.popAlert(this, getStringRes(this, R.string.alert), getStringRes(this, R.string.lack_cert));
            return null;
        } else {
            return list;
        }
    }

    private class MyAdapter extends BaseAdapter {
        private LayoutInflater inflater;
        private Holder holder;
        private int curSelectPosition = -1;
        private int defaultPosition = -1;
        private List<CertDetailInfo> certList = null;

        public MyAdapter(List<CertDetailInfo> certList) {
            this.certList = certList;
            inflater = LayoutInflater.from(CertSetActivity.this);
        }

        public void setcurSelectPosition(int curSelectPosition) {
            this.curSelectPosition = curSelectPosition;
        }

        public int getcurSelectPosition() {
            return this.curSelectPosition;
        }

        public void setDefaultPosition(int defaultPosition) {
            this.defaultPosition = defaultPosition;
        }

        @Override
        public int getCount() {
            return certList.size();
        }

        @Override
        public Object getItem(int arg0) {
            return arg0;
        }

        @Override
        public long getItemId(int arg0) {
            return arg0;
        }

        @Override
        public View getView(final int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = inflater.inflate(R.layout.certlist, null);
                holder = new Holder();
                holder.whole_layout = (LinearLayout) convertView.findViewById(R.id.whole_layout);
                holder.tv_subject = (TextView) convertView.findViewById(R.id.subject);
                holder.tv_issuer = (TextView) convertView.findViewById(R.id.issuer);
                holder.tv_sn = (TextView) convertView.findViewById(R.id.sn);
                holder.tv_indate = (TextView) convertView.findViewById(R.id.indate);
                holder.rb_defaultCert = (RadioButton) convertView.findViewById(R.id.defaultcert);
                convertView.setTag(holder);
            } else {
                holder = (Holder) convertView.getTag();
            }

            if (justShow) {
                holder.rb_defaultCert.setVisibility(View.GONE);
            } else {
                holder.rb_defaultCert.setVisibility(View.VISIBLE);
            }

            CertDetailInfo certInfo = certList.get(position);
//            Log.d(TAG, certInfo.toString());
            holder.tv_subject.setText(certInfo.subjectCn);
            holder.tv_issuer.setText(certInfo.issuerCn);
            holder.tv_sn.setText(certInfo.sn);
            holder.tv_indate.setText(certInfo.indate);

            if (position == curSelectPosition) {
                holder.rb_defaultCert.setChecked(true);
            } else {
                holder.rb_defaultCert.setChecked(false);
            }

			/* 设置item的背景 */
            setBackground(position, convertView);

            //西安移动警务通用的是0号容器交换证书
            // 西安移动警务通要求不显示其他证书 2017-01-10 14:45:51
            if (Compatibility.isXiAnJWT()) {
                if (position != defaultPosition) {
                    holder.whole_layout.setVisibility(View.GONE);
                } else {
                    holder.whole_layout.setVisibility(View.VISIBLE);
                    ByteUtil.print("CertId：", certInfo.certId);
                }
                Log.d(TAG, "The version is JWT of Xi'an.");
            }

            return convertView;
        }

        private class Holder {
            private LinearLayout whole_layout;
            private TextView tv_subject;
            private TextView tv_issuer;
            private TextView tv_sn;
            private TextView tv_indate;
            private RadioButton rb_defaultCert;
        }

        /**
         * 设置item的背景
         *
         * @param position
         * @param convertView
         */
        public void setBackground(int position, View convertView) {
            convertView.setBackgroundResource(getListItemBG(position));
        }

        private int getListItemBG(int position) {

            if (1 == certList.size()) {
                return R.drawable.list_item_single;
            }

            if (position == 0) {
                return R.drawable.list_item_top;
            }

            if (position == certList.size() - 1) {
                return R.drawable.list_item_bottom;
            }

            return R.drawable.list_item_middle;
        }
    }

    @Override
    public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
        MyAdapter adapt = (MyAdapter) arg0.getAdapter();
        adapt.setcurSelectPosition(arg2);//设置当前选中ITEM位置
        adapt.notifyDataSetChanged();    //更新adapt
    }

    /**
     * 保存
     */
    public void save() {
        //MyApplication myApplication = (MyApplication)getApplication();
        SslClientConfig sslClientConfig = myApplication.sslClientConfig;
        if (myAdapter == null) {
            return;
        }
        int curSelectPosition = myAdapter.getcurSelectPosition();


        int ctnNo;

        // 此处下标可能异常，原因未知 xjq 2017-01-19 14:23:01
        try {
            ctnNo = certList.get(curSelectPosition).ctnNo;
        } catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            return;
        }

        byte[] certId = new byte[2];
        byte[] pubkeyId = new byte[2];
        byte[] prikeyId = new byte[2];
        if (0 == ctnNo) {//0号容器使用0x01号口令密钥
            sslClientConfig.setRole(0x01);
            /* 交换证书 */
            if (mCertType == 0) {
                certId[0] = 0x00;
                certId[1] = 0x29;

                pubkeyId[0] = 0x00;
                pubkeyId[1] = 0x2a;

                prikeyId[0] = 0x00;
                prikeyId[1] = 0x2b;
            }
            /* 签名证书 */
            else {
                certId[0] = 0x00;
                certId[1] = 0x2c;

                pubkeyId[0] = 0x00;
                pubkeyId[1] = 0x2d;

                prikeyId[0] = 0x00;
                prikeyId[1] = 0x2e;
            }

            sslClientConfig.setCertId(certId);
            sslClientConfig.setPubkeyId(pubkeyId);
            sslClientConfig.setPrikeyId(prikeyId);
            myApplication.writeSslclientConfigFile();//保存配置文件
        } else if (4 == ctnNo) {//4号容器使用0x11号口令密钥
            sslClientConfig.setRole(0x11);
            /* 交换证书 */
            if (mCertType == 0) {
                certId[0] = 0x00;
                certId[1] = 0x45;

                pubkeyId[0] = 0x00;
                pubkeyId[1] = 0x46;

                prikeyId[0] = 0x00;
                prikeyId[1] = 0x47;
            }
            /* 签名证书 */
            else {
                certId[0] = 0x00;
                certId[1] = 0x48;

                pubkeyId[0] = 0x00;
                pubkeyId[1] = 0x49;

                prikeyId[0] = 0x00;
                prikeyId[1] = 0x4a;
            }
            sslClientConfig.setCertId(certId);
            sslClientConfig.setPubkeyId(pubkeyId);
            sslClientConfig.setPrikeyId(prikeyId);
            myApplication.writeSslclientConfigFile();//保存配置文件
        } else if (6 == ctnNo) {//6号容器使用0x11号口令密钥
            sslClientConfig.setRole(0x11);
            /* 交换证书 */
            if (mCertType == 0) {
                certId[0] = 0x00;
                certId[1] = 0x53;

                pubkeyId[0] = 0x00;
                pubkeyId[1] = 0x54;

                prikeyId[0] = 0x00;
                prikeyId[1] = 0x55;
            }
            /* 签名证书 */
            else {
                certId[0] = 0x00;
                certId[1] = 0x56;

                pubkeyId[0] = 0x00;
                pubkeyId[1] = 0x57;

                prikeyId[0] = 0x00;
                prikeyId[1] = 0x58;
            }
            sslClientConfig.setCertId(certId);
            sslClientConfig.setPubkeyId(pubkeyId);
            sslClientConfig.setPrikeyId(prikeyId);
            myApplication.writeSslclientConfigFile();//保存配置文件
        }


        finish();
    }

    // TODO: 2017/1/17 0017  在Function的exit()确定没问题之前，先注释掉
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }

}
