package com.xdja.safeclient.activity;

import java.io.File;
import java.util.ArrayList;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.xdja.safeclient.utils.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.safeclient.R;
import com.xdja.safeclient.adapter.ListViewAdapter;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.ui.HisRecDialog;
import com.xdja.safeclient.utils.FileUtil;

import static com.xdja.safeclient.utils.StringUtil.*;

public class HistoryRecordActivity extends BaseActivity {
    private ListView mHistoryRecListView = null;
    private ListViewAdapter mAdapter = null;
    private ProgressBar progressBar = null;

    private String pathStr; // 文件夹路径
    private String mHistoryRecFilePath; // 历史记录文件绝对路径
    private final String mHistoryRecFileName = "historyrecord.txt"; // 历史记录文件名
    private String mSDCardPath;
    private ArrayList<String> mStrArray = null;

    private final int READ_FILE_OK = 0;
    private final int EXPORT_HISREC_OK = 1;
    private final int EXPORT_HISREC_FAILED = 2;

    Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                // 读取文件完成
                case READ_FILE_OK:
                    setListItems();
                    break;
                // 导出历史记录成功
                case EXPORT_HISREC_OK:
                    Toast.makeText(HistoryRecordActivity.this, getStringRes(HistoryRecordActivity.this, R.string.export_to) + mSDCardPath + "/"
                                    + mHistoryRecFileName,
                            Toast.LENGTH_SHORT).show();
                    break;
                // 导出历史记录失败
                case EXPORT_HISREC_FAILED:
                    Toast.makeText(HistoryRecordActivity.this, getStringRes(HistoryRecordActivity.this, R.string.export_record_failed),
                            Toast.LENGTH_SHORT).show();
                    break;
                default:
                    break;
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_history_record);

        Log.d("HistoryRecordActivity", "onCreate");

        pathStr = this.getFilesDir().getAbsolutePath() + "/";
        mHistoryRecFilePath = pathStr + mHistoryRecFileName;

        //mSDCardPath = FileUtil.getSDPath();
        File page = getExternalFilesDir(null);

        if (page != null) {
            mSDCardPath = page.getPath();
        } else {
            mSDCardPath = "";
        }

        Log.d("initRightBtn", "mSDCardPath = " + mSDCardPath);

		/* test code start */
        /*
         * final File file = new File(mHistoryRecFilePath); if (!file .exists())
		 * { FileUtil.copyAssetsToPrivatePath(this, mHistoryRecFileName, file);
		 * }
		 */
        /* test code end */

        progressBar = (ProgressBar) findViewById(R.id.history_rec_progressbar);

		/* 初始化列表 */
        mStrArray = new ArrayList<String>();

        initListView();

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mRightBtn = (ImageView) findViewById(R.id.titlebar_rightbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);

        initLeftBtn();

        initTitleText();

        initRightBtn();

    }

    @Override
    protected void onDestroy() {
        // TODO Auto-generated method stub
        super.onDestroy();
        Log.d("HistoryRecordActivity", "onDestroy");
        mStrArray.clear();
        mStrArray = null;
        mAdapter = null;
    }

    protected void initRightBtn() {
        super.initRightBtn();

        mRightBtn.setVisibility(View.VISIBLE);

        mRightBtn.setBackgroundResource(R.drawable.save);

        mRightBtn.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                // TODO Auto-generated method stub
                /* 导出历史记录 */
                if (mSDCardPath == null) {
                    return;
                }

                final File sourceFile = new File(mHistoryRecFilePath);
                final File targetFile = new File(mSDCardPath + "/"
                        + mHistoryRecFileName);

                new Thread() {
                    public void run() {
                        Message msg = new Message();
                        // 导出历史记录成功
                        if (FileUtil.copeFile(sourceFile, targetFile)) {
                            msg.what = EXPORT_HISREC_OK;
                        }
                        // 导出历史记录失败
                        else {
                            msg.what = EXPORT_HISREC_FAILED;
                        }
                        // 向UI线程发消息
                        mHandler.sendMessage(msg);
                    }
                }.start();
            }
        });
    }

    protected void initTitleText() {
        super.initTitleText();

        mTitleText.setText(R.string.label_his_rec);
    }

    /**
     * 初始化列表
     */
    private void initListView() {

        mHistoryRecListView = (ListView) findViewById(R.id.history_record_listview);

        mHistoryRecListView.setOnItemClickListener(new OnItemClickListener() {

            @Override
            public void onItemClick(AdapterView<?> adapterView, View v,
                                    int position, long arg3) {
                /* 显示列表项内容 */
/*
                AlertDialog.Builder dialog = new AlertDialog.Builder(
						adapterView.getContext());

				dialog.setMessage(
						adapterView.getItemAtPosition(position).toString())
						.setCancelable(false)
						.setNegativeButton("返回",
								new DialogInterface.OnClickListener() {

									@Override
									public void onClick(DialogInterface dialog,
											int which) {
										dialog.cancel();
									}

								});
*/
                final String msg = adapterView.getItemAtPosition(position).toString();
                HisRecDialog dialog = new HisRecDialog(adapterView.getContext(), R.style.MyDialog) {
                    public void setMessage() {
                        this.setText(msg);
                    }
                };

                dialog.show();
            }

        });

        if (progressBar != null) {
            progressBar.setVisibility(View.VISIBLE);
        }

        FileUtil.readFileByLines(mHistoryRecFilePath, mStrArray, mHandler);

        if (progressBar != null) {
            progressBar.setVisibility(View.INVISIBLE);
        }
    }

    /**
     * 初始化列表项
     */
    private void setListItems() {

        if (mStrArray == null) {
            return;
        }

        mAdapter = new ListViewAdapter(this, mStrArray, R.layout.list_item,
                R.id.listItemTextView) {

            @Override
            public View setItemViewAttribute(View view) {
                if (view instanceof TextView) {
                    ((TextView) view).setMaxLines(1);
                    ((TextView) view).setEllipsize(TextUtils.TruncateAt.END);
                }

                return view;
            }

        };

        mHistoryRecListView.setAdapter(mAdapter);

        if (progressBar != null) {
            progressBar.setVisibility(View.INVISIBLE);
        }

    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }
}
