package com.xdja.safeclient.activity;


import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.xdja.safeclient.utils.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;


import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.config.SslClientConfig;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.safeclient.utils.StringUtil;

import java.io.File;

import static com.xdja.safeclient.utils.StringUtil.*;


public class LogSetupActivity extends BaseActivity {

    private CheckBox mLogSwitchCheckBox = null;
    private Spinner mLogLevelSpinner = null;
    private Spinner mLogFileSizeSpinner = null;
    private Button mLogQueryButton = null;
    private Button mLogExportButton = null;

    private final String[] logLevelStr = {"DEBUG", "WARNING"};
    private final String[] logFileSizeStr = {"1MB", "2MB", "3MB", "4MB"};

    private final int EXPORT_LOG_OK = 1;        //导出日志成功
    private final int EXPORT_LOG_FAILED = 2;    //导出日志失败

    private String mPrivatePath;        //保存文件的目录

    //	private final String mLogFileName = "log.txt";
    private final String mLogFileName = "safeclient.log";

    private String mLogFilePath;
    private String mSDCardPath;

    private MyApplication myApplication = null;
    private SslClientConfig sslClientConfig = null;

    private int mLogSwicth = 0;
    private int mLogLevel = 0;
    private int mLogFileSize = 0;

    Handler mExportLogHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            switch (msg.what) {
                // 导出日志成功
                case EXPORT_LOG_OK:
//				Toast.makeText(LogSetupActivity.this, "成功导出到" + mSDCardPath + "/" + mLogFileName, Toast.LENGTH_SHORT).show();

//				String path = "/storage/sdcard1/Android/data/com.xdja.safeclient/files" + "/" + mLogFileName;
                    String path = mSDCardPath + "/" + mLogFileName;
                    Toast.makeText(LogSetupActivity.this, getStringRes(LogSetupActivity.this, R.string.export_to) + path, Toast.LENGTH_SHORT).show();
                    break;
                // 导出日志失败
                case EXPORT_LOG_FAILED:
                    Toast.makeText(LogSetupActivity.this, StringUtil.getStringRes(LogSetupActivity.this, R.string.export_log_failed), Toast.LENGTH_SHORT).show();
                    break;
                default:
                    break;
            }
        }

    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_log_setup);

        mPrivatePath = this.getFilesDir().getAbsolutePath() + "/";
//		mPrivatePath = "/sdcard/";

//		mSDCardPath = FileUtil.getSDPath();
        File page = getExternalFilesDir(null);

        if (page != null) {
            mSDCardPath = page.getPath();
        } else {
            mSDCardPath = "";
        }

        mLogFilePath = mPrivatePath + mLogFileName;

        Log.d("onCreate", "pathStr = " + mPrivatePath);
        Log.d("LogSetupActivity", "mSDCardPath = " + mSDCardPath);

//		从xml配置文件中读出日志配置
        myApplication = (MyApplication) getApplication();
        sslClientConfig = myApplication.sslClientConfig;

//		初始化日志开关选择框
        initLogSetupCheckBox(mLogSwitchCheckBox, R.id.log_switch_checkbox);


//		初始化日志级别下拉列表
        initLogSetupSpiner(mLogLevelSpinner, R.id.log_level_spinner, logLevelStr);

//		初始化文件大小下拉列表
        initLogSetupSpiner(mLogFileSizeSpinner, R.id.log_file_size_spinner, logFileSizeStr);

//		初始化查看日志按钮
        initLogSetupButton(mLogQueryButton, R.id.log_query_button);

//		初始化导出日志按钮
        initLogSetupButton(mLogExportButton, R.id.log_export_button);

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mRightBtn = (ImageView) findViewById(R.id.titlebar_rightbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);

//		初始化返回按钮
        initLeftBtn();

//		初始化标题
        initTitleText();

//		初始化保存按钮
        initRightBtn();

        myApplication.activityList.add(this);
        myApplication.topActivity = this;

    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("LogSetupActivity", "onDestroy");
        if (myApplication.activityList != null) {
            myApplication.activityList.remove(this);
        }
    }

    protected void initRightBtn() {
        super.initRightBtn();
        mRightBtn.setVisibility(View.VISIBLE);

        mRightBtn.setBackgroundResource(R.drawable.save);

        mRightBtn.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                Log.d("LogSetupActivity", "LogSetupSaveButton clicked ");
                //保存日志配置

                sslClientConfig.setLogSwitch(mLogSwicth);
                sslClientConfig.setLogLevel(mLogLevel);
                sslClientConfig.setLogFileSize(mLogFileSize);

                myApplication.writeSslclientConfigFile();

                Toast.makeText(v.getContext(), getStringRes(LogSetupActivity.this, R.string.save_config_success), Toast.LENGTH_SHORT).show();
            }
        });
    }

    protected void initTitleText() {
        super.initTitleText();
        mTitleText.setText(R.string.label_log_setup);
    }

    /**
     * 初始化多选框
     *
     * @param checkBox
     * @param id
     * @return
     */
    private CheckBox initLogSetupCheckBox(CheckBox checkBox, int id) {

        checkBox = (CheckBox) findViewById(id);

        if (id == R.id.log_switch_checkbox) {
            // 日志开关为关闭
            if (sslClientConfig.getLogSwitch() == 0) {
                checkBox.setChecked(false);
                mLogSwicth = 0;
            }
            // 日志开关为打开
            else {
                checkBox.setChecked(true);
                mLogSwicth = 1;
            }
        }

        checkBox.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (R.id.log_switch_checkbox == ((CheckBox) v).getId()) {
                    if (((CheckBox) v).isChecked()) {
                        Log.d("LogSetupActivity", "LogSwitchCheckBox checked " + ((CheckBox) v).getId());
                        //sslClientConfig.setLogSwitch(1);
                        mLogSwicth = 1;
                    } else {
                        Log.d("LogSetupActivity", "LogSwitchCheckBox unchecked");
                        //sslClientConfig.setLogSwitch(0);
                        mLogSwicth = 0;
                    }
                }
            }
        });

        return checkBox;
    }

    /**
     * 初始化下拉列表
     *
     * @param spinner
     * @param id
     * @return
     */
    private Spinner initLogSetupSpiner(Spinner spinner, int id, String[] strArray) {
        ArrayAdapter<String> adapter = null;

        spinner = (Spinner) findViewById(id);

        adapter = new ArrayAdapter<String>(this, R.layout.spinner_item_select, strArray);

        adapter.setDropDownViewResource(R.layout.spinner_item_dropdown);

        spinner.setAdapter(adapter);


        if (R.id.log_level_spinner == id) {
            Log.d("LogSetupActivity", "init log_level_spinner " + strArray[sslClientConfig.getLogLevel()]);
            spinner.setSelection(sslClientConfig.getLogLevel());
            mLogLevel = sslClientConfig.getLogLevel();
        } else if (R.id.log_file_size_spinner == id) {
            if (sslClientConfig.getLogFileSize() < 1) {
                Log.e("LogSetupActivity", "init log_file_size_spinner, log file size < 1");
                spinner.setSelection(0);
                mLogFileSize = 1;
            } else {
                Log.d("LogSetupActivity", "init log_file_size_spinner " + strArray[sslClientConfig.getLogFileSize() - 1]);
                spinner.setSelection(sslClientConfig.getLogFileSize() - 1);
                mLogFileSize = sslClientConfig.getLogFileSize();
            }
        }

        //spinner.setOnItemSelectedListener(new SpinnerItemSelected());
        spinner.setOnItemSelectedListener(new OnItemSelectedListener() {

            @Override
            public void onItemSelected(AdapterView<?> arg0, View v, int position,
                                       long arg3) {
                //Log.d("LogSetupActivity", "SpinnerItemSelected checked "+arg0.getItemAtPosition(position).toString());

                if (R.id.log_level_spinner == arg0.getId()) {
                    Log.d("LogSetupActivity", "log_level_spinner checked " + arg0.getItemAtPosition(position).toString());
                    //sslClientConfig.setLogLevel(position);
                    mLogLevel = position;
                } else if (R.id.log_file_size_spinner == arg0.getId()) {
                    Log.d("LogSetupActivity", "log_file_size_spinner checked " + arg0.getItemAtPosition(position).toString());
                    //sslClientConfig.setLogFileSize(position + 1);
                    mLogFileSize = position + 1;
                }

            }

            @Override
            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });

        return spinner;
    }

    /**
     * 导出日志到sd卡
     */
    private void exportLogToSDCard() {

        if (mSDCardPath == null) {
            return;
        }

		/* 导出日志 */
        final File sourceFile = new File(mLogFilePath);
        final File targetFile = new File(mSDCardPath + "/" + mLogFileName);
//		final File targetFile = new File("/storage/sdcard1/Android/data/com.xdja.safeclient/files" + "/" + mLogFileName);

        new Thread() {
            public void run() {
                Message msg = new Message();
                //保存日志成功
                if (FileUtil.copeFile(sourceFile, targetFile)) {
                    msg.what = EXPORT_LOG_OK;
                }
                //保存日志失败
                else {
                    msg.what = EXPORT_LOG_FAILED;
                }
                //向UI线程发消息
                mExportLogHandler.sendMessage(msg);
            }
        }.start();
    }

    /**
     * 初始化button
     *
     * @param button
     * @param id
     * @return
     */
    private Button initLogSetupButton(Button button, int id) {

        button = (Button) findViewById(id);

        button.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                int viewId = ((Button) v).getId();
                if(viewId == R.id.log_query_button){
                    Log.d("LogSetupActivity", "log_query_button clicked " + viewId);
                    Intent intent = new Intent(LogSetupActivity.this, LogQueryActivity.class);
                    startActivity(intent);
                }
                if(viewId == R.id.log_export_button){
                    Log.d("LogSetupActivity", "log_export_button checked " + viewId);
                    exportLogToSDCard();
                }
            }
        });

        return button;
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }


}