package com.xdja.safeclient.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build.VERSION;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.telephony.TelephonyManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import com.longmai.security.plugin.SOF_AppLib;
import com.longmai.security.plugin.SOF_DeviceLib;
import com.safetf.SafeTF;
import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyModuleStateListener;
import com.xdja.key.KeyWrapper;
import com.xdja.key.koal.KoalCfg;
import com.xdja.key.koal.KoalKey;
import com.xdja.key.longmai.LMWrapper;
import com.xdja.key.longmai.LongmaiCfg;
import com.xdja.safeclient.BuildConfig;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.constant.SPKey;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.ui.DialogWrapper;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.ExpireUtil;
import com.xdja.safeclient.utils.LaunchUtil;
import com.xdja.safeclient.utils.LocaleUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.LogUtil;
import com.xdja.safeclient.utils.NetworkUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import com.xdja.safeclient.utils.ToastUtil;
import com.xdja.safeclient.wrapper.PinWrapper;
import com.xdja.soc.certupload.CertUploadErrorCode;
import com.xdja.soc.certupload.CertUploadManager;
import com.xdja.sslvpn.CONSTANT;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import static com.xdja.safeclient.utils.StringUtil.getStringRes;

public class MainActivity extends BaseActivity implements OnClickListener, KeyModuleStateListener {
    EditText et_pin = null;
    Button btn_start = null;
    CheckBox cb_rememberPassword = null;
    LinearLayout ll_more = null;
    LinearLayout ll_moremenu = null;
    LinearLayout ll_config = null;
    LinearLayout ll_update = null;
    LinearLayout ll_about = null;
    LinearLayout ll_exit = null;

    public String userPin = "";
    public int role = 0;

    MyApplication myApplication = null;

    private final String TAG = "MainActivity";

    final int ERROR_BASE = -100;
    final int NETWORK_UNAVAILABLE = ERROR_BASE + 1;
    final int SHOW_LOADING = ERROR_BASE + 2;

    private static String selectAppName = null;
    private static String selectContainerName = null;

    private static String koalCertPath = null;

    private ProgressDialog checkDeviceDlg = null;

    @Override
    protected void onResume() {
        super.onResume();
        if (BuildConfig.enableExpired) {
            LogUtil.d(TAG, "检测测试版本");
            boolean expired = ExpireUtil.validExpiredDate(this);
            if (!expired) {
                return;
            }
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {

        Log.d(TAG, "MainActivity onCreate.");
        if (!LocaleUtil.autoChoose(this)) {
            String name = (String) SharedPreferencesUtil.get(this, SPKey.CURRENT_lANGUAGE, "");
            Locale current = LocaleUtil.parseLocale(name);
            if (current != null) {
                LocaleUtil.changeLanguage(this, current);
            }
        }

        myApplication = (MyApplication) getApplication();

        // 贵阳市局需要检查设备状态. Add by xjq, 2017-5-31 12:03:20
        if (Compatibility.getAreaVersion() == Compatibility.AREA_VERSION_GUIYANG_EMM) {
            if (myApplication != null)
                myApplication.checkDevAdmin();
        }

        //设置主题 ，  广东财政厅需求
        if (myApplication.propertiesConfig.getIgnoreLogin() == 0) {
            int theme = getSharedPreferences("cons", MODE_PRIVATE).getInt("theme",
                    R.style.AppBaseTheme);
            //设定主题
            setTheme(theme);
        }

        super.onCreate(savedInstanceState);
        getWindow().requestFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_main);

        myApplication.activityList.add(this);
        myApplication.topActivity = this;

        boolean pinRet = true;

        //广东财政厅需求,跳过登陆页面直接VPN认证
        if (myApplication.propertiesConfig.getIgnoreLogin() != 0) {
            pinRet = isPinCorrect();
            Log.w(TAG, "pinRet : " + pinRet);
        }

        if (VpnService.startflag == true || (VERSION.SDK_INT >= 14 && TunVpnService.startflag == true)) {
            Intent intent = new Intent();
            intent.setClass(MainActivity.this, SafeVerifyActivity.class);
            startActivity(intent);
            this.finish();
        }
        //广东财政厅需求,跳过登陆页面直接VPN认证
        else if (myApplication.propertiesConfig.getIgnoreLogin() != 0 && pinRet) {
            MyApplication.selfStartFlag = true;
            Intent intent = new Intent();
            intent.setClass(MainActivity.this, SafeVerifyActivity.class);
            startActivity(intent);
            this.finish();
        } else {
            et_pin = (EditText) findViewById(R.id.pin);
            cb_rememberPassword = (CheckBox) findViewById(R.id.rememberpassword);
            btn_start = (Button) findViewById(R.id.start);
            ll_more = (LinearLayout) findViewById(R.id.more);
            ll_moremenu = (LinearLayout) findViewById(R.id.moremenu);
            ll_config = (LinearLayout) findViewById(R.id.config);
            ll_update = (LinearLayout) findViewById(R.id.update);
            ll_about = (LinearLayout) findViewById(R.id.about);
            ll_exit = (LinearLayout) findViewById(R.id.exit);

            btn_start.setOnClickListener(this);
            ll_more.setOnClickListener(this);
            ll_config.setOnClickListener(this);
            ll_update.setOnClickListener(this);
            ll_about.setOnClickListener(this);
            ll_exit.setOnClickListener(this);

            myApplication.topActivity = this;

            myApplication.initDevState();

            if (pinRet == false) {
                delPIN();
            }

            //使用默认PIN码，并禁止用户手动输入PIN码
            if (myApplication.propertiesConfig.getmUseDefualtPin() == 1) {
                et_pin.setText(PinWrapper.DEFAULT_PIN);
                cb_rememberPassword.setChecked(true);
                MyApplication.rememberPin = true;
                et_pin.setFocusable(false);
                cb_rememberPassword.setClickable(false);
            } else {
                boolean needSavePin = PinWrapper.getNeedSavePin(this);
                if (needSavePin) {
                    String pin = PinWrapper.getPin(this);
                    if (pin != null) {
                        et_pin.setText(pin);
                        cb_rememberPassword.setChecked(true);
                        MyApplication.rememberPin = true;
                    }
                }
            }

            //吉林交警换卡需求
            if (myApplication.propertiesConfig.getIsBigThan4G() != 0
                    && !Function.isSDTotalSizeBigThan4G(Function.getSDTotalSize(this))) {
                new AlertDialog.Builder(this).setTitle(getStringRes(this, R.string.alert))
                        .setMessage(getStringRes(MainActivity.this, R.string.safe_card_version_unmatched)).setNeutralButton(getStringRes(MainActivity.this, R.string.exit),
                        new DialogInterface.OnClickListener() {
                            public void onClick(DialogInterface dlg,
                                                int which) {
                                finish();
                            }
                        }).setCancelable(false).show();
            }

        }
        //检查海棠服务
        if (!Function.checkHitomservice(getApplicationContext())) {
            AlertUtil.popSystemAlert(getApplicationContext(), getStringRes(this, R.string.alert), getString(R.string.hitom_service_not_exist), new DialogInterface.OnClickListener() {

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    finish();
                }

            });
        }

        checkOtherSafeClient();
        SCAutoUpdate.updateStart(this, false, true);//调用升级模块

        // test
        if (myApplication.propertiesConfig.hasZhongfuKey() == 1) // 中孚卡
        {
            Intent intent = new Intent();
            intent.setClass(this, DeviceListActivity.class);
            startActivityForResult(intent, CONSTANT.REQUEST_SELECT_BT_DEVICE);
            Log.d(TAG, "Start bt device select.");
        }


        // 显示检测加密设备对话框
        int state = KeyWrapper.getInstance().getState();
        Log.d(TAG, "Current key module state " + state);
        switch (state) {
            case KeyWrapper.State.NULL:
            case KeyWrapper.State.INITIALIZING:
                KeyWrapper.getInstance().addKeyModuleStateListener(this);
                showDialog();
                Function.initKeyModule(false);
                break;
            case KeyWrapper.State.INIT_KEY_FAILED:
                ToastUtil.show(this, getString(R.string.init_key_failed));
                break;
            case KeyWrapper.State.NO_KEY:
//                ToastUtil.show(this, getString(R.string.detect_no_device));
                AlertUtil.popSystemAlert(this, getString(R.string.safe_client), getString(R.string.detect_no_device),
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {
                                Function.exitApp(MainActivity.this);
                            }
                        }, true);
                break;
            case KeyWrapper.State.READY:
                ToastUtil.show(this, getString(R.string.current_dev) + KeyWrapper.currentKeyTypeComment);
                configKey();
                break;
        }
    }



    private void configKey() {
        KeyDevInfo devInfo = new KeyDevInfo();
        int ret = KeyWrapper.getInstance().getDevInfo(KeyWrapper.currentIndex, devInfo);
        if (ret != 0) {
            return;
        }
        if (devInfo.getDriver().equals(KeyWrapper.LONGMAI_DRIVER_NAME)) {
            selectAppName();
        } else if (devInfo.getDriver().equals(KeyWrapper.KOAL_DRIVER_NAME)) {
            selectKoalCertPath();
        }
    }

    private void selectKoalCertPath() {
        if (koalCertPath != null) {
            KoalCfg koalCfg = new KoalCfg();
            koalCfg.setCertPath(koalCertPath);
            KeyWrapper.getInstance().configKoalKey(koalCfg);
            return;
        }

        final List<String> certList = KoalKey.getInstance().getCertList();
        if (certList == null) {
            ToastUtil.show(this, "没有检测到格尔服务！");
            return;
        }
        if (certList.size() == 1)
        {
            koalCertPath = certList.get(0);

            KoalCfg koalCfg = new KoalCfg();
            koalCfg.setCertPath(koalCertPath);
            KeyWrapper.getInstance().configKoalKey(koalCfg);
        }
        else{
            View bottomView = View.inflate(this, R.layout.appname_dialog, null);//填充ListView布局
            ListView lvAppName = (ListView) bottomView.findViewById(R.id.lv_appname);//初始化ListView控件

            lvAppName.setAdapter(new AppNameAdapter(this, certList));//ListView设置适配器
            TextView title = new TextView(MainActivity.this);
            title.setTextSize(18);
            title.setText("请选择证书");
            title.setTextColor(Color.WHITE);

            final AlertDialog dialog = new AlertDialog.Builder(this)
                    .setCustomTitle(title)
                    .setView(bottomView)//在这里把写好的这个listview的布局加载dialog中
                    .setNegativeButton("取消", new DialogInterface.OnClickListener() {

                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.cancel();
                        }
                    }).create();


            dialog.show();

            lvAppName.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                @Override
                public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                    ToastUtil.show(MainActivity.this, "选择的证书路径为" + certList.get(i));
                    koalCertPath = certList.get(i);
                    dialog.cancel();

                    KoalCfg koalCfg = new KoalCfg();
                    koalCfg.setCertPath(koalCertPath);
                    KeyWrapper.getInstance().configKoalKey(koalCfg);

                }
            });
        }


    }

    class AppNameAdapter extends BaseAdapter {
        Context context;
        LayoutInflater inflater;
        List<String> appNames;

        public AppNameAdapter(Context context, List<String> appNames) {
            this.context = context;
            inflater = LayoutInflater.from(context);
            this.appNames = appNames;
        }

        @Override
        public int getCount() {
            return appNames.size();
        }

        @Override
        public Object getItem(int position) {
            return appNames.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(final int position, View convertView, ViewGroup parent) {
            ViewGroup vg;

            if (convertView != null) {
                vg = (ViewGroup) convertView;
            } else {
                vg = (ViewGroup) inflater.inflate(R.layout.appname_item, null);
            }

            final String appName = appNames.get(position);
            final TextView tvAppName = ((TextView) vg.findViewById(R.id.tv_appname));
            tvAppName.setText(appName);
            return vg;
        }
    }


    @Override
    protected void onDestroy() {
        KeyWrapper.getInstance().removeKeyModuleStateListener(this);
        super.onDestroy();
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (resultCode == Activity.RESULT_OK) {
            switch (requestCode) {
                case CONSTANT.REQUEST_SELECT_BT_DEVICE:
//                    String address = data.getExtras().getString(BluetoothDevice.EXTRA_DEVICE);
//                    long[] devHandle = new long[1];
//                    long[] appHandle = new long[1];
//                    long[] conHandle = new long[1];
//                    long ret = zhongfuKey.connect(address, devHandle);
//
//                    if (ret != 0) {
//                        Toast.makeText(this, "连接中孚卡失败！错误 " + ret, Toast.LENGTH_LONG).show();
//                        return;
//                    }
//
//                    Toast.makeText(this, "打开中孚卡成功！", Toast.LENGTH_LONG).show();
//
//                    myApplication.zhongfuDevice = address;
//
//                    ret = zhongfuKey.openApp(address, MyApplication.zhongfuApp, appHandle);
//                    if  (ret!=0) {
//                        Toast.makeText(this, "打开应用" + MyApplication.zhongfuApp + "失败", Toast.LENGTH_SHORT).show();
//                    }
//
//                    Toast.makeText(this, "打开应用" + MyApplication.zhongfuApp+ "成功！", Toast.LENGTH_LONG).show();


//                    ret = zhongfuKey.openContainer("test");
//
//                    if (ret != 0) {
//                        Toast.makeText(this, "打开容器失败！", Toast.LENGTH_LONG).show();
//                        return;
//                    }
//
//                    Toast.makeText(this, "打开容器" + CONSTANT.ZHONGFU_APP_NAME + "成功！", Toast.LENGTH_LONG).show();

                    break;
            }
        }
    }

    DialogWrapper mDialogUtils = new DialogWrapper();
    Handler handler = new Handler() {
        @Override
        public void dispatchMessage(Message msg) {
            super.dispatchMessage(msg);
            switch (msg.what) {
                case CertUploadErrorCode.EXCEPTION_CODE_NO_POWER_REPORT:
                    mDialogUtils.dismissLoadingDialog();
                    TelephonyManager tm = (TelephonyManager) MainActivity.this.getSystemService(Context.TELEPHONY_SERVICE);
                    String deviceId = tm.getDeviceId();
                    if ("".equals(deviceId) || null == deviceId) {
                        new DialogWrapper().showTitleClickableMessage1BtnDialog(MainActivity.this,
                                getString(R.string.text_permission_limit),
                                getString(R.string.text_permission_limit_tip),
                                getString(R.string.text_device_imei, getString(R.string.unknown)), getString(R.string.know));
                    } else {
                        new DialogWrapper().showTitleClickableMessage1BtnDialog(MainActivity.this,
                                getString(R.string.text_permission_limit),
                                getString(R.string.text_permission_limit_tip),
                                getString(R.string.text_device_imei, deviceId), getString(R.string.know));
                    }
                    break;
                case CertUploadErrorCode.OK:
                    mDialogUtils.dismissLoadingDialog();
                    start();
                    break;
                case NETWORK_UNAVAILABLE:
                    Toast.makeText(MainActivity.this, R.string.check_network, Toast.LENGTH_LONG).show();
                    break;
                case CertUploadErrorCode.EXCEPTION_CODE_NO_READPHONESATE_PERMISSION:
                case CertUploadErrorCode.EXCEPTION_CODE_GET_IMEI_NULL:
                    mDialogUtils.dismissLoadingDialog();
                    new DialogWrapper().showTitleClickableMessage1BtnDialog(MainActivity.this,
                            getString(R.string.permission_denied),
                            getString(R.string.text_permission_read_phone_id),
                            "",
                            getString(R.string.know));
                    break;
                case CertUploadErrorCode.EXCEPTION_CODE_IO_ERR: //芯片管家与服务器通信出错网络异常
                    mDialogUtils.dismissLoadingDialog();
                    Toast.makeText(MainActivity.this, getString(R.string.text_chipmanager_server_error), Toast.LENGTH_LONG).show();
                    break;
                case SHOW_LOADING:
                    mDialogUtils.showLoadingDialog(MainActivity.this);
                    break;
                default:
                    mDialogUtils.dismissLoadingDialog();
                    Toast.makeText(MainActivity.this, getString(R.string.text_invoke_chipmanager_err) + msg.what, Toast.LENGTH_LONG).show();
                    break;
            }
        }
    };

    /**
     * 针对浙江电信项目处理卡sn问题
     */
    void uploadClientInfo() {
        new Thread() {
            @Override
            public void run() {
                super.run();
                if (!NetworkUtil.netWorkisAvailable(MainActivity.this)) {
                    handler.sendEmptyMessage(NETWORK_UNAVAILABLE);
                } else {
                    CertUploadManager manager = new CertUploadManager.Builder().build(MainActivity.this, CONSTANT.ZHEJIANG_DIANXIN_PROVIDER_URI);
                    Log.d(TAG, "call upload  before:" + System.currentTimeMillis());
                    handler.sendEmptyMessage(SHOW_LOADING);
                    int result = manager.uploadCert();
                    Log.d(TAG, "call upload  result:" + result);
                    handler.sendEmptyMessage(result);
                    Log.d(TAG, "call upload  after:" + System.currentTimeMillis());
                }
            }
        }.start();
    }


    private void checkOtherSafeClient() {

        if (Function.isServiceWork(MainActivity.this, "com.xdja.safeclient.tun.video.TunVpnService")) {
            new AlertDialog.Builder(MainActivity.this)
                    .setTitle(getStringRes(MainActivity.this, R.string.alert))
                    .setMessage(getResources().getText(R.string.otherclientrunning))
                    .setPositiveButton(getStringRes(this, R.string.positive), new DialogInterface.OnClickListener() {

                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            Function.stopOtherSafeClient(MainActivity.this);
                        }
                    })
                    .setNegativeButton(getStringRes(this, R.string.negative), new DialogInterface.OnClickListener() {

                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            finish();
                        }

                    }).show();
        }
    }

    @Override
    public void onClick(View arg0) {
        int viewId = arg0.getId();
        if (viewId == R.id.start) {
            if (BuildConfig.AREA_VERSION == Compatibility.AREA_VERSION_ZHEJIANG_DIANXIN_BASE) {
                if (!Compatibility.isSafeKeyServiceAppInstalled(getApplicationContext())) {
                    //芯片管家为安全接入应用提供基于硬件级加解密服务，现在就去安装吧~
                    Dialog dia = new AlertDialog.Builder(MainActivity.this).setTitle(getStringRes(MainActivity.this, R.string.alert)).setMessage(R.string.safe_key_service_uninstall)
                            // 设置内容
                            .setPositiveButton(getStringRes(MainActivity.this, R.string.negative),// 设置确定按钮
                                    new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();// 关闭进度对话框
                                        }
                                    }).setNegativeButton(getStringRes(MainActivity.this, R.string.install_now), new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    Uri uri = Uri.parse(CONSTANT.CKMS_STANDARD_URL);
                                    Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                                    startActivity(intent);
                                }
                            }).create();// 创建
                    // 显示对话框
                    dia.show();
                    dia.setCancelable(true);
                } else if (!Compatibility.isCKMSAppInstalled(getApplicationContext())) {
                    //芯片管家为安全接入应用提供基于硬件级加解密服务，现在就去安装吧~
                    Dialog dia = new AlertDialog.Builder(MainActivity.this).setTitle(getStringRes(MainActivity.this, R.string.alert)).setMessage(R.string.ckms_uninstall)
                            // 设置内容
                            .setPositiveButton(getStringRes(MainActivity.this, R.string.negative),// 设置确定按钮
                                    new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();// 关闭进度对话框
                                        }
                                    }).setNegativeButton(getStringRes(MainActivity.this, R.string.install_now), new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    Uri uri = Uri.parse(CONSTANT.ZHEJIANG_DIANXIN_CKMS_URL);
                                    Intent intent = new Intent(Intent.ACTION_VIEW, uri);
                                    startActivity(intent);
                                }
                            }).create();// 创建
                    // 显示对话框
                    dia.show();
                    dia.setCancelable(true);
                } else if (Compatibility.getSafeKeyServiceVersion(getApplicationContext()) < Compatibility.CKMS_VERSION_CODE) {
                    Dialog dia = new AlertDialog.Builder(MainActivity.this).setTitle(getStringRes(MainActivity.this, R.string.alert)).setMessage(R.string.safe_key_service_upgrade)
                            // 设置内容
                            .setPositiveButton(getStringRes(MainActivity.this, R.string.negative),// 设置确定按钮
                                    new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();// 关闭进度对话框
                                        }
                                    }).setNegativeButton(getStringRes(MainActivity.this, R.string.btn_upgrade), new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    startUpdateActivity(Compatibility.getSafeKeyServicePackageName(), Compatibility.STANDARD_CLSNAME);
                                }
                            }).create();// 创建
                    // 显示对话框
                    dia.show();
                    dia.setCancelable(true);
                } else if (Compatibility.getCKMSVersion(getApplicationContext()) < Compatibility.CKMS_VERSION_CODE) {
                    Dialog dia = new AlertDialog.Builder(MainActivity.this).setTitle(getStringRes(MainActivity.this, R.string.alert)).setMessage(R.string.ckms_upgrade)
                            // 设置内容
                            .setPositiveButton(getStringRes(MainActivity.this, R.string.negative),// 设置确定按钮
                                    new DialogInterface.OnClickListener() {
                                        public void onClick(DialogInterface dialog, int which) {
                                            dialog.dismiss();// 关闭进度对话框
                                        }
                                    }).setNegativeButton(getStringRes(MainActivity.this, R.string.btn_upgrade), new DialogInterface.OnClickListener() {
                                public void onClick(DialogInterface dialog, int whichButton) {
                                    startUpdateActivity(Compatibility.getCKMSPackageName(), Compatibility.SPECIFIED_CLSNAME);
                                }
                            }).create();// 创建
                    // 显示对话框
                    dia.show();
                    dia.setCancelable(true);
                } else {
                    uploadClientInfo();
                }
            } else {
                start();
            }
        }
        if (viewId == R.id.more) {
            more();
        }
        if (viewId == R.id.config) {
            config();
        }
        if (viewId == R.id.update) {
            update();
        }
        if (viewId == R.id.about) {
            about();
        }
        if (viewId == R.id.exit) {
            Function.exitApp(this);
        }
    }

    void startUpdateActivity(String packageName, String clsName) {
        Intent intent = new Intent();
        //String pkgName = "com.xdja.safekeyservice";
        //String className = "com.xdja.scservice.presenter.activity.UpdatePresener";
        intent.setClassName(packageName, clsName);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        startActivity(intent);
    }

    /**
     * 启动按钮操作
     */
    public void start() {
        if(KeyWrapper.getInstance().getState() == KeyWrapper.State.NO_KEY)
        {
            ToastUtil.show(this, getString(R.string.detect_no_device));
            return;
        }
        configKey();
        if (safeCardPinVerify()) {
            MyApplication.selfStartFlag = true;
            LaunchUtil.start(this, SafeVerifyActivity.class);
            this.finish();
        }
    }

    /**
     * 更多按钮操作
     */
    public void more() {
        ll_more.setVisibility(View.GONE);
        ll_moremenu.setVisibility(View.VISIBLE);
    }

    /**
     * 配置菜单操作
     */
    public void config() {
        Intent intent = new Intent();
        intent.setClass(MainActivity.this, ConnectSetActivity.class);
        startActivity(intent);
    }

    /**
     * 更新操作菜单
     */
    public void update() {
        SCAutoUpdate.updateStart(MainActivity.this, true);//调用升级模块
    }

    /**
     * 关于菜单操作
     */
    public void about() {
        Intent intent = new Intent(MainActivity.this, AboutActivity.class);
        startActivity(intent);
    }

    /**
     * 安全卡pin认证
     */
    public boolean safeCardPinVerify() {
        userPin = et_pin.getText().toString();

        if (!PinWrapper.verifyPinLength(userPin)) {
            AlertUtil.popAlert(this, getStringRes(this, R.string.alert), getStringRes(this, R.string.pleaseinputsafepin));
            delPIN();
            return false;
        }

        myApplication.isWeakPassWD = userPin.equals(PinWrapper.DEFAULT_PIN);

        int nres = KeyWrapper.getInstance().keyOpen(KeyWrapper.currentKey);
        if (nres != 0)
        {
            return  false;
        }
        nres = KeyWrapper.getInstance().verifyPIN(userPin);

        if (nres != 0) {
            AlertUtil.popAlert(this, getStringRes(this, R.string.alert), getStringRes(this, R.string.wrong_password)
                    + "\r\n"
                    + getString(R.string.current_dev) + KeyWrapper.currentKeyTypeComment + "\r\n"
                    + KeyWrapper.StatusCode.getComment(nres));
            delPIN();
            return false;
        } else {
            //内存中保存安全卡pin码
            myApplication.sslClientConfig.setPin(userPin.getBytes());
            myApplication.sslClientConfig.setRole(role);

            if (cb_rememberPassword.isChecked()) {

                MyApplication.rememberPin = true;

                PinWrapper.setNeedSavePin(this, true);

                //持久化存储pin码
                PinWrapper.savePin(this, userPin);

            } else {
                MyApplication.rememberPin = false;
                delPIN();
            }
            return true;
        }
    }

    /**
     * 验证PIN码是否正确
     */
    public boolean isPinCorrect() {

        MyApplication myApplication = (MyApplication) getApplication();

        String userPin = "";

        // fix by zhaoxiaolong 20160530
        // 忽律登陆，并且使用默认PIN码，则直接进入认证界面
        if (myApplication.propertiesConfig.getmUseDefualtPin() == 1) {
            userPin = "111111";
        } else {

            boolean needSavePin = PinWrapper.getNeedSavePin(this);

            if (needSavePin) {
                userPin = PinWrapper.getPin(this);
                if (userPin == null) {
                    return false;
                }
            } else {
                return false;
            }
        }

        myApplication.isWeakPassWD = userPin.equals(PinWrapper.DEFAULT_PIN);

        int nres = -1;
        SafeTF tf = new SafeTF();

        int hHandle = 0;

        if (MyApplication.devOpenFlag == 0
                || MyApplication.devOpenFlag == MyApplication.OPEN_DEV_AUTO) {
            hHandle = tf.OpenSTFCardAuto();
            if (hHandle != 0) {
                MyApplication.devOpenFlag = MyApplication.OPEN_DEV_AUTO;
                myApplication.sslClientConfig.setDevOpenFlag(MyApplication.devOpenFlag);
            }
            Log.d("MainActivity", "OpenSTFCardAuto, hHandle = " + hHandle);
        }

        if ((MyApplication.devOpenFlag == 0
                || MyApplication.devOpenFlag == MyApplication.OPEN_DEV_BY_PATH)) {
            String tmp = new String(myApplication.sslClientConfig.getDevPath());

            hHandle = tf.OpenSTFCard(tmp);
            if (hHandle != 0) {
                MyApplication.devOpenFlag = MyApplication.OPEN_DEV_BY_PATH;
                myApplication.sslClientConfig.setDevOpenFlag(MyApplication.devOpenFlag);
            }
            Log.d("MainActivity", "OpenSTFCard ,hHandle = " + hHandle);
        }

        if (hHandle == 0) {
            MyApplication.devOpenFlag = 0;
            Log.d("MainActivity", "Open STF Card failed");
            AlertUtil.openCardFailed(this);
            return false;
        }

        //fix by zhaoxiaolong 2016-07-07
        role = myApplication.sslClientConfig.getRole();
        if (role != 0x01 && role != 0x11) {
            byte[] defaultCertId = myApplication.sslClientConfig.getCertId();
            role = Function.generateRole(defaultCertId);
        }

        nres = tf.SafePin(hHandle, userPin.getBytes(), role);

        if (nres != 0) {
            tf.CloseSTFCard(hHandle);

            return false;
        } else {
            tf.CloseSTFCard(hHandle);

            //内存中保存安全卡pin码
            myApplication.sslClientConfig.setPin(userPin.getBytes());
            myApplication.sslClientConfig.setRole(role);

            return true;
        }
    }

    private void delPIN() {
        //不保存pin码标识
        PinWrapper.setNeedSavePin(this, false);
        PinWrapper.deletePin(this);
    }

    private void selectContainerName(String appName) {
        int ret;
        SOF_AppLib app = SOF_DeviceLib.SOF_GetInstance(appName);
        final List<String> containerNames = new ArrayList<>();
        ret = app.SOF_EnumContainers(containerNames);
        if (ret != 0) {
            Log.e(TAG, "SOF enum containers failed. err " + SOF_DeviceLib.SOF_GetLastError());
            return;
        }
        if (containerNames.isEmpty()) {
            ToastUtil.show(this, "卡内无可用容器！");
            return;
        }
        Log.d(TAG, "Enum containers " + containerNames);

        View bottomView = View.inflate(this, R.layout.appname_dialog, null);//填充ListView布局
        ListView lvAppName = (ListView) bottomView.findViewById(R.id.lv_appname);//初始化ListView控件

        lvAppName.setAdapter(new AppNameAdapter(this, containerNames));//ListView设置适配器
        TextView title = new TextView(MainActivity.this);
        title.setTextSize(18);
        title.setText("请选择容器");
        title.setTextColor(Color.WHITE);

        final AlertDialog pickAppNameDlg = new AlertDialog.Builder(this)
                .setCustomTitle(title)
                .setView(bottomView)//在这里把写好的这个listview的布局加载dialog中
                .setNegativeButton("取消", new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.cancel();
                    }
                }).create();


        pickAppNameDlg.show();

        lvAppName.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                ToastUtil.show(MainActivity.this, "选择的容器名称为" + containerNames.get(i));
                selectContainerName = containerNames.get(i);
                pickAppNameDlg.cancel();

                LongmaiCfg longmaiCfg = new LongmaiCfg();
                longmaiCfg.setAppName(selectAppName);
                longmaiCfg.setContainerName(selectContainerName);
                KeyWrapper.getInstance().configLongmaiKey(longmaiCfg);

            }
        });
    }

    private void selectAppName() {
        if (selectAppName != null && selectContainerName != null) {
            return;
        }
        // 弹出应用选择框
        final List<String> appNames = LMWrapper.getInstance().enumApplications();

        View bottomView = View.inflate(this, R.layout.appname_dialog, null);//填充ListView布局
        ListView lvAppName = (ListView) bottomView.findViewById(R.id.lv_appname);//初始化ListView控件

        lvAppName.setAdapter(new AppNameAdapter(this, appNames));//ListView设置适配器
        TextView title = new TextView(MainActivity.this);
        title.setTextSize(18);
        title.setText("请选择应用");
        title.setTextColor(Color.WHITE);

        final AlertDialog pickAppNameDlg = new AlertDialog.Builder(this)
                .setCustomTitle(title)
                .setView(bottomView)//在这里把写好的这个listview的布局加载dialog中
                .setNegativeButton("取消", new DialogInterface.OnClickListener() {

                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        dialog.cancel();
                    }
                }).create();


        pickAppNameDlg.show();

        lvAppName.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                ToastUtil.show(MainActivity.this, "选择的应用名称为" + appNames.get(i));
                selectAppName = appNames.get(i);
                pickAppNameDlg.cancel();

                // 弹出选择容器窗口
                selectContainerName(selectAppName);
            }
        });


    }

    @Override
    public void onStateChanged(int curState) {
        cancelDialog();
        switch (curState) {
            case KeyWrapper.State.INIT_KEY_FAILED:
                ToastUtil.show(this, getString(R.string.init_key_failed));
                break;
            case KeyWrapper.State.NO_KEY:
//                ToastUtil.show(this, getString(R.string.detect_no_device));
                AlertUtil.popSystemAlert(this, getString(R.string.safe_client), getString(R.string.detect_no_device),
                        new DialogInterface.OnClickListener() {
                            @Override
                            public void onClick(DialogInterface dialogInterface, int i) {
                                Function.exitApp(MainActivity.this);
                            }
                        }, true);
                break;
            case KeyWrapper.State.READY:
                ToastUtil.show(this, getString(R.string.current_dev) + KeyWrapper.currentKeyTypeComment);
                configKey();
                break;
        }

    }


    private synchronized void cancelDialog() {
        if (checkDeviceDlg != null) {
            checkDeviceDlg.cancel();
        }
    }

    private synchronized void showDialog() {
        checkDeviceDlg = new ProgressDialog(this);
        checkDeviceDlg.setProgressStyle(ProgressDialog.STYLE_SPINNER);
        checkDeviceDlg.setTitle(getString(R.string.scan_in_progress));
        checkDeviceDlg.setMessage(getString(R.string.scan_encrpy_device));
        checkDeviceDlg.setCancelable(false);
        checkDeviceDlg.show();
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }



}
