package com.xdja.safeclient.activity;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.telephony.TelephonyManager;
import com.xdja.safeclient.utils.Log;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;

import com.xdja.safeclient.BuildConfig;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.ui.DialogWrapper;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.sslvpn.CONSTANT;

import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

import static com.xdja.safeclient.utils.StringUtil.getStringRes;

public class SafeVerifyActivity extends BaseActivity implements OnClickListener {

    LinearLayout ll_fail = null;
    TextView tv_fail = null;

    ImageView btn_titleLeft = null;
    TextView tv_title = null;
    ImageView btn_titleRight = null;

    ListView lv_show = null;
    static Button btn_stop = null;
    Button btn_hide = null;

    MyApplication myApplication = null;

    public static MyAdapter myAdapter = null;
    public static MyAdapter myTunAdapter = null;
    public static boolean startService = false;
//	public static boolean selfStartFlag = false; //如果是第三方应用启动服务则为false，客户端启动服务为true

    public static boolean stopBtnClick = false;

    private String TAG = "SafeVerifyActivity";

    Intent itt = null;
    Intent ittTunVpn = null;

    public static boolean threadStart = false;

    private Timer timer = new Timer();

    private HomeKeyReceiver homeReceiver = null;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        /*boolean startFromNotification = getIntent().getBooleanExtra(IntentParam.FLAG_START_FROM_NOTIFICATION, false);
        if (startFromNotification) {
            //之前会有手动点击退出之后，通知栏可能一秒之后才消失，
            // 此时点击点击通知之后仍然可以进入到此界面，只不过认证阶段为空，并且功能异常的情况
            //因此，如果已经点击退出，那从通知栏点击进入此界面不再处理
            if (QuitWrapper.getHasBeenQuit(this)) {
                return;
            }
        }*/

        setContentView(R.layout.activity_safeverify);
        ll_fail = (LinearLayout) findViewById(R.id.layout_fail);
        tv_fail = (TextView) findViewById(R.id.fail);

        btn_titleLeft = (ImageView) findViewById(R.id.titlebar_leftbtn);
        tv_title = (TextView) findViewById(R.id.titlebar_text);
        btn_titleRight = (ImageView) findViewById(R.id.titlebar_rightbtn);

        lv_show = (ListView) findViewById(R.id.show);
        btn_stop = (Button) findViewById(R.id.stop);
        btn_hide = (Button) findViewById(R.id.hide);

        btn_titleRight.setOnClickListener(this);
        btn_stop.setOnClickListener(this);
        btn_hide.setOnClickListener(this);

        btn_titleLeft.setBackgroundResource(R.drawable.titlebar_logo);
        tv_title.setText(getString(R.string.safe_client));
        btn_titleRight.setBackgroundResource(R.drawable.setting74);
        btn_titleRight.setVisibility(View.VISIBLE);

        myApplication = (MyApplication) getApplication();
        myApplication.activityList.add(this);

        myApplication.topActivity = this;
        homeReceiver = new HomeKeyReceiver();
        IntentFilter homeFilter = new IntentFilter(Intent.ACTION_CLOSE_SYSTEM_DIALOGS);
        registerReceiver(homeReceiver, homeFilter);

//        if (VpnService.TUNNEL_MODE == myApplication.sslClientConfig.transportMode) {
//            myApplication.havingRootPermission = Function.getRootAhth();
//        }
        //转发模式 或无ROOT权限 隧道模式使用VpnService
//        if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode
//                || myApplication.havingRootPermission == true) {
        if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode)
        {
            if (myAdapter == null) {
                //Log.i(TAG,"new MyAdapter,myAdapter");
                myAdapter = new MyAdapter(VpnService.sslStageList) {

                    @Override
                    public boolean isEnabled(int position) {
                        return false;
                    }

                };
            }

            lv_show.setAdapter(myAdapter);

            startService();
        } else if (VpnService.TUNNEL_MODE == myApplication.sslClientConfig.transportMode)//隧道模式
        {
            if (myTunAdapter == null) {
                //Log.i(TAG,"new MyAdapter,myTunAdapter1");
                myTunAdapter = new MyAdapter(TunVpnService.sslStageList) {

                    @Override
                    public boolean isEnabled(int position) {
                        return false;
                    }

                };
            }

            lv_show.setAdapter(myTunAdapter);
            startTunVpnService();

        }

        stopBtnClick = false;
    }


    @Override
    protected void onStart() {
        super.onStart();
    }


    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy");

        threadStart = false;

        if (timer != null) {
            timer.cancel();
        }

        if (homeReceiver != null) {
            unregisterReceiver(homeReceiver);
            homeReceiver = null;
        }
    }

    private void clearSslStageList() {
        SafeVerifyStageInfo item = null;
//        if (myApplication.sslClientConfig.transportMode == 0
//                || myApplication.havingRootPermission == true) {
        if (myApplication.sslClientConfig.transportMode == 0)
        {
            if (VpnService.sslStageList != null) {
                int size = VpnService.sslStageList.size();
                if (size > 0) {
                    item = VpnService.sslStageList.get(size - 1);
                }

                VpnService.sslStageList.clear();
                if (item != null) {
                    VpnService.sslStageList.add(item);
                }
            }
        } else {
            if (TunVpnService.sslStageList != null) {
                int size = TunVpnService.sslStageList.size();
                if (size > 0) {
                    item = TunVpnService.sslStageList.get(size - 1);
                }
                TunVpnService.sslStageList.clear();
                if (item != null) {
                    TunVpnService.sslStageList.add(item);
                }
            }
        }
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {

        Log.d(TAG, "onKeyDown,keyCode ======================== " + keyCode);

        if (KeyEvent.KEYCODE_BACK == keyCode) {
            if (startService == true) {
                Log.d(TAG, "KEYCODE_BACK,showHomeScreen");
                showHomeScreen();
            } else {
                myApplication.activityList.remove(this);
                finish();
            }
//			else {
            Log.d(TAG, "KEYCODE_BACK,finish, clear sslStageList");
            clearSslStageList();
//				myApplication.activityList.remove(this);
//				finish();
//			}
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    public void onClick(View arg0) {
        int viewId = arg0.getId();
        if(viewId == R.id.titlebar_rightbtn){
            set();
        }
        if(viewId == R.id.stop){
            stopService();
        }
        if(viewId == R.id.hide){
            showHomeScreen();
        }
    }

    private class HomeKeyReceiver extends BroadcastReceiver {
        final String SYS_KEY = "reason";
        final String SYS_HOME_KEY = "homekey";

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals(Intent.ACTION_CLOSE_SYSTEM_DIALOGS)) {
                String reason = intent.getStringExtra(SYS_KEY);
                if (reason != null && reason.equals(SYS_HOME_KEY)) {
                    Log.d(TAG, "BroadcastReceiver receiver: home key down");
                    if (startService == true) {
                        Log.d(TAG, "HOMEKEY_DOWN,showHomeScreen");
                        showHomeScreen();
                    } else {
                        Log.d(TAG, "HOMEKEY_DOWN,finish, clear SSLStage list");
//							clearSslStageList();
                        myApplication.activityList.remove(this);
                        finish();
                    }
                    clearSslStageList();
                }
            }
        }

    }

    /**
     * 设置按钮操作
     */
    public void set() {
        Intent intent = new Intent();
        intent.setClass(SafeVerifyActivity.this, SettingActivity.class);
        startActivity(intent);
    }

    public void startService() {
        //启动vpn服务
        Intent intent = new Intent();
        intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
        startService(intent);
        /* add by majp 2013-12-04 start bug id 1401 */
//		if (VpnService.startService == false) {
        if (Function.getSafeVpnState(getApplicationContext()) == false) {
            VpnService.errorState = "";
            ll_fail.setVisibility(View.GONE);

            VpnService.sslStageList.clear();
            if (myAdapter != null) {
                myAdapter.notifyDataSetChanged();
            }
        }

		/* add by majp 2013-12-04 end bug id 1401 */
        startService = true;
        //20140829
//		btn_stop.setClickable(true);
//		btn_stop.setText(R.string.stop);

        if (threadStart == true) {
            return;
        }

        new Thread(new Runnable() {
            public void run() {
                threadStart = true;

                while (true) {
                    if (stopBtnClick == true) {
                        Log.d(TAG, "stopBtnClick");
                        // add by mjp version 4.1.0.6048
                        if (startService == false
                                && Function.getSafeVpnState(getApplicationContext()) == false
                                && VpnService.stopService == true) {
                            threadStart = false;
                            Message message_stop = new Message();
                            message_stop.what = 2;
                            mHandler.sendMessage(message_stop);
                            Log.d(TAG, "sendMessage 2");
                            break;
                        }
                    }

                    if (threadStart == false) {
                        break;
                    }

                    Message message = new Message();
                    message.what = 1;
                    mHandler.sendMessage(message);

                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {
                    }

                }

            }

            ;
        }).start();
    }

    private Handler mHandler = new Handler() {
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1:
                    updateState();
                    break;
                case 2:
                    updateStopBtn();
                    break;
            }
        }

        ;
    };

    /**
     * 更新ssl认证状态
     */
    private void updateState() {
        //转发模式
//        if (myApplication.sslClientConfig.transportMode == 0
//                || myApplication.havingRootPermission == true) {
        if (myApplication.sslClientConfig.transportMode == 0) {
            if (VpnService.errorState.equals("")) {
                //myAdapter.notifyDataSetChanged();
                ll_fail.setVisibility(View.GONE);
            } else {//认证中有错误
                ll_fail.setVisibility(View.VISIBLE);
                tv_fail.setText(VpnService.errorState);
            }

            if (myAdapter != null) {
                myAdapter.notifyDataSetChanged();
            }
        }
        //隧道模式
        else {
            if (TunVpnService.errorState.equals("")) {
                //myAdapter.notifyDataSetChanged();
                ll_fail.setVisibility(View.GONE);
            } else {//认证中有错误
                ll_fail.setVisibility(View.VISIBLE);
                tv_fail.setText(TunVpnService.errorState);
            }

            if (myTunAdapter != null) {
                myTunAdapter.notifyDataSetChanged();
            }
            //TODO wanghao 针对浙江电信弹出dialog提醒
           if(BuildConfig.AREA_VERSION == Compatibility.AREA_VERSION_ZHEJIANG_DIANXIN_BASE){
                try {
                    String comment = myApplication.sslvpn.excuteOuterCmd("GETSTATUS");
                    String resultStr, stageStr, reasonStr, errCodeStr;
                    String[] commentArray = comment.split(" ");
                    resultStr = commentArray[0];
                    stageStr = commentArray[1];
                    errCodeStr= commentArray[2];

                    int errCode = Integer.valueOf(errCodeStr);
                    //-1163 参看SSLErrorID.h--->SSL_SERIVCE_UNESTABLISH
                    if(errCode == -1163){
                        stopService();
                        TelephonyManager tm = (TelephonyManager) this.getSystemService(Context.TELEPHONY_SERVICE);
                        String deviceId = tm.getDeviceId();
                        new DialogWrapper().showTitleClickableMessage1BtnDialog(this,
                                getString(R.string.text_permission_limit),
                                getString(R.string.text_permission_limit_tip),
                                getString(R.string.text_device_imei,deviceId), getString(R.string.know));
                    }else if (errCode == -1164){
                        stopService();
                        new DialogWrapper().showTitleClickableMessage1BtnDialog(this,
                                getString(R.string.notify),
                                getString(R.string.text_group_not_open),
                                "", getString(R.string.know),
                                Gravity.CENTER);
                    }

                }catch (Exception e){
                    Log.d(TAG,"zhejiang_dianxin error");
                }
            }
        }

    }

    /* add by majp 2013-12-20 start */
    private void updateStopBtn() {
        Log.d(TAG, "updateStopBtn");
        btn_stop.setText(getString(R.string.start));

		/* add by majp 2013-12-04 start bug id 1401 */
        SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
        stageInfo.name = getStringRes(this, R.string.stop_service);
        stageInfo.error = "";
        stageInfo.result = getStringRes(this, R.string.success);

        // 服务停止，需要做地方兼容性处理 Add by xjq, 2017-01-05 16:02:45
        Compatibility.onServiceStop();

        //转发模式
//        if (myApplication.sslClientConfig.transportMode == 0
//                || myApplication.havingRootPermission == true) {
        if (myApplication.sslClientConfig.transportMode == 0)
        {
            if (VpnService.sslStageList.isEmpty() == false &&
                    VpnService.sslStageList.get(VpnService.sslStageList.size() - 1).name.equals(stageInfo.name) == true) {
                //
            } else {
                VpnService.sslStageList.add(stageInfo);
                myAdapter.notifyDataSetChanged();
            }
            /* add by majp 2013-12-04 end bug id 1401 */
        } else {
            if (TunVpnService.sslStageList.isEmpty() == false &&
                    TunVpnService.sslStageList.get(TunVpnService.sslStageList.size() - 1).name.equals(stageInfo.name) == true) {
                //
            } else {
                TunVpnService.sslStageList.add(stageInfo);
                myTunAdapter.notifyDataSetChanged();
            }
            /* add by majp 2013-12-04 end bug id 1401 */
        }

        //20140829
        //btn_stop.setClickable(true);
        /* add by majp 2013-12-20 end */
    }
    /* add by majp 2013-12-20 end */

    void setStopBtn() {
        btn_stop.setClickable(false);
        btn_stop.setEnabled(false);
        Log.d(TAG, "btn_stop.setClickable(false)");

        TimerTask task = new TimerTask() {
            @Override
            public void run() {
                runOnUiThread(new Runnable() {
                    public void run() {
                        if (btn_stop != null) {
                            btn_stop.setClickable(true);
                            btn_stop.setEnabled(true);
                            Log.d(TAG, "btn_stop.setClickable(true)");
                        }
                    }
                });
            }
        };
        timer.schedule(task, 2000);
    }

    /**
     * 停止服务
     */
    private void stopService() {
        setStopBtn();

        String btn_text = btn_stop.getText().toString();
        Log.v(TAG, "the btn stop string is " + btn_text);
        if (btn_text.equals(getString(R.string.stop))) {
            Log.d(TAG, "stop btn click");
            stopBtnClick = true;
            //20140829
            //btn_stop.setClickable(false);

//            if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode
//                    || myApplication.havingRootPermission == true)//转发模式
            if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode)//转发模式
            {
                Intent intent = new Intent();
                intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
                stopService(intent);

                myAdapter.notifyDataSetChanged();
                VpnService.errorState = "";
            } else if (VpnService.TUNNEL_MODE == myApplication.sslClientConfig.transportMode)//隧道模式
            {
                Log.d("SafeVerifyActivity", "stop Service TunVpnService");
                try {
                    boolean res = false;
                    try {
                        if (TunVpnService.mInterface != null) {
                            Log.d(TAG, "TunVpnService.mInterface.close");
                            TunVpnService.mInterface.close();
                            TunVpnService.mInterface = null;
                            if (TunVpnService.tunVpnObj != null) {
                                TunVpnService.tunVpnObj.destroyBuilder();
                            }
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }

                    if (myApplication.sslvpn != null) {
                        myApplication.sslvpn.closeTunFd();
                    }

                    Intent intent = new Intent();
                    intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");

                    res = stopService(intent);

                    if (res == false) {
                        Log.e(TAG, "stopService TunVpnService failed");
                    } else {
                        Log.d(TAG, "stopService TunVpnService success ");
                    }

                } catch (SecurityException e) {
                    e.printStackTrace();
                }
                myTunAdapter.notifyDataSetChanged();
                TunVpnService.errorState = "";
            }

            startService = false;

//			selfStartFlag = false;
            MyApplication.selfStartFlag = false;

            ll_fail.setVisibility(View.GONE);
        } else {
            stopBtnClick = false;

//			selfStartFlag = true;
            MyApplication.selfStartFlag = true;

//            if (VpnService.TUNNEL_MODE == myApplication.sslClientConfig.transportMode) {
//                myApplication.havingRootPermission = Function.getRootAhth();
//            }

            btn_stop.setText(getString(R.string.stop));

            //转发模式 或者有root权限的隧道模式
//            if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode
//                    || myApplication.havingRootPermission == true) {
            if (VpnService.FORWARD_MODE == myApplication.sslClientConfig.transportMode)
            {
                if (myAdapter == null) {
                    Log.i(TAG, "new MyAdapter,myAdapter2");
                    myAdapter = new MyAdapter(VpnService.sslStageList) {

                        @Override
                        public boolean isEnabled(int position) {
                            return false;
                        }

                    };
                }

                lv_show.setAdapter(myAdapter);

                startService();
            }
            //无root权限的隧道模式
            else if (VpnService.TUNNEL_MODE == myApplication.sslClientConfig.transportMode) {
                if (myTunAdapter == null) {
                    Log.i(TAG, "new MyAdapter,myTunAdapter2");
                    myTunAdapter = new MyAdapter(TunVpnService.sslStageList) {

                        @Override
                        public boolean isEnabled(int position) {
                            return false;
                        }

                    };
                }

                lv_show.setAdapter(myTunAdapter);

                startTunVpnService();
            }
        }
    }

    public void startTunVpnService() {
        Log.d(TAG, "prepare...");
        itt = android.net.VpnService.prepare(this);

        if (itt != null) {
            Log.d(TAG, "startActivityForResult...");
            startActivityForResult(itt, 0);
        } else {
            Log.d(TAG, "onActivityResult...");
            onActivityResult(0, RESULT_OK, null);
        }


//		if (TunVpnService.startService == false) {
        if (Function.getSafeTunVpnState(getApplicationContext()) == false) {
            TunVpnService.errorState = "";
            ll_fail.setVisibility(View.GONE);

            if (TunVpnService.sslStageList != null) {
                TunVpnService.sslStageList.clear();
            }
            if (myTunAdapter != null) {
                //Log.e(TAG,"TunVpnService.sslStageList.clear()...");
                myTunAdapter.notifyDataSetChanged();
            }
        }

        startService = true;

        if (threadStart == true) {
            return;
        }

        new Thread(new Runnable() {
            public void run() {
                threadStart = true;

                while (true) {
                    if (stopBtnClick == true) {

                        threadStart = false;
                        Message message_stop = new Message();
                        message_stop.what = 2;
                        mHandler.sendMessage(message_stop);
                        Log.d(TAG, "sendMessage 2");
                        break;
                    }

                    if (threadStart == false) {
                        break;
                    }

                    Message message = new Message();
                    message.what = 1;
                    mHandler.sendMessage(message);

                    try {
                        Thread.sleep(1000);
                    } catch (InterruptedException e) {
                    }
                }
            }

            ;
        }).start();
    }

    @Override
    protected void onActivityResult(int request, int result, Intent data) {
        if (RESULT_OK == result) {
            Log.d(TAG, "onActivityResult , user permit");

            ittTunVpn = new Intent();
            ittTunVpn.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");

            ComponentName name = startService(ittTunVpn);
            if (name == null) {
                Log.d(TAG, "start TunVpnService failed");
            } else {
                Log.d(TAG, "start TunVpnService success " + name.toString());
            }
        } else {
            startService = false;
//    		TunVpnService.startService = false; 
            Function.setSafeTunVpnState(getApplicationContext(), false);
            TunVpnService.stopService = true;
            Log.d(TAG, "onActivityResult , user not permit");
        }
    }

    /**
     * 显示手机home屏
     */
    public void showHomeScreen() {
        this.finish();
    }


    public class MyAdapter extends BaseAdapter {
        private LayoutInflater inflater;
        private Holder holder;
        private List<SafeVerifyStageInfo> stageInfoList = null;

        public MyAdapter(List<SafeVerifyStageInfo> stageInfoList) {
            this.stageInfoList = stageInfoList;
            inflater = LayoutInflater.from(SafeVerifyActivity.this);
        }


        @Override
        public int getCount() {
            return stageInfoList.size();
        }

        @Override
        public Object getItem(int arg0) {
            return arg0;
        }

        @Override
        public long getItemId(int arg0) {
            return arg0;
        }

        @Override
        public View getView(final int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = inflater.inflate(R.layout.safeverifystagelist, null);
                holder = new Holder();
                holder.tv_stage = (TextView) convertView.findViewById(R.id.stage);
                holder.tv_result = (TextView) convertView.findViewById(R.id.result);

                convertView.setTag(holder);
            } else {
                holder = (Holder) convertView.getTag();
            }

            SafeVerifyStageInfo stageInfo = stageInfoList.get(position);
            holder.tv_stage.setText(stageInfo.name);
            holder.tv_result.setText(stageInfo.result);

            return convertView;
        }

        private class Holder {
            private TextView tv_stage;
            private TextView tv_result;
        }
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }

}
