package com.xdja.safeclient.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.adapter.SwitchLanguageAdapter;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.bean.LanguageBean;
import com.xdja.safeclient.constant.SPKey;
import com.xdja.safeclient.utils.LocaleUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.sslvpn.SSLVPN;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

//import butterknife.BindView;
//import butterknife.ButterKnife;
//import butterknife.OnClick;

public class SwitchLanguageActivity extends BaseActivity implements View.OnClickListener{

    SwitchLanguageAdapter adapter;

    //@BindView(R.id.titlebar_text)
    TextView titlebarText;
    //@BindView(R.id.titlebar_leftbtn)
    ImageView titlebarLeftbtn;
    //@BindView(R.id.titlebar_rightbtn)
    ImageView titlebarRightbtn;

    //@BindView(R.id.rv_language_list)
    RecyclerView rvLanguageList;

    List<LanguageBean> list = new ArrayList<>();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_switch_language);
        //ButterKnife.bind(this);
        initView();

        titlebarRightbtn.setBackgroundResource(R.drawable.save);
        titlebarRightbtn.setVisibility(View.VISIBLE);

        titlebarText.setText(R.string.switch_language);

        initLanguage();

        LinearLayoutManager layoutManager = new LinearLayoutManager(this);
        rvLanguageList.setLayoutManager(layoutManager);

        adapter = new SwitchLanguageAdapter(this, list, getDefaultPosition());

        rvLanguageList.setAdapter(adapter);

    }

    private void initView(){
         titlebarText = (TextView)findViewById(R.id.titlebar_text);
        titlebarLeftbtn = (ImageView)findViewById(R.id.titlebar_leftbtn);
        titlebarRightbtn = (ImageView)findViewById(R.id.titlebar_rightbtn);
        rvLanguageList = (RecyclerView)findViewById(R.id.rv_language_list);
        titlebarLeftbtn.setOnClickListener(this);
        titlebarRightbtn.setOnClickListener(this);
    }


    private int getDefaultPosition() {
        if (LocaleUtil.autoChoose(this)) {
            return 0;
        } else {
            String name = LocaleUtil.getCurrentLocaleName(this);
            LanguageBean language = new LanguageBean(name);
            return list.indexOf(language);
//            Toast.makeText(SwitchLanguageActivity.this, list.contains(language) + "", Toast.LENGTH_SHORT).show();
        }
    }

    private void initLanguage() {
        list.add(new LanguageBean(StringUtil.getStringRes(this, R.string.auto), Locale.getDefault(), true));
        list.add(new LanguageBean(LocaleUtil.SIMPLIFIED_CHINESE, Locale.SIMPLIFIED_CHINESE));
        list.add(new LanguageBean(LocaleUtil.ENGLISH, Locale.ENGLISH));
    }

    LocaleUtil.ChangeListener listener = new LocaleUtil.ChangeListener() {
        @Override
        public void onChange(LanguageBean language) {

            //按照产品经理的要求，切换完成之后，之前显示的内容，不再以其他语言显示
            //如果切换语言时是认证失败的状态，会不断尝试
            //此后添加到列表中的认证状态都是英文
            //如果切换时候是成功状态
            //根据转发模式或者隧道模式，自行添加一条成功的状态

//            VpnService.sslStageList.clear();
//            TunVpnService.sslStageList.clear();

            /*if (Function.isServiceWork(context, "com.xdja.safeclient.VpnService")) {
                if (VpnService.issuccess.equals("OK")) {
//                    ToastUtil.show(context, "转发模式在运行");
                    SafeVerifyStageInfo info = new SafeVerifyStageInfo();
                    info.name = StringUtil.getStringRes(context, R.string.safe_tunnel_via_trans_mode);
                    info.result = StringUtil.getStringRes(context, R.string.success);
                    info.error = "";
                    VpnService.sslStageList.add(info);
                }
            } else if (Function.isServiceWork(context, "com.xdja.safeclient.TunVpnService")) {

                if (TunVpnService.issuccess.equals("OK")) {
//                    ToastUtil.show(context, "隧道模式在运行");
                    SafeVerifyStageInfo info = new SafeVerifyStageInfo();
                    info.name = StringUtil.getStringRes(context, R.string.safe_tunnel_via_tunnel_mode);
                    info.result = StringUtil.getStringRes(context, R.string.success);
                    info.error = "";
                    TunVpnService.sslStageList.add(info);
                }

            }*/


            // 提示底层系统语言发生变化 xjq 2017-02-14 18:47:25
            SSLVPN.setLocale(language.isAuto()?LocaleUtil.getSystemLocale():language.getLocale());

            finish();

            Intent intent = new Intent(SwitchLanguageActivity.this, SafeVerifyActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);

            startActivity(intent);
        }
    };

    public void onClick(View view) {
        if(view.getId() == R.id.titlebar_leftbtn){
            finish();
        }
        if(view.getId() == R.id.titlebar_rightbtn){
            LanguageBean selectLanguage = list.get(adapter.getSelectedPosition());
            LocaleUtil.changeLanguage(this, selectLanguage, listener);

            SharedPreferencesUtil.put(this, SPKey.AUTO_LANGUAGE, selectLanguage.isAuto());
            SharedPreferencesUtil.put(this, SPKey.CURRENT_lANGUAGE, selectLanguage.getName());
        }
    }
}
