package com.xdja.safeclient.activity;

import android.app.DatePickerDialog;
import android.app.DatePickerDialog.OnDateSetListener;
import android.app.Dialog;
import android.os.Bundle;
import com.xdja.safeclient.utils.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TrafficStatistics;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.bean.TrafficTable;

import java.text.ParseException;
import java.util.Calendar;

public class TrafficStatisticsActivity extends BaseActivity {
    private TextView mTrafficAmountUp = null;
    private TextView mTrafficAmountDown = null;
    private TextView mTrafficUp = null;
    private TextView mTrafficDown = null;
    private TextView mTrafficAverageUp = null;
    private TextView mTrafficAverageDown = null;
    private TextView mStartTimeDisplay = null;
    private Button mStartTimeButton = null;
    private TextView mEndTimeDisplay = null;
    private Button mEndTimeButton = null;
    private Calendar mCal = null;
    private int mStartYear;
    private int mStartMonth;
    private int mStartDay;
    private int mEndYear;
    private int mEndMonth;
    private int mEndDay;
    private TrafficStatistics mTrafficStatistics = null;
    MyApplication myApplication = null;
    private String TAG = "TrafficStaticsActivity";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_traffic_statistics);

        myApplication = (MyApplication) getApplication();

        Log.d(TAG, "onCreate");

        mCal = Calendar.getInstance();

        mLeftBtn = (ImageView) findViewById(R.id.titlebar_leftbtn);
        mRightBtn = (ImageView) findViewById(R.id.titlebar_rightbtn);
        mTitleText = (TextView) findViewById(R.id.titlebar_text);

        initTitleText();

        initLeftBtn();

        initStartTime();

        initEndTime();

        mTrafficUp = (TextView) findViewById(R.id.traffic_up);
        mTrafficDown = (TextView) findViewById(R.id.traffic_down);

        mTrafficAverageUp = (TextView) findViewById(R.id.traffic_average_up);
        mTrafficAverageDown = (TextView) findViewById(R.id.traffic_average_down);

        myApplication.activityList.add(this);
        myApplication.topActivity = this;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(TAG, "onDestroy");
        if (myApplication.activityList != null) {
            myApplication.activityList.remove(this);
        }
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d(TAG, "onResume");
        /* 打开数据库 */
        initTrafficStatisticsDB();

        initTrafficAmount();
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d(TAG, "onPause");
        closeTrafficStatisticsDB();
    }

    /**
     * 初始化数据库句柄
     */
    private void initTrafficStatisticsDB() {

        mTrafficStatistics = new TrafficStatistics();

        mTrafficStatistics.openDB(this);

    }

    private void closeTrafficStatisticsDB() {
        mTrafficStatistics.closeDB();
    }

    /**
     * 获取总流量
     */
    private void initTrafficAmount() {
        TrafficTable trafTable = new TrafficTable();

        mTrafficAmountUp = (TextView) findViewById(R.id.traffic_amount_up);
        mTrafficAmountDown = (TextView) findViewById(R.id.traffic_amount_down);
        if (mTrafficStatistics != null && mTrafficAmountUp != null && mTrafficAmountDown != null) {
            mTrafficStatistics.queryTrafficAmount(mTrafficStatistics.getmDB(), trafTable);

            mTrafficAmountUp.setText(getString(R.string.traffic_amount_up).toString() + String.format("%.1f", trafTable.getmTrafficUp()) + getString(R.string.MB));
            mTrafficAmountDown.setText(getString(R.string.traffic_amount_down).toString() + String.format("%.1f", trafTable.getmTrafficDown()) + getString(R.string.MB));
        }
    }

    /**
     * 获取一段时间内的流量
     *
     * @param trafTable
     */
    private void getTraffic(TrafficTable trafTable) {

        if (trafTable != null && mTrafficStatistics != null
                && mTrafficUp != null && mTrafficDown != null) {
            mTrafficStatistics.queryTraffic(mTrafficStatistics.getmDB(), trafTable);

            mTrafficUp.setText(getString(R.string.traffic_up).toString() + String.format("%.1f", trafTable.getmTrafficUp()) + getString(R.string.MB));
            mTrafficDown.setText(getString(R.string.traffic_down).toString() + String.format("%.1f", trafTable.getmTrafficDown()) + getString(R.string.MB));
        }
    }

    /**
     * 获取一段时间内的日均流量
     *
     * @param trafTable
     * @throws ParseException
     */
    private void getTrafficAverage(TrafficTable trafTable) throws ParseException {

        if (trafTable != null && mTrafficStatistics != null
                && mTrafficAverageUp != null && mTrafficAverageDown != null) {
            mTrafficStatistics.queryTrafficAverage(mTrafficStatistics.getmDB(), trafTable);

            mTrafficAverageUp.setText(getString(R.string.traffic_average_up).toString() + String.format("%.1f", trafTable.getmTrafficUp()) + getString(R.string.MB));

            mTrafficAverageDown.setText(getString(R.string.traffic_average_down).toString() + String.format("%.1f", trafTable.getmTrafficDown()) + getString(R.string.MB));
        }
    }

    /**
     * 初始化开始时间
     */
    private void initStartTime() {
        mStartTimeDisplay = (TextView) findViewById(R.id.start_time_display);
        mStartTimeButton = (Button) findViewById(R.id.start_time_button);

        mStartYear = mCal.get(Calendar.YEAR);

        mStartMonth = mCal.get(Calendar.MONTH) + 1;

        mStartDay = mCal.get(Calendar.DAY_OF_MONTH);

//		mStartTimeDisplay.setText(String.format("%04d", mStartYear) + "-" + String.format("%02d", mStartMonth) + "-" + String.format("%02d", mStartDay));

        mStartTimeButton.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                showDialog(0);
            }
        });
    }

    /**
     * 初始化结束时间
     */
    private void initEndTime() {
        mEndTimeDisplay = (TextView) findViewById(R.id.end_time_display);
        mEndTimeButton = (Button) findViewById(R.id.end_time_button);

        mEndYear = mCal.get(Calendar.YEAR);

        mEndMonth = mCal.get(Calendar.MONTH) + 1;

        mEndDay = mCal.get(Calendar.DAY_OF_MONTH);

//		mEndTimeDisplay.setText(String.format("%4d", mEndYear) + "-" + String.format("%02d", mEndMonth) + "-" + String.format("%02d", mEndDay));

        mEndTimeButton.setOnClickListener(new OnClickListener() {

            @Override
            public void onClick(View v) {
                showDialog(1);
            }
        });
    }

    protected Dialog onCreateDialog(int id) {
        if (0 == id) {
            OnDateSetListener startDateListener = new OnDateSetListener() {

                @Override
                public void onDateSet(DatePicker view, int year, int monthOfYear,
                                      int dayOfMonth) {

                    mStartYear = year;

                    mStartMonth = monthOfYear + 1;

                    mStartDay = dayOfMonth;

                    mStartTimeDisplay.setText(String.format("%04d", mStartYear) + "-" + String.format("%02d", mStartMonth) + "-" + String.format("%02d", mStartDay));
                        /* 提示选择结束时间 */
                    Toast.makeText(view.getContext(), getString(R.string.select_end_time), Toast.LENGTH_SHORT).show();
                }
            };

            return new DatePickerDialog(this, startDateListener, mStartYear, mStartMonth - 1, mStartDay);
        } else if (1 == id) {
            OnDateSetListener endDateListener = new OnDateSetListener() {

                @Override
                public void onDateSet(DatePicker view, int year, int monthOfYear,
                                      int dayOfMonth) {

                    mEndYear = year;

                    mEndMonth = monthOfYear + 1;

                    mEndDay = dayOfMonth;

                    mEndTimeDisplay.setText(String.format("%4d", mEndYear) + "-" + String.format("%02d", mEndMonth) + "-" + String.format("%02d", mEndDay));


                    if ((mEndYear < mStartYear)
                            || (mEndYear == mStartYear && (mEndMonth < mStartMonth))
                            || (mEndYear == mStartYear && mEndMonth == mStartMonth && mEndDay < mStartDay)) {
						/* 提示结束时间小于开始时间 */
                        Toast.makeText(view.getContext(), getString(R.string.endtime_less_than_startime), Toast.LENGTH_LONG).show();
						
						/* 清空上行下行文本框 */
                        mTrafficUp.setText(getString(R.string.traffic_up).toString());
                        mTrafficDown.setText(getString(R.string.traffic_down).toString());
						
						/* 清空日均上行下行文本框 */
                        mTrafficAverageUp.setText(getString(R.string.traffic_average_up).toString());
                        mTrafficAverageDown.setText(getString(R.string.traffic_average_down).toString());
                    } else {
						/* 获取一段时间内的流量 */
                        TrafficTable trafTable = new TrafficTable(mStartYear, mStartMonth, mStartDay,
                                mEndYear, mEndMonth, mEndDay);

                        getTraffic(trafTable);

                        TrafficTable trafTableAverage = new TrafficTable(mStartYear, mStartMonth, mStartDay,
                                mEndYear, mEndMonth, mEndDay);
						/* 获取一段时间内的日均流量 */
                        try {
                            getTrafficAverage(trafTableAverage);
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                }
            };

            return new DatePickerDialog(this, endDateListener, mEndYear, mEndMonth - 1, mEndDay);
        }

        return null;
    }

    protected void initTitleText() {
        super.initTitleText();

        mTitleText.setText(R.string.label_traffic_statistics);
    }

//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleExitAppEvent(ExitAppEvent event) {
//        super.handleExitAppEvent(event);
//    }
//
//    @Subscribe
//    @CallSuper
//    @Override
//    public void handleFinishEvent(FinishActivityEvent event) {
//        super.handleFinishEvent(event);
//    }

}
