package com.xdja.safeclient.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import com.xdja.bean.SettingBean;
import com.xdja.safeclient.R;

import java.util.List;

/**
 * Description:
 * Created by Administrator on 2017/2/15 0015.
 */
public class SettingAdapter extends RecyclerView.Adapter<SettingAdapter.ViewHolder> {

    Context context;

    List<SettingBean> list;

    OnItemClickListener listener;

    public SettingAdapter(Context context, List<SettingBean> list, OnItemClickListener listener) {
        this.context = context;
        this.list = list;
        this.listener = listener;
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder(LayoutInflater.from(context).inflate(R.layout.list_item_setting, null));
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position) {
        final SettingBean bean = list.get(position);
        holder.icon.setImageResource(bean.getIconResId());
        holder.name.setText(bean.getNameResId());
        holder.ll_whole.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                listener.onClick(bean);
            }
        });

        //根据Item位置的不同，使用不同的背景（分割线不同）
        if (position == 0) {
            holder.ll_whole.setBackgroundResource(R.drawable.list_top_selector);
        } else if (position == list.size() - 1) {
            holder.ll_whole.setBackgroundResource(R.drawable.list_bottom_selector);
        } else {
            holder.ll_whole.setBackgroundResource(R.drawable.list_middle_selector);
        }
    }

    @Override
    public int getItemCount() {
        return list != null ? list.size() : 0;
    }

    class ViewHolder extends RecyclerView.ViewHolder {

        ImageView icon;

        TextView name;

        View ll_whole;

        public ViewHolder(View itemView) {
            super(itemView);
            icon = (ImageView) itemView.findViewById(R.id.icon);
            name = (TextView) itemView.findViewById(R.id.name);
            ll_whole = itemView.findViewById(R.id.ll_whole);
        }
    }

    public interface OnItemClickListener {
        void onClick(SettingBean bean);
    }

}


