package com.xdja.safeclient.card;

import com.xdja.safeclient.wrapper.CardWrapper;
import com.xdja.safeclient.utils.ByteUtil;

/**
 * Description:
 * Created by zjc on 2017/1/12 0012.
 */
public class Role {

    private int type;

    /**
     * 4号和6号容器为0x11,其他的为0x01
     * <p/>
     * 一般会先读取配置文件中值，如果不是0x11或0x01，再调用gen生成
     *
     * @param certId 证书ID
     * @return
     */
    public static Role gen(byte[] certId) {
        return new Role(certId);
    }

    private Role(byte[] certId) {
        //
        if (ByteUtil.equals(certId, CardWrapper.CONTAINER4.getExchangeCert().getCertId()) ||
                ByteUtil.equals(certId, CardWrapper.CONTAINER4.getSignCert().getCertId()) ||
                ByteUtil.equals(certId, CardWrapper.CONTAINER6.getExchangeCert().getCertId()) ||
                ByteUtil.equals(certId, CardWrapper.CONTAINER6.getSignCert().getCertId())) {
            type = 0x11;
        } else {
            type = 0x01;
        }
    }

    public int getType() {
        return type;
    }

}
