package com.xdja.safeclient.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.xdja.safeclient.utils.Log;

import com.xdja.safeclient.utils.FileUtil;

public class PropertiesConfig {

	private static final String TAG = "PropertiesConfig";
	private int mCertType;
	private int mDisableWifi;
	private int mDisableBluetoolth;
	private int mDisableFlag;
	private int mAutoStart;
	private int mShowTransportModeSet;
	private int mShowCertTypeSet;	
	private int mArmOrX86;
	private int mSuOrXdsu;
	private int mUseDefualtPin;
	private int mHuNanJwt;  // 0 ：非湖南警务通专版  1：湖南警务通专版
	private int ignoreLogin; //广东财政厅需求，跳过登陆页面
	private int isBigThan4G; //吉林交警需求，TF卡容量大于4G可用。
	private int isWakeLock;	
	//根据运营商选择网关地址，第一个IP：中国移动，第二个IP：中国联通，第三个IP：中国电信，如果第二第三个地址为空则使用第一个地址。
	private int pickIpByProviders;
	//是否显示通知栏消息，0：通知，1：不通知
	private int disableNotification;
	
	//是否检查海棠服务,0:不检查，1：检查
	private int checkhitomservice;

	// 系统VPN连接状态展示, 0:展示   1:不展示
	private int disableVpnInfoDialog;

	// 隧道模式下，是否阻断公网访问：0 不阻断  1 阻断
	private int disablePublicNetwork;

	// 是否使用贴膜key 0 不使用 1 使用
	private int hasCoverKey;

	// 是否使用中孚卡 0 不使用 1 使用
	private int hasZhongfuKey;

	// 是否使用龙脉卡 0 不使用 1 使用
	private int hasLongmaiKey;

	// 是否使用公司tf卡或者芯片 0 不使用 1 使用
	private int hasXdjaKey;

	// 是否调用芯片管家 0 不使用 1 使用
	private int hasChipManager;

	// 是否通过content provider调用卡 0 不使用 1 使用
	private int hasProviderKey;

	// 是否使用格尔软证书 0 不使用 1 使用
	private int hasKoalKey;

	// whether forcing detect cover card 0 no 1 yes
	private int forceDetectCoverCard;

	public int forceDectectCoverCard() {
		return forceDetectCoverCard;
	}

	public void setForceDetectCoverCard(int force) {
		this.forceDetectCoverCard = force;
	}

	public int hasProviderKey() {
		return hasProviderKey;
	}

	public void setHasProviderKey(int hasProviderKey) {
		this.hasProviderKey = hasProviderKey;
	}

	public int hasChipManager() {
		return hasChipManager;
	}

	public void setHasChipManager(int hasChipManager) {
		this.hasChipManager = hasChipManager;
	}


	public int hasCoverKey() {
		return hasCoverKey;
	}

	public void setHasCoverKey(int hasCoverKey) {
		this.hasCoverKey = hasCoverKey;
	}

	public int hasZhongfuKey() {
		return hasZhongfuKey;
	}

	public void setHasZhongfuKey(int hasZhongfuKey) {
		this.hasZhongfuKey = hasZhongfuKey;
	}

	public int hasXdjaKey() {
		return hasXdjaKey;
	}

	public void setHasXdjaKey(int hasXdjaKey) {
		this.hasXdjaKey = hasXdjaKey;
	}

	public int hasLongmaiKey() {
		return hasLongmaiKey;
	}

	public void setHasLongmaiKey(int hasLongmaiKey) {
		this.hasLongmaiKey = hasLongmaiKey;
	}

	public int hasKoalKey() {
		return hasKoalKey;
	}

	public void setHasKoalKey(int hasKoalKey) {
		this.hasKoalKey = hasKoalKey;
	}

	public PropertiesConfig() {
		this.mCertType = 0;
		this.mDisableWifi = 0;
		this.mDisableBluetoolth = 0;
		this.mAutoStart = 0;
		this.mShowTransportModeSet = 0;
		this.mShowCertTypeSet = 0;
		this.mArmOrX86 = 0;
		this.mSuOrXdsu = 0;
		this.mUseDefualtPin = 0;
		this.mHuNanJwt = 0;
		this.ignoreLogin = 0;
		this.isBigThan4G = 0;
		this.isWakeLock = 0;
		this.pickIpByProviders = 0;
		this.disableNotification = 0;
		this.checkhitomservice = 0;
		this.disableVpnInfoDialog = 0;
		this.disablePublicNetwork = 0;
		this.hasCoverKey=0;
		this.hasXdjaKey=0;
		this.hasZhongfuKey=0;
		this.hasChipManager=0;
		this.hasProviderKey=0;
		this.hasLongmaiKey=0;
		this.hasKoalKey = 0;
		this.forceDetectCoverCard=0;
	}


	public PropertiesConfig(InputStream in) {
		
		Properties prop = new Properties();
		try {
			prop.load(in);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			
			Log.d(TAG, "loadProperties failed");
			
			return;
		}
		
		if (prop != null) {
			String strCertType = (String) prop.get("certType");
			this.mCertType = (byte) Integer.parseInt(strCertType);
			Log.d(TAG, "loadProperties, mCertType = " + mCertType);
			
			String strDisableWifi = (String) prop.get("disableWifi");	
			if (strDisableWifi != null) {
				this.mDisableWifi = Integer.parseInt(strDisableWifi);	
			}
			else {
				this.mDisableWifi = 0;
			}
			Log.d(TAG, "loadProperties, disableWifi = " + this.mDisableWifi);
			
			String strDisableBluetoolth = (String) prop.get("disableBluetoolth");	
			if (strDisableBluetoolth != null) {
				this.mDisableBluetoolth = Integer.parseInt(strDisableBluetoolth);
			}
			else {
				this.mDisableBluetoolth = 0;
			}
			Log.d(TAG, "loadProperties, disableBluetoolth = " + this.mDisableBluetoolth);

			String strDisableFlag = (String) prop.get("disableFlag");	
			if (strDisableFlag != null) {
				this.mDisableFlag = Integer.parseInt(strDisableFlag);		
			}
			else {
				this.mDisableFlag = 0;
			}
			Log.d(TAG, "loadProperties, disableFlag = " + this.mDisableFlag);
			
			String strAutoStart = (String) prop.get("autoStart");	
			if (strAutoStart != null) {
				this.mAutoStart = Integer.parseInt(strAutoStart);		
			}
			else {
				this.mAutoStart = 0;
			}
			Log.d(TAG, "loadProperties, autoStart = " + this.mAutoStart);
			
			String strShowTransportModeSet = (String) prop.get("showTransportModeSet");		
			if (strShowTransportModeSet != null) {
				this.mShowTransportModeSet = Integer.parseInt(strShowTransportModeSet);	
			}
			else {
				this.mShowTransportModeSet = 0;
			}
			Log.d(TAG, "loadProperties, showTransportModeSet = " + this.mShowTransportModeSet);
			
			String strShowCertTypeSet = (String) prop.get("showCertTypeSet");
			if (strShowCertTypeSet != null) {
				this.mShowCertTypeSet = Integer.parseInt(strShowCertTypeSet);
			}
			else {
				this.mShowCertTypeSet = 0;
			}			
			Log.d(TAG, "loadProperties, showCertTypeSet = " + this.mShowCertTypeSet);
			
			String strArmOrX86 = (String) prop.get("armOrX86");	
			if (strArmOrX86 != null) {
				this.mArmOrX86 = Integer.parseInt(strArmOrX86);	
			}
			else {
				this.mArmOrX86 = 0;
			}
			Log.d(TAG, "loadProperties, armOrX86 = " + this.mArmOrX86);
			
			String strmSuOrXdsu = (String) prop.get("suOrXdsu");	
			if (strmSuOrXdsu != null) {
				this.mSuOrXdsu = Integer.parseInt(strmSuOrXdsu);	
			}
			else {
				this.mSuOrXdsu = 0;	
			}		
			Log.d(TAG, "loadProperties, suOrXdsu = " + this.mSuOrXdsu);
			
			String strmUseDefualtPin = (String) prop.get("useDefualtPin");	
			if (strmUseDefualtPin != null) {
				this.mUseDefualtPin = Integer.parseInt(strmUseDefualtPin);	
			}
			else {
				this.mUseDefualtPin = 0;
			}
			Log.d(TAG, "loadProperties, useDefualtPin = " + this.mUseDefualtPin);
			
			String strmHuNanJwt = (String) prop.get("huNanJwt");
			if (strmHuNanJwt != null) {
				this.mHuNanJwt = Integer.parseInt(strmHuNanJwt);		
			}
			else {
				this.mHuNanJwt = 0;
			}
			Log.d(TAG, "loadProperties, huNanJwt = " + this.mHuNanJwt);
			
			String strIgnoreLogin = (String) prop.get("ignoreLogin");
			if (strIgnoreLogin != null) {
				this.ignoreLogin = Integer.parseInt(strIgnoreLogin);		
			}
			else {
				this.ignoreLogin = 0;
			}
			Log.d(TAG, "loadProperties, ignoreLogin = " + this.ignoreLogin);
			
			String strIsBigThan4G = (String) prop.get("isBigThan4G");
			if (strIsBigThan4G != null) {
				this.isBigThan4G = Integer.parseInt(strIsBigThan4G);		
			}
			else {
				this.isBigThan4G = 0;
			}
			Log.d(TAG, "loadProperties, isBigThan4G = " + this.isBigThan4G);
			
			
			String strIsWakeLock = (String) prop.get("isWakeLock");
			if (strIsWakeLock != null) {
				this.isWakeLock = Integer.parseInt(strIsWakeLock);		
			}
			else {
				this.isWakeLock = 0;
			}
		
			
			Log.d(TAG, "loadProperties, isWakeLock = " + this.isWakeLock);
			
			String strpickIpByProviders = (String) prop.get("pickIpByProviders");
			if (strIsWakeLock != null) {
				this.pickIpByProviders = Integer.parseInt(strpickIpByProviders);		
			}
			else {
				this.pickIpByProviders = 0;
			}
			
			Log.d(TAG, "loadProperties, pickIpByProviders = " + this.pickIpByProviders);
			
			String strnotification = (String) prop.get("disableNotification");
			if (strIsWakeLock != null) {
				this.disableNotification = Integer.parseInt(strnotification);		
			}
			else {
				this.disableNotification = 0;
			}
			
			Log.d(TAG, "loadProperties, disableNotification = " + this.disableNotification);
			
			String strcheckhitomservice = (String) prop.get("checkhitomservice");
			if (strIsWakeLock != null) {
				this.checkhitomservice = Integer.parseInt(strcheckhitomservice);		
			}
			else {
				this.checkhitomservice = 0;
			}
			
			Log.d(TAG, "loadProperties, checkhitomservice = " + this.checkhitomservice);
			
			String strVpnInfoDialog = (String) prop.get("disableVpnInfoDialog");
			if (strVpnInfoDialog != null) {
				this.disableVpnInfoDialog = Integer.parseInt(strVpnInfoDialog);		
			}
			else {
				this.disableVpnInfoDialog = 0;
			}

			String strDisablePublicNetwork = (String)prop.get("disablePublicNetwork");
			if (strDisablePublicNetwork != null) {
				this.disablePublicNetwork = Integer.parseInt(strDisablePublicNetwork);
			} else {
				this.disablePublicNetwork = 0;
			}
			
			Log.d(TAG, "loadProperties, disablePublicNetwork = " + this.disablePublicNetwork);

			String strHasCoverKey = (String)prop.get("hasCoverKey");
			if (strHasCoverKey != null) {
				this.hasCoverKey = Integer.parseInt(strHasCoverKey);
			} else {
				this.hasCoverKey = 0;
			}
			Log.d(TAG, "loadProperties, hasCoverKey = " + this.hasCoverKey);

			String strHasZhongfuKey = (String)prop.get("hasZhongfuKey");
			if (strHasZhongfuKey != null) {
				this.hasZhongfuKey = Integer.parseInt(strHasZhongfuKey);
			} else {
				this.hasZhongfuKey = 0;
			}
			Log.d(TAG, "loadProperties, hasZhongfuKey = " + this.hasZhongfuKey);

			String strHasXdjaKey = (String)prop.get("hasXdjaKey");
			if (strHasXdjaKey != null) {
				this.hasXdjaKey = Integer.parseInt(strHasXdjaKey);
			} else {
				this.hasXdjaKey = 0;
			}
			Log.d(TAG, "loadProperties, hasXdjaKey = " + this.hasXdjaKey);

			String strHasChipManager = (String)prop.get("hasChipManager");
			if (strHasChipManager != null) {
				this.hasChipManager = Integer.parseInt(strHasChipManager);
			} else {
				this.hasChipManager = 0;
			}
			Log.d(TAG, "loadProperties, hasChipManager = " + this.hasChipManager);

			String strHasProviderKey = (String)prop.get("hasProviderKey");
			if (strHasProviderKey != null) {
				this.hasProviderKey = Integer.parseInt(strHasProviderKey);
			} else {
				this.hasProviderKey = 0;
			}
			Log.d(TAG, "loadProperties, hasProviderKey = " + this.hasProviderKey);

			String strHasLongmaiKey = (String )prop.get("hasLongmaiKey");
			if (strHasLongmaiKey != null) {
				this.hasLongmaiKey = Integer.parseInt(strHasLongmaiKey);
			} else {
				this.hasLongmaiKey = 0;
			}
			Log.d(TAG, "loadProperties, hasLongmaiKey = " + this.hasLongmaiKey);

			String strHasKoalKey = (String)prop.get("hasKoalKey");
			if (strHasKoalKey != null) {
				this.hasKoalKey = Integer.parseInt(strHasKoalKey);
			} else {
				this.hasKoalKey = 0;
			}
			Log.d(TAG, "loadProperties, hasKoalKey = " + this.hasKoalKey);

			String strForceDetectCoverCard = (String)prop.get("forceDetectCoverCard");
			if (strForceDetectCoverCard != null) {
				this.forceDetectCoverCard = Integer.parseInt(strForceDetectCoverCard);
			} else {
				this.forceDetectCoverCard = 0;
			}
			Log.d(TAG, "loadProperties, forceDectectCoverCard = " + this.forceDetectCoverCard);
		}
	}
	
	public void savePropertiesConfig(String filename) {
		Properties prop = new Properties();
		
		prop.put("certType",Integer.toString(this.mCertType));
		prop.put("disableWifi",Integer.toString(this.mDisableWifi));
		prop.put("disableBluetoolth",Integer.toString(this.mDisableBluetoolth));
		prop.put("autoStart",Integer.toString(this.mAutoStart));
		prop.put("showTransportModeSet",Integer.toString(this.mShowTransportModeSet));
		prop.put("showCertTypeSet",Integer.toString(this.mShowCertTypeSet));
		prop.put("armOrX86",Integer.toString(this.mArmOrX86));
		prop.put("suOrXdsu",Integer.toString(this.mSuOrXdsu));
		prop.put("useDefualtPin",Integer.toString(this.mUseDefualtPin));
		prop.put("huNanJwt",Integer.toString(this.mHuNanJwt));
		prop.put("ignoreLogin",Integer.toString(this.ignoreLogin));
		prop.put("isBigThan4G",Integer.toString(this.isBigThan4G));
		prop.put("isWakeLock",Integer.toString(this.isWakeLock));
		prop.put("pickIpByProviders",Integer.toString(this.pickIpByProviders));
		prop.put("disableNotification",Integer.toString(this.disableNotification));
		prop.put("checkhitomservice",Integer.toString(this.checkhitomservice));
		prop.put("disableVpnInfoDialog",Integer.toString(this.disableVpnInfoDialog));
		prop.put("disablePublicNetwork", Integer.toString(this.disablePublicNetwork));
		prop.put("hasCoverKey", Integer.toString(this.hasCoverKey));
		prop.put("hasZhongfuKey", Integer.toString(this.hasZhongfuKey));
		prop.put("hasXdjaKey", Integer.toString(this.hasXdjaKey));
		prop.put("hasChipManager", Integer.toString(this.hasChipManager));
		prop.put("hasLongmaiKey", Integer.toString(this.hasLongmaiKey));
		prop.put("hasKoalKey", Integer.toString(this.hasKoalKey));
		prop.put("forceDetectCoverCard", Integer.toString(this.forceDetectCoverCard));

		FileUtil.saveProperties(filename, prop);
	}
	
	public int getmCertType() {
		return mCertType;
	}
	public void setmCertType(int mCertType) {
		this.mCertType = mCertType;
	}
	public int getmDisableWifi() {
		return mDisableWifi;
	}
	public void setmDisableWifi(int mDisableWifi) {
		this.mDisableWifi = mDisableWifi;
	}
	public int getmDisableBluetoolth() {
		return mDisableBluetoolth;
	}
	public void setmDisableBluetoolth(int mDisableBluetoolth) {
		this.mDisableBluetoolth = mDisableBluetoolth;
	}
	public int getmDisableFlag() {
		return mDisableFlag;
	}
	public void setmDisableFlag(int mDisableFlag) {
		this.mDisableFlag = mDisableFlag;
	}
	public int getmAutoStart() {
		return mAutoStart;
	}
	public void setmAutoStart(int mAutoStart) {
		this.mAutoStart = mAutoStart;
	}
	
	public int getmShowTransportModeSet() {
		return mShowTransportModeSet;
	}

	public void setmShowTransportModeSet(int mShowTransportModeSet) {
		this.mShowTransportModeSet = mShowTransportModeSet;
	}

	public int getmShowCertTypeSet() {
		return mShowCertTypeSet;
	}

	public void setmShowCertTypeSet(int mShowCertTypeSet) {
		this.mShowCertTypeSet = mShowCertTypeSet;
	}
	
	public int getmArmOrX86() {
		return mArmOrX86;
	}

	public void setmArmOrX86(int mArmOrX86) {
		this.mArmOrX86 = mArmOrX86;
	}
	
	public int getmSuOrXdsu() {
		return mSuOrXdsu;
	}

	public void setmSuOrXdsu(int mSuOrXdsu) {
		this.mSuOrXdsu = mSuOrXdsu;
	}
	
	public int getmUseDefualtPin() {
		return mUseDefualtPin;
	}

	public void setmUseDefualtPin(int mUseDefualtPin) {
		this.mUseDefualtPin = mUseDefualtPin;
	}
	
	public int getmHuNanJwt() {
		return mHuNanJwt;
	}

	public void setmHuNanJwt(int mHuNanJwt) {
		this.mHuNanJwt = mHuNanJwt;
	}
	
	public int getIgnoreLogin() {
		return ignoreLogin;
	}

	public void setIgnoreLogin(int ignoreLogin) {
		this.ignoreLogin = ignoreLogin;
	}

	public int getIsBigThan4G() {
		return isBigThan4G;
	}


	public void setIsBigThan4G(int isBigThan4G) {
		this.isBigThan4G = isBigThan4G;
	}

	public int getIsWakeLock() {
		return isWakeLock;
	}


	public void setIsWakeLock(int isWakeLock) {
		this.isWakeLock = isWakeLock;
	}
	
	public int getPickIpByProviders() {
		return pickIpByProviders;
	}

	public void setPickIpByProviders(int pickIpByProviders) {
		this.pickIpByProviders = pickIpByProviders;
	}
	
	public int getNotification() {
		return disableNotification;
	}

	public void setNotification(int notification) {
		this.disableNotification = notification;
	}

	public int getCheckhitomservice() {
		return checkhitomservice;
	}

	public void setCheckhitomservice(int checkhitomservice) {
		this.checkhitomservice = checkhitomservice;
	}
	public int getVpnInfoDialog(){
		return this.disableVpnInfoDialog;
	}
	public void setVpnInfoDialog(int vpnInfoDialog){
		this.disableVpnInfoDialog = vpnInfoDialog;
	}


	public int getDisablePublicNetwork() {
		return disablePublicNetwork;
	}

	public void setDisablePublicNetwork(int disablePublicNetwork) {
		this.disablePublicNetwork = disablePublicNetwork;
	}


}
