package com.xdja.safeclient.event;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by xingjianqiang on 2017/8/2.
 * Project : safeclient.android.origin
 * Email : xingjianqiang@xdja.com
 */

public class EventManager {

    private static EventManager manager = new EventManager();
    private EventManager(){}

    public static EventManager getInstance() {
        return manager;
    }

    private List<SimStateChangedListener> simList = new ArrayList<>();
    private List<SDCardStateChangeListener> sdList = new ArrayList<>();

    public boolean addSimStateChangedListener(SimStateChangedListener listener) {
        return simList.add(listener);
    }

    public boolean removeSimStateListener(SimStateChangedListener listener) {
        return simList.remove(listener);
    }

    public boolean addSDCardStateChangedListener(SDCardStateChangeListener listener) {
        return sdList.add(listener);
    }

    public boolean removeSDCardStateChangedListener(SDCardStateChangeListener listener) {
        return sdList.remove(listener);
    }


    public synchronized void onSDCardStateChanged(int state) {
        for(SDCardStateChangeListener listener:sdList) {
            listener.onSDCardStateChanged(state);
        }
    }

    public synchronized void onSimStateChanged(int prevState, int curState) {
        for (SimStateChangedListener listener:simList) {
            listener.onSimStateChanged(prevState, curState);
        }
    }


}
