package com.xdja.safeclient.receiver;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.CallSuper;
import android.text.TextUtils;
import com.xdja.safeclient.utils.Log;

import com.xdja.safeclient.architecture.BusProvider;
import com.xdja.safeclient.event.ReceiverEvent;


/**
 * 使用Otto在收到广播时发送事件
 * Created by zjc on 2016/10/26 0026.
 */
public abstract class DynamicReceiver extends BroadcastReceiver {

    private final String TAG = this.getClass().getName();

    private IntentFilter intentFilter;

    public void register(Context context) {
        this.intentFilter = getFilter();
        context.registerReceiver(this, getFilter());
    }

    public void unRegister(Context context) {
        context.unregisterReceiver(this);
    }

    @CallSuper
    @Override
    public void onReceive(Context context, Intent intent) {
        if (context == null) {
            Log.e(TAG, "receiver的context为空，不太正常");
        } else {
            if (!TextUtils.isEmpty(intent.getAction())) {
                String action = intent.getAction();
                if (intentFilter.hasAction(intent.getAction())) {
                    Log.d(TAG, "包含所需要的广播" + action);
                    BusProvider.getMainProvider().post(event(intent));
                }
            } else {
                Log.e(TAG, "receiver的action为null或者空");
            }
        }
    }

    public abstract IntentFilter getFilter();

    public abstract ReceiverEvent event(Intent intent);
}

