package com.xdja.safeclient.ui;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.TextView;

import com.xdja.safeclient.Function;
import com.xdja.safeclient.R;

/**
 * 对话框
 */
public class DialogWrapper {

    //private ProgressDialog pDialog;

    private MDialog dialog;

    /**
     * 含有标题,可点击提示信息,一个按钮的对话框(消息体内容默认居中)
     *
     * @param context                上下文句柄 Ps:句柄用UI界面的句柄 不能为空
     * @param title                  标题 不能为空
     * @param msg1               提示信息 不能为空
     * @param msg2               提示信息 不能为空
     * @param positive               positive按钮显示文本 不可为空
     * //@param positiveListener       positive按钮点击监听事件 可以为空 若为空则默认关闭对话框
     */
    public void showTitleClickableMessage1BtnDialog(final Context context,
                                                    String title,
                                                    String msg1,
                                                    String msg2,
                                                    String positive)
    {
        showTitleClickableMessage1BtnDialog(context, title, msg1, msg2, positive, Gravity.LEFT);
    }


    /**
     * 含有标题,可点击提示信息,一个按钮的对话框
     *
     * @param context                上下文句柄 Ps:句柄用UI界面的句柄 不能为空
     * @param title                  标题 不能为空
     * @param msg1               提示信息 不能为空
     * @param msg2               提示信息 不能为空
     * @param positive               positive按钮显示文本 不可为空
     * //@param positiveListener       positive按钮点击监听事件 可以为空 若为空则默认关闭对话框
     */
    public void showTitleClickableMessage1BtnDialog(final Context context,
                                                    String title,
                                                    String msg1,
                                                    String msg2,
                                                    String positive,
                                                    int textGravity) {
        dialog = new MDialog(context);
        View view = LayoutInflater.from(context).inflate(R.layout.layout_click_message, null);
        dialog.setView(view);
        TextView titleText = (TextView) view.findViewById(R.id.tv_title);
        titleText.setGravity(Gravity.CENTER);
        titleText.setText(title);

        TextView message1 = (TextView) view.findViewById(R.id.tv_message1);
        message1.setText(msg1);
        message1.setGravity(textGravity);


        TextView message2 = (TextView) view.findViewById(R.id.tv_message2);
        message2.setText(msg2);
        message2.setGravity(textGravity);
        if("".equals(msg2)){
            message2.setVisibility(View.INVISIBLE);
        }

        dialog.setMessageGravity(Gravity.CENTER);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(true);
        dialog.setPositiveButton(positive, new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dialog.dismiss();
                if(context != null) {
                    //((Activity) context).finish();
                    Function.exitApp(context);
                }

            }
        });
        dialog.show();
    }

    /**
     * 含有标题,可点击提示信息,一个按钮的对话框
     *
     * @param context  上下文句柄 Ps:句柄用UI界面的句柄 不能为空
     * @param title    标题 不能为空
     * @param msg1     提示信息 不能为空
     * @param msg2     提示信息 不能为空
     * @param positive positive按钮显示文本 不可为空
     *                 //@param positiveListener       positive按钮点击监听事件 可以为空 若为空则默认关闭对话框
     */
    public void showTitleClickableMessage1BtnDialog(final Context context,
                                                    String title,
                                                    String msg1,
                                                    String msg2,
                                                    String positive,
                                                    View.OnClickListener listener) {
        dialog = new MDialog(context);
        View view = LayoutInflater.from(context).inflate(R.layout.layout_click_message, null);
        dialog.setView(view);
        TextView titleText = (TextView) view.findViewById(R.id.tv_title);
        titleText.setGravity(Gravity.CENTER);
        titleText.setText(title);

        TextView message1 = (TextView) view.findViewById(R.id.tv_message1);
        message1.setText(msg1);
        message1.setGravity(Gravity.LEFT);


        TextView message2 = (TextView) view.findViewById(R.id.tv_message2);
        message2.setText(msg2);
        message2.setGravity(Gravity.LEFT);
        if ("".equals(msg2)) {
            message2.setVisibility(View.INVISIBLE);
        }

        dialog.setMessageGravity(Gravity.CENTER);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(true);
        dialog.setPositiveButton(positive, listener);
        dialog.show();
    }

    Dialog pDialog;

    public void showLoadingDialog(Context context){
        View view = LayoutInflater.from(context).inflate(R.layout.app_progress_dialog,null);
        pDialog = new Dialog(context,R.style.progressDialog);// 创建自定义样式dialog
        pDialog.setCancelable(true);
        Animation hyperspaceJumpAnimation = AnimationUtils.loadAnimation(context, R.anim.my_progress_dialog_rotate);
        // 使用ImageView显示动画
        view.startAnimation(hyperspaceJumpAnimation);
        pDialog.setContentView(view);
        pDialog.getWindow().getAttributes().gravity = Gravity.CENTER;
        pDialog.getWindow().setType(WindowManager.LayoutParams.TYPE_SYSTEM_ALERT);
        pDialog.show();
    }

    public void dismissLoadingDialog(){
        if (pDialog != null) {
            pDialog.dismiss();// 关闭进度对话框
            pDialog = null;
        }
    }

}
