package com.xdja.safeclient.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;

import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

/**
 * Created by wanghao on 2018/1/18.
 */

public class AppSHAUtil {

    /**
     * 根据pkgName 得到证书指纹(SHA1)
     *
     * @param context context
     * @param pkgName pkgName
     * @return result
     */
    public static String getAppSHASign(Context context, String pkgName) {
        try {
            X509Certificate cert = getSignCer(context, pkgName);
            return format(parseCerFingerprint(cert));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取指定包名程序的签名信息
     *
     * @param context
     * @param packName
     */
    private static  X509Certificate getSignCer(Context context, String packName) {
        try {
            // 获取前面信息
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packName, PackageManager.GET_SIGNATURES);
            Signature[] signs = packageInfo.signatures;
            Signature signature = signs[0];

            // 获取证书Cer
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate) certFactory.generateCertificate(new ByteArrayInputStream(signature.toByteArray()));
            return cert;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 对证书指纹SHA1进行格式化（使用“:”分割）
     * @param str
     * @return
     */
    private static  String format(String str) {
        StringBuffer localStringBuffer = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            localStringBuffer.append(str.charAt(i));
            if ((i <= 0) || (i % 2 != 1) || (i >= str.length() - 1))
                continue;
            localStringBuffer.append(":");
        }
        return localStringBuffer.toString();
    }

    /**
     * X509Certificate 获取证书的指纹信息SHA1字符串
     *
     * @param cert
     * @return
     */
    private static String parseCerFingerprint(X509Certificate cert) {
        try {
            byte[] arrayOfByte = convert1(cert.getEncoded());
            return convert2(arrayOfByte);
        } catch (CertificateEncodingException localCertificateEncodingException) {
        }
        return null;
    }

    /**
     * 对字节数组进行SHA1加密
     *
     * @param data
     * @return
     */
    private static byte[] convert1(byte[] data) {
        try {
            MessageDigest localMessageDigest = MessageDigest.getInstance("SHA1");
            return localMessageDigest.digest(data);
        } catch (NoSuchAlgorithmException localNoSuchAlgorithmException) {
        }
        return null;
    }

    /**
     * 将字节数组转换格式化为证书指纹SHA1格式
     *
     * @author 单红宇
     */
    private static String convert2(byte[] data) {
        char[] arr = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder sb = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(arr[((data[i] & 0xF0) >> 4)]);
            sb.append(arr[(data[i] & 0xF)]);
        }
        return sb.toString();
    }
}
