package com.xdja.safeclient.utils;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.text.format.DateFormat;

import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.BuildConfig;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.sslvpn.CONSTANT;
import com.xdja.sslvpn.StatusCode;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by xingjianqiang on 2017/1/5.
 * Project : safeclient.android.origin
 * Email : xingjianqiang@xdja.com
 * <p/>
 * <p/>
 * 这个文件暂时来尝试合并安全客户端不同的地方版本到同一主版本上
 */

public class Compatibility {

    private static final String TAG = "Compatibility";

    public static final int AREA_VERSION_GENERAL = 0; // 通用版本

    public static final int AREA_VERSION_LIAONING_SHENGTING_BASE = 1000; // 辽宁省厅
    public static final int AREA_VERSION_LIAOING_ZHIAN = AREA_VERSION_LIAONING_SHENGTING_BASE + 1; // 辽宁治安

    public static final int AREA_VERSION_XINING_BASE = 2000; // 西宁项目

    public static final int AREA_VERSION_XINING_VIDEO = AREA_VERSION_XINING_BASE + 1; // 西宁视频安全客户端（隧道），通过shareduserid调卡

    public static final int AREA_VERSION_GUOSHUI = 3001; // 国税版本

    public static final int AREA_VERSION_ZHANG_JIA_JIE_BASE = 7000;//张家界通用版，包括张家界电信和移动的统一版本

    public static final int AREA_VERSION_XIAN_BASE = 8000;//西安移动警务通

    public static final int AREA_VERSION_ZHEJIANG_DIANXIN_BASE = 9000;//浙江电信

    public static final int AREA_VERSION_ZHENGZHOU_SHIJU = 6000;//郑州市局

    public static final int AREA_VERSION_GUIYANG_EMM = 10000; // 贵阳市局EMM

    public static final int AREA_VERSION_YANGZHOU_SHIJU = 12000; // 扬州市局V870

    public static final int AREA_VERSION_JIANGSU_YANCHENG = 13000; // 江苏盐城V870

    public static final int AREA_VERSION_JIANGSU_TAIZHOU = 14000; // 江苏泰州V870

    public static final int AREA_VERSION_LIAONING_SHENGTING = 15000; // 辽宁省厅V870

    public static final int AREA_VERSION_LANZHOU_GONGAN = 16000; // 兰州公安

    public static final int AREA_VERSION_GUANGDONG_SHENGTING = 17000; // 广东省厅

    public static final int AREA_VERSION_XDJA = 18000; // 信大内部使用版本

    public static final int AREA_VERSION_SHANXI_SHENGTING = 19000; // 陕西省厅

    public static final int AREA_VERSION_WUHAN_SHIJU = 20000; // 武汉市局

    private static int areaVersion = AREA_VERSION_GENERAL;

    public static int getAreaVersion() {
        return areaVersion;
    }

    public static void initAreaVersion() {
        areaVersion = BuildConfig.AREA_VERSION;
    }

    public static int onServiceStop() {
        if (areaVersion / AREA_VERSION_LIAONING_SHENGTING_BASE == 1) { // 黑龙江通用版
            onVPNStateChanged(CONSTANT.SUCCESS,
                    StatusCode.SERVICE_STOPPED,
                    StatusCode.SERVICE_STOPPED
            );
        }

        return 0;
    }


    public static int onVPNStateChanged(int result, int stage, int errCode) {

        if (areaVersion / AREA_VERSION_LIAONING_SHENGTING_BASE == 1) {

            if (stage != StatusCode.DIAL_NETWORK) { // 这种情况不发送广播，原因未知 Add by xjq, 2017-01-05 16:29:04
                // send broadcast
                Log.e(TAG, "heilongjiang shengting broadcast event  = " + stage + " action result = " +
                        result + " comment = " + StatusCode.getStatusComment(stage));
                Intent intent = new Intent(CONSTANT.ACTION_SSLVPN_STATE_CHANGED_HLG_SHENGTING);
                intent.putExtra(CONSTANT.VPN_EVENT, stage);
                intent.putExtra(CONSTANT.VPN_STATE, result);
                MyApplication.myApplication.sendBroadcast(intent);
            }
        }

        return 0;
    }

    public static int onSDCardEject() {
        if (areaVersion == AREA_VERSION_LIAONING_SHENGTING_BASE) { // 沈阳中兴A2015手机，sd卡移除后，退出程序 Add by xjq, 2017-01-06 08:41:50
            Function.exitApp(MyApplication.myApplication);
        }
        return 0;
    }

    public static boolean isXiAnJWT() {
        return areaVersion == AREA_VERSION_XIAN_BASE;
    }

    public static String getTFPackage(Context context) {
        if (areaVersion == AREA_VERSION_XINING_VIDEO) {
            return "com.xdja.safeclient";
        }

        return context.getPackageName();
    }


    // 抓包数据
    private final static String CAPTURE_FOLDER = "captures";
    // 日志
    private final static String LOGS_FOLDER = "logs";

    /**
     * Get the SD card folder name.
     * This folder will be used to store call logs and other app data(capture socket data).
     *
     * @return the name of the folder to use
     */
    public static String getSDCardFolder() {
        return "SafeClient";
    }

    private static File getStorageFolder(Context ctxt, boolean preferCache) {
        File root = Environment.getExternalStorageDirectory();
        if (!root.canWrite() || preferCache) {
            root = ctxt.getCacheDir();
        }

        if (root.canWrite()) {
            File dir = new File(root.getAbsolutePath() + File.separator + getSDCardFolder());
            if (!dir.exists()) {
                dir.mkdirs();
                Log.d(TAG, "Create directory " + dir.getAbsolutePath());
            }
            return dir;
        }
        return null;
    }

    private static File getSubFolder(Context ctxt, String subFolder, boolean preferCache) {
        File root = getStorageFolder(ctxt, preferCache);
        if (root != null) {
            File dir = new File(root.getAbsoluteFile() + File.separator + subFolder);
            dir.mkdirs();
            return dir;
        }
        return null;
    }

    /**
     * 获取日志存储目录
     *
     * @param ctxt
     * @return
     */
    public static File getLogsFolder(Context ctxt) {
        return getSubFolder(ctxt, LOGS_FOLDER, false);
    }

    /**
     * 获取日志文件
     *
     * @param ctxt
     * @return
     */
    public static File getLogsFile(Context ctxt) {
        File dir = getLogsFolder(ctxt);
        File outFile = null;
        if (dir != null) {
            Date d = new Date();
            StringBuffer fileName = new StringBuffer();
            fileName.append("safeclient");
            fileName.append("logs_");
            fileName.append(DateFormat.format("yy-MM-dd_kkmmss", d));
            fileName.append(".txt");
            outFile = new File(dir.getAbsoluteFile() + File.separator + fileName.toString());
        }

        return outFile;
    }

    /**
     * 清除日志文件
     *
     * @param ctxt
     */
    public static void cleanLogsFiles(Context ctxt) {
        File logsFolder = getLogsFolder(ctxt);
        if (logsFolder != null) {
            File[] files = logsFolder.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (file.isFile()) {
                        file.delete();
                    }
                }
            }
        }
    }

    public static boolean isZhangJiaJieBase() {
        return areaVersion / AREA_VERSION_ZHANG_JIA_JIE_BASE == 1;
    }


    public static void onStartedByThirdApp(Context context) {
        if (areaVersion == AREA_VERSION_LIAOING_ZHIAN) {
            LaunchUtil.start(context, SafeVerifyActivity.class);
        }
    }

    public static boolean isZhengZhouShiju(){
        return areaVersion / AREA_VERSION_ZHENGZHOU_SHIJU == 1;
    }


    /**
     * 监听本地端口时是否设置为IP_ANY Add by xjq, 2017-6-26 16:38:12
     * @return
     */
    public static boolean needBindAllIP() {
        boolean bindAllIP = true;
        switch (areaVersion) {
            case AREA_VERSION_YANGZHOU_SHIJU:
            case AREA_VERSION_JIANGSU_TAIZHOU:
            case AREA_VERSION_JIANGSU_YANCHENG:
            case AREA_VERSION_LIAONING_SHENGTING:
                Log.d(TAG, "Only bind 127.0.0.1");
                bindAllIP = false;
                break;

            default:
                bindAllIP = true;
        }

        return bindAllIP;
    }




    //浙江电信私有化-----芯片管家和ckms 最低版本要求
    public static final int CKMS_VERSION_CODE = 38182394;

    static final String SAFE_KEY_SERVICE_STANDARD = "com.xdja.safekeyservice";

    //浙江电信版本的芯片管家
    static final String SAFE_KEY_SERVICE_ZHE_JIANG = "com.xdja.safekeyservice.zjtel";
    //标准版升级界面路径
    public static final String STANDARD_CLSNAME = "com.xdja.scservice.presenter.activity.UpdatePresener";
    //浙江电信私有化升级界面路径
    public static final String SPECIFIED_CLSNAME = "com.xdja.appupdate.activity.UpdateShowActivity";


    static Map<Integer,String> SAFE_KEY_SERVICE_PACKAGE_NAME_MAP = new HashMap<Integer,String>();



    static{
        SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.put(AREA_VERSION_GENERAL,SAFE_KEY_SERVICE_STANDARD);
        SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.put(AREA_VERSION_ZHEJIANG_DIANXIN_BASE,SAFE_KEY_SERVICE_ZHE_JIANG);
    }

    /**<pre>
     * 获取当前版本的安全客户端---对应的芯片管家包名
     * 标准版安全客户端---标准版芯片管家
     * 浙江电信版安全客户端----浙江电信版芯片管家
     * </pre>
     * @return
     */
    public static String getCKMSPackageName(){
        return SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.get(AREA_VERSION_ZHEJIANG_DIANXIN_BASE);
    }

    public static String getSafeKeyServicePackageName(){
        return SAFE_KEY_SERVICE_PACKAGE_NAME_MAP.get(AREA_VERSION_GENERAL);
    }

    /**
     * 浙江电信版本_对应的芯片管家是否已经安装
     * @return
     */
    public static boolean isCKMSAppInstalled(Context context){
        return isAppInstalled(context, getCKMSPackageName());
    }

    /**
     * 获取私有化版  版本号
     * @param context
     * @return
     */
    public static int getCKMSVersion(Context context){
        try {
            PackageInfo packageInfo = getPackageInfo(context,getCKMSPackageName());
            return packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            Log.e("SafeClient"," getCKMSVersion--> package is not found.");
        }
        return -1;
    }

    /**
     * 标准版  芯片管家
     * @param context
     * @return
     */
    public static boolean isSafeKeyServiceAppInstalled(Context context){
        return isAppInstalled(context, getSafeKeyServicePackageName());
    }

    /**
     * 获取标准版芯片管家 版本号
     * @param context
     * @return
     */
    public static int getSafeKeyServiceVersion(Context context){
        try {
            PackageInfo packageInfo = getPackageInfo(context,getSafeKeyServicePackageName());
            return packageInfo.versionCode;
        } catch (PackageManager.NameNotFoundException e) {
            Log.e("SafeClient"," getSafeKeyServiceVersion---->package is not found.");
        }
        return -1;
    }


    static PackageInfo getPackageInfo(Context context,String packageName) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = context.getPackageManager();
        return packageManager.getPackageInfo(packageName,PackageManager.GET_ACTIVITIES);
    }

    static boolean isAppInstalled(Context context, String packageName){
        boolean isInstalled = false;
        try {
            PackageInfo packageInfo = getPackageInfo(context,packageName);
            if(packageInfo != null){
                isInstalled = true;
            }
        } catch (PackageManager.NameNotFoundException e) {
            Log.e("SafeClient"," package is not found. packageName:"+packageName);
        }
        return isInstalled;
    }

    public static boolean useZhongfuKey() {
        MyApplication application = MyApplication.myApplication;
        return application.propertiesConfig.hasZhongfuKey() == 1;
    }

    public static int[] getKeyDriverSort() {
        return new int[]{KeyWrapper.CHIP_MANAGER_KEY, KeyWrapper.XDJA_KEY, KeyWrapper.COVER_KEY};
    }

    public static int[] getKeyTypeSort() {
        return new int[]{KeyWrapper.KEY_TYPE_CHIP, KeyWrapper.KEY_TYPE_TF, KeyWrapper.KEY_TYPE_SIM};
    }


    /**
     * 是否屏蔽公司内置芯片
     * @return
     */
    public static boolean disableXdjaChip() {
        if (areaVersion == AREA_VERSION_GUANGDONG_SHENGTING ||
                areaVersion == AREA_VERSION_WUHAN_SHIJU) {
            return true;
        }
        return false;
    }

    public static List<String> getTunDisallowedApps() {
        ArrayList<String> appList = new ArrayList<>();
        if (areaVersion == AREA_VERSION_LANZHOU_GONGAN) {
            appList.add("lte.trunk.terminal.mdmclient");
            appList.add("lte.trunk.terminal.loguploader");
            appList.add("lte.trunk.terminal.touc");
            appList.add("lte.trunk.tapp");
            appList.add("lte.trunk.terminal.contacts");
            appList.add("lte.trunk.tapp.telephony");
            appList.add("lte.trunk.terminal.tmophone");
            return appList;
        } else if (areaVersion == AREA_VERSION_GUANGDONG_SHENGTING) {
            appList.add("com.bit.pmcrg.dispatchclient");
            appList.add("com.android.providers.downloads");
            return appList;
        }

        return null;
    }


    public static void showNetTimeoutDialog() {

        if (areaVersion == AREA_VERSION_GENERAL) {

            MyApplication.myApplication.getHandler().post(
                    new Runnable() {
                        @Override
                        public void run() {
                            AlertUtil.popSystemAlert(MyApplication.myApplication, "连接网关超时", "安全客户端可能被系统限制访问网络，请尝试点击'确定'关闭客户端，然后手动重启", new DialogInterface.OnClickListener() {
                                @Override
                                public void onClick(DialogInterface dialog, int which) {
                                    Function.exitApp(MyApplication.myApplication);
                                }
                            });
                        }
                    });

        }
    }

    /**
     * 获取关于页面显示声明
     * @return
     */
    public static String getDeclaration() {
        if (areaVersion == AREA_VERSION_XDJA){
            return MyApplication.myApplication.getString(R.string.xdja_declaration);
        }

        return MyApplication.myApplication.getString(R.string.declaration);
    }


    public static boolean showPersionInfo() {
        if (areaVersion == AREA_VERSION_WUHAN_SHIJU) {
            return true;
        }
        return false;
    }

}
