package com.xdja.safeclient.utils;

import android.content.Context;

import com.xdja.datapersistence.DataPersistence;

/**
 * Description:使用DataPersistence的工具类
 * Created by zjc on 2017/1/16 0016.
 */
public class DPUtil {

    public static void savePin(Context context, String pin) {
        savePin(context, pin.getBytes());
    }

    public static void savePin(Context context, byte[] pin) {
        String privatePath = context.getFilesDir().getPath();
//        DataPersistence dp = new DataPersistence(context, privatePath + "/datapersistence");
        DataPersistence dp = DataPersistence.getInstance(context);
        dp.addData("pin", pin);
    }

    /**
     * 获取保存的Pin码
     *
     * @param context
     * @return 没有保存过Pin码返回null
     */
    public static String getPin(Context context) {
        String privatePath = context.getFilesDir().getPath();
//        DataPersistence dp = new DataPersistence(context, privatePath + "/datapersistence");
        DataPersistence dp = DataPersistence.getInstance(context);
        byte pin[] = dp.getData("pin");
        return pin != null ? new String(pin) : null;
    }

    public static boolean deletePin(Context context) {
        //删除持久化存储pin码
        String privatePath = context.getFilesDir().getPath();
//        DataPersistence dp = new DataPersistence(context, privatePath + "/datapersistence");
        DataPersistence dp = DataPersistence.getInstance(context);
        return dp.deleteData("pin") != -1;
    }


}
