package com.xdja.safeclient.utils;

import android.content.Context;
import android.util.*;
import com.xdja.safeclient.utils.Log;

import com.safetf.SafeTF;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.ui.AlertUtil;

/**
 * Description:
 * Created by zjc on 2017/1/12 0012.
 */
public class OpenCard {

    openListener listener;

    public OpenCard(Context context, openListener listener) {
        this.listener = listener;

        int handle = 0;

        SafeTF tf = new SafeTF();

        if (MyApplication.devOpenFlag == 0 ||
                MyApplication.devOpenFlag == MyApplication.OPEN_DEV_AUTO) {
            handle = tf.OpenSTFCardAuto();
            if (handle != 0) {
                MyApplication.devOpenFlag = MyApplication.OPEN_DEV_AUTO;
                listener.auto();
                if (listener.autoClose()) {
                    tf.CloseSTFCard(handle);
                }

            }
        }

        if (MyApplication.devOpenFlag == 0 ||
                MyApplication.devOpenFlag == MyApplication.OPEN_DEV_BY_PATH) {
            String devPath = new String(MyApplication.myApplication.sslClientConfig.getDevPath());
            handle = tf.OpenSTFCard(devPath);
            if (handle != 0) {
                MyApplication.devOpenFlag = MyApplication.OPEN_DEV_BY_PATH;
                MyApplication.myApplication.sslClientConfig.setDevOpenFlag(MyApplication.devOpenFlag);
                listener.byPath();
                if (listener.autoClose()) {
                    tf.CloseSTFCard(handle);
                }
            }
        }

        if (handle == 0) {
            MyApplication.devOpenFlag = 0;
            listener.openFailed();
            AlertUtil.openCardFailed(context);
        }

    }

    interface openListener {

        /**
         * 打开卡后，是否在操作完成后自动关闭卡
         *
         * @return
         */
        boolean autoClose();

        void auto();

        void byPath();

        void openFailed();

    }

}
