package com.xdja.safeclient.utils;

import android.content.Context;

import com.orhanobut.logger.Logger;
import com.xdja.safeclient.architecture.BusProvider;
import com.xdja.safeclient.ottoobj.ExitAppEvent;
import com.xdja.safeclient.ottoobj.FinishActivityEvent;
import com.xdja.safeclient.ottoobj.LanguageEvent;
import com.xdja.safeclient.ottoobj.StopTunEvent;
import com.xdja.safeclient.ottoobj.StopVpnEvent;

import java.util.Locale;

/**
 * Description:
 * Created by zjc on 2017/1/12 0012.
 */
public class OttoUtil {

    public static void register(Object object) {
        BusProvider.getMainProvider().register(object);
        Logger.d(object.getClass().getName());
    }

    public static void unRegister(Object object) {
        BusProvider.getMainProvider().unregister(object);
        Logger.d(object.getClass().getName());
    }

    /**
     * 退出应用
     */
    public static void exitApp() {
        BusProvider.getMainProvider().post(new ExitAppEvent());
    }

    /**
     * 停止隧道服务
     */
    public static void stopTunService() {
        BusProvider.getMainProvider().post(new StopTunEvent());
    }

    /**
     * 停止VPN服务
     */
    public static void stopVpnService() {
        BusProvider.getMainProvider().post(new StopVpnEvent());
    }

    /**
     * 结束Activity
     *
     * @param context
     */
    public static void finishActivity(Context context) {
        BusProvider.getMainProvider().post(new FinishActivityEvent(context.getClass().getName()));
    }

    /**
     * 更改客户端内设置的语言
     *
     * @param locale 更改后的语言
     */
    public static void customChangeLanguage(Locale locale) {
        BusProvider.getMainProvider().post(new LanguageEvent(locale));
    }


    public static void systemChangeLanguage() {

    }





}
