package com.xdja.safeclient.utils;

import android.content.Context;
import android.support.annotation.StringRes;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Description: 字符串相关的操作接口
 * Created by Administrator on 2017/2/7 0007.
 */
public class StringUtil {

    public static String getStringRes(Context context, @StringRes int resId) {
        return context.getResources().getString(resId);
    }


    /**
     * 获取字符串中第N次出现子串的位置
     *
     * @param string  查找的字符串
     * @param pattern   子串样式
     * @param index 第几次
     * @return  下标
     */
    public static int getCharacterPosition(String string, String pattern, int index){
        //这里是获取"/"符号的位置
        Matcher slashMatcher = Pattern.compile(pattern).matcher(string);
        int mIdx = 0;
        while(slashMatcher.find()) {
            mIdx++;
            if(mIdx == index){
                break;
            }
        }
        return slashMatcher.start();
    }


}
