package com.xdja.sslvpn;

public class StatusCode {

	public static final int SDCARD_REMOVED = 1000;
	public static final int SERVICE_STOPPED = 1001;
	public static final int NULL_STAGE = 0;
	public static final int DIAL_NETWORK = 10;
	public static final int SAFEMODULE_INIT = 20;
	public static final int CONNECT_GATEWAY = 30;
	public static final int SAFEVERIFY = 40;
	public static final int BIND_VERIFYINFO = 50;
	public static final int START_DATASERVICE = 60;
	public static final int BUILD_SAFEGALLERY = 100;

	public static final String SDCARD_REMOVED_COMMENT = "安全卡已移除";
	public static final String SERVICE_STOPPED_COMMENT = "停止服务";
	public static final String NULL_STAGE_COMMENT = "";
	public static final String DIAL_NETWORK_COMMENT = "建立拨号连接";
	public static final String SAFEMODULE_INIT_COMMENT = "安全模块初始化";
	public static final String CONNECT_GATEWAY_COMMENT = "连接安全网关";
	public static final String SAFEVERIFY_COMMENT = "安全认证";
	public static final String BIND_VERIFYINFO_COMMENT = "绑定认证信息";
	public static final String START_DATASERVICE_COMMENT = "启动数据服务";
	public static final String BUILD_SAFEGALLERY_COMMENT = "建立安全通道";

	public static final String getStatusComment(int statusCode) {
		switch (statusCode) {
		case SDCARD_REMOVED:
			return SDCARD_REMOVED_COMMENT;
		case SERVICE_STOPPED:
			return SERVICE_STOPPED_COMMENT;
		case NULL_STAGE:
			return NULL_STAGE_COMMENT;
		case DIAL_NETWORK:
			return DIAL_NETWORK_COMMENT;
		case SAFEMODULE_INIT:
			return SAFEMODULE_INIT_COMMENT;
		case CONNECT_GATEWAY:
			return CONNECT_GATEWAY_COMMENT;
		case SAFEVERIFY:
			return SAFEVERIFY_COMMENT;
		case BIND_VERIFYINFO:
			return BIND_VERIFYINFO_COMMENT;
		case START_DATASERVICE:
			return START_DATASERVICE_COMMENT;
		case BUILD_SAFEGALLERY:
			return BUILD_SAFEGALLERY_COMMENT;
		}

		return "";
	}

}
