package com.xdja.sslvpn.api;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;

import com.xdja.safeclient.utils.Log;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by xingjianqiang on 2017/3/11.
 * Project : safeclient_android_apidemo
 * Email : xingjianqiang@xdja.com
 */

public class VPN implements VPNApi {

    public static final String AUTOHORITY = "com.xdja.providers.safetfprovider";

    // 启动安全客户端 add by zhaoxiaolong 20160527
    public static final String METHOD_STARTSAFECLIENT = "startSafeClient";

    //卡库版本接口
    public static final String METHOD_GETVERSION = "getVersion";

    //设备管理类接口
    public static final String METHOD_ISEXISTDEV = "isExistDev";
    public static final String METHOD_OPENDEV = "openDev";
    public static final String METHOD_CLOSEDEV = "closeDev";
    public static final String METHOD_LOCKDEV = "lockDev";
    public static final String METHOD_UNLOCKDEV = "unlockDev";
    public static final String METHOD_TRANSMIT = "transmit";
    public static final String METHOD_GETDEVINFO = "getDevInfo";
    public static final String METHOD_SETLOGPATH = "setLogPath";

    //访问控制类接口
    public static final String METHOD_CHANGEPIN = "changePIN";
    public static final String METHOD_GETPINTRYCOUNT = "getPinTryCount";
    public static final String METHOD_VERIFYPIN = "verifyPIN";
    public static final String METHOD_CARDRESET = "cardReset";

    //文件管理类接口
    public static final String METHOD_SELECTFILE = "selectFile";
    public static final String METHOD_GETDIRSIZE = "getDirSize";
    public static final String METHOD_CREATEFILE = "createFile";
    public static final String METHOD_GETFILEINFO = "getFileInfo";
    public static final String METHOD_READFILE = "readFile";
    public static final String METHOD_WRITEFILE = "writeFile";
    public static final String METHOD_READRSAPUBKEY = "readRsaPubKey";
    public static final String METHOD_WRITERSAPUBKEY = "writeRsaPubKey";
    public static final String METHOD_READCERT = "readCert";
    public static final String METHOD_WRITECERT = "writeCert";

    //密码服务类接口
    public static final String METHOD_GENRANDOM = "genRandom";

    //对称算法
    public static final String METHOD_SM1 = "sm1";
    public static final String METHOD_TMPSM1 = "tmpSM1";
    public static final String METHOD_SM1KEY = "sm1key";
    public static final String METHOD_SM4KEY = "sm4key";
    public static final String METHOD_SM6KEY = "sm6key";

    //RSA
    public static final String METHOD_GENRSAKEYPAIR = "genRSAKeyPair";
    public static final String METHOD_RSAPUBKEYCALC = "rsaPubKeyCalc";
    public static final String METHOD_RSAPRIKEYCALC = "rsaPriKeyCalc";
    public static final String METHOD_RSASIGN = "rsaSign";

    /**
     * 天津项目需要调用卡接口签名，第三方应用验证签名，需要把数据按照PKCS1标准填充 zjc, 2017-01-10 14:49:47
     */
    public static final String METHOD_RSASIGNWITHOUTDER = "rsaSignNoDER";
    public static final String METHOD_RSASIGNVERIFY = "rsaSignVerify";

    // SM2 add by xjq, 2016-12-27 增加SM2签名算法
    public static final String METHOD_SM2SIGN = "sm2Sign";
    public static final String METHOD_SM2SIGNVERIFY = "sm2SignVerify";

    //Hash
    public static final String METHOD_SHA1 = "sha1";
    public static final String METHOD_SM3 = "sm3";

    //TF卡专用接口
    public static final String METHOD_GETTFMOUNTPATH = "getTFMountPath";

    //获取安全卡ID
    public static final String METHOD_GETSAFECARDID = "getSafeCardID";

    //获取警员编号
    public static final String METHOD_GETPOLICEMANID = "getPolicemanID";

    //获取上次认证成功的时间
    // 西安警务通要求获取上次认证成功的时间  zjc 2017-01-10 14:46:59
    public static final String METHOD_GET_LAST_VERIFY_TIME = "getLastVerifyTime";

    // 兼容AidlService的接口 2017-01-18 15:28:47
    // XKF_GetVPNTunnelState
    public static final String METHOD_GET_VPN_TUNNEL_STATE = "getVPNTunnelState";

    // XKF_GetMonitorServerAddress
    public static final String METHOD_GET_MONITOR_SERVER_ADDRESS = "getMonitorServerAddress";

    // XKF_GetVendorInfo
    public static final String METHOD_GET_VENDOR_INFO = "getVendorInfo";

    // XKF_CheckWeakPassWD
    public static final String METHOD_CHECK_WEAK_PASSWD = "checkWeakPassWD";

    // XKF_PassWordEnter
    public static final String METHOD_PASSWORD_ENTER = "passwordEnter";
    // XKF_ReadDefaultCert
    public static final String METHOD_READ_DEFAULT_CERT = "readDefaultCert";
    // excute cmd xjq, 2017-03-11 11:22:57
    public static final String METHOD_EXCUTE_CMD = "excuteCmd";
    public static final Uri SAFETF_URI = Uri.parse("content://" + AUTOHORITY);


    private static final Uri URI = Uri.parse("content://com.xdja.providers.safetfprovider");

    private ContentResolver contentResolver = null;
    private Context mContext = null;

    public VPN(Context c) {
        mContext = c.getApplicationContext();
        contentResolver = c.getContentResolver();
    }


    @Override
    public int start() {
        int ret;
        try {
            Bundle result = contentResolver.call(URI, METHOD_STARTSAFECLIENT, null, null);
            ret = result.getInt("ret");
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return VPNApi.APP_NOT_INSTALLED;
        }

        return ret;
    }


    @Override
    public int stop() {
        //发送停止服务广播
        Intent intent = new Intent();
        intent.setAction("com.xdja.safeclient.action.STOP_SERVICE");
        mContext.sendBroadcast(intent);
        return 0;
    }

    /**
     * 获取安全客户端当前状态
     *
     * @return
     */
    @Override
    public StateResult getStatus() {
        StateResult state = new StateResult();

        Bundle inBundle = new Bundle();
        inBundle.putString("cmd", "GETSTATUS");
        try {
            Bundle outBundle = contentResolver.call(URI, METHOD_EXCUTE_CMD, null, inBundle);
            int ret = outBundle.getInt("ret");

            if (ret == 0) {
                String resultStr, stageStr, reasonStr, errCodeStr;
                String comment = outBundle.getString("result");
                String[] commentArray = comment.split(" ");

                resultStr = commentArray[0];
                stageStr = commentArray[1];
                errCodeStr = commentArray[2];

                int errCode = Integer.valueOf(errCodeStr);

                int commentStartIndex = getCharacterPosition(comment, " ", 3);
                reasonStr = comment.substring(commentStartIndex);

                state.setComment(reasonStr);
                if (resultStr.equals("OK") && stageStr.equals("100")) {
                    state.setCode(VPNApi.CONNECTED); // 连接成功
                } else if (resultStr.equals("OK") || errCode >= 0) {
//                    Log.e("StartVpnActivity vpn", "errCode:" + errCode + " resultStr:" + resultStr);
                    state.setCode(VPNApi.CONNECTING); // 正在连接中
                } else if (resultStr.equals("FAILED")) {
                    state.setCode(VPNApi.FAILED); // 连接失败
                }
                state.setOriginalCode(errCode);
            } else {
                state.setCode(VPNApi.APP_NOT_STARTED);
            }
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            state.setCode(VPNApi.APP_NOT_INSTALLED);
        }

        return state;
    }

    @Override
    public String getCardID() {
        try {
            Bundle result = contentResolver.call(URI, METHOD_GETSAFECARDID, null, null);
            return result.getString("result");
        } catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }


    /**
     * 获取字符串中第N次出现子串的位置
     *
     * @param string  查找的字符串
     * @param pattern 子串样式
     * @param index   第几次
     * @return 下标
     */
    private static int getCharacterPosition(String string, String pattern, int index) {
        //这里是获取"/"符号的位置
        Matcher slashMatcher = Pattern.compile(pattern).matcher(string);
        int mIdx = 0;
        while (slashMatcher.find()) {
            mIdx++;
            if (mIdx == index) {
                break;
            }
        }
        return slashMatcher.start();
    }
}

