/*
 * Decompiled with CFR 0.152.
 */
package com.ccore;

import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.util.Log;
import com.ccore.CResult;
import com.ccore.CcoreBT;
import com.ccore.NameAddr;
import java.util.ArrayList;

public class CcoreGuomi {
    private CcoreBT bto = null;
    private final String tag = "SDCC";
    private final long SAR_OK = 0L;
    private final long SAR_FAIL = 0xA000001L;
    private final long SAR_INVALIDPARAMERR = 0xA000006L;
    private final long SAR_NOTINITIALIZEDERR = 0xA00000CL;
    private final long SAR_OBJERR = 0xA00000DL;
    private final long SAR_MEMORYERR = 0xA00000EL;

    public CcoreGuomi(Context context) {
        this.bto = new CcoreBT(context.getPackageManager(), (BluetoothManager)context.getSystemService("bluetooth"));
        if (this.bto.errno < 0) {
            this.bto = null;
        }
    }

    public synchronized long SKF_WaitForDevEvent(StringBuffer devName, long[] event) {
        return 0xA000003L;
    }

    public synchronized long SKF_CancelWaitForDevEvent() {
        return 0xA000003L;
    }

    private void showRes(String f, CResult r) {
        if (r == null) {
            return;
        }
        Log.v((String)"SDCC", (String)(String.valueOf(f) + " returns " + String.format("0x%x", r.code)));
        Log.v((String)"SDCC", (String)("reth = " + String.format("0x%x", r.handle)));
        if (r.bmsg != null) {
            StringBuffer sf = new StringBuffer("retb = ");
            byte[] byArray = r.bmsg;
            int n = r.bmsg.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                String s = String.format("0x%x ", b);
                sf.append(s);
                ++n2;
            }
            Log.v((String)"SDCC", (String)sf.toString());
        }
        if (r.smsg != null) {
            Log.v((String)"SDCC", (String)("rets = " + r.smsg));
        }
    }

    public synchronized long SKF_EnumDev(boolean present, ArrayList<String> list) {
        ArrayList<NameAddr> l = null;
        if (this.bto == null) {
            return 0xA00000CL;
        }
        if (list == null) {
            return 0xA000006L;
        }
        list.clear();
        int i = 0;
        while (i < 3) {
            Log.d((String)"SDCC", (String)("bto.getDeviceList(), i = " + i));
            l = this.bto.getDeviceList();
            if (l != null && l.size() > 0) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        for (NameAddr na : l) {
            if (na.name == null || na.addr == null) continue;
            list.add(na.name);
        }
        CResult r = this.bto.nativeEnumDev(present);
        this.showRes("nativeEnumDev()", r);
        if (r != null) {
            return r.code;
        }
        return 0xA00000EL;
    }

    public synchronized long SKF_ConnectDev(String name, long[] handle) {
        if (this.bto == null) {
            return 0xA00000CL;
        }
        if (name == null || handle == null || handle.length < 1) {
            return 0xA000006L;
        }
        long r0 = this.bto.connectDev(name);
        Log.v((String)"SDCC", (String)("bto.connectDev() returns " + String.format("0x%x", r0)));
        if (r0 != 0L) {
            return r0;
        }
        CResult r1 = this.bto.nativeConnectDev(name);
        this.showRes("nativeConnectDev()", r1);
        if (r1 == null) {
            return 0xA00000EL;
        }
        if (r1.code == 0L) {
            handle[0] = r1.handle;
        }
        return r1.code;
    }

    public synchronized long SKF_DisconnectDev(long handle) {
        if (this.bto == null) {
            return 0xA00000CL;
        }
        if (handle < 0L) {
            return 0xA000006L;
        }
        if (!this.bto.disconnectDev()) {
            return 0xA00000DL;
        }
        CResult r = this.bto.nativeDisconnectDev();
        this.showRes("nativeDisConnectDev()", r);
        if (r == null) {
            return 0xA00000EL;
        }
        return r.code;
    }
}

