/*
 * Decompiled with CFR 0.152.
 */
package com.ccore;

import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import cn.org.bjca.wsecx.interfaces.BJCABLEWirelessInterface;
import cn.org.bjca.wsecx.interfaces.BJCAWirelessInfo;
import cn.org.bjca.wsecx.interfaces.BJCAWirelessInterface;
import cn.org.bjca.wsecx.interfaces.WSecurityEngineException;
import cn.org.bjca.wsecx.outter.encoder.Hex;
import com.ccore.CResult;
import com.ccore.CcoreBT;
import com.ccore.NameAddr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CcoreWirelessImpl
implements BJCABLEWirelessInterface,
BJCAWirelessInterface,
BJCAWirelessInfo {
    private static CcoreBT bto = null;
    private final String tag = "SDCC";
    private boolean appOpen = false;
    private String mbtID;
    private String mbtPass;

    public CcoreWirelessImpl() {
        Log.d((String)"SDCC", (String)"CcoreWirelessImpl is constructed");
    }

    public synchronized List<Map<String, String>> findDevices() {
        ArrayList<NameAddr> l = null;
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
        ret.clear();
        Log.d((String)"SDCC", (String)"begin calling findDevices()");
        this.disconnectDevice();
        Log.d((String)"SDCC", (String)"end disconnect");
        int i = 0;
        while (i < 3) {
            Log.d((String)"SDCC", (String)("bto.getDeviceList(), i = " + i));
            l = bto.getDeviceList();
            if (l != null && l.size() > 0) break;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        for (NameAddr na : l) {
            if (na.name == null || na.addr == null) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            if (na.name.length() == 11 && na.name.charAt(0) == '_') {
                map.put("NAME", "600520" + na.name.substring(1));
                map.put("ServiceID", "600520" + na.name.substring(1));
            } else {
                map.put("NAME", na.name);
                map.put("ServiceID", na.addr);
            }
            ret.add(map);
        }
        return ret;
    }

    public synchronized int connectDevice(String btID, String btPass) {
        Log.d((String)"SDCC", (String)"begin calling connectDevice()");
        if (this.isConnect()) {
            this.disconnectDevice();
        }
        this.mbtID = btID;
        this.mbtPass = btPass;
        return bto.connect(btID, btPass, true);
    }

    private synchronized int connectDeviceWait(String btID, String btPass) {
        int r = -1;
        if (this.isConnect()) {
            return 2;
        }
        Log.d((String)"SDCC", (String)"begin calling connectDeviceWait()");
        this.disconnectDevice();
        int i = 0;
        while (i < 5) {
            if (bto.isConnected()) {
                bto.disconnect();
            }
            if ((r = bto.connect(btID, btPass, true)) == 1) {
                return 1;
            }
            bto.sleep(500);
            ++i;
        }
        return r == 1020 ? 1020 : 1091;
    }

    public synchronized boolean isConnect() {
        return bto.isConnected();
    }

    public synchronized boolean disconnectDevice() {
        Log.i((String)"SDCC", (String)"logout, closeApp, disConnect");
        bto.ccLogout();
        bto.ccCloseApp();
        return bto.disconnect();
    }

    public synchronized int setEnv(Context context) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)("begin calling setEnv(), bto is null == " + (bto == null)));
        if (Build.VERSION.SDK_INT < 18) {
            return 1029;
        }
        if (bto != null) {
            this.disconnectDevice();
        } else {
            bto = new CcoreBT(context.getPackageManager(), (BluetoothManager)context.getSystemService("bluetooth"));
        }
        this.appOpen = false;
        this.mbtPass = "";
        this.mbtID = "";
        if (CcoreWirelessImpl.bto.errno == -1) {
            return 1029;
        }
        if (CcoreWirelessImpl.bto.errno == -3) {
            return 1030;
        }
        if (CcoreWirelessImpl.bto.errno == -4) {
            return 1034;
        }
        return 1;
    }

    public synchronized long openApp() {
        if (this.appOpen) {
            return 1L;
        }
        int i = 0;
        while (i < 3) {
            if (!this.isConnect() && this.connectDeviceWait(this.mbtID, this.mbtPass) > 9) {
                Log.e((String)"SDCC", (String)"Connection is lost");
                return -1L;
            }
            Log.d((String)"SDCC", (String)("begin calling openApp(), i = " + i));
            if (bto.ccOpenApp() == 0L) {
                this.appOpen = true;
                return 0L;
            }
            this.disconnectDevice();
            bto.sleep(500);
            ++i;
        }
        return -1L;
    }

    public synchronized boolean finalizeEnv() {
        bto = null;
        return true;
    }

    public synchronized int initDevice(String superPin, String adminPin, String userPin, int retryNum) {
        long r;
        String ips = null;
        Log.d((String)"SDCC", (String)"begin calling initDevice()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1007;
        }
        try {
            ips = new String(Hex.decode((String)superPin));
        }
        catch (Exception e) {
            ips = superPin;
        }
        if (ips == null || ips.equals("")) {
            ips = superPin;
        }
        if ((r = bto.ccInitDevice(ips, adminPin, userPin, retryNum)) == 0L) {
            return 1;
        }
        Log.e((String)"SDCC", (String)("initDevice() return 0x" + String.format("%x", r)));
        return 1007;
    }

    public synchronized int modifyUserPin(String oldUserPin, String newUserPin) {
        Log.d((String)"SDCC", (String)"begin calling modifyUserPin()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1007;
        }
        if (newUserPin.length() < 6 || newUserPin.length() > 16) {
            return 1007;
        }
        long r = bto.ccModifyUserPin(oldUserPin, newUserPin);
        if (r == 0L) {
            return 0;
        }
        Log.i((String)"SDCC", (String)String.format("modifyUserPin()'s internal error code = 0x%x", r));
        return 1007;
    }

    public synchronized int modifyAdminPin(String oldAdminPin, String newAdminPin) {
        Log.d((String)"SDCC", (String)("begin calling modifyAdminPin(): old = " + oldAdminPin + ", new = " + newAdminPin));
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1007;
        }
        if (newAdminPin.length() < 6 || newAdminPin.length() > 16) {
            Log.i((String)"SDCC", (String)"password should be 6-16 bytes.");
            return 1007;
        }
        long r = bto.ccModifyAdminPin(oldAdminPin, newAdminPin);
        if (r == 0L) {
            Log.i((String)"SDCC", (String)"modifyAdminPin() succeeds.");
            return 0;
        }
        Log.i((String)"SDCC", (String)String.format("modifyAdminPin()'s internal error code = 0x%x", r));
        return 1007;
    }

    public synchronized int login(String userPin) {
        Log.d((String)"SDCC", (String)("begin calling login(), passwd = " + userPin));
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return -2;
        }
        long r = bto.ccLogin(userPin);
        if (r == 0L) {
            return 0;
        }
        if (r > 0L && r < 100L) {
            Log.i((String)"SDCC", (String)String.format("incorrect pin, %d times retry remain", r));
            return (int)r;
        }
        if (r == 167772197L) {
            Log.i((String)"SDCC", (String)"key is locked");
            return -1;
        }
        if (r == 167772201L || r == 0xA00000CL) {
            Log.i((String)"SDCC", (String)"key is not initialized");
            return -2;
        }
        Log.i((String)"SDCC", (String)String.format("CC_Login() rturns error 0x%x", (int)r));
        return (int)r;
    }

    public synchronized boolean logout() {
        Log.d((String)"SDCC", (String)"begin calling logout()");
        return bto.ccLogout() == 0L;
    }

    public synchronized int unLockDevice(String adminPin, String userPin) {
        Log.d((String)"SDCC", (String)"begin calling unlockDevice()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1007;
        }
        long r = bto.ccUnlockDevice(adminPin, userPin);
        if (r == 0L) {
            return 1;
        }
        return 1007;
    }

    public synchronized String getDeviceInfo(int infoType) {
        Log.d((String)"SDCC", (String)"begin calling getDeviceInfo()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return "";
        }
        CResult s = bto.ccGetDeviceInfo(infoType);
        if (s.code == 0L) {
            return s.smsg;
        }
        return "";
    }

    public synchronized int generateKeyPair(String containerName, int algType) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling generateKeyPair()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1002;
        }
        long r = bto.ccGenerateKeyPair(containerName, algType);
        Log.d((String)"SDCC", (String)("generateKeyPair() error code = " + r));
        if (r == 0L) {
            return 1;
        }
        if (r == 0xA000030L) {
            return 1032;
        }
        return 1002;
    }

    public synchronized int importCertificate(String containerName, int keyType, byte[] cert) {
        Log.d((String)"SDCC", (String)"begin calling importCertificate()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1005;
        }
        long r = bto.ccImportCertificate(containerName, keyType, cert);
        Log.d((String)"SDCC", (String)("importCertificate() error code = 0x" + String.format("%x", r)));
        if (r == 0L) {
            return 1;
        }
        if (r == 0xA000030L) {
            return 1032;
        }
        return 1005;
    }

    public synchronized int importEncryptionKeyPair(String containerName, byte[] encryptedWrapKey, byte[] pubKey, byte[] encryptedPriKey, int algType) {
        Log.d((String)"SDCC", (String)"begin calling importEncryptionKeyPair()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1998;
        }
        StringBuffer sf = new StringBuffer("");
        byte[] byArray = encryptedPriKey;
        int n = encryptedPriKey.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sf.append(String.format("%x ", b));
            ++n2;
        }
        Log.d((String)"SDCC", (String)("encryptedPriKey = " + sf));
        long r = bto.ccImportEncryptionKeyPair(containerName, encryptedWrapKey, pubKey, encryptedPriKey, algType);
        Log.d((String)"SDCC", (String)("importEncryptionKeyPair() error code = 0x" + String.format("%x", r)));
        if (r == 0L) {
            return 1;
        }
        if (r == 0xA000030L) {
            return 1032;
        }
        return 1998;
    }

    public synchronized int importP12(String containerName, int keyType, byte[] pkcs12, byte[] p12Password) throws WSecurityEngineException {
        return 1999;
    }

    public synchronized byte[] exportCertificate(String containerName, int keyType) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling exportCertficate()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccExportCertificate(containerName, keyType);
        if (r.code == 0L) {
            return r.bmsg;
        }
        return null;
    }

    public synchronized byte[] exportPubKey(String containerName, int keyType) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling exportPubKey()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccExportPubKey(containerName, keyType);
        if (r.code == 0L) {
            return r.bmsg;
        }
        return null;
    }

    public synchronized Vector<String> getContainerList() {
        Log.d((String)"SDCC", (String)"begin calling getContainerList()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            Vector<String> v = new Vector<String>();
            v.clear();
            return v;
        }
        CResult r = bto.ccGetContainerList();
        Vector<String> v = new Vector<String>();
        if (r.code == 0L) {
            int i = 0;
            while (true) {
                if (i < r.bmsg.length && r.bmsg[i] == 0) {
                    ++i;
                    continue;
                }
                if (i >= r.bmsg.length) break;
                int j = i;
                while (i < r.bmsg.length && r.bmsg[i] != 0) {
                    ++i;
                }
                if (i >= r.bmsg.length) break;
                byte[] t = new byte[i - j];
                int k = j;
                while (k < i) {
                    t[k - j] = r.bmsg[k];
                    ++k;
                }
                v.add(new String(t));
            }
        }
        return v;
    }

    public synchronized int deleteContainer(String containerName) {
        Log.d((String)"SDCC", (String)"begin calling deleteContainer()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return 1998;
        }
        long r = bto.ccDeleteContainer(containerName);
        if (r == 0L) {
            return 1;
        }
        return 1998;
    }

    public synchronized byte[] symEncrypt(byte[] key, byte[] inData, int algType, int mode, byte[] iv) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling symEncrypt()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccSymmEncrypt(key, algType, inData, iv);
        Log.d((String)"SDCC", (String)("symEncrypt() error code = " + String.format("%x", (int)r.code)));
        if (r.code == 0L) {
            return r.bmsg;
        }
        if (r.code == 0xA00000FL) {
            return "timeout error".getBytes();
        }
        return null;
    }

    public synchronized byte[] symDecrypt(byte[] key, byte[] inData, int algType, int mode, byte[] iv) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling symDecrypt()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccSymmDecrypt(key, algType, inData, iv);
        Log.d((String)"SDCC", (String)("symDecrypt() error code = " + String.format("%x", (int)r.code)));
        if (r.code == 0L) {
            return r.bmsg;
        }
        if (r.code == 0xA00000FL) {
            return "timeout error".getBytes();
        }
        return null;
    }

    public synchronized byte[] genRandom(int randomLen) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling getRandom()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        Log.d((String)"SDCC", (String)"begin genRandom");
        CResult r = bto.ccGetRandom(randomLen);
        if (r.code == 0L) {
            Log.d((String)"SDCC", (String)("random = " + new String(r.bmsg)));
            return r.bmsg;
        }
        Log.d((String)"SDCC", (String)"genRandom fails");
        return null;
    }

    public synchronized byte[] pubKeyEncryption(String containerName, int keyType, byte[] inData) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling pubKeyEncryption()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccPubKeyEncryption(containerName, keyType, new byte[0], inData);
        if (r.code == 0L) {
            return r.bmsg;
        }
        return null;
    }

    public synchronized byte[] pubKeyEncryption(byte[] cert, byte[] inData) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling pubKeyEncryption()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccPubKeyEncryption("", 0, cert, inData);
        if (r.code == 0L) {
            return r.bmsg;
        }
        return null;
    }

    public synchronized byte[] priKeyDecryption(String containerName, int keyType, byte[] encryptedData) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling priKeyDecryption()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccPriKeyDecryption(containerName, keyType, encryptedData);
        if (r.code == 0L) {
            return r.bmsg;
        }
        return null;
    }

    public synchronized byte[] signData(String containerName, int keyType, int hashType, byte[] inData, boolean isHash) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling signData()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccSignData(containerName, keyType, hashType, inData);
        if (r.code == 0L) {
            return r.bmsg;
        }
        return null;
    }

    public synchronized boolean verifySignedData(byte[] cert, byte[] inData, byte[] signedValue, int hashType, boolean isHash) throws WSecurityEngineException {
        Log.d((String)"SDCC", (String)"begin calling verifySingedData()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return false;
        }
        long r = bto.ccVerifySignedData(cert, inData, signedValue, hashType);
        return r == 0L;
    }

    public synchronized int writeFile(String fileName, byte[] fileData) {
        Log.d((String)"SDCC", (String)"begin calling writeFile()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return -1;
        }
        return (int)(bto.ccWriteFile(fileName, fileData) & 0xFFFFFFFFFFFFFFFFL) == 0 ? fileData.length : -1;
    }

    public synchronized byte[] readFile(String fileName) {
        Log.d((String)"SDCC", (String)"begin calling readFile");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return null;
        }
        CResult r = bto.ccReadFile(fileName);
        Log.d((String)"SDCC", (String)("readFile(): error = " + String.format("0x%x", r.code)));
        if (r.code == 0L) {
            return r.bmsg;
        }
        return null;
    }

    public synchronized int deleteFile(String fileName) {
        Log.d((String)"SDCC", (String)"begin calling deleteFile()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            return -1;
        }
        return bto.ccDeleteFile(fileName) == 0L ? 1 : -1;
    }

    public synchronized Vector<String> getFileList() {
        CResult r = bto.ccGetFileList();
        Vector<String> v = new Vector<String>();
        Log.d((String)"SDCC", (String)"begin calling getFileList()");
        if (this.openApp() < 0L) {
            Log.e((String)"SDCC", (String)"OpenApp fails");
            v.clear();
            return v;
        }
        if (r.code == 0L) {
            int i = 0;
            while (true) {
                if (i < r.bmsg.length && r.bmsg[i] == 0) {
                    ++i;
                    continue;
                }
                if (i >= r.bmsg.length) break;
                int j = i;
                while (i < r.bmsg.length && r.bmsg[i] != 0) {
                    ++i;
                }
                if (i >= r.bmsg.length) break;
                byte[] t = new byte[i - j];
                int k = j;
                while (k < i) {
                    t[k - j] = r.bmsg[k];
                    ++k;
                }
                v.add(new String(t));
            }
        }
        return v;
    }
}

