/*
 * Decompiled with CFR 0.152.
 */
package com.hed.bluetooth.le;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.util.Log;
import com.hed.bluetooth.le.datagram.BluetoothDatagram;
import com.hed.bluetooth.le.datagram.BluetoothDatagramFactory;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import opencard.core.util.HexString;

@SuppressLint(value={"NewApi"})
public class SyncBluetoothGatt
extends BluetoothGattCallback {
    private static final String TAG = "SyncBluetoothGatt";
    private static final int PROTOCOL = 2;
    private BluetoothDatagram mDatagram = BluetoothDatagramFactory.createDatagram(2);
    private BluetoothGattCharacteristic mCharacteristic;
    private BluetoothGattService mService;
    private BluetoothDevice mDevice;
    private BluetoothGatt mGatt;
    private Context mContext;
    private Listener mListener;
    private UUID mServiceUuid;
    private final Object mStateLock = new Object();
    private int mConnState = 0;
    private boolean mNotifyEnabled = false;
    private boolean mWritten = false;
    private boolean mLogOn = true;
    private int mAsyncStatus = 0;

    protected SyncBluetoothGatt(Context context, BluetoothDevice device) {
        this.mContext = context;
        this.mDevice = device;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int connect(int millis) throws InterruptedException, IllegalArgumentException {
        if (millis < 0) {
            throw new IllegalArgumentException("millis < 0");
        }
        this.mAsyncStatus = -1;
        this.mGatt = this.mDevice.connectGatt(this.mContext, false, (BluetoothGattCallback)this);
        if (this.mGatt == null) {
            throw new NullPointerException("connectGatt return null");
        }
        Log.i((String)TAG, (String)("Wait onConnectionStateChange " + millis + " ms"));
        Object object = this.mStateLock;
        synchronized (object) {
            if (!this.isConnected()) {
                this.mStateLock.wait(millis);
            }
        }
        Log.i((String)TAG, (String)"Wakeup");
        if (this.isConnected()) {
            return 0;
        }
        return this.mAsyncStatus == -1 ? 100000 : this.mAsyncStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int disconnect(int millis) throws InterruptedException {
        if (this.mGatt == null) {
            return 0;
        }
        if (millis < 0) {
            throw new IllegalArgumentException("millis < 0");
        }
        this.mAsyncStatus = -1;
        this.mGatt.disconnect();
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.isConnected()) {
                this.mStateLock.wait(millis);
            }
        }
        if (!this.isConnected()) {
            Log.i((String)TAG, (String)"Gatt Disconnected");
            return 0;
        }
        int retCode = this.mAsyncStatus == -1 ? 100000 : this.mAsyncStatus;
        Log.i((String)TAG, (String)("Gatt Disconnect Failed, status=" + retCode));
        return retCode;
    }

    public void close() {
        if (this.mGatt == null) {
            return;
        }
        this.mGatt.close();
        this.mGatt = null;
        this.mService = null;
        this.mConnState = 0;
        this.mAsyncStatus = -1;
        Log.i((String)TAG, (String)"Gatt Closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int discoverServices(UUID serviceUuid, int millis) throws InterruptedException, IllegalArgumentException {
        if (millis < 0) {
            throw new IllegalArgumentException("millis < 0");
        }
        this.mServiceUuid = serviceUuid;
        this.mAsyncStatus = -1;
        if (!this.mGatt.discoverServices()) {
            Log.e((String)TAG, (String)"Discover services failed");
            return 257;
        }
        Log.i((String)TAG, (String)("Wait onServicesDiscovered " + millis + " ms"));
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mService == null) {
                this.mStateLock.wait(millis);
            }
        }
        Log.i((String)TAG, (String)"Wakeup");
        if (!this.isConnected()) {
            Log.e((String)TAG, (String)"Gatt Connection Disconnected");
            return 100001;
        }
        if (this.mService != null) {
            return 0;
        }
        Log.e((String)TAG, (String)"mService is null");
        Log.e((String)TAG, (String)String.format("Gatt Service %s Not Found", serviceUuid.toString()));
        return this.mAsyncStatus == -1 ? 100000 : 100002;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCharacteristicNotification(UUID notifyUuid, boolean enable, int millis) throws InterruptedException, IllegalArgumentException {
        if (millis < 0) {
            throw new IllegalArgumentException("millis < 0");
        }
        if (this.mService == null) {
            return 100002;
        }
        BluetoothGattCharacteristic characteristic = this.mService.getCharacteristic(notifyUuid);
        if (characteristic == null) {
            Log.e((String)TAG, (String)String.format("Gatt Characteristic %s Not Found", notifyUuid.toString()));
            return 100003;
        }
        if (!this.mGatt.setCharacteristicNotification(characteristic, true)) {
            Log.e((String)TAG, (String)String.format("setCharacteristicNotification failed", new Object[0]));
            return 257;
        }
        UUID descriptorUUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(descriptorUUID);
        if (descriptor == null) {
            Log.e((String)TAG, (String)String.format("Gatt Descriptor %s Not Found", descriptorUUID.toString()));
            return 100003;
        }
        if (enable) {
            if ((characteristic.getProperties() & 0x10) == 16) {
                descriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            }
            if ((characteristic.getProperties() & 0x20) == 32) {
                descriptor.setValue(BluetoothGattDescriptor.ENABLE_INDICATION_VALUE);
            }
        } else if ((characteristic.getProperties() & 0x10) == 16) {
            descriptor.setValue(BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE);
        }
        this.mAsyncStatus = -1;
        this.mNotifyEnabled = false;
        if (!this.mGatt.writeDescriptor(descriptor)) {
            Log.e((String)TAG, (String)String.format("writeDescriptor failed", new Object[0]));
            return 257;
        }
        Log.i((String)TAG, (String)("Wait onDescriptorWrite " + millis + " ms"));
        Object object = this.mStateLock;
        synchronized (object) {
            if (!this.mNotifyEnabled) {
                this.mStateLock.wait(millis);
            }
        }
        Log.i((String)TAG, (String)"Wakeup");
        if (!this.isConnected()) {
            Log.e((String)TAG, (String)"Gatt Connection Disconnected");
            return 100001;
        }
        if (this.mNotifyEnabled) {
            return 0;
        }
        return this.mAsyncStatus == -1 ? 100000 : this.mAsyncStatus;
    }

    public int setCharacteristicWrite(UUID writeUuid) {
        if (this.mService == null) {
            Log.e((String)TAG, (String)String.format("Gatt Service %s Not Found", this.mServiceUuid.toString()));
            return 100002;
        }
        this.mCharacteristic = this.mService.getCharacteristic(writeUuid);
        if (this.mCharacteristic == null) {
            Log.e((String)TAG, (String)String.format("Gatt Characteristic %s Not Found", this.mCharacteristic.getUuid().toString()));
            return 100003;
        }
        return 0;
    }

    public int write(byte[] buffer, int millis) throws InterruptedException, IllegalArgumentException {
        return this.write(buffer, 0, buffer.length, millis);
    }

    @SuppressLint(value={"NewApi"})
    public int write(byte[] buffer, int offset, int length, int millis) throws InterruptedException, IllegalArgumentException {
        if (millis < 0) {
            throw new IllegalArgumentException("millis<0");
        }
        if (offset < 0 || length <= 0) {
            throw new IllegalArgumentException("offset<0 or length<=0");
        }
        List<byte[]> list = BluetoothDatagramFactory.createDatagram(2, Arrays.copyOfRange(buffer, offset, length)).split(BluetoothDatagram.MAX_CHARACTERISTIC_SIZE);
        int retCode = 0;
        if (this.mLogOn) {
            Log.i((String)TAG, (String)("Request =[" + HexString.toHexString(buffer, offset, length) + "]"));
        }
        int i = 0;
        while (i < list.size()) {
            this.mCharacteristic.setValue(list.get(i));
            retCode = this.writeCharacteristic(this.mCharacteristic, millis);
            if (retCode != 0) {
                return retCode;
            }
            ++i;
        }
        return retCode;
    }

    public int requestMtu(int mtu) {
        throw new UnsupportedOperationException("BluetoothGattConnection.requestMtu Unsupported");
    }

    public synchronized boolean isConnected() {
        return this.mConnState == 2;
    }

    public void logOn(boolean on) {
        this.mLogOn = on;
    }

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    @SuppressLint(value={"NewApi"})
    public BluetoothDevice getRemoteDevice() {
        if (this.mGatt != null) {
            return this.mGatt.getDevice();
        }
        return null;
    }

    public BluetoothGatt getGatt() {
        return this.mGatt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeCharacteristic(BluetoothGattCharacteristic characteristic, int millis) throws InterruptedException {
        this.mAsyncStatus = -1;
        this.mWritten = false;
        if (this.mLogOn) {
            Log.i((String)TAG, (String)("writeCharacteristic: " + HexString.hexify(characteristic.getValue())));
        }
        if (!this.mGatt.writeCharacteristic(characteristic)) {
            Log.e((String)TAG, (String)"writeCharacteristic return false");
            return 257;
        }
        Log.i((String)TAG, (String)("Wait onCharacteristicWrite " + millis + " ms"));
        Object object = this.mStateLock;
        synchronized (object) {
            if (!this.mWritten) {
                this.mStateLock.wait(millis);
            }
        }
        Log.i((String)TAG, (String)"Wakeup");
        if (!this.isConnected()) {
            Log.e((String)TAG, (String)"Gatt Connection Disconnected");
            return 100001;
        }
        if (this.mWritten) {
            return 0;
        }
        return this.mAsyncStatus == -1 ? 100000 : this.mAsyncStatus;
    }

    @SuppressLint(value={"NewApi"})
    public void onCharacteristicChanged(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic) {
        if (this.mLogOn) {
            Log.i((String)TAG, (String)("onCharacteristicChanged: " + HexString.hexify(characteristic.getValue())));
        }
        this.mDatagram.parse(characteristic.getValue());
        if (this.mDatagram.isEof() && this.mListener != null) {
            Log.i((String)TAG, (String)"Call Listener.onReceiveData");
            if (this.mLogOn) {
                Log.i((String)TAG, (String)("Response=[" + HexString.toHexString(this.mDatagram.getData()) + "]"));
            }
            this.mListener.onReceiveData(this.mDatagram.getData());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCharacteristicWrite(BluetoothGatt gatt, BluetoothGattCharacteristic characteristic, int status) {
        Log.i((String)TAG, (String)("onCharacteristicWrite called, status=" + status));
        Object object = this.mStateLock;
        synchronized (object) {
            this.mAsyncStatus = status;
            if (status == 0) {
                if (characteristic.getUuid().compareTo(this.mCharacteristic.getUuid()) == 0) {
                    this.mWritten = true;
                }
                Log.i((String)TAG, (String)("Characteristic " + characteristic.getUuid().toString() + " write success"));
            } else {
                Log.e((String)TAG, (String)("Characteristic " + this.mCharacteristic.getUuid().toString() + " write failure, status: " + status));
            }
            this.mStateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnectionStateChange(BluetoothGatt gatt, int status, int newState) {
        Log.i((String)TAG, (String)String.format("SyncBluetoothGatt.onConnectionStateChange called, status=%d, newState=%d", status, newState));
        Object object = this.mStateLock;
        synchronized (object) {
            this.mAsyncStatus = status;
            if (status == 0) {
                this.mConnState = newState;
                switch (newState) {
                    case 2: {
                        Log.i((String)TAG, (String)String.format("SyncBluetoothGatt.onConnectionStateChange newState: STATE_CONNECTED", new Object[0]));
                        break;
                    }
                    case 1: {
                        Log.i((String)TAG, (String)String.format("SyncBluetoothGatt.onConnectionStateChange newState: STATE_CONNECTING", new Object[0]));
                        break;
                    }
                    case 0: {
                        Log.i((String)TAG, (String)String.format("SyncBluetoothGatt.onConnectionStateChange newState: STATE_DISCONNECTED", new Object[0]));
                        break;
                    }
                    case 3: {
                        Log.i((String)TAG, (String)String.format("SyncBluetoothGatt.onConnectionStateChange newState: STATE_DISCONNECTING", new Object[0]));
                    }
                }
            }
            this.mStateLock.notifyAll();
        }
        if (this.mListener != null) {
            this.mListener.onConnectionStateChange(status, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDescriptorWrite(BluetoothGatt gatt, BluetoothGattDescriptor descriptor, int status) {
        Log.i((String)TAG, (String)String.format("onDescriptorWrite called, status=%d", status));
        Object object = this.mStateLock;
        synchronized (object) {
            this.mAsyncStatus = status;
            if (status == 0) {
                Log.i((String)TAG, (String)("descriptor " + descriptor.getUuid().toString() + " write success"));
                this.mNotifyEnabled = true;
            } else {
                Log.e((String)TAG, (String)("descriptor " + descriptor.getUuid().toString() + " write failure, status: " + status));
            }
            this.mStateLock.notifyAll();
        }
    }

    public void onMtuChanged(BluetoothGatt gatt, int mtu, int status) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServicesDiscovered(BluetoothGatt gatt, int status) {
        Log.i((String)TAG, (String)String.format("onServicesDiscovered called, status=%d", status));
        Object object = this.mStateLock;
        synchronized (object) {
            this.mAsyncStatus = status;
            if (status == 0) {
                if (this.mServiceUuid != null) {
                    this.mService = gatt.getService(this.mServiceUuid);
                }
                Log.i((String)TAG, (String)("Services " + this.mServiceUuid.toString() + " Discovered success"));
            } else {
                Log.e((String)TAG, (String)("Services " + this.mServiceUuid.toString() + " Discovered failure, status: " + status));
            }
            this.mStateLock.notifyAll();
        }
    }

    public static class Errors {
        public static final int GATT_SUCCESS = 0;
        public static final int GATT_FAILURE = 257;
        public static final int GATT_TIMEOUT = 100000;
        public static final int GATT_CONNECTION_INTERRUPTED = 100001;
        public static final int GATT_SERVICE_NOT_FOUND = 100002;
        public static final int GATT_CHARACTERISTIC_NOT_FOUND = 100003;
        public static final int GATT_DESCRIPTOR_NOT_FOUND = 100003;
        static final int GATT_UNKOWN = -1;
    }

    public static interface Listener {
        public void onConnectionStateChange(int var1, int var2);

        public void onReceiveData(byte[] var1);
    }
}

