/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.otg;

import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.driver.conn.Connection;
import com.longmai.security.plugin.driver.otg.io.OTGInputStream;
import com.longmai.security.plugin.driver.otg.io.OTGOutputStream;
import com.longmai.security.plugin.driver.otg.io.stack.MessagePool;
import com.longmai.security.plugin.driver.otg.io.stack.MessagePoolImpl;
import com.longmai.security.plugin.util.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeoutException;

public class ConnectionImpl
implements Connection {
    private static final String TAG = ConnectionImpl.class.getName();
    private UsbDeviceConnection connection;
    private MessagePool messagePool;

    public ConnectionImpl(UsbManager usbManager, UsbDevice usbDevice) throws PluginException {
        if (!usbManager.hasPermission(usbDevice)) {
            throw new PluginException(17);
        }
        this.connection = usbManager.openDevice(usbDevice);
        this.messagePool = new MessagePoolImpl(this.connection, usbDevice);
        this.messagePool.init();
    }

    public InputStream getInputStream() throws PluginException {
        LogUtil.d((String)TAG, (String)"getInputStream()");
        return new OTGInputStream(this.messagePool);
    }

    public OutputStream getOutputStream() throws PluginException {
        LogUtil.d((String)TAG, (String)"getOutputStream()");
        return new OTGOutputStream(this.messagePool);
    }

    public boolean isValid() {
        LogUtil.d((String)TAG, (String)"isValid()");
        return true;
    }

    public void close() throws PluginException {
        LogUtil.d((String)TAG, (String)"close()");
        if (this.messagePool != null) {
            this.messagePool.destroy();
            this.messagePool = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public int deviceio(byte[] input, int input_len, byte[] output, int[] output_len) throws PluginException {
        LogUtil.d((String)TAG, (String)"deviceio()");
        this.messagePool.setTimeOut(500);
        int i = 0;
        while (i < 3) {
            block10: {
                block9: {
                    byte[] apdu;
                    block8: {
                        try {
                            this.messagePool.write(input, 0, input_len);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            throw new PluginException(14);
                        }
                        apdu = this.messagePool.read();
                        if (apdu != null) break block8;
                        return 1;
                    }
                    try {
                        if (output.length < apdu.length) {
                            throw new PluginException(2);
                        }
                        System.arraycopy(apdu, 0, output, 0, apdu.length);
                        output_len[0] = apdu.length;
                        break block9;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        throw new PluginException(15);
                    }
                    catch (TimeoutException e) {
                        e.printStackTrace();
                    }
                    break block10;
                }
                return 0;
            }
            ++i;
        }
        throw new PluginException(15);
    }

    public void setValue(int type, Object value) throws PluginException {
        LogUtil.d((String)TAG, (String)"setValue()");
    }

    public Object getValue(int type) throws PluginException {
        LogUtil.d((String)TAG, (String)"getValue()");
        return null;
    }
}

