/*
 * Decompiled with CFR 0.152.
 */
package com.longmai.security.plugin.driver.tf;

import com.longmai.security.plugin.base.PluginException;
import com.longmai.security.plugin.device.Device;
import com.longmai.security.plugin.driver.conn.Connection;
import com.longmai.security.plugin.driver.tf.base.TF;
import com.longmai.security.plugin.driver.tf.io.TFInputStream;
import com.longmai.security.plugin.driver.tf.io.TFOutputStream;
import com.longmai.security.plugin.util.LogUtil;
import java.io.InputStream;
import java.io.OutputStream;

public class ConnectionImpl
implements Connection {
    private static final String TAG = ConnectionImpl.class.getName();
    private volatile int connStat = 0;
    private Device device;
    private TF tf;
    private HeartBeatThread HeartBeat;

    public ConnectionImpl(Device device, TF tf) throws PluginException {
        LogUtil.d((String)TAG, (String)"ConnectionImpl Create");
        this.device = device;
        this.tf = tf;
        int rtn = tf.connect(device.getId());
        if (rtn != 0) {
            this.connStat = 0;
            throw new PluginException(13);
        }
        if (this.HeartBeat != null) {
            this.HeartBeat.cancel();
            this.HeartBeat = null;
        }
        this.HeartBeat = new HeartBeatThread();
        this.HeartBeat.start();
        this.connStat = 2;
    }

    public InputStream getInputStream() throws PluginException {
        LogUtil.d((String)TAG, (String)"getInputStream()");
        return new TFInputStream(this.device, this.tf);
    }

    public OutputStream getOutputStream() throws PluginException {
        LogUtil.d((String)TAG, (String)"getOutputStream()");
        return new TFOutputStream(this.device, this.tf);
    }

    public boolean isValid() {
        LogUtil.d((String)TAG, (String)"isValid()");
        return this.connStat != 0;
    }

    public void close() throws PluginException {
        LogUtil.d((String)TAG, (String)"close()");
        if (this.HeartBeat != null) {
            this.HeartBeat.cancel();
            this.HeartBeat = null;
        }
        if (this.connStat == 2) {
            this.connStat = 0;
            this.tf.disconnect(this.device.getId());
        }
    }

    public int deviceio(byte[] cmd, int cmd_len, byte[] response, int[] res_len) throws PluginException {
        LogUtil.d((String)TAG, (String)"deviceio()");
        return this.tf.deviceio(this.device.getId(), cmd, cmd_len, response, res_len);
    }

    public void setValue(int type, Object value) throws PluginException {
    }

    public Object getValue(int type) throws PluginException {
        return null;
    }

    class HeartBeatThread
    extends Thread {
        boolean flag = true;

        HeartBeatThread() {
        }

        @Override
        public void run() {
            while (this.flag) {
                try {
                    HeartBeatThread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    LogUtil.d((String)TAG, (String)"\u7ebf\u7a0b\u5524\u9192\uff0c\u8df3\u51fa\u5faa\u73af");
                    break;
                }
                byte[] response = new byte[1024];
                int[] res_len = new int[1];
                try {
                    int rtn = ConnectionImpl.this.deviceio(new byte[1], 1, response, res_len);
                    if (rtn == 0) continue;
                    ConnectionImpl.this.connStat = 0;
                }
                catch (PluginException e) {
                    e.printStackTrace();
                }
                break;
            }
            LogUtil.d((String)TAG, (String)"Heart Beat end");
        }

        public void cancel() {
            LogUtil.d((String)TAG, (String)"Heart Beat cancel");
            this.flag = false;
            if (!this.isInterrupted()) {
                LogUtil.d((String)TAG, (String)"\u4e2d\u65ad\u7ebf\u7a0b");
                this.interrupt();
            }
        }
    }
}

