/*
 * Decompiled with CFR 0.152.
 */
package com.mpt.aidlservice;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.gson.Gson;
import com.mpt.aidlservice.Base64;
import com.mpt.aidlservice.IApnAndSafeKey;
import com.safetf.SafeTF;
import com.xdja.bean.VendorInfoJson;
import com.xdja.key.KeyWrapper;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.utils.Log;
import com.xdja.sslvpn.SslvpnStatus;
import org.json.JSONException;
import org.json.JSONObject;

public class AidlService
extends Service {
    private IApnAndSafeKeyBinder iBinder;
    private boolean blockMainThread = false;
    MyApplication myApplication = null;
    private static final String TAG = "AidlService";

    public void onCreate() {
        super.onCreate();
        Log.d(TAG, "onCreate");
        this.myApplication = (MyApplication)this.getApplication();
        this.iBinder = new IApnAndSafeKeyBinder();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        Log.d(TAG, "onBind");
        return this.iBinder;
    }

    public class IApnAndSafeKeyBinder
    extends IApnAndSafeKey.Stub {
        @Override
        public boolean XKF_GetVPNTunnelState() throws RemoteException {
            if (0 == AidlService.this.myApplication.sslClientConfig.transportMode) {
                return VpnService.safeVerifySuccess;
            }
            return TunVpnService.safeVerifySuccess;
        }

        @Override
        public String XKF_GetMonitorServerAddress() throws RemoteException {
            return this.getMonitorServerAddress();
        }

        @Override
        public String XKF_GetVendorInfo() throws RemoteException {
            return this.getVendorInfo();
        }

        @Override
        public String XKF_GetCardID() throws RemoteException {
            return this.getCardId();
        }

        @Override
        public String XKF_ReadCert() throws RemoteException {
            return this.readCert();
        }

        @Override
        public byte[] XKF_SM1KEY(byte[] sourceData, byte[] testKey, int encryptFlag, byte[] iv) throws RemoteException {
            return this.sm1Key(sourceData, testKey, encryptFlag, iv);
        }

        @Override
        public boolean XKF_CheckWeakPassWD() throws RemoteException {
            return this.checkWeakPassWD();
        }

        @Override
        public boolean XKF_PassWordEnter(String testPin) throws RemoteException {
            return this.passWordEnter(testPin);
        }

        private String getCardId() {
            String cardId = "";
            byte[] cardIdArray = new byte[64];
            int[] cardIdLen = new int[1];
            int ret = KeyWrapper.getInstance().getSN(cardIdArray, cardIdLen);
            if (ret == 0) {
                cardId = new String(cardIdArray, 0, cardIdLen[0]);
                Log.d(AidlService.TAG, "Cover card id " + cardId);
            }
            return cardId;
        }

        private String getMonitorServerAddress() {
            int res = -1;
            String serverAddr = null;
            JSONObject json = new JSONObject();
            try {
                json.put("jsonrpc", (Object)"2.0");
                json.put("id", (Object)"1");
                JSONObject result = new JSONObject();
                JSONObject serveraddress = new JSONObject();
                if (!VpnService.safeVerifySuccess && !TunVpnService.safeVerifySuccess) {
                    result.put("res", (Object)"FAILED");
                    Log.d(AidlService.TAG, "safeVerifySuccess false");
                } else {
                    result.put("res", (Object)"OK");
                    Log.d(AidlService.TAG, "safeVerifySuccess true");
                    if (0 == AidlService.this.myApplication.sslClientConfig.transportMode) {
                        SslvpnStatus sslvpnStatus = new SslvpnStatus();
                        if (AidlService.this.myApplication.sslvpn != null) {
                            res = AidlService.this.myApplication.sslvpn.getStatus(sslvpnStatus);
                            serveraddress.put("monitorserverip", (Object)"127.0.0.1");
                            if (res == 0 && sslvpnStatus != null) {
                                serveraddress.put("monitorserverporxyport", (Object)sslvpnStatus.monitorserverporxyport);
                                serveraddress.put("monitorserverporxyport1", (Object)sslvpnStatus.monitorserverporxyport1);
                            }
                            serveraddress.put("tunelmode", (Object)"101");
                        } else {
                            result.put("res", (Object)"FAILED");
                        }
                    } else {
                        final SslvpnStatus sslvpnStatus = new SslvpnStatus();
                        AidlService.this.blockMainThread = true;
                        int count = 0;
                        new Thread(){

                            @Override
                            public void run() {
                                IApnAndSafeKeyBinder.this.getCurSslvpnStatus(sslvpnStatus);
                                AidlService.this.blockMainThread = false;
                            }
                        }.start();
                        while (AidlService.this.blockMainThread && count <= 30) {
                            ++count;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        if (sslvpnStatus != null) {
                            serveraddress.put("monitorserverip", (Object)sslvpnStatus.monitorSrvIp);
                            serveraddress.put("realPort", (Object)sslvpnStatus.monitorserverporxyport);
                            serveraddress.put("realPort1", (Object)sslvpnStatus.monitorserverporxyport1);
                        }
                        serveraddress.put("tunelmode", (Object)"100");
                    }
                }
                result.put("serveraddress", (Object)serveraddress);
                json.put("result", (Object)result);
                serverAddr = json.toString();
                Log.d(AidlService.TAG, "getMonitorServerAddress : " + serverAddr);
                return serverAddr;
            }
            catch (JSONException e) {
                return "";
            }
        }

        private void getCurSslvpnStatus(SslvpnStatus sslvpnStatus) {
            String temp = null;
            int vpnstatelen = 0;
            byte[] vpnstate = new byte[4096];
            if (TunVpnService.sock == null) {
                sslvpnStatus.monitorSrvIp = "";
                return;
            }
            TunVpnService.sock.sendData("GETCURSTATUS");
            vpnstatelen = TunVpnService.sock.recvData(vpnstate);
            Log.d(AidlService.TAG, "vpnstatelen = " + vpnstatelen);
            if (vpnstatelen <= 0) {
                Log.d(AidlService.TAG, "vpnstatelen = " + vpnstatelen);
                sslvpnStatus.monitorSrvIp = "";
                return;
            }
            temp = new String(vpnstate, 0, vpnstatelen);
            Log.d(AidlService.TAG, "temp = " + temp);
            String[] arrayStr = temp.split("#");
            if (arrayStr.length < 6) {
                Log.d(AidlService.TAG, "arrayStr.length = " + arrayStr.length);
                return;
            }
            sslvpnStatus.monitorserverporxyport = arrayStr[3];
            sslvpnStatus.monitorserverporxyport1 = arrayStr[4];
            sslvpnStatus.monitorSrvIp = arrayStr[5];
        }

        private String getVendorInfo() {
            String version = null;
            String vendorInfo = null;
            Gson gson = new Gson();
            VendorInfoJson vendorinfojosn = new VendorInfoJson();
            SafeTF tf = new SafeTF();
            int hHandle = 0;
            hHandle = tf.OpenSTFCardAuto();
            Log.d(AidlService.TAG, "OpenSTFCardAuto, hHandle = " + hHandle);
            if (hHandle == 0 && AidlService.this.myApplication.sslClientConfig.getSdkVersion() >= 19) {
                String tmp = new String(AidlService.this.myApplication.sslClientConfig.getDevPath());
                hHandle = tf.OpenSTFCard(tmp);
                Log.d(AidlService.TAG, "OpenSTFCard ,hHandle = " + hHandle);
                if (hHandle == 0) {
                    Log.d(AidlService.TAG, "OpenSTFCard failed");
                    return null;
                }
            }
            version = tf.GetVersion();
            tf.CloseSTFCard(hHandle);
            vendorinfojosn.getResult().getVendorinfo().setVendor("xdja");
            vendorinfojosn.getResult().getVendorinfo().setVersion(version);
            vendorinfojosn.getResult().getVendorinfo().setExtendinfo("");
            vendorinfojosn.setId(2);
            if (version == null || version.equals("")) {
                vendorinfojosn.getResult().setRes("FAILED");
            } else {
                vendorinfojosn.getResult().setRes("OK");
            }
            vendorInfo = gson.toJson((Object)vendorinfojosn);
            Log.d(AidlService.TAG, "getVendorInfo : " + vendorInfo);
            return vendorInfo;
        }

        private String readCert() {
            byte[] bCertBuf = new byte[2048];
            int[] bCertLen = new int[1];
            String certBase64 = null;
            int iCertLen = 0;
            int res = 0;
            byte[] defaultCertId = new byte[2];
            SafeTF tf = new SafeTF();
            int hHandle = 0;
            hHandle = tf.OpenSTFCardAuto();
            Log.d(AidlService.TAG, "OpenSTFCardAuto, hHandle = " + hHandle);
            if (hHandle == 0 && AidlService.this.myApplication.sslClientConfig.getSdkVersion() >= 19) {
                String tmp = new String(AidlService.this.myApplication.sslClientConfig.getDevPath());
                hHandle = tf.OpenSTFCard(tmp);
                Log.d(AidlService.TAG, "OpenSTFCard ,hHandle = " + hHandle);
                if (hHandle == 0) {
                    Log.d(AidlService.TAG, "OpenSTFCard failed");
                    return null;
                }
            }
            if (AidlService.this.myApplication.sslClientConfig != null) {
                defaultCertId = AidlService.this.myApplication.sslClientConfig.getCertId();
                Log.d(AidlService.TAG, "CertId :" + defaultCertId[0] + defaultCertId[1]);
            }
            res = tf.GetCert(hHandle, bCertBuf, bCertLen, defaultCertId);
            iCertLen = bCertLen[0];
            Log.d(AidlService.TAG, "CertLen : " + iCertLen);
            if (res == 0) {
                try {
                    certBase64 = Base64.encodeBytes(bCertBuf, 0, iCertLen);
                    Log.d(AidlService.TAG, "certBase64 : " + certBase64);
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
                catch (IndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
            } else if (res == 2) {
                certBase64 = null;
                Log.d(AidlService.TAG, "parm is error");
            } else {
                certBase64 = null;
                Log.d(AidlService.TAG, "GetCardID " + tf.getErrorMsg((Context)AidlService.this, hHandle));
            }
            tf.CloseSTFCard(hHandle);
            return certBase64;
        }

        private byte[] sm1Key(byte[] sourceData, byte[] testKey, int encryptFlag, byte[] iv) {
            int res = -1;
            byte[] pDataOut = new byte[sourceData.length];
            SafeTF tf = new SafeTF();
            int hHandle = 0;
            hHandle = tf.OpenSTFCardAuto();
            Log.d(AidlService.TAG, "OpenSTFCardAuto, hHandle = " + hHandle);
            if (hHandle == 0 && AidlService.this.myApplication.sslClientConfig.getSdkVersion() >= 19) {
                String tmp = new String(AidlService.this.myApplication.sslClientConfig.getDevPath());
                hHandle = tf.OpenSTFCard(tmp);
                Log.d(AidlService.TAG, "OpenSTFCard ,hHandle = " + hHandle);
                if (hHandle == 0) {
                    Log.d(AidlService.TAG, "OpenSTFCard failed");
                    return null;
                }
            }
            if ((res = tf.SM1KEY(hHandle, testKey, sourceData, encryptFlag, pDataOut, iv)) == 0) {
                Log.d(AidlService.TAG, "SM1KEY success");
            } else if (res == 2) {
                pDataOut = null;
                Log.d(AidlService.TAG, "parm is error");
            } else {
                pDataOut = null;
                Log.d(AidlService.TAG, "sm1Key " + tf.getErrorMsg((Context)AidlService.this, hHandle));
            }
            tf.CloseSTFCard(hHandle);
            return pDataOut;
        }

        private boolean checkWeakPassWD() {
            return AidlService.this.myApplication.isWeakPassWD;
        }

        private boolean passWordEnter(String testPin) {
            int nres = -1;
            int hMutex = -1;
            int role = 0;
            boolean result = false;
            SafeTF tf = new SafeTF();
            int hHandle = 0;
            hHandle = tf.OpenSTFCardAuto();
            Log.d(AidlService.TAG, "OpenSTFCardAuto, hHandle = " + hHandle);
            if (hHandle == 0 && AidlService.this.myApplication.sslClientConfig.getSdkVersion() >= 19) {
                String tmp = new String(AidlService.this.myApplication.sslClientConfig.getDevPath());
                hHandle = tf.OpenSTFCard(tmp);
                Log.d(AidlService.TAG, "OpenSTFCard ,hHandle = " + hHandle);
                if (hHandle == 0) {
                    Log.d(AidlService.TAG, "OpenSTFCard failed");
                    return false;
                }
            }
            if ((role = AidlService.this.myApplication.sslClientConfig.getRole()) != 1 && role != 17) {
                byte[] defaultCertId = AidlService.this.myApplication.sslClientConfig.getCertId();
                role = Function.generateRole(defaultCertId);
            }
            if ((nres = tf.SafePin(hHandle, testPin.getBytes(), role)) != 0) {
                Log.d(AidlService.TAG, "???????????" + tf.getErrorMsg((Context)AidlService.this, nres));
                result = false;
            } else {
                Log.d(AidlService.TAG, "??????????");
                result = true;
            }
            tf.CloseSTFCard(hHandle);
            return result;
        }
    }
}

