/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key.koal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.mpt.aidlservice.Base64;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.utils.Log;
import java.util.List;
import java.util.Locale;
import koal.cert.tools.ByteBuf;
import koal.cert.tools.ICertManager;
import koal.cert.tools.ResultBean;

public class KoalKey {
    private static KoalKey instance = null;
    private Context context = null;
    private ICertManager certManager;
    private static final String THIS_FILE = "KoalKey";
    private ServiceConnection conn = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.d(KoalKey.THIS_FILE, "Koal service connected");
            KoalKey.this.certManager = ICertManager.Stub.asInterface(service);
        }

        public void onServiceDisconnected(ComponentName name) {
            KoalKey.this.certManager = null;
        }
    };

    private KoalKey() {
    }

    public static KoalKey getInstance() {
        if (instance == null) {
            instance = new KoalKey();
        }
        return instance;
    }

    private void bindService() {
        Function.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction("koal.cert.tools.CertManagerService");
                intent.setComponent(new ComponentName("kl.cds", "kl.cds.service.CertManagerService"));
                Log.d(KoalKey.THIS_FILE, "start to call bind service");
                KoalKey.this.context.bindService(intent, KoalKey.this.conn, 1);
            }
        });
    }

    public boolean checkService() {
        this.context = MyApplication.myApplication;
        this.bindService();
        return true;
    }

    public List<String> getCertList() {
        if (this.certManager == null) {
            return null;
        }
        try {
            return this.certManager.SOF_GetUserList();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int open() {
        return 0;
    }

    public int close() {
        this.context.unbindService(this.conn);
        return 0;
    }

    private void logError(ResultBean resultBean) {
        if (0 != resultBean.getErrorCode()) {
            Log.d(THIS_FILE, String.format(Locale.CHINA, "failed!errorCode:%d message:%s detail:%s", resultBean.getErrorCode(), resultBean.getMessage(), resultBean.getDetail()));
        }
    }

    public int verifyPIN(String certPath, String pwd) {
        if (this.certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }
        try {
            ResultBean resultBean = this.certManager.SOF_Login(certPath, pwd);
            this.logError(resultBean);
            return resultBean.getErrorCode();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -2;
        }
    }

    public int readCert(String certPath, int isSign, byte[] certBuf, int[] certLen) {
        if (this.certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }
        try {
            String b64cert = isSign == 1 ? this.certManager.SOF_ExportUserCert(certPath) : this.certManager.SOF_ExportExChangeUserCert(certPath);
            byte[] cert = Base64.decode(b64cert);
            certLen[0] = cert.length;
            System.arraycopy(cert, 0, certBuf, 0, cert.length);
            return 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -2;
        }
    }

    public int RSAPrikeyCalc(byte[] input, int inputLen, byte[] output, int[] outputLen) {
        if (this.certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }
        ResultBean resultBean = null;
        try {
            byte[] inputBuf = new byte[inputLen];
            System.arraycopy(input, 0, inputBuf, 0, inputLen);
            ByteBuf localSignDataByte = new ByteBuf();
            String str = Base64.encodeBytes(inputBuf);
            resultBean = this.certManager.SKF_NakedSignData(inputBuf, localSignDataByte);
            if (0 != resultBean.getErrorCode()) {
                this.logError(resultBean);
                return resultBean.getErrorCode();
            }
            byte[] result = localSignDataByte.getByte();
            outputLen[0] = result.length;
            System.arraycopy(result, 0, output, 0, result.length);
            return 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -2;
        }
    }

    public int SM2Sign(byte[] input, int inputLen, byte[] output, int[] outputLen) {
        if (this.certManager == null) {
            Log.e(THIS_FILE, "Cert manager null!");
            return -1;
        }
        ResultBean resultBean = null;
        try {
            byte[] inputBuf = new byte[inputLen];
            System.arraycopy(input, 0, inputBuf, 0, inputLen);
            ByteBuf localSignDataByte = new ByteBuf();
            resultBean = this.certManager.SKF_NakedSignData(inputBuf, localSignDataByte);
            if (0 != resultBean.getErrorCode()) {
                this.logError(resultBean);
                return resultBean.getErrorCode();
            }
            byte[] result = localSignDataByte.getByte();
            outputLen[0] = result.length;
            System.arraycopy(result, 0, output, 0, result.length);
            return 0;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }
}

