/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.key.longmai;

import android.content.Context;
import com.longmai.security.plugin.SOF_DeviceLib;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.LogUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LMWrapper {
    private Context context = null;
    private static final String THIS_FILE = "LMWrapper";
    private static LMWrapper instance = null;

    private LMWrapper() {
    }

    public static LMWrapper getInstance() {
        if (instance == null) {
            instance = new LMWrapper();
        }
        return instance;
    }

    public int loadDriver() {
        this.context = MyApplication.myApplication;
        ArrayList<String> longmai_init_param = new ArrayList<String>();
        try {
            DocumentBuilder domBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xml = domBuilder.parse(this.context.getAssets().open("longmai_config.xml"));
            Element root = xml.getDocumentElement();
            NodeList _drivers = root.getElementsByTagName("driver");
            for (int i = 0; i < _drivers.getLength(); ++i) {
                Element driver = (Element)_drivers.item(i);
                if (!driver.getAttribute("name").equals("mToken TF/SD Card")) continue;
                LogUtil.d(THIS_FILE, "id:" + driver.getAttribute("id"));
                LogUtil.d(THIS_FILE, "name:" + driver.getAttribute("name"));
                LogUtil.d(THIS_FILE, "class:" + driver.getAttribute("class"));
                LogUtil.d(THIS_FILE, "describe:" + driver.getAttribute("describe"));
                longmai_init_param.add(driver.getAttribute("id"));
                longmai_init_param.add(driver.getAttribute("name"));
                longmai_init_param.add(driver.getAttribute("class"));
                longmai_init_param.add(driver.getAttribute("describe"));
                break;
            }
        }
        catch (Exception e) {
            Log.e(THIS_FILE, "Get sdcard driver failed");
            e.printStackTrace();
            return -1;
        }
        int ret = SOF_DeviceLib.SOF_LoadLibrary((Context)this.context, (String)((String)longmai_init_param.get(0)), (String)((String)longmai_init_param.get(1)), (String)((String)longmai_init_param.get(2)), (String)((String)longmai_init_param.get(3)), (String[])new String[0]);
        if (ret != 0) {
            Log.e(THIS_FILE, "Load driver failed. Return " + SOF_DeviceLib.SOF_GetLastError());
            return ret;
        }
        return 0;
    }

    public List<String> enumDevices() {
        ArrayList<String> devices = new ArrayList<String>();
        this.loadDriver();
        int ret = SOF_DeviceLib.SOF_EnumDevices((Context)this.context, devices);
        if (ret != 0) {
            Log.e(THIS_FILE, "SOF Enum devices failed. Return " + SOF_DeviceLib.SOF_GetLastError());
            return null;
        }
        return devices;
    }

    public List<String> enumApplications() {
        ArrayList<String> appNames = new ArrayList<String>();
        int ret = SOF_DeviceLib.SOF_EnumApplication(appNames);
        if (ret != 0) {
            SOF_DeviceLib.SOF_Disconnect();
            Log.e(THIS_FILE, "SOF enum application failed. err " + SOF_DeviceLib.SOF_GetLastError());
            return null;
        }
        if (appNames.size() <= 0) {
            SOF_DeviceLib.SOF_Disconnect();
            Log.e(THIS_FILE, "No applicaiton found");
            return null;
        }
        Log.d(THIS_FILE, "Enum application " + appNames);
        return appNames;
    }

    public String getDeviceId(String deviceName) {
        int ret = SOF_DeviceLib.SOF_Connect((String)deviceName, (String)"");
        if (ret != 0) {
            Log.d(THIS_FILE, "SOF connect failed. Return " + SOF_DeviceLib.SOF_GetLastError());
            return "";
        }
        byte[] label = new byte[128];
        byte[] serialNumber = new byte[128];
        int[] version = new int[1];
        ret = SOF_DeviceLib.SOF_GetDeviceInfo((byte[])label, (byte[])serialNumber, (int[])version);
        if (ret != 0) {
            Log.e(THIS_FILE, "SOF get device info failed. err " + SOF_DeviceLib.SOF_GetLastError());
            return "";
        }
        return new String(serialNumber, 0, 16);
    }
}

