/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Looper;
import android.os.PowerManager;
import android.os.StatFs;
import android.support.annotation.NonNull;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.safetf.SafeTF;
import com.xdja.SafeKey.JNIAPI;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeySelector;
import com.xdja.key.KeyWrapper;
import com.xdja.key.covercard.CoverCardWrapper;
import com.xdja.key.longmai.LongmaiCfg;
import com.xdja.key.xdjakey.XdjaKeyCfg;
import com.xdja.key.zhongfu.ZhongfuCfg;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.config.PropertiesConfig;
import com.xdja.safeclient.event.TelnetResultCallback;
import com.xdja.safeclient.receiver.bootBroadcastReceiver;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.wrapper.QuitWrapper;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.net.telnet.TelnetClient;

public class Function {
    private static PowerManager pm = null;
    private static PowerManager.WakeLock mWakeLock = null;
    private static String TAG = "Function";

    public static void exitApp(Context context) {
        QuitWrapper.setHasBeenQuit(context);
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(1);
        MyApplication myApplication = MyApplication.myApplication;
        SafeVerifyActivity.startService = false;
        MyApplication.selfStartFlag = false;
        if (myApplication.sslClientConfig.transportMode == 0) {
            Function.setSafeVpnState(context.getApplicationContext(), false);
            VpnService.stopService = true;
            VpnService.sslStageList.clear();
            Intent intent = new Intent();
            intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
            context.stopService(intent);
        } else {
            Function.setSafeTunVpnState(context.getApplicationContext(), false);
            TunVpnService.stopService = true;
            TunVpnService.sslStageList.clear();
            try {
                boolean res = false;
                try {
                    if (TunVpnService.mInterface != null) {
                        Log.d("MainActivity", "TunVpnService.mInterface.close");
                        TunVpnService.mInterface.close();
                        TunVpnService.mInterface = null;
                        if (TunVpnService.tunVpnObj != null) {
                            TunVpnService.tunVpnObj.destroyBuilder();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (myApplication.sslvpn != null) {
                    myApplication.sslvpn.closeTunFd();
                }
                Intent intent = new Intent();
                intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");
                res = context.stopService(intent);
                if (!res) {
                    Log.e(TAG, "stopService TunVpnService failed");
                } else {
                    Log.d(TAG, "stopService TunVpnService success ");
                }
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        for (Activity activity : myApplication.activityList) {
            activity.finish();
        }
        myApplication.activityList.clear();
        if (myApplication.propertiesConfig.getmDisableFlag() == 1) {
            myApplication.disableFlag = 0;
        }
        if (myApplication.propertiesConfig.hasCoverKey() == 1) {
            CoverCardWrapper.getInstance().destroy();
        }
        MyApplication.myApplication.getHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                System.exit(0);
            }
        }, 500L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writePrivateFile(Context context, String filename, String text) {
        FileOutputStream os = null;
        OutputStreamWriter osw = null;
        try {
            os = context.openFileOutput(filename, 0);
            osw = new OutputStreamWriter(os);
            osw.write(text);
            osw.close();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            return;
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeFile(String filePath, String text) {
        File file = new File(filePath);
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter(new FileOutputStream(file));
            osw.write(text);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFile(String filePath, byte[] output, int[] len) {
        File file = new File(filePath);
        byte[] tmp = new byte[10];
        FileInputStream in = null;
        int byteread = 0;
        try {
            int size;
            in = new FileInputStream(file);
            while ((size = ((InputStream)in).read(tmp)) != -1) {
                System.arraycopy(tmp, 0, output, byteread, size);
                byteread += size;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        len[0] = byteread;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAssets(Context context, String destFilePath, String filename) {
        InputStream in = null;
        FileOutputStream out = null;
        byte[] data = new byte[2048];
        int byteCount = 0;
        try {
            in = context.getResources().getAssets().open(filename);
            out = context.openFileOutput(filename, 0);
            FileOutputStream fos = new FileOutputStream(new File(destFilePath));
            while ((byteCount = in.read(data)) != -1) {
                fos.write(data, 0, byteCount);
            }
            fos.flush();
            in.close();
            fos.close();
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveFile(Context context, String filename) {
        InputStream in = null;
        FileOutputStream out = null;
        byte[] data = new byte[2048];
        int datalen = 0;
        try {
            in = context.getResources().getAssets().open(filename);
            out = context.openFileOutput(filename, 0);
            while ((datalen = in.read(data)) != -1) {
                out.write(data, 0, datalen);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void Hex_Decode(byte[] str, byte[] digest, int digestlength) {
        int i = 0;
        int tmp = 0;
        for (i = 0; i < digestlength; ++i) {
            tmp = str[i * 2] >= 97 ? str[i * 2] - 87 : str[i * 2] - 48;
            tmp *= 16;
            tmp = str[i * 2 + 1] >= 97 ? (tmp += str[i * 2 + 1] - 87) : (tmp += str[i * 2 + 1] - 48);
            digest[i] = (byte)(tmp & 0xFF);
        }
    }

    public static String byte2hex(byte[] buffer, int start, int length) {
        String h = "";
        int end = start + length;
        for (int i = start; i < end; ++i) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = h + " " + temp;
        }
        return h;
    }

    public static String byte2hex(byte[] buffer, int length) {
        String h = "";
        for (int i = 0; i < length; ++i) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = h + " " + temp;
        }
        return h;
    }

    public static String byte2hex(byte[] buffer) {
        String h = "";
        for (int i = 0; i < buffer.length; ++i) {
            String temp = Integer.toHexString(buffer[i] & 0xFF);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            h = h + " " + temp;
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getRootAhth() {
        float ver = Float.parseFloat(Build.VERSION.RELEASE);
        if ((double)ver > 4.4) {
            return false;
        }
        Process process = null;
        FilterOutputStream os = null;
        try {
            process = Runtime.getRuntime().exec("su");
            if (process == null) {
                boolean bl = false;
                return bl;
            }
            os = new DataOutputStream(process.getOutputStream());
            ((DataOutputStream)os).writeBytes("exit\n");
            ((DataOutputStream)os).flush();
            int exitValue = process.waitFor();
            if (exitValue == 0) {
                Log.d("Function", "have root promission");
                boolean bl = true;
                return bl;
            }
            Log.d("Function", "not have root promission");
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                    os = null;
                }
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static double getSDTotalSize(Context context) {
        String mountPath = Function.getTFMountPath(context);
        if (mountPath == null || mountPath.equals("")) {
            return 128.0;
        }
        File path = new File(mountPath);
        Log.i("Function", "tf card path : " + path.getAbsolutePath());
        StatFs stat = new StatFs(path.getPath());
        long blockSize = stat.getBlockSize();
        Log.i("Function", "tf card blockSize : " + blockSize);
        long totalBlocks = stat.getBlockCount();
        Log.i("Function", "tf card totalBlocks : " + totalBlocks);
        Log.i("Function", "tf card totalSize : " + (double)(blockSize * totalBlocks) / 1.073741824E9 + " G");
        return (double)(blockSize * totalBlocks) / 1.073741824E9;
    }

    public static boolean isSDTotalSizeBigThan4G(double sdTotalSize) {
        Log.i("Function", "isSDTotalSizeBigThan4G, sdTotalSize : " + sdTotalSize + " G");
        return sdTotalSize > 4.0;
    }

    public static ArrayList<String> findSdcardPrivatePath(String packageName) {
        ArrayList<String> devList = new ArrayList<String>();
        try {
            BufferedReader br = new BufferedReader(new FileReader("/proc/mounts"));
            String line = "";
            String privatePath = "";
            while ((line = br.readLine()) != null) {
                File file;
                String[] columns = line.split(" ");
                if (columns == null || columns.length <= 3 || !(file = new File(privatePath = columns[1] + "/Android/data/" + packageName + "/files")).exists()) continue;
                devList.add(privatePath);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return devList;
    }

    public static String getTFMountPath(Context context) {
        JNIAPI safekey = new JNIAPI();
        int[] devNum = new int[1];
        long[] devHandle = new long[1];
        byte[] mountPath = new byte[256];
        int[] pathLen = new int[1];
        int ANDROID_4_4_2 = 19;
        int ret = -1;
        if (MyApplication.devOpenFlag == 0 || MyApplication.devOpenFlag == 1) {
            ret = safekey.EnumDev(0, devNum);
            if (ret != 0) {
                Log.e("Function", "EnumDev failed, ret = " + ret);
                return "";
            }
            Log.d("Function", "EnumDev sucess, devNum = " + devNum[0]);
            ret = safekey.OpenDev(0, devHandle);
            if (ret != 0) {
                return "";
            }
            if (ret == 0) {
                Log.d("Function", "openDevAuto,success");
                MyApplication.devOpenFlag = 1;
            }
        }
        if ((MyApplication.devOpenFlag == 0 || MyApplication.devOpenFlag == 2) && ret != 0 && Build.VERSION.SDK_INT >= ANDROID_4_4_2) {
            context.getExternalFilesDir(null);
            ArrayList<String> sdcardPrivatePathList = Function.findSdcardPrivatePath(context.getPackageName());
            int listCount = sdcardPrivatePathList.size();
            for (int i = 0; i < listCount; ++i) {
                String sdcardPrivatePath = sdcardPrivatePathList.get(i) + "/";
                ret = safekey.OpenDevByName(sdcardPrivatePath.getBytes(), devHandle);
                if (0 != ret) continue;
                MyApplication.devOpenFlag = 2;
                break;
            }
            Log.d("Function", "openDevByName, ret = " + ret);
        }
        if (ret != 0) {
            MyApplication.devOpenFlag = 0;
            return "";
        }
        safekey.GetTFMountPath(devHandle[0], mountPath, pathLen);
        String path = new String(mountPath, 0, pathLen[0]);
        Log.i("Function", "mountPath : " + path);
        return path;
    }

    public static void getWakeLock() {
        if (mWakeLock == null) {
            pm = (PowerManager)MyApplication.myApplication.getSystemService("power");
            mWakeLock = pm.newWakeLock(1, "XDJA");
        }
        Log.d("Function", "mWakeLock.acquire");
        mWakeLock.acquire();
        Function.invokeWakeupAlarm((Context)MyApplication.myApplication, 10L);
    }

    public static void releaseWakeLock() {
        Log.d("Function", "mWakeLock.release");
        if (mWakeLock != null) {
            mWakeLock.release();
            mWakeLock = null;
        }
        Function.cancleWakeupAlarm((Context)MyApplication.myApplication);
    }

    public static void invokeWakeupAlarm(Context context, long cycleSecond) {
        Log.d("Function", "invokeWakeupAlarm, time = " + (int)cycleSecond);
        Intent intent = new Intent(context, bootBroadcastReceiver.class);
        intent.setAction("com.xdja.safeclient.repeat_wakeup_device");
        PendingIntent sender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        AlarmManager am = (AlarmManager)context.getSystemService("alarm");
        am.setRepeating(0, System.currentTimeMillis(), cycleSecond * 1000L, sender);
    }

    public static void cancleWakeupAlarm(Context context) {
        Log.d("Function", "cancleWakeupAlarm");
        Intent intent = new Intent(context, bootBroadcastReceiver.class);
        intent.setAction("com.xdja.safeclient.repeat_wakeup_device");
        PendingIntent sender = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)intent, (int)0);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        alarm.cancel(sender);
    }

    public static String getProvidersName(Context context) {
        String ProvidersName = null;
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String IMSI = telephonyManager.getSubscriberId();
        if (IMSI == null) {
            return "unkwon";
        }
        ProvidersName = IMSI.startsWith("46000") || IMSI.startsWith("46002") || IMSI.startsWith("46007") ? "\u4e2d\u56fd\u79fb\u52a8" : (IMSI.startsWith("46001") ? "\u4e2d\u56fd\u8054\u901a" : (IMSI.startsWith("46003") || IMSI.startsWith("46005") ? "\u4e2d\u56fd\u7535\u4fe1" : "\u4e2d\u56fd\u79fb\u52a8"));
        return ProvidersName;
    }

    public static boolean isPackageExist_v2(Context context, String packageName) {
        try {
            ApplicationInfo info = context.getPackageManager().getApplicationInfo(packageName, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public static boolean checkHitomservice(Context context) {
        MyApplication myApplication = MyApplication.myApplication;
        if (myApplication.propertiesConfig.getCheckhitomservice() == 1) {
            boolean ret = Function.isPackageExist_v2(context, "com.hitom.hitomservice");
            Log.d("Function", "isPackageExist_v2 ret = " + ret);
            return ret;
        }
        return true;
    }

    public static void setSafeVpnState(Context context, boolean state) {
        SharedPreferences sp = context.getSharedPreferences("status", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean("VpnState", state);
        editor.commit();
    }

    public static boolean getSafeVpnState(Context context) {
        SharedPreferences sp = context.getSharedPreferences("status", 0);
        return sp.getBoolean("VpnState", false);
    }

    public static void setSafeTunVpnState(Context context, boolean state) {
        SharedPreferences sp = context.getSharedPreferences("status", 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean("TunVpnState", state);
        editor.commit();
    }

    public static boolean getSafeTunVpnState(Context context) {
        SharedPreferences sp = context.getSharedPreferences("status", 0);
        return sp.getBoolean("TunVpnState", false);
    }

    public static boolean isServiceWork(Context mContext, String serviceName) {
        boolean isWork = false;
        ActivityManager am = (ActivityManager)mContext.getSystemService("activity");
        List myList = am.getRunningServices(100);
        if (myList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < myList.size(); ++i) {
            String mName = ((ActivityManager.RunningServiceInfo)myList.get((int)i)).service.getClassName().toString();
            if (!mName.equals(serviceName)) continue;
            isWork = true;
            break;
        }
        return isWork;
    }

    public static void stopOtherSafeClient(Context context) {
        Intent itt = new Intent();
        itt.setAction("com.xdja.safeclient.tun.video.action.STOP_SERVICE");
        context.sendBroadcast(itt);
    }

    public static void startVpnActivity(Context context) {
        ComponentName componetName = new ComponentName(MyApplication.packageName, "com.xdja.safeclient.StartVpnActivity");
        try {
            Intent intt = new Intent();
            intt.setFlags(0x10000000);
            intt.setComponent(componetName);
            context.startActivity(intt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int generateRole(byte[] certId) {
        int role = 0;
        byte[][] especialCert = new byte[][]{{0, 69}, {0, 72}, {0, 83}, {0, 86}};
        if (certId.length != 2) {
            return 1;
        }
        for (int i = 0; i < especialCert.length; ++i) {
            if (!Arrays.equals(certId, especialCert[i])) continue;
            role = 17;
            break;
        }
        if (role == 0) {
            role = 1;
        }
        Log.d(TAG, "gererate role: 0x" + Integer.toHexString(role));
        return role;
    }

    public static String getIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException ex) {
            Log.e("WifiPreferenceIpAddress", "error", ex);
        }
        return "";
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public static boolean isBackground(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (!appProcess.processName.equals(context.getPackageName())) continue;
            if (appProcess.importance == 400) {
                Log.i("\u540e\u53f0", appProcess.processName);
                return true;
            }
            Log.i("\u524d\u53f0", appProcess.processName);
            return false;
        }
        return false;
    }

    public static void stopVPN(Context context) {
        String packageName = context.getPackageName();
        if (packageName.equals("com.xdja.safeclient")) {
            context.sendBroadcast(new Intent("com.xdja.safeclient.action.STOP_SERVICE"));
        } else if (packageName.equals("com.xdja.safeclient.tun")) {
            context.sendBroadcast(new Intent("com.xdja.safeclient.tun.action.STOP_SERVICE"));
        }
    }

    public static void initKeyModule(boolean reinit) {
        int keyFlag = 0;
        int state = KeyWrapper.getInstance().getState();
        if (state != 0 && !reinit) {
            Log.e(TAG, "Key module already inited.");
            return;
        }
        MyApplication myApplication = MyApplication.myApplication;
        PropertiesConfig propertiesConfig = myApplication.propertiesConfig;
        if (propertiesConfig.hasCoverKey() == 1) {
            if (propertiesConfig.hasXdjaKey() == 1 && (!TextUtils.isEmpty((CharSequence)MyApplication.myApplication.getDevPath()) || Function.hasXdjaChip() && !Compatibility.disableXdjaChip()) && MyApplication.myApplication.propertiesConfig.forceDectectCoverCard() == 0) {
                Log.e(TAG, "Has avalibale xdja key, do not need to check cover card.");
            } else {
                Log.e(TAG, "add cover key flag");
                Log.e(TAG, "Need to check cover card.");
                keyFlag |= 4;
            }
        }
        if (propertiesConfig.hasXdjaKey() == 1) {
            Log.e(TAG, "add xdja key flag ");
            keyFlag |= 1;
        }
        if (propertiesConfig.hasChipManager() == 1) {
            Log.e(TAG, "add chip manager flag");
            keyFlag |= 8;
        }
        if (propertiesConfig.hasProviderKey() == 1) {
            Log.d(TAG, "add provider key flag");
            keyFlag |= 0x10;
        }
        if (propertiesConfig.hasLongmaiKey() == 1) {
            Log.d(TAG, "add longmai key flag");
            keyFlag |= 0x20;
        }
        if (propertiesConfig.hasKoalKey() == 1) {
            Log.d(TAG, "add koal key flag");
            keyFlag |= 0x80;
        }
        Log.d(TAG, "Current key flag " + keyFlag);
        if ((keyFlag & 1) == 1 || (keyFlag & 4) == 4 || (keyFlag & 8) == 8) {
            XdjaKeyCfg xdjaKeyCfg = new XdjaKeyCfg();
            String currentPath = "";
            if (myApplication.sslClientConfig.devPath != null) {
                currentPath = new String(myApplication.sslClientConfig.devPath);
            }
            if (TextUtils.isEmpty((CharSequence)currentPath)) {
                String path = "";
                if ((keyFlag & 1) == 1) {
                    path = myApplication.getDevPath();
                }
                Log.d(TAG, "Xdja dev path " + path);
                xdjaKeyCfg.setDevPath(path);
            } else {
                xdjaKeyCfg.setDevPath(new String(myApplication.sslClientConfig.devPath));
            }
            xdjaKeyCfg.setSignCertId(myApplication.sslClientConfig.certId);
            xdjaKeyCfg.setRole(Function.generateRole(myApplication.sslClientConfig.certId));
            xdjaKeyCfg.setSignPubkeyId(myApplication.sslClientConfig.pubkeyId);
            xdjaKeyCfg.setSignPrikeyId(myApplication.sslClientConfig.prikeyId);
            KeyWrapper.getInstance().configXdjaKey(xdjaKeyCfg);
        }
        if ((keyFlag & 2) == 2) {
            ZhongfuCfg zhongfuCfg = new ZhongfuCfg();
            zhongfuCfg.setDevMac("61:11:08:09:62:25");
            zhongfuCfg.setAppName("RSA-Application");
            zhongfuCfg.setContainerName("xdja");
            KeyWrapper.getInstance().configZhongfuKey(zhongfuCfg);
        }
        if ((keyFlag & 0x20) == 32) {
            LongmaiCfg longmaiCfg = new LongmaiCfg();
            KeyWrapper.getInstance().configLongmaiKey(longmaiCfg);
        }
        Log.e(TAG, "Start to call init device auto");
        KeyWrapper.getInstance().initDviceAuto(keyFlag, new KeySelector(){

            @Override
            public int select(ArrayList<KeyDevInfo> keyDevInfoArrayList) {
                int size = keyDevInfoArrayList.size();
                int xdjaChipIndex = -1;
                int xdjaTFIndex = -1;
                int coverKeyIndex = -1;
                int providerKeyIndex = -1;
                int longmaiKeyIndex = -1;
                int koalKeyIndex = -1;
                for (int i = 0; i < size; ++i) {
                    KeyDevInfo keyDevInfo = keyDevInfoArrayList.get(i);
                    if (keyDevInfo.getDriver().equals("chip_manager")) {
                        if (keyDevInfo.getType() == 0) {
                            xdjaChipIndex = i;
                        }
                        if (keyDevInfo.getType() == 1) {
                            xdjaTFIndex = i;
                        }
                        if (keyDevInfo.getType() != 3) continue;
                        coverKeyIndex = i;
                        continue;
                    }
                    if (keyDevInfo.getDriver().equals("xdja_key")) {
                        if (keyDevInfo.getType() == 0) {
                            xdjaChipIndex = i;
                        }
                        if (keyDevInfo.getType() != 1) continue;
                        xdjaTFIndex = i;
                        continue;
                    }
                    if (keyDevInfo.getDriver().equals("cover_card")) {
                        coverKeyIndex = i;
                        continue;
                    }
                    if (keyDevInfo.getDriver().equals("content_provider")) {
                        providerKeyIndex = i;
                        continue;
                    }
                    if (keyDevInfo.getDriver().equals("longmai_key")) {
                        longmaiKeyIndex = i;
                        continue;
                    }
                    if (!keyDevInfo.getDriver().equals("koal_key")) continue;
                    koalKeyIndex = i;
                }
                if (koalKeyIndex != -1) {
                    return koalKeyIndex;
                }
                if (longmaiKeyIndex != -1) {
                    return longmaiKeyIndex;
                }
                if (coverKeyIndex != -1) {
                    return coverKeyIndex;
                }
                if (xdjaTFIndex != -1) {
                    return xdjaTFIndex;
                }
                if (xdjaChipIndex != -1 && !Compatibility.disableXdjaChip()) {
                    return xdjaChipIndex;
                }
                if (providerKeyIndex != -1) {
                    return providerKeyIndex;
                }
                return -1;
            }
        });
    }

    public static boolean isVPNConnected() {
        MyApplication application = MyApplication.myApplication;
        if (application != null && application.sslClientConfig != null) {
            if (application.sslClientConfig.transportMode == 0) {
                return VpnService.safeVerifySuccess;
            }
            return TunVpnService.safeVerifySuccess;
        }
        return false;
    }

    public static boolean hasXdjaChip() {
        SafeTF tf = new SafeTF();
        int handle = tf.OpenSTFCardAuto();
        return handle != 0;
    }

    public static void telnet(final String ip, final int port, final int timeout, final TelnetResultCallback trc) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TelnetClient tc = new TelnetClient();
                try {
                    tc.setConnectTimeout(timeout);
                    tc.connect(ip, port);
                    trc.onSuccess();
                }
                catch (SocketTimeoutException e) {
                    e.printStackTrace();
                    trc.onTimeout();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    trc.onError(-1);
                }
                try {
                    tc.disconnect();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static void runOnMainThread(Runnable r) {
        MyApplication.myApplication.getHandler().post(r);
    }

    public static void startChipManagerActivity(@NonNull Context context) {
        Intent intent = new Intent();
        intent.setClassName("com.xdja.safekeyservice", "com.xdja.scservice.presenter.activity.SplashScreenPresener");
        intent.setPackage("com.xdja.safekeyservice");
        if (!(context instanceof Activity)) {
            intent.setFlags(0x10000000);
        }
        context.startActivity(intent);
    }
}

