/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.xdja.safeclient.bean.TrafficTable;
import com.xdja.safeclient.utils.FileUtil;
import com.xdja.safeclient.utils.Log;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class TrafficStatistics {
    private static final String mDBName = "flow.db";
    private String pathStr;
    private String mDBPath;
    private static final String mTrafficTable = "traffic";
    private SQLiteDatabase mDB = null;

    public SQLiteDatabase getmDB() {
        return this.mDB;
    }

    public void setmDB(SQLiteDatabase mDB) {
        this.mDB = mDB;
    }

    public static String getMdbname() {
        return mDBName;
    }

    public static String getMtraffictable() {
        return mTrafficTable;
    }

    public SQLiteDatabase openDB(Context context) {
        this.pathStr = context.getFilesDir().getAbsolutePath() + "/";
        this.mDBPath = this.pathStr + mDBName;
        Log.i(TrafficStatistics.class.getName(), "mDBPath = " + this.mDBPath);
        File jhPath = new File(this.mDBPath);
        if (jhPath.exists()) {
            try {
                this.mDB = SQLiteDatabase.openOrCreateDatabase((String)this.mDBPath, null);
            }
            catch (Exception e) {
                Log.e("db", e.getMessage());
                e.printStackTrace();
            }
            Log.i(TrafficStatistics.class.getName(), "openOrCreateDatabase");
            return this.mDB;
        }
        File path = new File(this.pathStr);
        if (!path.exists()) {
            if (path.mkdir()) {
                Log.i(TrafficStatistics.class.getName(), "mkdir " + this.pathStr + " success");
            } else {
                Log.e(TrafficStatistics.class.getName(), "mkdir " + this.pathStr + " failed");
            }
        }
        if (!FileUtil.copyAssetsToPrivatePath(context, mDBName, jhPath)) {
            return null;
        }
        Log.i(TrafficStatistics.class.getName(), "openDB");
        return this.openDB(context);
    }

    public void closeDB() {
        if (this.mDB != null) {
            Log.i(TrafficStatistics.class.getName(), "close DB");
            this.mDB.close();
            this.mDB = null;
        }
    }

    public void queryTrafficAmount(SQLiteDatabase db, TrafficTable traffic) {
        Cursor cur = null;
        if (db == null) {
            return;
        }
        String sql = "select sum(traffic_up),sum(traffic_down) from traffic";
        Log.d(TrafficStatistics.class.getName(), sql);
        try {
            cur = db.rawQuery(sql, null);
        }
        catch (Exception e) {
            cur = null;
            return;
        }
        if (cur != null) {
            int indexTrafficUp = cur.getColumnIndex("sum(traffic_up)");
            int indexTrafficDown = cur.getColumnIndex("sum(traffic_down)");
            if (indexTrafficUp < 0 || indexTrafficDown < 0) {
                return;
            }
            if (cur.moveToFirst()) {
                do {
                    traffic.setmTrafficUp(cur.getInt(indexTrafficUp));
                    traffic.setmTrafficDown(cur.getInt(indexTrafficDown));
                } while (cur.moveToNext());
            }
        }
    }

    public void queryTraffic(SQLiteDatabase db, TrafficTable traffic) {
        Cursor cur = null;
        if (db == null) {
            return;
        }
        String sql = "select sum(traffic_up),sum(traffic_down) from traffic where date >= '" + traffic.getmStartDate() + "' and date <= '" + traffic.getmEndDate() + "'";
        Log.d(TrafficStatistics.class.getName(), sql);
        try {
            cur = db.rawQuery(sql, null);
        }
        catch (Exception e) {
            cur = null;
            return;
        }
        if (cur != null) {
            int indexTrafficUp = cur.getColumnIndex("sum(traffic_up)");
            int indexTrafficDown = cur.getColumnIndex("sum(traffic_down)");
            if (indexTrafficUp < 0 || indexTrafficDown < 0) {
                return;
            }
            if (cur.moveToFirst()) {
                do {
                    traffic.setmTrafficUp(cur.getInt(indexTrafficUp));
                    traffic.setmTrafficDown(cur.getInt(indexTrafficDown));
                } while (cur.moveToNext());
            }
        }
    }

    public static long dateDiff(Date dt1, Date dt2) {
        long diff = 0L;
        try {
            long n1 = dt1.getTime();
            long n2 = dt2.getTime();
            diff = Math.abs(n1 - n2);
        }
        catch (Exception e) {
            return -1L;
        }
        return (diff /= 86400000L) + 1L;
    }

    public void queryTrafficAverage(SQLiteDatabase db, TrafficTable traffic) throws ParseException {
        Cursor cur = null;
        long daySum = 1L;
        if (db == null) {
            return;
        }
        SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd", Locale.CHINA);
        Date start = formatDate.parse(traffic.getmStartDate());
        Date end = formatDate.parse(traffic.getmEndDate());
        daySum = TrafficStatistics.dateDiff(start, end);
        Log.d(TrafficStatistics.class.getName(), "daySum = " + daySum);
        String sql = "select sum(traffic_up),sum(traffic_down) from traffic where date >= '" + traffic.getmStartDate() + "' and date <= '" + traffic.getmEndDate() + "'";
        Log.d(TrafficStatistics.class.getName(), sql);
        if (daySum == 0L) {
            Log.e(TrafficStatistics.class.getName(), "error,daySum = " + daySum);
            return;
        }
        try {
            cur = db.rawQuery(sql, null);
        }
        catch (Exception e) {
            cur = null;
            return;
        }
        if (cur != null) {
            int indexTrafficUp = cur.getColumnIndex("sum(traffic_up)");
            int indexTrafficDown = cur.getColumnIndex("sum(traffic_down)");
            if (indexTrafficUp < 0 || indexTrafficDown < 0) {
                return;
            }
            if (cur.moveToFirst()) {
                do {
                    traffic.setmTrafficUp(Integer.parseInt((long)cur.getInt(indexTrafficUp) / daySum + ""));
                    traffic.setmTrafficDown(Integer.parseInt((long)cur.getInt(indexTrafficDown) / daySum + ""));
                } while (cur.moveToNext());
            }
        }
    }
}

