/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.telephony.TelephonyManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.longmai.security.plugin.SOF_AppLib;
import com.longmai.security.plugin.SOF_DeviceLib;
import com.safetf.SafeTF;
import com.xdja.autoupdate.SCAutoUpdate;
import com.xdja.key.KeyDevInfo;
import com.xdja.key.KeyModuleStateListener;
import com.xdja.key.KeyWrapper;
import com.xdja.key.koal.KoalCfg;
import com.xdja.key.koal.KoalKey;
import com.xdja.key.longmai.LMWrapper;
import com.xdja.key.longmai.LongmaiCfg;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.activity.AboutActivity;
import com.xdja.safeclient.activity.ConnectSetActivity;
import com.xdja.safeclient.activity.DeviceListActivity;
import com.xdja.safeclient.activity.SafeVerifyActivity;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.ui.AlertUtil;
import com.xdja.safeclient.ui.DialogWrapper;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.LaunchUtil;
import com.xdja.safeclient.utils.LocaleUtil;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.NetworkUtil;
import com.xdja.safeclient.utils.SharedPreferencesUtil;
import com.xdja.safeclient.utils.StringUtil;
import com.xdja.safeclient.utils.ToastUtil;
import com.xdja.safeclient.wrapper.PinWrapper;
import com.xdja.soc.certupload.CertUploadManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class MainActivity
extends BaseActivity
implements View.OnClickListener,
KeyModuleStateListener {
    EditText et_pin = null;
    Button btn_start = null;
    CheckBox cb_rememberPassword = null;
    LinearLayout ll_more = null;
    LinearLayout ll_moremenu = null;
    LinearLayout ll_config = null;
    LinearLayout ll_update = null;
    LinearLayout ll_about = null;
    LinearLayout ll_exit = null;
    public String userPin = "";
    public int role = 0;
    MyApplication myApplication = null;
    private final String TAG = "MainActivity";
    final int ERROR_BASE = -100;
    final int NETWORK_UNAVAILABLE = -99;
    final int SHOW_LOADING = -98;
    private static String selectAppName = null;
    private static String selectContainerName = null;
    private static String koalCertPath = null;
    private ProgressDialog checkDeviceDlg = null;
    DialogWrapper mDialogUtils = new DialogWrapper();
    Handler handler = new Handler(){

        public void dispatchMessage(Message msg) {
            super.dispatchMessage(msg);
            switch (msg.what) {
                case -1008: {
                    MainActivity.this.mDialogUtils.dismissLoadingDialog();
                    TelephonyManager tm = (TelephonyManager)MainActivity.this.getSystemService("phone");
                    String deviceId = tm.getDeviceId();
                    if ("".equals(deviceId) || null == deviceId) {
                        new DialogWrapper().showTitleClickableMessage1BtnDialog((Context)MainActivity.this, MainActivity.this.getString(R.string.text_permission_limit), MainActivity.this.getString(R.string.text_permission_limit_tip), MainActivity.this.getString(R.string.text_device_imei, new Object[]{MainActivity.this.getString(R.string.unknown)}), MainActivity.this.getString(R.string.know));
                        break;
                    }
                    new DialogWrapper().showTitleClickableMessage1BtnDialog((Context)MainActivity.this, MainActivity.this.getString(R.string.text_permission_limit), MainActivity.this.getString(R.string.text_permission_limit_tip), MainActivity.this.getString(R.string.text_device_imei, new Object[]{deviceId}), MainActivity.this.getString(R.string.know));
                    break;
                }
                case 0: {
                    MainActivity.this.mDialogUtils.dismissLoadingDialog();
                    MainActivity.this.start();
                    break;
                }
                case -99: {
                    Toast.makeText((Context)MainActivity.this, (int)R.string.check_network, (int)1).show();
                    break;
                }
                case -1002: 
                case -1001: {
                    MainActivity.this.mDialogUtils.dismissLoadingDialog();
                    new DialogWrapper().showTitleClickableMessage1BtnDialog((Context)MainActivity.this, MainActivity.this.getString(R.string.permission_denied), MainActivity.this.getString(R.string.text_permission_read_phone_id), "", MainActivity.this.getString(R.string.know));
                    break;
                }
                case -1007: {
                    MainActivity.this.mDialogUtils.dismissLoadingDialog();
                    Toast.makeText((Context)MainActivity.this, (CharSequence)MainActivity.this.getString(R.string.text_chipmanager_server_error), (int)1).show();
                    break;
                }
                case -98: {
                    MainActivity.this.mDialogUtils.showLoadingDialog((Context)MainActivity.this);
                    break;
                }
                default: {
                    MainActivity.this.mDialogUtils.dismissLoadingDialog();
                    Toast.makeText((Context)MainActivity.this, (CharSequence)(MainActivity.this.getString(R.string.text_invoke_chipmanager_err) + msg.what), (int)1).show();
                }
            }
        }
    };

    protected void onResume() {
        super.onResume();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        Intent intent;
        String name;
        Locale current;
        Log.d("MainActivity", "MainActivity onCreate.");
        if (!LocaleUtil.autoChoose((Context)this) && (current = LocaleUtil.parseLocale(name = (String)SharedPreferencesUtil.get((Context)this, "current_language", ""))) != null) {
            LocaleUtil.changeLanguage((Context)this, current);
        }
        this.myApplication = (MyApplication)this.getApplication();
        if (Compatibility.getAreaVersion() == 10000 && this.myApplication != null) {
            this.myApplication.checkDevAdmin();
        }
        if (this.myApplication.propertiesConfig.getIgnoreLogin() == 0) {
            int theme = this.getSharedPreferences("cons", 0).getInt("theme", R.style.AppBaseTheme);
            this.setTheme(theme);
        }
        super.onCreate(savedInstanceState);
        this.getWindow().requestFeature(1);
        this.setContentView(R.layout.activity_main);
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
        boolean pinRet = true;
        if (this.myApplication.propertiesConfig.getIgnoreLogin() != 0) {
            pinRet = this.isPinCorrect();
            Log.w("MainActivity", "pinRet : " + pinRet);
        }
        if (VpnService.startflag || Build.VERSION.SDK_INT >= 14 && TunVpnService.startflag) {
            intent = new Intent();
            intent.setClass((Context)this, SafeVerifyActivity.class);
            this.startActivity(intent);
            this.finish();
        } else if (this.myApplication.propertiesConfig.getIgnoreLogin() != 0 && pinRet) {
            MyApplication.selfStartFlag = true;
            intent = new Intent();
            intent.setClass((Context)this, SafeVerifyActivity.class);
            this.startActivity(intent);
            this.finish();
        } else {
            this.et_pin = (EditText)this.findViewById(R.id.pin);
            this.cb_rememberPassword = (CheckBox)this.findViewById(R.id.rememberpassword);
            this.btn_start = (Button)this.findViewById(R.id.start);
            this.ll_more = (LinearLayout)this.findViewById(R.id.more);
            this.ll_moremenu = (LinearLayout)this.findViewById(R.id.moremenu);
            this.ll_config = (LinearLayout)this.findViewById(R.id.config);
            this.ll_update = (LinearLayout)this.findViewById(R.id.update);
            this.ll_about = (LinearLayout)this.findViewById(R.id.about);
            this.ll_exit = (LinearLayout)this.findViewById(R.id.exit);
            this.btn_start.setOnClickListener((View.OnClickListener)this);
            this.ll_more.setOnClickListener((View.OnClickListener)this);
            this.ll_config.setOnClickListener((View.OnClickListener)this);
            this.ll_update.setOnClickListener((View.OnClickListener)this);
            this.ll_about.setOnClickListener((View.OnClickListener)this);
            this.ll_exit.setOnClickListener((View.OnClickListener)this);
            this.myApplication.topActivity = this;
            this.myApplication.initDevState();
            if (!pinRet) {
                this.delPIN();
            }
            if (this.myApplication.propertiesConfig.getmUseDefualtPin() == 1) {
                this.et_pin.setText((CharSequence)"111111");
                this.cb_rememberPassword.setChecked(true);
                MyApplication.rememberPin = true;
                this.et_pin.setFocusable(false);
                this.cb_rememberPassword.setClickable(false);
            } else {
                String pin;
                boolean needSavePin = PinWrapper.getNeedSavePin((Context)this);
                if (needSavePin && (pin = PinWrapper.getPin((Context)this)) != null) {
                    this.et_pin.setText((CharSequence)pin);
                    this.cb_rememberPassword.setChecked(true);
                    MyApplication.rememberPin = true;
                }
            }
            if (this.myApplication.propertiesConfig.getIsBigThan4G() != 0 && !Function.isSDTotalSizeBigThan4G(Function.getSDTotalSize((Context)this))) {
                new AlertDialog.Builder((Context)this).setTitle((CharSequence)StringUtil.getStringRes((Context)this, R.string.alert)).setMessage((CharSequence)StringUtil.getStringRes((Context)this, R.string.safe_card_version_unmatched)).setNeutralButton((CharSequence)StringUtil.getStringRes((Context)this, R.string.exit), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dlg, int which) {
                        MainActivity.this.finish();
                    }
                }).setCancelable(false).show();
            }
        }
        if (!Function.checkHitomservice(this.getApplicationContext())) {
            AlertUtil.popSystemAlert(this.getApplicationContext(), StringUtil.getStringRes((Context)this, R.string.alert), this.getString(R.string.hitom_service_not_exist), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MainActivity.this.finish();
                }
            });
        }
        this.checkOtherSafeClient();
        SCAutoUpdate.updateStart((Context)this, false, true);
        if (this.myApplication.propertiesConfig.hasZhongfuKey() == 1) {
            intent = new Intent();
            intent.setClass((Context)this, DeviceListActivity.class);
            this.startActivityForResult(intent, 1001);
            Log.d("MainActivity", "Start bt device select.");
        }
        int state = KeyWrapper.getInstance().getState();
        Log.d("MainActivity", "Current key module state " + state);
        switch (state) {
            case 0: 
            case 1: {
                KeyWrapper.getInstance().addKeyModuleStateListener(this);
                this.showDialog();
                Function.initKeyModule(false);
                break;
            }
            case 4: {
                ToastUtil.show((Context)this, this.getString(R.string.init_key_failed));
                break;
            }
            case 3: {
                AlertUtil.popSystemAlert((Context)this, this.getString(R.string.safe_client), this.getString(R.string.detect_no_device), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        Function.exitApp((Context)MainActivity.this);
                    }
                }, true);
                break;
            }
            case 2: {
                ToastUtil.show((Context)this, this.getString(R.string.current_dev) + KeyWrapper.currentKeyTypeComment);
                this.configKey();
            }
        }
    }

    private void configKey() {
        KeyDevInfo devInfo = new KeyDevInfo();
        int ret = KeyWrapper.getInstance().getDevInfo(KeyWrapper.currentIndex, devInfo);
        if (ret != 0) {
            return;
        }
        if (devInfo.getDriver().equals("longmai_key")) {
            this.selectAppName();
        } else if (devInfo.getDriver().equals("koal_key")) {
            this.selectKoalCertPath();
        }
    }

    private void selectKoalCertPath() {
        if (koalCertPath != null) {
            KoalCfg koalCfg = new KoalCfg();
            koalCfg.setCertPath(koalCertPath);
            KeyWrapper.getInstance().configKoalKey(koalCfg);
            return;
        }
        final List<String> certList = KoalKey.getInstance().getCertList();
        if (certList == null) {
            ToastUtil.show((Context)this, "\u6ca1\u6709\u68c0\u6d4b\u5230\u683c\u5c14\u670d\u52a1\uff01");
            return;
        }
        if (certList.size() == 1) {
            koalCertPath = certList.get(0);
            KoalCfg koalCfg = new KoalCfg();
            koalCfg.setCertPath(koalCertPath);
            KeyWrapper.getInstance().configKoalKey(koalCfg);
        } else {
            View bottomView = View.inflate((Context)this, (int)R.layout.appname_dialog, null);
            ListView lvAppName = (ListView)bottomView.findViewById(R.id.lv_appname);
            lvAppName.setAdapter((ListAdapter)new AppNameAdapter((Context)this, certList));
            TextView title = new TextView((Context)this);
            title.setTextSize(18.0f);
            title.setText((CharSequence)"\u8bf7\u9009\u62e9\u8bc1\u4e66");
            title.setTextColor(-1);
            final AlertDialog dialog = new AlertDialog.Builder((Context)this).setCustomTitle((View)title).setView(bottomView).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            }).create();
            dialog.show();
            lvAppName.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                    ToastUtil.show((Context)MainActivity.this, "\u9009\u62e9\u7684\u8bc1\u4e66\u8def\u5f84\u4e3a" + (String)certList.get(i));
                    koalCertPath = (String)certList.get(i);
                    dialog.cancel();
                    KoalCfg koalCfg = new KoalCfg();
                    koalCfg.setCertPath(koalCertPath);
                    KeyWrapper.getInstance().configKoalKey(koalCfg);
                }
            });
        }
    }

    @Override
    protected void onDestroy() {
        KeyWrapper.getInstance().removeKeyModuleStateListener(this);
        super.onDestroy();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            switch (requestCode) {
                default: 
            }
        }
    }

    void uploadClientInfo() {
        new Thread(){

            @Override
            public void run() {
                super.run();
                if (!NetworkUtil.netWorkisAvailable((Context)MainActivity.this)) {
                    MainActivity.this.handler.sendEmptyMessage(-99);
                } else {
                    CertUploadManager manager = new CertUploadManager.Builder().build((Context)MainActivity.this, "content://com.xdja.scservice.cp.CertUploadProvider.syh");
                    Log.d("MainActivity", "call upload  before:" + System.currentTimeMillis());
                    MainActivity.this.handler.sendEmptyMessage(-98);
                    int result = manager.uploadCert();
                    Log.d("MainActivity", "call upload  result:" + result);
                    MainActivity.this.handler.sendEmptyMessage(result);
                    Log.d("MainActivity", "call upload  after:" + System.currentTimeMillis());
                }
            }
        }.start();
    }

    private void checkOtherSafeClient() {
        if (Function.isServiceWork((Context)this, "com.xdja.safeclient.tun.video.TunVpnService")) {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)StringUtil.getStringRes((Context)this, R.string.alert)).setMessage(this.getResources().getText(R.string.otherclientrunning)).setPositiveButton((CharSequence)StringUtil.getStringRes((Context)this, R.string.positive), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Function.stopOtherSafeClient((Context)MainActivity.this);
                }
            }).setNegativeButton((CharSequence)StringUtil.getStringRes((Context)this, R.string.negative), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    MainActivity.this.finish();
                }
            }).show();
        }
    }

    public void onClick(View arg0) {
        int viewId = arg0.getId();
        if (viewId == R.id.start) {
            this.start();
        }
        if (viewId == R.id.more) {
            this.more();
        }
        if (viewId == R.id.config) {
            this.config();
        }
        if (viewId == R.id.update) {
            this.update();
        }
        if (viewId == R.id.about) {
            this.about();
        }
        if (viewId == R.id.exit) {
            Function.exitApp((Context)this);
        }
    }

    void startUpdateActivity(String packageName, String clsName) {
        Intent intent = new Intent();
        intent.setClassName(packageName, clsName);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
    }

    public void start() {
        if (KeyWrapper.getInstance().getState() == 3) {
            ToastUtil.show((Context)this, this.getString(R.string.detect_no_device));
            return;
        }
        this.configKey();
        if (this.safeCardPinVerify()) {
            MyApplication.selfStartFlag = true;
            LaunchUtil.start((Context)this, SafeVerifyActivity.class);
            this.finish();
        }
    }

    public void more() {
        this.ll_more.setVisibility(8);
        this.ll_moremenu.setVisibility(0);
    }

    public void config() {
        Intent intent = new Intent();
        intent.setClass((Context)this, ConnectSetActivity.class);
        this.startActivity(intent);
    }

    public void update() {
        SCAutoUpdate.updateStart((Context)this, true);
    }

    public void about() {
        Intent intent = new Intent((Context)this, AboutActivity.class);
        this.startActivity(intent);
    }

    public boolean safeCardPinVerify() {
        this.userPin = this.et_pin.getText().toString();
        if (!PinWrapper.verifyPinLength(this.userPin)) {
            AlertUtil.popAlert((Context)this, StringUtil.getStringRes((Context)this, R.string.alert), StringUtil.getStringRes((Context)this, R.string.pleaseinputsafepin));
            this.delPIN();
            return false;
        }
        this.myApplication.isWeakPassWD = this.userPin.equals("111111");
        int nres = KeyWrapper.getInstance().keyOpen(KeyWrapper.currentKey);
        if (nres != 0) {
            return false;
        }
        nres = KeyWrapper.getInstance().verifyPIN(this.userPin);
        if (nres != 0) {
            AlertUtil.popAlert((Context)this, StringUtil.getStringRes((Context)this, R.string.alert), StringUtil.getStringRes((Context)this, R.string.wrong_password) + "\r\n" + this.getString(R.string.current_dev) + KeyWrapper.currentKeyTypeComment + "\r\n" + KeyWrapper.StatusCode.getComment(nres));
            this.delPIN();
            return false;
        }
        this.myApplication.sslClientConfig.setPin(this.userPin.getBytes());
        this.myApplication.sslClientConfig.setRole(this.role);
        if (this.cb_rememberPassword.isChecked()) {
            MyApplication.rememberPin = true;
            PinWrapper.setNeedSavePin((Context)this, true);
            PinWrapper.savePin((Context)this, this.userPin);
        } else {
            MyApplication.rememberPin = false;
            this.delPIN();
        }
        return true;
    }

    public boolean isPinCorrect() {
        MyApplication myApplication = (MyApplication)this.getApplication();
        String userPin = "";
        if (myApplication.propertiesConfig.getmUseDefualtPin() == 1) {
            userPin = "111111";
        } else {
            boolean needSavePin = PinWrapper.getNeedSavePin((Context)this);
            if (needSavePin) {
                userPin = PinWrapper.getPin((Context)this);
                if (userPin == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        myApplication.isWeakPassWD = userPin.equals("111111");
        int nres = -1;
        SafeTF tf = new SafeTF();
        int hHandle = 0;
        if (MyApplication.devOpenFlag == 0 || MyApplication.devOpenFlag == 1) {
            hHandle = tf.OpenSTFCardAuto();
            if (hHandle != 0) {
                MyApplication.devOpenFlag = 1;
                myApplication.sslClientConfig.setDevOpenFlag(MyApplication.devOpenFlag);
            }
            Log.d("MainActivity", "OpenSTFCardAuto, hHandle = " + hHandle);
        }
        if (MyApplication.devOpenFlag == 0 || MyApplication.devOpenFlag == 2) {
            String tmp = new String(myApplication.sslClientConfig.getDevPath());
            hHandle = tf.OpenSTFCard(tmp);
            if (hHandle != 0) {
                MyApplication.devOpenFlag = 2;
                myApplication.sslClientConfig.setDevOpenFlag(MyApplication.devOpenFlag);
            }
            Log.d("MainActivity", "OpenSTFCard ,hHandle = " + hHandle);
        }
        if (hHandle == 0) {
            MyApplication.devOpenFlag = 0;
            Log.d("MainActivity", "Open STF Card failed");
            AlertUtil.openCardFailed((Context)this);
            return false;
        }
        this.role = myApplication.sslClientConfig.getRole();
        if (this.role != 1 && this.role != 17) {
            byte[] defaultCertId = myApplication.sslClientConfig.getCertId();
            this.role = Function.generateRole(defaultCertId);
        }
        if ((nres = tf.SafePin(hHandle, userPin.getBytes(), this.role)) != 0) {
            tf.CloseSTFCard(hHandle);
            return false;
        }
        tf.CloseSTFCard(hHandle);
        myApplication.sslClientConfig.setPin(userPin.getBytes());
        myApplication.sslClientConfig.setRole(this.role);
        return true;
    }

    private void delPIN() {
        PinWrapper.setNeedSavePin((Context)this, false);
        PinWrapper.deletePin((Context)this);
    }

    private void selectContainerName(String appName) {
        ArrayList<String> containerNames;
        SOF_AppLib app = SOF_DeviceLib.SOF_GetInstance((String)appName);
        int ret = app.SOF_EnumContainers(containerNames = new ArrayList<String>());
        if (ret != 0) {
            Log.e("MainActivity", "SOF enum containers failed. err " + SOF_DeviceLib.SOF_GetLastError());
            return;
        }
        if (containerNames.isEmpty()) {
            ToastUtil.show((Context)this, "\u5361\u5185\u65e0\u53ef\u7528\u5bb9\u5668\uff01");
            return;
        }
        Log.d("MainActivity", "Enum containers " + containerNames);
        View bottomView = View.inflate((Context)this, (int)R.layout.appname_dialog, null);
        ListView lvAppName = (ListView)bottomView.findViewById(R.id.lv_appname);
        lvAppName.setAdapter((ListAdapter)new AppNameAdapter((Context)this, containerNames));
        TextView title = new TextView((Context)this);
        title.setTextSize(18.0f);
        title.setText((CharSequence)"\u8bf7\u9009\u62e9\u5bb9\u5668");
        title.setTextColor(-1);
        final AlertDialog pickAppNameDlg = new AlertDialog.Builder((Context)this).setCustomTitle((View)title).setView(bottomView).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).create();
        pickAppNameDlg.show();
        lvAppName.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                ToastUtil.show((Context)MainActivity.this, "\u9009\u62e9\u7684\u5bb9\u5668\u540d\u79f0\u4e3a" + (String)containerNames.get(i));
                selectContainerName = (String)containerNames.get(i);
                pickAppNameDlg.cancel();
                LongmaiCfg longmaiCfg = new LongmaiCfg();
                longmaiCfg.setAppName(selectAppName);
                longmaiCfg.setContainerName(selectContainerName);
                KeyWrapper.getInstance().configLongmaiKey(longmaiCfg);
            }
        });
    }

    private void selectAppName() {
        if (selectAppName != null && selectContainerName != null) {
            return;
        }
        final List<String> appNames = LMWrapper.getInstance().enumApplications();
        View bottomView = View.inflate((Context)this, (int)R.layout.appname_dialog, null);
        ListView lvAppName = (ListView)bottomView.findViewById(R.id.lv_appname);
        lvAppName.setAdapter((ListAdapter)new AppNameAdapter((Context)this, appNames));
        TextView title = new TextView((Context)this);
        title.setTextSize(18.0f);
        title.setText((CharSequence)"\u8bf7\u9009\u62e9\u5e94\u7528");
        title.setTextColor(-1);
        final AlertDialog pickAppNameDlg = new AlertDialog.Builder((Context)this).setCustomTitle((View)title).setView(bottomView).setNegativeButton((CharSequence)"\u53d6\u6d88", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        }).create();
        pickAppNameDlg.show();
        lvAppName.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int i, long l) {
                ToastUtil.show((Context)MainActivity.this, "\u9009\u62e9\u7684\u5e94\u7528\u540d\u79f0\u4e3a" + (String)appNames.get(i));
                selectAppName = (String)appNames.get(i);
                pickAppNameDlg.cancel();
                MainActivity.this.selectContainerName(selectAppName);
            }
        });
    }

    @Override
    public void onStateChanged(int curState) {
        this.cancelDialog();
        switch (curState) {
            case 4: {
                ToastUtil.show((Context)this, this.getString(R.string.init_key_failed));
                break;
            }
            case 3: {
                AlertUtil.popSystemAlert((Context)this, this.getString(R.string.safe_client), this.getString(R.string.detect_no_device), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialogInterface, int i) {
                        Function.exitApp((Context)MainActivity.this);
                    }
                }, true);
                break;
            }
            case 2: {
                ToastUtil.show((Context)this, this.getString(R.string.current_dev) + KeyWrapper.currentKeyTypeComment);
                this.configKey();
            }
        }
    }

    private synchronized void cancelDialog() {
        if (this.checkDeviceDlg != null) {
            this.checkDeviceDlg.cancel();
        }
    }

    private synchronized void showDialog() {
        this.checkDeviceDlg = new ProgressDialog((Context)this);
        this.checkDeviceDlg.setProgressStyle(0);
        this.checkDeviceDlg.setTitle((CharSequence)this.getString(R.string.scan_in_progress));
        this.checkDeviceDlg.setMessage((CharSequence)this.getString(R.string.scan_encrpy_device));
        this.checkDeviceDlg.setCancelable(false);
        this.checkDeviceDlg.show();
    }

    class AppNameAdapter
    extends BaseAdapter {
        Context context;
        LayoutInflater inflater;
        List<String> appNames;

        public AppNameAdapter(Context context, List<String> appNames) {
            this.context = context;
            this.inflater = LayoutInflater.from((Context)context);
            this.appNames = appNames;
        }

        public int getCount() {
            return this.appNames.size();
        }

        public Object getItem(int position) {
            return this.appNames.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewGroup vg = convertView != null ? (ViewGroup)convertView : (ViewGroup)this.inflater.inflate(R.layout.appname_item, null);
            String appName = this.appNames.get(position);
            TextView tvAppName = (TextView)vg.findViewById(R.id.tv_appname);
            tvAppName.setText((CharSequence)appName);
            return vg;
        }
    }
}

