/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.activity;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.xdja.safeclient.Function;
import com.xdja.safeclient.MyApplication;
import com.xdja.safeclient.R;
import com.xdja.safeclient.TunVpnService;
import com.xdja.safeclient.VpnService;
import com.xdja.safeclient.activity.SettingActivity;
import com.xdja.safeclient.architecture.BaseActivity;
import com.xdja.safeclient.bean.SafeVerifyStageInfo;
import com.xdja.safeclient.utils.Compatibility;
import com.xdja.safeclient.utils.Log;
import com.xdja.safeclient.utils.StringUtil;
import java.io.IOException;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class SafeVerifyActivity
extends BaseActivity
implements View.OnClickListener {
    LinearLayout ll_fail = null;
    TextView tv_fail = null;
    ImageView btn_titleLeft = null;
    TextView tv_title = null;
    ImageView btn_titleRight = null;
    ListView lv_show = null;
    static Button btn_stop = null;
    Button btn_hide = null;
    MyApplication myApplication = null;
    public static MyAdapter myAdapter = null;
    public static MyAdapter myTunAdapter = null;
    public static boolean startService = false;
    public static boolean stopBtnClick = false;
    private String TAG = "SafeVerifyActivity";
    Intent itt = null;
    Intent ittTunVpn = null;
    public static boolean threadStart = false;
    private Timer timer = new Timer();
    private HomeKeyReceiver homeReceiver = null;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    SafeVerifyActivity.this.updateState();
                    break;
                }
                case 2: {
                    SafeVerifyActivity.this.updateStopBtn();
                }
            }
        }
    };

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_safeverify);
        this.ll_fail = (LinearLayout)this.findViewById(R.id.layout_fail);
        this.tv_fail = (TextView)this.findViewById(R.id.fail);
        this.btn_titleLeft = (ImageView)this.findViewById(R.id.titlebar_leftbtn);
        this.tv_title = (TextView)this.findViewById(R.id.titlebar_text);
        this.btn_titleRight = (ImageView)this.findViewById(R.id.titlebar_rightbtn);
        this.lv_show = (ListView)this.findViewById(R.id.show);
        btn_stop = (Button)this.findViewById(R.id.stop);
        this.btn_hide = (Button)this.findViewById(R.id.hide);
        this.btn_titleRight.setOnClickListener((View.OnClickListener)this);
        btn_stop.setOnClickListener((View.OnClickListener)this);
        this.btn_hide.setOnClickListener((View.OnClickListener)this);
        this.btn_titleLeft.setBackgroundResource(R.drawable.titlebar_logo);
        this.tv_title.setText((CharSequence)this.getString(R.string.safe_client));
        this.btn_titleRight.setBackgroundResource(R.drawable.setting74);
        this.btn_titleRight.setVisibility(0);
        this.myApplication = (MyApplication)this.getApplication();
        this.myApplication.activityList.add(this);
        this.myApplication.topActivity = this;
        this.homeReceiver = new HomeKeyReceiver();
        IntentFilter homeFilter = new IntentFilter("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        this.registerReceiver(this.homeReceiver, homeFilter);
        if (0 == this.myApplication.sslClientConfig.transportMode) {
            if (myAdapter == null) {
                myAdapter = new MyAdapter((List)VpnService.sslStageList){

                    public boolean isEnabled(int position) {
                        return false;
                    }
                };
            }
            this.lv_show.setAdapter((ListAdapter)myAdapter);
            this.startService();
        } else if (1 == this.myApplication.sslClientConfig.transportMode) {
            if (myTunAdapter == null) {
                myTunAdapter = new MyAdapter((List)TunVpnService.sslStageList){

                    public boolean isEnabled(int position) {
                        return false;
                    }
                };
            }
            this.lv_show.setAdapter((ListAdapter)myTunAdapter);
            this.startTunVpnService();
        }
        stopBtnClick = false;
    }

    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d(this.TAG, "onDestroy");
        threadStart = false;
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.homeReceiver != null) {
            this.unregisterReceiver(this.homeReceiver);
            this.homeReceiver = null;
        }
    }

    private void clearSslStageList() {
        SafeVerifyStageInfo item = null;
        if (this.myApplication.sslClientConfig.transportMode == 0) {
            if (VpnService.sslStageList != null) {
                int size = VpnService.sslStageList.size();
                if (size > 0) {
                    item = VpnService.sslStageList.get(size - 1);
                }
                VpnService.sslStageList.clear();
                if (item != null) {
                    VpnService.sslStageList.add(item);
                }
            }
        } else if (TunVpnService.sslStageList != null) {
            int size = TunVpnService.sslStageList.size();
            if (size > 0) {
                item = TunVpnService.sslStageList.get(size - 1);
            }
            TunVpnService.sslStageList.clear();
            if (item != null) {
                TunVpnService.sslStageList.add(item);
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        Log.d(this.TAG, "onKeyDown,keyCode ======================== " + keyCode);
        if (4 == keyCode) {
            if (startService) {
                Log.d(this.TAG, "KEYCODE_BACK,showHomeScreen");
                this.showHomeScreen();
            } else {
                this.myApplication.activityList.remove((Object)this);
                this.finish();
            }
            Log.d(this.TAG, "KEYCODE_BACK,finish, clear sslStageList");
            this.clearSslStageList();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onClick(View arg0) {
        int viewId = arg0.getId();
        if (viewId == R.id.titlebar_rightbtn) {
            this.set();
        }
        if (viewId == R.id.stop) {
            this.stopService();
        }
        if (viewId == R.id.hide) {
            this.showHomeScreen();
        }
    }

    public void set() {
        Intent intent = new Intent();
        intent.setClass((Context)this, SettingActivity.class);
        this.startActivity(intent);
    }

    public void startService() {
        Intent intent = new Intent();
        intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
        this.startService(intent);
        if (!Function.getSafeVpnState(this.getApplicationContext())) {
            VpnService.errorState = "";
            this.ll_fail.setVisibility(8);
            VpnService.sslStageList.clear();
            if (myAdapter != null) {
                myAdapter.notifyDataSetChanged();
            }
        }
        startService = true;
        if (threadStart) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                threadStart = true;
                while (true) {
                    if (stopBtnClick) {
                        Log.d(SafeVerifyActivity.this.TAG, "stopBtnClick");
                        if (!startService && !Function.getSafeVpnState(SafeVerifyActivity.this.getApplicationContext()) && VpnService.stopService) {
                            threadStart = false;
                            Message message_stop = new Message();
                            message_stop.what = 2;
                            SafeVerifyActivity.this.mHandler.sendMessage(message_stop);
                            Log.d(SafeVerifyActivity.this.TAG, "sendMessage 2");
                            break;
                        }
                    }
                    if (!threadStart) break;
                    Message message = new Message();
                    message.what = 1;
                    SafeVerifyActivity.this.mHandler.sendMessage(message);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }).start();
    }

    private void updateState() {
        if (this.myApplication.sslClientConfig.transportMode == 0) {
            if (VpnService.errorState.equals("")) {
                this.ll_fail.setVisibility(8);
            } else {
                this.ll_fail.setVisibility(0);
                this.tv_fail.setText((CharSequence)VpnService.errorState);
            }
            if (myAdapter != null) {
                myAdapter.notifyDataSetChanged();
            }
        } else {
            if (TunVpnService.errorState.equals("")) {
                this.ll_fail.setVisibility(8);
            } else {
                this.ll_fail.setVisibility(0);
                this.tv_fail.setText((CharSequence)TunVpnService.errorState);
            }
            if (myTunAdapter != null) {
                myTunAdapter.notifyDataSetChanged();
            }
        }
    }

    private void updateStopBtn() {
        Log.d(this.TAG, "updateStopBtn");
        btn_stop.setText((CharSequence)this.getString(R.string.start));
        SafeVerifyStageInfo stageInfo = new SafeVerifyStageInfo();
        stageInfo.name = StringUtil.getStringRes((Context)this, R.string.stop_service);
        stageInfo.error = "";
        stageInfo.result = StringUtil.getStringRes((Context)this, R.string.success);
        Compatibility.onServiceStop();
        if (this.myApplication.sslClientConfig.transportMode == 0) {
            if (VpnService.sslStageList.isEmpty() || !VpnService.sslStageList.get((int)(VpnService.sslStageList.size() - 1)).name.equals(stageInfo.name)) {
                VpnService.sslStageList.add(stageInfo);
                myAdapter.notifyDataSetChanged();
            }
        } else if (TunVpnService.sslStageList.isEmpty() || !TunVpnService.sslStageList.get((int)(TunVpnService.sslStageList.size() - 1)).name.equals(stageInfo.name)) {
            TunVpnService.sslStageList.add(stageInfo);
            myTunAdapter.notifyDataSetChanged();
        }
    }

    void setStopBtn() {
        btn_stop.setClickable(false);
        btn_stop.setEnabled(false);
        Log.d(this.TAG, "btn_stop.setClickable(false)");
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                SafeVerifyActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (btn_stop != null) {
                            btn_stop.setClickable(true);
                            btn_stop.setEnabled(true);
                            Log.d(SafeVerifyActivity.this.TAG, "btn_stop.setClickable(true)");
                        }
                    }
                });
            }
        };
        this.timer.schedule(task, 2000L);
    }

    private void stopService() {
        this.setStopBtn();
        String btn_text = btn_stop.getText().toString();
        Log.v(this.TAG, "the btn stop string is " + btn_text);
        if (btn_text.equals(this.getString(R.string.stop))) {
            Log.d(this.TAG, "stop btn click");
            stopBtnClick = true;
            if (0 == this.myApplication.sslClientConfig.transportMode) {
                Intent intent = new Intent();
                intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.VpnService");
                this.stopService(intent);
                myAdapter.notifyDataSetChanged();
                VpnService.errorState = "";
            } else if (1 == this.myApplication.sslClientConfig.transportMode) {
                Log.d("SafeVerifyActivity", "stop Service TunVpnService");
                try {
                    boolean res = false;
                    try {
                        if (TunVpnService.mInterface != null) {
                            Log.d(this.TAG, "TunVpnService.mInterface.close");
                            TunVpnService.mInterface.close();
                            TunVpnService.mInterface = null;
                            if (TunVpnService.tunVpnObj != null) {
                                TunVpnService.tunVpnObj.destroyBuilder();
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (this.myApplication.sslvpn != null) {
                        this.myApplication.sslvpn.closeTunFd();
                    }
                    Intent intent = new Intent();
                    intent.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");
                    res = this.stopService(intent);
                    if (!res) {
                        Log.e(this.TAG, "stopService TunVpnService failed");
                    } else {
                        Log.d(this.TAG, "stopService TunVpnService success ");
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                myTunAdapter.notifyDataSetChanged();
                TunVpnService.errorState = "";
            }
            startService = false;
            MyApplication.selfStartFlag = false;
            this.ll_fail.setVisibility(8);
        } else {
            stopBtnClick = false;
            MyApplication.selfStartFlag = true;
            btn_stop.setText((CharSequence)this.getString(R.string.stop));
            if (0 == this.myApplication.sslClientConfig.transportMode) {
                if (myAdapter == null) {
                    Log.i(this.TAG, "new MyAdapter,myAdapter2");
                    myAdapter = new MyAdapter((List)VpnService.sslStageList){

                        public boolean isEnabled(int position) {
                            return false;
                        }
                    };
                }
                this.lv_show.setAdapter((ListAdapter)myAdapter);
                this.startService();
            } else if (1 == this.myApplication.sslClientConfig.transportMode) {
                if (myTunAdapter == null) {
                    Log.i(this.TAG, "new MyAdapter,myTunAdapter2");
                    myTunAdapter = new MyAdapter((List)TunVpnService.sslStageList){

                        public boolean isEnabled(int position) {
                            return false;
                        }
                    };
                }
                this.lv_show.setAdapter((ListAdapter)myTunAdapter);
                this.startTunVpnService();
            }
        }
    }

    public void startTunVpnService() {
        Log.d(this.TAG, "prepare...");
        this.itt = android.net.VpnService.prepare((Context)this);
        if (this.itt != null) {
            Log.d(this.TAG, "startActivityForResult...");
            this.startActivityForResult(this.itt, 0);
        } else {
            Log.d(this.TAG, "onActivityResult...");
            this.onActivityResult(0, -1, null);
        }
        if (!Function.getSafeTunVpnState(this.getApplicationContext())) {
            TunVpnService.errorState = "";
            this.ll_fail.setVisibility(8);
            if (TunVpnService.sslStageList != null) {
                TunVpnService.sslStageList.clear();
            }
            if (myTunAdapter != null) {
                myTunAdapter.notifyDataSetChanged();
            }
        }
        startService = true;
        if (threadStart) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                threadStart = true;
                while (true) {
                    if (stopBtnClick) {
                        threadStart = false;
                        Message message_stop = new Message();
                        message_stop.what = 2;
                        SafeVerifyActivity.this.mHandler.sendMessage(message_stop);
                        Log.d(SafeVerifyActivity.this.TAG, "sendMessage 2");
                        break;
                    }
                    if (!threadStart) break;
                    Message message = new Message();
                    message.what = 1;
                    SafeVerifyActivity.this.mHandler.sendMessage(message);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }).start();
    }

    protected void onActivityResult(int request, int result, Intent data) {
        if (-1 == result) {
            Log.d(this.TAG, "onActivityResult , user permit");
            this.ittTunVpn = new Intent();
            this.ittTunVpn.setClassName(MyApplication.packageName, "com.xdja.safeclient.TunVpnService");
            ComponentName name = this.startService(this.ittTunVpn);
            if (name == null) {
                Log.d(this.TAG, "start TunVpnService failed");
            } else {
                Log.d(this.TAG, "start TunVpnService success " + name.toString());
            }
        } else {
            startService = false;
            Function.setSafeTunVpnState(this.getApplicationContext(), false);
            TunVpnService.stopService = true;
            Log.d(this.TAG, "onActivityResult , user not permit");
        }
    }

    public void showHomeScreen() {
        this.finish();
    }

    public class MyAdapter
    extends BaseAdapter {
        private LayoutInflater inflater;
        private Holder holder;
        private List<SafeVerifyStageInfo> stageInfoList = null;

        public MyAdapter(List<SafeVerifyStageInfo> stageInfoList) {
            this.stageInfoList = stageInfoList;
            this.inflater = LayoutInflater.from((Context)SafeVerifyActivity.this);
        }

        public int getCount() {
            return this.stageInfoList.size();
        }

        public Object getItem(int arg0) {
            return arg0;
        }

        public long getItemId(int arg0) {
            return arg0;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = this.inflater.inflate(R.layout.safeverifystagelist, null);
                this.holder = new Holder();
                this.holder.tv_stage = (TextView)convertView.findViewById(R.id.stage);
                this.holder.tv_result = (TextView)convertView.findViewById(R.id.result);
                convertView.setTag((Object)this.holder);
            } else {
                this.holder = (Holder)convertView.getTag();
            }
            SafeVerifyStageInfo stageInfo = this.stageInfoList.get(position);
            this.holder.tv_stage.setText((CharSequence)stageInfo.name);
            this.holder.tv_result.setText((CharSequence)stageInfo.result);
            return convertView;
        }

        private class Holder {
            private TextView tv_stage;
            private TextView tv_result;

            private Holder() {
            }
        }
    }

    private class HomeKeyReceiver
    extends BroadcastReceiver {
        final String SYS_KEY = "reason";
        final String SYS_HOME_KEY = "homekey";

        private HomeKeyReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String reason;
            String action = intent.getAction();
            if (action.equals("android.intent.action.CLOSE_SYSTEM_DIALOGS") && (reason = intent.getStringExtra("reason")) != null && reason.equals("homekey")) {
                Log.d(SafeVerifyActivity.this.TAG, "BroadcastReceiver receiver: home key down");
                if (startService) {
                    Log.d(SafeVerifyActivity.this.TAG, "HOMEKEY_DOWN,showHomeScreen");
                    SafeVerifyActivity.this.showHomeScreen();
                } else {
                    Log.d(SafeVerifyActivity.this.TAG, "HOMEKEY_DOWN,finish, clear SSLStage list");
                    SafeVerifyActivity.this.myApplication.activityList.remove((Object)this);
                    SafeVerifyActivity.this.finish();
                }
                SafeVerifyActivity.this.clearSslStageList();
            }
        }
    }
}

