/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.config;

import com.xdja.safeclient.MyApplication;

public class SslClientConfig {
    public static final int DEBUG_MODE = 0;
    public static final int RELEASE_MODE = 1;
    public static final int HARD_CERT = 0;
    public static final int SOFT_CERT = 1;
    public static final int NO_CERT = 2;
    public int transportMode;
    public int certMode;
    public byte[] caPath;
    public byte[] gateWayIp;
    public byte[] gateWayIp2;
    public byte[] gateWayIp3;
    public int gateWayPort;
    public int privatePort;
    public byte[] pin;
    public int role;
    public int cipherSuit;
    public int connectTimeOut;
    public int retryConnectCount;
    public byte[] certId;
    public byte[] pubkeyId;
    public byte[] prikeyId;
    public byte[] terminalInfo;
    public int logSwitch;
    public int logLevel;
    public int logFileSize;
    public byte[] privDir;
    public int mixNum;
    public int mixDeno;
    public int aclVersion;
    public int sdkVersion;
    public byte[] devPath;
    public int devOpenFlag;
    public int tunFd;
    public int netType;

    public int getNetType() {
        return this.netType;
    }

    public void setNetType(int netType) {
        this.netType = netType;
    }

    public int getAclVersion() {
        return this.aclVersion;
    }

    public void setAclVersion(int aclVersion) {
        this.aclVersion = aclVersion;
    }

    public int getTunFd() {
        return this.tunFd;
    }

    public void setTunFd(int tunFd) {
        this.tunFd = tunFd;
    }

    public int getSdkVersion() {
        return this.sdkVersion;
    }

    public void setSdkVersion(int sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public byte[] getDevPath() {
        return this.devPath;
    }

    public void setDevPath(byte[] devPath) {
        this.devPath = devPath;
    }

    public int getDevOpenFlag() {
        return this.devOpenFlag;
    }

    public void setDevOpenFlag(int devOpenFlag) {
        this.devOpenFlag = devOpenFlag;
    }

    public int getLogSwitch() {
        return this.logSwitch;
    }

    public void setLogSwitch(int logSwitch) {
        this.logSwitch = logSwitch;
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public int getLogFileSize() {
        return this.logFileSize;
    }

    public void setLogFileSize(int logFileSize) {
        this.logFileSize = logFileSize;
    }

    public byte[] getPrivDir() {
        return this.privDir;
    }

    public void setPrivDir(byte[] privDir) {
        this.privDir = privDir;
    }

    public int getMixNum() {
        return this.mixNum;
    }

    public void setMixNum(int mixNum) {
        this.mixNum = mixNum;
    }

    public int getMixDeno() {
        return this.mixDeno;
    }

    public void setMixDeno(int mixDeno) {
        this.mixDeno = mixDeno;
    }

    public int getTransportMode() {
        return this.transportMode;
    }

    public void setTransportMode(int transportMode) {
        this.transportMode = transportMode;
    }

    public int getCertMode() {
        return this.certMode;
    }

    public void setCertMode(int certMode) {
        this.certMode = certMode;
    }

    public byte[] getTerminalInfo() {
        return this.terminalInfo;
    }

    public void setTerminalInfo(byte[] terminalInfo) {
        this.terminalInfo = terminalInfo;
    }

    public byte[] getCaPath() {
        return this.caPath;
    }

    public void setCaPath(byte[] caPath) {
        this.caPath = caPath;
    }

    public byte[] getGateWayIp() {
        return this.gateWayIp;
    }

    public byte[] getGateWayIp2() {
        return this.gateWayIp2;
    }

    public byte[] getGateWayIp3() {
        return this.gateWayIp3;
    }

    public void setGateWayIp(byte[] gateWayIp) {
        this.gateWayIp = gateWayIp;
    }

    public void setGateWayIp2(byte[] gateWayIp) {
        this.gateWayIp2 = gateWayIp;
    }

    public void setGateWayIp3(byte[] gateWayIp) {
        this.gateWayIp3 = gateWayIp;
    }

    public int getGateWayPort() {
        return this.gateWayPort;
    }

    public void setGateWayPort(int gateWayPort) {
        this.gateWayPort = gateWayPort;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    public void setPrivatePort(int privatePort) {
        this.privatePort = privatePort;
    }

    public byte[] getPin() {
        return this.pin;
    }

    public void setPin(byte[] pin) {
        this.pin = pin;
    }

    public int getRole() {
        return this.role;
    }

    public void setRole(int role) {
        this.role = role;
    }

    public int getCipherSuit() {
        return this.cipherSuit;
    }

    public void setCipherSuit(int cipherSuit) {
        this.cipherSuit = cipherSuit;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(int connectTimeOut) {
        this.connectTimeOut = connectTimeOut;
    }

    public int getRetryConnectCount() {
        return this.retryConnectCount;
    }

    public void setRetryConnectCount(int retryConnectCount) {
        this.retryConnectCount = retryConnectCount;
    }

    public byte[] getCertId() {
        return this.certId;
    }

    public void setCertId(byte[] certId) {
        this.certId = certId;
    }

    public byte[] getPubkeyId() {
        return this.pubkeyId;
    }

    public void setPubkeyId(byte[] pubkeyId) {
        this.pubkeyId = pubkeyId;
    }

    public byte[] getPrikeyId() {
        return this.prikeyId;
    }

    public void setPrikeyId(byte[] prikeyId) {
        this.prikeyId = prikeyId;
    }

    public SslClientConfig(String temp) {
        this.pin = "111111".getBytes();
        this.role = 1;
    }

    public SslClientConfig() {
        this.transportMode = 0;
        this.certMode = 0;
        this.caPath = MyApplication.myApplication.getFilesDir().getPath().getBytes();
        this.gateWayIp = "192.168.13.78".getBytes();
        this.gateWayIp2 = "".getBytes();
        this.gateWayIp3 = "".getBytes();
        this.gateWayPort = 3001;
        this.pin = "111111".getBytes();
        this.role = 1;
        this.cipherSuit = 3;
        this.connectTimeOut = 5;
        this.retryConnectCount = 10000;
        this.certId = new byte[2];
        this.pubkeyId = new byte[2];
        this.prikeyId = new byte[2];
        this.certId[0] = 0;
        this.certId[1] = 41;
        this.pubkeyId[0] = 0;
        this.pubkeyId[1] = 42;
        this.prikeyId[0] = 0;
        this.prikeyId[1] = 43;
        this.logSwitch = 1;
        this.logLevel = 1;
        this.logFileSize = 1;
        this.mixNum = 1;
        this.mixDeno = 1;
        this.aclVersion = 2;
    }

    public String formatSslClientConfig() {
        StringBuffer configInfo = new StringBuffer();
        configInfo.append("\"");
        configInfo.append(this.transportMode + "#");
        configInfo.append(this.certMode + "#");
        configInfo.append(new String(this.caPath) + "#");
        configInfo.append(new String(this.gateWayIp) + "#");
        if (this.gateWayIp2 == null || this.gateWayIp2.equals("")) {
            configInfo.append(new String("") + "#");
        } else {
            configInfo.append(new String(this.gateWayIp2) + "#");
        }
        if (this.gateWayIp3 == null || this.gateWayIp3.equals("")) {
            configInfo.append(new String("") + "#");
        } else {
            configInfo.append(new String(this.gateWayIp3) + "#");
        }
        configInfo.append(this.gateWayPort + "#");
        configInfo.append(new String(this.pin) + "#");
        configInfo.append(this.role + "#");
        configInfo.append(this.cipherSuit + "#");
        configInfo.append(this.connectTimeOut + "#");
        configInfo.append(this.retryConnectCount + "#");
        configInfo.append(String.format("%02x%02x", this.certId[0], this.certId[1]) + "#");
        configInfo.append(String.format("%02x%02x", this.pubkeyId[0], this.pubkeyId[1]) + "#");
        configInfo.append(String.format("%02x%02x", this.prikeyId[0], this.prikeyId[1]) + "#");
        configInfo.append(new String(this.terminalInfo) + "#");
        configInfo.append(this.logSwitch + "#");
        configInfo.append(this.logLevel + "#");
        configInfo.append(this.logFileSize + "#");
        configInfo.append(this.mixNum + "#");
        configInfo.append(this.mixDeno + "#");
        configInfo.append(this.sdkVersion + "#");
        configInfo.append(new String(this.devPath) + "#");
        configInfo.append(this.devOpenFlag + "#");
        configInfo.append(new String(this.privDir) + "#");
        configInfo.append("\"");
        return configInfo.toString();
    }
}

