/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.safeclient.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;
import com.xdja.safeclient.R;

public class WidthRatioRelativeLayout
extends RelativeLayout {
    private float mRatio = 1.0f;

    public WidthRatioRelativeLayout(Context context) {
        this(context, null);
    }

    public WidthRatioRelativeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WidthRatioRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.WidthRatioRelativeLayout);
        this.mRatio = typedArray.getFloat(R.styleable.WidthRatioRelativeLayout_ratio, 1.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(WidthRatioRelativeLayout.getDefaultSize((int)0, (int)widthMeasureSpec), WidthRatioRelativeLayout.getDefaultSize((int)0, (int)heightMeasureSpec));
        int childWidthSize = this.getMeasuredWidth();
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)childWidthSize, (int)0x40000000);
        if (childWidthSize < 600) {
            this.mRatio = 0.25f;
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.round((float)childWidthSize * this.mRatio), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

